/*
 * Decompiled with CFR 0.152.
 */
package plugins.tinevez.rieszwavelets;

import edu.emory.mathcs.jtransforms.fft.DoubleFFT_2D;
import plugins.tinevez.rieszwavelets.HarmonicTypes;
import plugins.tinevez.rieszwavelets.RieszGeneralization;

public class RieszConfig {
    int order;
    double[][] filters;
    int numChannels;
    HarmonicTypes harmonicType;
    int[] harmonics;
    int width;
    int height;

    RieszConfig(int order, HarmonicTypes harmonicTypes, int width, int height) {
        this.order = Math.abs(order);
        this.harmonicType = harmonicTypes;
        this.width = width;
        this.height = height;
        this.fillHarmonics();
        this.prepareFiltersFFT();
    }

    RieszConfig(int order, HarmonicTypes harmonicTypes) {
        this.order = order;
        this.harmonicType = harmonicTypes;
        this.fillHarmonics();
    }

    RieszConfig(int[] harmonics, int width, int height) {
        throw new IllegalArgumentException("Custom harmonics not yet supported");
    }

    private void fillHarmonics() {
        switch (this.harmonicType) {
            case even: {
                if (this.order % 2 > 0) {
                    throw new IllegalArgumentException("Order of Riesz filter must be even for even-type harmonics.");
                }
                this.numChannels = this.order + 1;
                this.harmonics = new int[this.numChannels];
                int k = 0;
                int o = -this.order;
                while (o <= this.order) {
                    this.harmonics[k] = o;
                    ++k;
                    o += 2;
                }
                break;
            }
            case odd: {
                if (this.order % 2 == 0) {
                    throw new IllegalArgumentException("Order of Riesz filter must be odd for odd-type harmonics.");
                }
                this.numChannels = this.order + 1;
                this.harmonics = new int[this.numChannels];
                int k = 0;
                int o = -this.order;
                while (o <= this.order) {
                    this.harmonics[k] = o;
                    ++k;
                    o += 2;
                }
                break;
            }
            case complete: {
                this.numChannels = 2 * this.order + 1;
                this.harmonics = new int[this.numChannels];
                int k = 0;
                int o = -this.order;
                while (o <= this.order) {
                    this.harmonics[k] = o++;
                    ++k;
                }
                break;
            }
            case positive: {
                this.numChannels = this.order + 1;
                this.harmonics = new int[this.numChannels];
                int k = 0;
                int o = 0;
                while (o <= this.order) {
                    this.harmonics[k] = o++;
                    ++k;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unable to use this constructor for RieszConfig with custom harmonics");
            }
        }
    }

    protected void prepareFiltersFFT() {
        int x;
        this.filters = new double[this.numChannels][this.width * this.height * 2];
        double[] angles = new double[this.width * this.height];
        int cX = (int)Math.ceil((this.width + 1) / 2);
        int cY = (int)Math.ceil((this.height + 1) / 2);
        int x2 = 0;
        while (x2 < cX) {
            angles[x2] = 0.0;
            ++x2;
        }
        x2 = cX;
        while (x2 < this.width) {
            angles[x2] = Math.PI;
            ++x2;
        }
        int y = 1;
        while (y < cY) {
            angles[y * this.width] = 1.5707963267948966;
            x = 1;
            while (x < cX) {
                angles[x + y * this.width] = Math.atan2((double)y / (double)this.height, (double)x / (double)this.width);
                ++x;
            }
            x = cX;
            while (x < this.width) {
                angles[x + y * this.width] = Math.atan2((double)y / (double)this.height, (double)(x - this.width) / (double)this.width);
                ++x;
            }
            ++y;
        }
        y = cY;
        while (y < this.height) {
            angles[y * this.width] = -1.5707963267948966;
            x = 1;
            while (x < cX) {
                angles[x + y * this.width] = Math.atan2((double)(y - this.height) / (double)this.height, (double)x / (double)this.width);
                ++x;
            }
            x = cX;
            while (x < this.width) {
                angles[x + y * this.width] = Math.atan2((double)(y - this.height) / (double)this.height, (double)(x - this.width) / (double)this.width);
                ++x;
            }
            ++y;
        }
        int c = 0;
        while (c < this.numChannels) {
            double h = this.harmonics[c];
            double[] values = this.filters[c];
            int i = 0;
            while (i < angles.length) {
                values[2 * i] = Math.cos(h * angles[i]);
                values[2 * i + 1] = Math.sin(h * angles[i]);
                ++i;
            }
            ++c;
        }
    }

    public double[][] analysis(double[] image, RieszGeneralization generalization) {
        return this.analysis(image, generalization, false, false);
    }

    public double[][] analysis(double[] image, RieszGeneralization generalization, boolean inputInFourier, boolean outputInFourier) {
        double[] dataFFT;
        if (inputInFourier) {
            dataFFT = image;
        } else {
            dataFFT = new double[this.width * this.height * 2];
            int i = 0;
            while (i < this.width * this.height) {
                dataFFT[2 * i] = image[i];
                ++i;
            }
            DoubleFFT_2D fft = new DoubleFFT_2D(this.height, this.width);
            fft.complexForward(dataFFT);
        }
        double[][] bandFFT = new double[this.numChannels][this.width * this.height * 2];
        int i = 0;
        while (i < this.numChannels) {
            int t = 0;
            while (t < this.width * this.height) {
                bandFFT[i][2 * t] = dataFFT[2 * t] * this.filters[i][2 * t] - dataFFT[2 * t + 1] * this.filters[i][2 * t + 1];
                bandFFT[i][2 * t + 1] = dataFFT[2 * t] * this.filters[i][2 * t + 1] + dataFFT[2 * t + 1] * this.filters[i][2 * t];
                ++t;
            }
            ++i;
        }
        bandFFT = generalization.combineBandsForwardComplex(bandFFT);
        if (outputInFourier) {
            return bandFFT;
        }
        if (generalization.realCoefficients) {
            DoubleFFT_2D fft = new DoubleFFT_2D(this.height, this.width);
            double[][] bands = new double[bandFFT.length][this.width * this.height];
            int i2 = 0;
            while (i2 < bandFFT.length) {
                fft.complexInverse(bandFFT[i2], true);
                int j = 0;
                while (j < this.width * this.height) {
                    bands[i2][j] = bandFFT[i2][2 * j];
                    ++j;
                }
                ++i2;
            }
            return bands;
        }
        DoubleFFT_2D fft = new DoubleFFT_2D(this.height, this.width);
        int i3 = 0;
        while (i3 < bandFFT.length) {
            fft.complexInverse(bandFFT[i3], true);
            ++i3;
        }
        return bandFFT;
    }

    public double[] synthesis(double[][] rieszBands, RieszGeneralization generalization, boolean inputInFourier, boolean outputInFourier) {
        double[] reconstruction;
        double[][] rieszBandsFFT;
        if (inputInFourier) {
            rieszBandsFFT = rieszBands;
        } else {
            rieszBandsFFT = new double[rieszBands.length][2 * this.width * this.height];
            int i = 0;
            while (i < rieszBands.length) {
                DoubleFFT_2D fft = new DoubleFFT_2D(this.height, this.width);
                int j = 0;
                while (j < this.width * this.height) {
                    rieszBandsFFT[i][2 * j] = rieszBands[i][j];
                    ++j;
                }
                fft.complexForward(rieszBandsFFT[i]);
                ++i;
            }
        }
        rieszBandsFFT = generalization.combineBandsBackwardComplex(rieszBandsFFT);
        double[] reconstructionFFT = new double[this.width * this.height * 2];
        int i = 0;
        while (i < this.numChannels) {
            int t = 0;
            while (t < this.width * this.height) {
                int n = 2 * t;
                reconstructionFFT[n] = reconstructionFFT[n] + (rieszBandsFFT[i][2 * t] * this.filters[i][2 * t] + rieszBandsFFT[i][2 * t + 1] * this.filters[i][2 * t + 1]);
                int n2 = 2 * t + 1;
                reconstructionFFT[n2] = reconstructionFFT[n2] + (-rieszBandsFFT[i][2 * t] * this.filters[i][2 * t + 1] + rieszBandsFFT[i][2 * t + 1] * this.filters[i][2 * t]);
                ++t;
            }
            ++i;
        }
        if (outputInFourier) {
            reconstruction = reconstructionFFT;
        } else {
            DoubleFFT_2D fft = new DoubleFFT_2D(this.height, this.width);
            fft.complexInverse(reconstructionFFT, true);
            reconstruction = new double[this.width * this.height];
            int t = 0;
            while (t < this.width * this.height) {
                reconstruction[t] = reconstructionFFT[2 * t];
                ++t;
            }
        }
        return reconstruction;
    }

    public void steerCoefficients(double[][] rieszBands, RieszGeneralization generalization, double[] angles, boolean forward) {
        if (generalization.realCoefficients) {
            Object complexBands = new double[rieszBands.length][];
            int i = 0;
            while (i < ((double[][])complexBands).length) {
                complexBands[i] = new double[rieszBands[i].length * 2];
                int j = 0;
                while (j < rieszBands[i].length) {
                    complexBands[i][2 * j] = rieszBands[i][j];
                    ++j;
                }
                ++i;
            }
            complexBands = generalization.combineBandsBackwardComplex((double[][])complexBands);
            int b = 0;
            while (b < ((double[][])complexBands).length) {
                double s;
                double i2;
                double r;
                int k;
                int harmonic = this.harmonics[b];
                if (forward) {
                    k = 0;
                    while (k < angles.length) {
                        r = complexBands[b][2 * k];
                        i2 = complexBands[b][2 * k + 1];
                        double c = Math.cos((double)harmonic * angles[k]);
                        s = Math.sin((double)harmonic * angles[k]);
                        complexBands[b][2 * k] = r * c - i2 * s;
                        complexBands[b][2 * k + 1] = r * s + i2 * c;
                        ++k;
                    }
                } else {
                    k = 0;
                    while (k < angles.length) {
                        r = complexBands[b][2 * k];
                        i2 = complexBands[b][2 * k + 1];
                        double c = Math.cos((double)(-harmonic) * angles[k]);
                        s = Math.sin((double)(-harmonic) * angles[k]);
                        complexBands[b][2 * k] = r * c - i2 * s;
                        complexBands[b][2 * k + 1] = r * s + i2 * c;
                        ++k;
                    }
                }
                ++b;
            }
            complexBands = generalization.combineBandsForwardComplex((double[][])complexBands);
            b = 0;
            while (b < rieszBands.length) {
                int k = 0;
                while (k < rieszBands[b].length) {
                    rieszBands[b][k] = complexBands[b][2 * k];
                    ++k;
                }
                ++b;
            }
        } else {
            rieszBands = generalization.combineBandsBackwardComplex(rieszBands);
            int b = 0;
            while (b < rieszBands.length) {
                double s;
                double c;
                double i;
                double r;
                int k;
                int harmonic = this.harmonics[b];
                if (forward) {
                    k = 0;
                    while (k < angles.length) {
                        r = rieszBands[b][2 * k];
                        i = rieszBands[b][2 * k + 1];
                        c = Math.cos((double)harmonic * angles[k]);
                        s = Math.sin((double)harmonic * angles[k]);
                        rieszBands[b][2 * k] = r * c - i * s;
                        rieszBands[b][2 * k + 1] = r * s + i * c;
                        ++k;
                    }
                } else {
                    k = 0;
                    while (k < angles.length) {
                        r = rieszBands[b][2 * k];
                        i = rieszBands[b][2 * k + 1];
                        c = Math.cos((double)(-harmonic) * angles[k]);
                        s = Math.sin((double)(-harmonic) * angles[k]);
                        rieszBands[b][2 * k] = r * c - i * s;
                        rieszBands[b][2 * k + 1] = r * s + i * c;
                        ++k;
                    }
                }
                ++b;
            }
            double[][] combinedBands = generalization.combineBandsForwardComplex(rieszBands);
            int b2 = 0;
            while (b2 < rieszBands.length) {
                rieszBands[b2] = combinedBands[b2];
                ++b2;
            }
        }
    }
}

