/*
 * Decompiled with CFR 0.152.
 */
package plugins.ferreol.demics;

import icy.gui.frame.progress.FailedAnnounceFrame;
import icy.plugin.interface_.PluginBundled;
import icy.sequence.Sequence;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;
import mitiv.linalg.shaped.FloatShapedVectorSpace;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarChannel;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.vars.lang.Var;
import plugins.mitiv.io.Icy2TiPi;
import plugins.mitiv.io.IcyImager;

public class Convolution
extends EzPlug
implements Block,
EzStoppable,
PluginBundled {
    protected EzVarSequence psf;
    protected EzVarChannel psfchannel;
    private EzVarBoolean normalizePSF;
    protected ShapedArray imgArray;
    protected ShapedArray psfArray;
    protected Sequence seqPSF;
    private int vectorSpaceType;
    private ShapedVectorSpace dataSpace;
    private ShapedVectorSpace objectSpace;
    private EzVarSequence data;
    private EzVarChannel channel;
    private EzVarSequence outputHeadlessImage;
    private Sequence dataSeq;
    private Shape psfShape;
    private Shape dataShape;

    protected void initialize() {
        this.data = new EzVarSequence("Image");
        this.channel = new EzVarChannel("Data channel:", (Var)this.data.getVariable(), false);
        this.psf = new EzVarSequence("PSF");
        this.psfchannel = new EzVarChannel("PSF channel:", (Var)this.psf.getVariable(), false);
        this.normalizePSF = new EzVarBoolean("Normalize PSF (sum=1):", true);
        this.addEzComponent((EzComponent)this.data);
        this.addEzComponent((EzComponent)this.channel);
        this.addEzComponent((EzComponent)this.psf);
        this.addEzComponent((EzComponent)this.psfchannel);
        this.addEzComponent((EzComponent)this.normalizePSF);
        if (this.isHeadLess()) {
            this.outputHeadlessImage = new EzVarSequence("Output Image");
        }
    }

    protected void execute() {
        this.dataSeq = (Sequence)this.data.getValue();
        this.seqPSF = (Sequence)this.psf.getValue();
        if (this.dataSeq == null) {
            this.throwError("An image should be given");
            return;
        }
        if (this.seqPSF == null) {
            this.throwError("A psf should be given");
            return;
        }
        this.imgArray = Icy2TiPi.sequenceToArray(this.dataSeq, (Integer)this.channel.getValue());
        this.psfArray = Icy2TiPi.sequenceToArray(this.seqPSF, (Integer)this.psfchannel.getValue());
        this.dataShape = this.imgArray.getShape();
        this.psfShape = this.psfArray.getShape();
        this.vectorSpaceType = this.imgArray.getType() == 5 || this.psfArray != null && this.psfArray.getType() == 5 ? 5 : 4;
        if (this.vectorSpaceType == 4) {
            this.dataSpace = new FloatShapedVectorSpace(this.dataShape);
            this.objectSpace = new FloatShapedVectorSpace(this.dataShape);
        } else {
            this.dataSpace = new DoubleShapedVectorSpace(this.dataShape);
            this.objectSpace = new DoubleShapedVectorSpace(this.dataShape);
        }
        mitiv.conv.Convolution H = mitiv.conv.Convolution.build((Shape)this.dataShape, (ShapedVectorSpace)this.dataSpace, (ShapedVectorSpace)this.objectSpace);
        ShapedVector imgVector = this.dataSpace.create(this.imgArray);
        ShapedVector resultVector = this.objectSpace.create();
        H.setPSF(this.psfArray, null, ((Boolean)this.normalizePSF.getValue()).booleanValue());
        H.apply((Vector)resultVector, (Vector)imgVector);
        Sequence seqY = new Sequence();
        IcyImager.show(resultVector.asShapedArray(), seqY, this.dataSeq.getName() + "*" + this.seqPSF.getName(), this.isHeadLess());
        if (this.isHeadLess()) {
            if (this.outputHeadlessImage == null) {
                this.outputHeadlessImage = new EzVarSequence("Output Image");
            }
            this.outputHeadlessImage.setValue(seqY);
        }
    }

    public void clean() {
    }

    public void declareInput(VarList inputMap) {
        this.initialize();
        inputMap.add("image", (Var)this.data.getVariable());
        inputMap.add("image", this.channel.getVariable());
        inputMap.add("PSF", (Var)this.psf.getVariable());
        inputMap.add("PSF", this.psfchannel.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("output", (Var)this.outputHeadlessImage.getVariable());
    }

    public String getMainPluginClassName() {
        return "SimpleDEMIC";
    }

    protected void throwError(String s) {
        if (this.isHeadLess()) {
            throw new IllegalArgumentException(s);
        }
        new FailedAnnounceFrame(s);
    }
}

