/*
 * Decompiled with CFR 0.152.
 */
package plugins.ferreol.demics;

import icy.file.Loader;
import icy.gui.frame.progress.AnnounceFrame;
import icy.main.Icy;
import icy.sequence.Sequence;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.SwingUtilities;
import mitiv.array.ArrayUtils;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.conv.WeightedConvolutionCost;
import mitiv.cost.DifferentiableCostFunction;
import mitiv.cost.HyperbolicTotalVariation;
import mitiv.jobs.DeconvolutionJob;
import mitiv.linalg.shaped.ShapedVectorSpace;
import mitiv.utils.FFTUtils;
import mitiv.utils.HistoMap;
import mitiv.utils.TiPiHook;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzButton;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarChannel;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarListener;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.vars.lang.Var;
import plugins.ferreol.demics.DEMICSPlug;
import plugins.mitiv.io.DeconvHook;
import plugins.mitiv.io.Icy2TiPi;
import plugins.mitiv.io.IcyImager;

public class SimpleDEMIC
extends DEMICSPlug
implements Block,
EzStoppable {
    private EzVarSequence psf;
    private EzVarInteger paddingSizeX;
    private EzVarInteger paddingSizeY;
    private EzVarDouble epsilon;
    private EzVarBoolean normalizePSF;
    static boolean debug = false;
    private int psfSizeX = 1;
    private int psfSizeY = 1;
    private int psfSizeZ = 1;
    private EzVarChannel channelpsf;
    private EzGroup ezDeconvolutionGroup2;
    private IcyImager curImager;

    @Override
    protected void initialize() {
        super.initialize();
        this.psf = new EzVarSequence("PSF:");
        this.channelpsf = new EzVarChannel("PSF channel :", (Var)this.psf.getVariable(), false);
        this.psf.setNoSequenceSelection();
        this.normalizePSF = new EzVarBoolean("Normalize PSF (sum=1):", true);
        this.paddingSizeX = new EzVarInteger("padding x:", 0, Integer.MAX_VALUE, 1);
        this.paddingSizeY = new EzVarInteger("padding y:", 0, Integer.MAX_VALUE, 1);
        this.dataSizeTxt.setVisible(false);
        this.outputSizeTxt.setVisible(false);
        this.ezPaddingGroup = new EzGroup("Padding", new EzComponent[]{this.paddingSizeX, this.paddingSizeY, this.paddingSizeZ});
        this.ezPaddingGroup.setFoldedState(true);
        this.paddingSizeX.addVarChangeListener(this.zeroPadActionListener);
        this.paddingSizeY.addVarChangeListener(this.zeroPadActionListener);
        this.paddingSizeZ.addVarChangeListener(this.zeroPadActionListener);
        this.dataEV.addVarChangeListener((EzVarListener)new EzVarListener<Sequence>(){

            public void variableChanged(EzVar<Sequence> source, Sequence newValue) {
                if (debug) {
                    System.out.println("Seq ch..." + SimpleDEMIC.this.dataEV.getValue());
                }
                SimpleDEMIC.this.modelArray = null;
                SimpleDEMIC.this.dataChanged();
                SimpleDEMIC.this.updatePSFSize();
            }
        });
        this.psf.addVarChangeListener((EzVarListener)new EzVarListener<Sequence>(){

            public void variableChanged(EzVar<Sequence> source, Sequence newValue) {
                if (debug) {
                    System.out.println("PSF changed" + SimpleDEMIC.this.psf.getValue());
                }
                if (newValue != null || newValue != null && newValue.isEmpty()) {
                    SimpleDEMIC.this.psfSizeX = Math.max(1, newValue.getSizeX());
                    SimpleDEMIC.this.psfSizeY = Math.max(1, newValue.getSizeY());
                    SimpleDEMIC.this.psfSizeZ = Math.max(1, newValue.getSizeZ());
                    SimpleDEMIC.this.modelArray = null;
                    SimpleDEMIC.this.updatePSFSize();
                    SimpleDEMIC.this.updateImageSize();
                    if (debug) {
                        System.out.println("PSF changed:" + SimpleDEMIC.this.psfSizeX + "  " + SimpleDEMIC.this.psfSizeY);
                    }
                }
            }
        });
        this.epsilon = new EzVarDouble("Threshold level:", 0.01, 0.0, Double.MAX_VALUE, 1.0);
        this.ezDeconvolutionGroup2 = new EzGroup("More  parameters", new EzComponent[]{this.epsilon, this.scale, this.positivityEV, this.singlePrecision});
        this.ezDeconvolutionGroup2.setFoldedState(true);
        this.ezDeconvolutionGroup = new EzGroup("Deconvolution parameters", new EzComponent[]{this.logmu, this.mu, this.nbIterDeconv, this.ezDeconvolutionGroup2});
        this.startDecButton = new EzButton("Start Deconvolution", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SimpleDEMIC.this.deconvolver != null && SimpleDEMIC.this.deconvolver.isRunning()) {
                    SimpleDEMIC.this.stopExecution();
                } else {
                    Thread workerThread = new Thread(){

                        @Override
                        public void run() {
                            SimpleDEMIC.this.launch();
                        }
                    };
                    workerThread.start();
                }
            }
        });
        this.addEzComponent((EzComponent)this.dataEV);
        this.addEzComponent((EzComponent)this.channelEV);
        this.addEzComponent((EzComponent)this.psf);
        this.addEzComponent((EzComponent)this.channelpsf);
        this.addEzComponent((EzComponent)this.normalizePSF);
        this.addEzComponent((EzComponent)this.restartEV);
        this.addEzComponent((EzComponent)this.channelRestartEV);
        this.addEzComponent((EzComponent)this.dataSizeTxt);
        this.addEzComponent((EzComponent)this.outputSizeTxt);
        this.addEzComponent((EzComponent)this.ezPaddingGroup);
        this.ezWeightingGroup = new EzGroup("Weighting", new EzComponent[]{this.weightsMethod, this.weightsSeq, this.gain, this.noise, this.badpixMap, this.showWeightButton});
        this.ezWeightingGroup.setFoldedState(true);
        this.addEzComponent((EzComponent)this.ezWeightingGroup);
        this.addEzComponent((EzComponent)this.ezDeconvolutionGroup);
        this.addEzComponent((EzComponent)this.startDecButton);
        this.addEzComponent((EzComponent)this.groupVisu);
        this.addEzComponent((EzComponent)this.saveFile);
        this.addEzComponent((EzComponent)this.saveParam);
        this.addEzComponent((EzComponent)this.loadParam);
        this.setDefaultValue();
        this.updatePaddedSize();
        this.updateOutputSize();
        this.updateImageSize();
        if (!this.isHeadLess()) {
            this.outputSizeTxt.setEnabled(false);
            this.dataSizeTxt.setEnabled(false);
            this.mu.setEnabled(false);
        } else {
            this.outputHeadlessImage = new EzVarSequence("Output Image");
            this.outputHeadlessWght = new EzVarSequence("Computed weight");
        }
    }

    @Override
    protected void updatePaddedSize() {
        this.Nx = FFTUtils.bestDimension((int)Math.max(this.psfSizeX, this.sizeX + (Integer)this.paddingSizeX.getValue()));
        this.Ny = FFTUtils.bestDimension((int)Math.max(this.psfSizeY, this.sizeY + (Integer)this.paddingSizeY.getValue()));
        if (this.Nz == 1 && (Integer)this.paddingSizeZ.getValue() == 0) {
            this.outputShape = new Shape(this.Nx, this.Ny);
        } else {
            this.Nz = FFTUtils.bestDimension((int)Math.max(this.psfSizeZ, this.sizeZ + (Integer)this.paddingSizeZ.getValue()));
            this.outputShape = new Shape(this.Nx, this.Ny, this.Nz);
        }
        this.updateOutputSize();
        if (debug) {
            System.out.println(" UpdatePaddedSize" + this.paddingSizeX.getValue() + this.outputShape.toString());
        }
    }

    protected void updatePSFSize() {
        this.paddingSizeX.setValue((Object)Math.max(this.psfSizeX / 10, 10));
        this.paddingSizeY.setValue((Object)Math.max(this.psfSizeY / 10, 10));
        if (this.psfSizeZ == 1) {
            this.paddingSizeZ.setValue((Object)0);
        } else {
            this.paddingSizeZ.setValue((Object)Math.max(this.psfSizeZ / 10, 10));
        }
        this.updatePaddedSize();
        if (debug) {
            System.out.println(" UpdatePaddedSize " + this.paddingSizeX.getValue() + this.outputShape.toString());
        }
    }

    protected void execute() {
        if (this.isHeadLess()) {
            if (Icy.getCommandLinePluginArgs().length != 0) {
                this.initialize();
                this.parseCmdLine();
            }
            this.showIteration.setValue((Object)false);
            if (debug) {
                System.out.println("Launch it:" + this.nbIterDeconv.getValue());
            }
        }
        this.launch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void launch() {
        try {
            this.startDecButton.setText("Emergency stop");
            this.dataSeq = (Sequence)this.dataEV.getValue();
            Sequence psfSeq = (Sequence)this.psf.getValue();
            Sequence restartSeq = (Sequence)this.restartEV.getValue();
            if (this.dataSeq == null) {
                this.throwError("An image should be given");
                return;
            }
            if (psfSeq == null) {
                this.throwError("A psf should be given");
                return;
            }
            if (this.sizeZ == 1 && this.sizeY == 1) {
                this.throwError("Input data must be 2D or 3D");
                return;
            }
            if ((double)((Integer)this.paddingSizeX.getValue()).intValue() < 0.0) {
                this.throwError("Padding value cannot be negative");
                return;
            }
            if ((double)((Integer)this.paddingSizeY.getValue()).intValue() < 0.0) {
                this.throwError("Padding value cannot be negative");
                return;
            }
            if ((double)((Integer)this.paddingSizeZ.getValue()).intValue() < 0.0) {
                this.throwError("Padding value cannot be negative");
                return;
            }
            if (((Boolean)this.singlePrecision.getValue()).booleanValue()) {
                this.dataArray = Icy2TiPi.sequenceToArray(this.dataSeq, (Integer)this.channelEV.getValue()).toFloat();
                this.psfArray = Icy2TiPi.sequenceToArray(psfSeq, (Integer)this.channelpsf.getValue()).toFloat();
            } else {
                this.dataArray = Icy2TiPi.sequenceToArray(this.dataSeq, (Integer)this.channelEV.getValue()).toDouble();
                this.psfArray = Icy2TiPi.sequenceToArray(psfSeq, (Integer)this.channelpsf.getValue()).toDouble();
            }
            if (this.restartEV.getValue() != null && restartSeq != null) {
                this.objArray = Icy2TiPi.sequenceToArray(restartSeq, (Integer)this.channelRestartEV.getValue());
                if (debug) {
                    System.out.println("restart seq:" + restartSeq.getName());
                }
            } else {
                this.objArray = Icy2TiPi.sequenceToArray(this.dataSeq, (Integer)this.channelEV.getValue());
                if (debug) {
                    System.out.println("restart seq is null:");
                }
            }
            this.createWeights(true);
            this.cursequence = new Sequence("Current Iterate");
            this.cursequence.copyMetaDataFrom(this.dataSeq, false);
            if (this.Nz == 1) {
                if (((double[])this.scale.getValue()).length != 2) {
                    this.throwError("Pixel scale must have 2 elements");
                    return;
                }
            } else if (((double[])this.scale.getValue()).length != 3) {
                this.throwError("Pixel scale must have 3 elements");
                return;
            }
            if (debug) {
                System.out.println("Launch it:" + this.nbIterDeconv.getValue());
            }
            this.curImager = new IcyImager(this.cursequence, this.isHeadLess());
            DeconvHook dHook = new DeconvHook(this.curImager, this.dataShape, null, debug);
            DeconvHook dHookfinal = new DeconvHook(this.curImager, this.dataShape, "Deconvolved " + this.dataSeq.getName(), debug);
            this.buildVectorSpaces();
            this.fprior = new HyperbolicTotalVariation(this.objectSpace, ((Double)this.epsilon.getValue()).doubleValue(), (double[])this.scale.getValue());
            this.fdata = WeightedConvolutionCost.build((ShapedVectorSpace)this.objectSpace, (ShapedVectorSpace)this.dataSpace);
            this.fdata.setData(this.dataArray);
            this.fdata.setWeights(this.wgtArray, true);
            this.fdata.setPSF(this.psfArray, ((Boolean)this.normalizePSF.getValue()).booleanValue());
            this.deconvolver = new DeconvolutionJob((DifferentiableCostFunction)this.fdata, ((Double)this.mu.getValue()).doubleValue(), this.fprior, ((Boolean)this.positivityEV.getValue()).booleanValue(), ((Integer)this.nbIterDeconv.getValue()).intValue(), (TiPiHook)dHook, (TiPiHook)dHookfinal);
            this.objArray = ArrayUtils.extract((ShapedArray)this.objArray, (Shape)this.outputShape, (double)this.fdata.getWeightedMean());
            this.objArray = this.deconvolver.deconv(this.objArray);
            if (this.weightsMethod.getValue() == this.weightOptions[4]) {
                this.modelArray = this.fdata.getModel(this.objArray).asShapedArray();
                HistoMap hm = new HistoMap(this.modelArray, this.dataArray, this.badpixArray);
                this.gain.setValue((Object)hm.getAlpha());
                this.noise.setValue((Object)(Math.sqrt(hm.getBeta()) / hm.getAlpha()));
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (debug) {
                        System.out.println("invoke later");
                    }
                    SimpleDEMIC.this.restartEV.setValue(SimpleDEMIC.this.cursequence);
                    SimpleDEMIC.this.channelRestartEV.setValue((Object)0);
                    if (SimpleDEMIC.this.isHeadLess()) {
                        if (SimpleDEMIC.this.outputHeadlessImage == null) {
                            SimpleDEMIC.this.outputHeadlessImage = new EzVarSequence("Output Image");
                        }
                        SimpleDEMIC.this.outputHeadlessImage.setValue(SimpleDEMIC.this.cursequence);
                        if (SimpleDEMIC.this.outputHeadlessWght == null) {
                            SimpleDEMIC.this.outputHeadlessWght = new EzVarSequence("Computed weightsSeq");
                        }
                        SimpleDEMIC.this.outputHeadlessWght.setValue(Icy2TiPi.arrayToSequence(SimpleDEMIC.this.wgtArray));
                        if (SimpleDEMIC.this.outputPath != null) {
                            IcyImager.save(SimpleDEMIC.this.cursequence, SimpleDEMIC.this.outputPath);
                        }
                        if (SimpleDEMIC.this.saveFile.getValue() != null) {
                            SimpleDEMIC.this.saveParamClicked();
                        }
                    }
                }
            });
        }
        catch (IllegalArgumentException e) {
            new AnnounceFrame("Oops, Error: " + e.getMessage());
            if (debug) {
                e.printStackTrace();
            }
        }
        finally {
            this.startDecButton.setText("Start Deconvolution");
        }
    }

    public void stopExecution() {
        if (this.deconvolver != null) {
            this.deconvolver.abort();
        }
    }

    @Override
    protected void setDefaultValue() {
        super.setDefaultValue();
        this.paddingSizeX.setValue((Object)10);
        this.paddingSizeY.setValue((Object)10);
        this.paddingSizeZ.setValue((Object)10);
    }

    @Override
    public void declareInput(VarList inputMap) {
        this.initialize();
        super.declareInput(inputMap);
        inputMap.add("psf", (Var)this.psf.getVariable());
        inputMap.add("psf channel", this.channelpsf.getVariable());
        inputMap.add("psf normalization", this.normalizePSF.getVariable());
        inputMap.add("Padding X", this.paddingSizeX.getVariable());
        inputMap.add("Padding Y", this.paddingSizeY.getVariable());
        inputMap.add("Padding Z", this.paddingSizeZ.getVariable());
        inputMap.add("espilon", this.epsilon.getVariable());
    }

    public void clean() {
        this.stopExecution();
    }

    private void parseCmdLine() {
        String[] args = Icy.getCommandLinePluginArgs();
        this.normalizePSF.setValue((Object)false);
        this.loadParameters(new File(args[0]));
        block18: for (int i = 1; i < args.length; ++i) {
            switch (args[i]) {
                case "-i": {
                    if (i + 1 >= args.length) continue block18;
                    System.out.println("load image:" + args[i + 1]);
                    this.dataEV.setValue(Loader.loadSequence((String)args[i + 1], (int)0, (boolean)false));
                    this.dataEV.valueChanged((Var)this.dataEV.getVariable(), null, this.dataEV.getValue());
                    if (i + 3 >= args.length || args[i + 1].startsWith("-")) continue block18;
                    if (args[i + 2].equalsIgnoreCase("-c")) {
                        this.channelEV.setValue((Object)Integer.parseInt(args[i + 3]));
                        i += 3;
                        continue block18;
                    }
                    ++i;
                    continue block18;
                }
                case "-p": {
                    if (i + 1 >= args.length || args[i + 1].startsWith("-")) continue block18;
                    System.out.println("load psf:" + args[i + 1]);
                    this.psf.setValue(Loader.loadSequence((String)args[i + 1], (int)0, (boolean)false));
                    if (i + 3 >= args.length) continue block18;
                    if (args[i + 2].equalsIgnoreCase("-c")) {
                        this.channelpsf.setValue((Object)Integer.parseInt(args[i + 3]));
                        i += 3;
                        continue block18;
                    }
                    ++i;
                    continue block18;
                }
                case "-r": {
                    if (i + 1 >= args.length || args[i + 1].startsWith("-")) continue block18;
                    System.out.println("load restart:" + args[i + 1]);
                    this.restartEV.setValue(Loader.loadSequence((String)args[i + 1], (int)0, (boolean)false));
                    if (i + 3 >= args.length) continue block18;
                    if (args[i + 2].equalsIgnoreCase("-c")) {
                        System.out.println("channel restart:" + Integer.parseInt(args[i + 3]));
                        this.channelRestartEV.setValue((Object)Integer.parseInt(args[i + 3]));
                        i += 3;
                        continue block18;
                    }
                    ++i;
                    continue block18;
                }
                case "-o": {
                    if (i + 1 >= args.length) continue block18;
                    this.outputPath = args[i + 1];
                    ++i;
                    continue block18;
                }
                case "-badpix": {
                    if (i + 1 >= args.length || args[i + 1].startsWith("-")) continue block18;
                    this.badpixMap.setValue(Loader.loadSequence((String)args[i + 1], (int)0, (boolean)false));
                    ++i;
                    continue block18;
                }
                case "-wghtmap": {
                    if (i + 1 >= args.length || args[i + 1].startsWith("-")) continue block18;
                    this.weightsSeq.setValue(Loader.loadSequence((String)args[i + 1], (int)0, (boolean)false));
                    ++i;
                    continue block18;
                }
                case "-n": {
                    this.normalizePSF.setValue((Object)true);
                }
                default: {
                    System.out.println("Usage: ");
                    System.out.println("java -jar -Xms24G icy.jar -hl -x plugins.ferreol.demics.SimpleDEMIC ParametersFile.xml -i DataFile   -c CHANNELNUMBER   -p PSFFile  -c CHANNELNUMBER  -r InitialGuessFile -c CHANNELNUMBER  -o DeconvolvedOutputFile");
                    System.out.println("Wrong command line");
                    System.out.println("-i input data file");
                    System.out.println("-p psf file");
                    System.out.println("-n normalize PSF");
                    System.out.println("-r restart file");
                    System.out.println("-o deconvolved output file");
                    System.out.println("-badpix bad pixels file");
                    System.out.println("-wghtmap weight or variance map file");
                }
            }
        }
    }

    @Override
    protected void loadParamClicked() {
        File loadName = (File)this.loadFile.getValue();
        if (!this.isHeadLess()) {
            new AnnounceFrame("Loading deconvolution parameters from " + loadName.getAbsolutePath().toString(), 3);
        }
        this.loadParameters((File)this.loadFile.getValue());
        this.loadFile.setValue((Object)loadName);
        if (this.dataSeq != null) {
            this.sizeX = this.dataSeq.getSizeX();
            this.sizeY = this.dataSeq.getSizeY();
            this.sizeZ = this.dataSeq.getSizeZ();
            this.updatePaddedSize();
            this.updateOutputSize();
            this.updateImageSize();
            this.dataShape = new Shape(this.sizeX, this.sizeY, this.sizeZ);
        }
    }

    @Override
    protected void saveParamClicked() {
        File pathName = (File)this.saveFile.getValue();
        if (pathName != null) {
            if (!pathName.getName().endsWith(".xml")) {
                pathName = new File(pathName.getAbsolutePath() + ".xml");
            }
            if (!this.isHeadLess()) {
                new AnnounceFrame("Saving deconvolution parameters in " + pathName.getAbsolutePath().toString(), 3);
            }
            this.saveParameters(pathName);
        }
    }
}

