/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.roi;

import icy.file.FileUtil;
import icy.gui.dialog.SaveDialog;
import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.util.GuiUtil;
import icy.plugin.interface_.PluginBundled;
import icy.roi.ROI;
import icy.roi.ROIDescriptor;
import icy.roi.ROIUtil;
import icy.sequence.Sequence;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.poi.ss.usermodel.Workbook;
import org.math.plot.Plot2DPanel;
import org.math.plot.plots.Plot;
import plugins.adufour.activecontours.ActiveContour;
import plugins.adufour.activecontours.ActiveContours;
import plugins.adufour.blocks.tools.io.WorkbookToFile;
import plugins.adufour.roi.ROIMeasures;
import plugins.adufour.vars.gui.VarEditor;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarChannel;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.util.VarListener;
import plugins.adufour.workbooks.IcySpreadSheet;
import plugins.adufour.workbooks.Workbooks;
import plugins.fab.trackmanager.PluginTrackManagerProcessor;
import plugins.fab.trackmanager.TrackGroup;
import plugins.fab.trackmanager.TrackSegment;
import plugins.kernel.roi.roi2d.ROI2DArea;
import plugins.kernel.roi.roi3d.ROI3DArea;
import plugins.nchenouard.particletracking.DetectionSpotTrack;
import plugins.nchenouard.spot.Detection;
import plugins.nchenouard.spot.Point3D;

public class ROIStatisticsTrackProcessor
extends PluginTrackManagerProcessor
implements PluginBundled {
    private final JButton exportButton = new JButton("Export to XLS...");
    private final JComboBox<ROIDescriptorWrapper> jComboDescriptors;
    private VarSequence sequence = new VarSequence("Sequence", null);
    private VarChannel channel = new VarChannel("Channel", (Var)this.sequence, false);
    private VarEditor<Integer> channelSelector = this.channel.createVarEditor();
    private final JPanel chartPanel;
    private final Plot2DPanel plotPanel;

    public String getMainPluginClassName() {
        return ROIMeasures.class.getName();
    }

    public ROIStatisticsTrackProcessor() {
        super.getDescriptor().setDescription("Monitor shape and intensity over time");
        super.setName("ROI Statistics");
        Map map = ROIUtil.getROIDescriptors();
        Vector<ROIDescriptorWrapper> descriptors = new Vector<ROIDescriptorWrapper>(map.size());
        for (ROIDescriptor desc : map.keySet()) {
            if (!Number.class.isAssignableFrom(desc.getType())) continue;
            descriptors.addElement(new ROIDescriptorWrapper(desc));
        }
        Collections.sort(descriptors);
        this.jComboDescriptors = new JComboBox(descriptors);
        this.panel.setLayout(new BoxLayout(this.panel, 3));
        this.panel.add(Box.createVerticalStrut(5));
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ROIStatisticsTrackProcessor.this.export();
            }
        });
        this.exportButton.setEnabled(false);
        this.panel.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createHorizontalStrut(10), new JLabel("Plot:"), Box.createHorizontalStrut(5), this.jComboDescriptors, Box.createHorizontalStrut(10), new JLabel("Channel:"), Box.createHorizontalStrut(5), (JComponent)this.channelSelector.getEditorComponent(), Box.createHorizontalStrut(10), this.exportButton, Box.createHorizontalStrut(10)}));
        this.jComboDescriptors.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ROIStatisticsTrackProcessor.this.Compute();
            }
        });
        this.channel.addListener((VarListener)new VarListener<Integer>(){

            public void valueChanged(Var<Integer> source, Integer oldValue, Integer newValue) {
                ROIStatisticsTrackProcessor.this.Compute();
            }

            public void referenceChanged(Var<Integer> source, Var<? extends Integer> oldReference, Var<? extends Integer> newReference) {
            }
        });
        this.chartPanel = new JPanel();
        this.panel.add(this.chartPanel);
        this.plotPanel = new Plot2DPanel();
        this.plotPanel.setPreferredSize(new Dimension(500, 300));
    }

    public void Close() {
        this.channelSelector.setEnabled(false);
    }

    public void Compute() {
        this.chartPanel.removeAll();
        if (!super.isEnabled()) {
            return;
        }
        Sequence seq = this.trackPool.getDisplaySequence();
        if (seq == null) {
            this.chartPanel.add(new JLabel("Cannot compute descriptors without a display sequence"));
            return;
        }
        this.sequence.setValue(seq);
        ROIDescriptorWrapper descriptor = (ROIDescriptorWrapper)this.jComboDescriptors.getSelectedItem();
        String name = descriptor.descriptor.getName();
        String unit = descriptor.descriptor.getUnit(seq);
        String title = name + " (" + (unit == null ? "a.u." : unit) + ")";
        this.plotPanel.removeAllPlots();
        this.plotPanel.removeAllPlotables();
        this.plotPanel.setAxisLabels(new String[]{"Time (sec.)", title});
        this.channelSelector.setEnabled(descriptor.descriptor.separateChannel());
        String[] trackIDs = new String[this.trackPool.getTrackSegmentList().size()];
        try {
            int trackID = 0;
            block2: for (TrackSegment ts : this.trackPool.getTrackSegmentList()) {
                if (!ts.isAllDetectionEnabled()) continue;
                TrackGroup trackGroup = this.trackPool.getTrackGroupContainingSegment(ts);
                int id = trackGroup.getTrackSegmentList().indexOf(ts);
                trackIDs[trackID] = trackGroup.getDescription() + " #" + id;
                ArrayList detections = ts.getDetectionList();
                double[][] xy = new double[detections.size()][];
                int detID = 0;
                for (Detection det : detections) {
                    ROI2DArea roi = null;
                    if (det instanceof DetectionSpotTrack) {
                        if (seq.getSizeZ() == 1) {
                            roi = new ROI2DArea();
                            for (Point3D pt : ((DetectionSpotTrack)det).spot.point3DList) {
                                roi.addPoint((int)pt.x, (int)pt.y);
                            }
                        } else {
                            roi = new ROI3DArea();
                            for (Point3D pt : ((DetectionSpotTrack)det).spot.point3DList) {
                                ((ROI3DArea)roi).addPoint((int)pt.x, (int)pt.y, (int)pt.z);
                            }
                        }
                    } else if (det instanceof ActiveContour) {
                        roi = ((ActiveContour)det).toROI(ActiveContours.ROIType.AREA, seq);
                    }
                    if (roi == null) continue block2;
                    if (descriptor.descriptor.separateChannel()) {
                        roi = roi.getSubROI(-1, -1, this.channel.getValue().intValue());
                    }
                    if (roi.isEmpty()) {
                        xy[detID++] = new double[]{(double)det.getT() * seq.getTimeInterval(), 0.0};
                        continue;
                    }
                    xy[detID++] = new double[]{(double)det.getT() * seq.getTimeInterval(), (Double)descriptor.descriptor.compute((ROI)roi, seq)};
                }
                this.plotPanel.addLinePlot(trackIDs[trackID], ts.getFirstDetection().getColor(), (double[][])xy);
                ++trackID;
            }
            if (this.plotPanel.getPlots().size() > 0) {
                this.chartPanel.add((Component)this.plotPanel);
                this.exportButton.setEnabled(true);
            } else {
                this.chartPanel.add(new JLabel("No statistics available. This may happen when tracking particles (with no shape)"));
                this.exportButton.setEnabled(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.chartPanel.add(new JLabel("Cannot compute descriptor: " + e.getMessage()));
            this.exportButton.setEnabled(false);
        }
        this.panel.updateUI();
    }

    public void displaySequenceChanged() {
        this.sequence.setValue(this.trackPool.getDisplaySequence());
        this.Compute();
    }

    private void export() {
        if (this.plotPanel.getPlots().size() == 0) {
            return;
        }
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ROIDescriptorWrapper descriptor = (ROIDescriptorWrapper)ROIStatisticsTrackProcessor.this.jComboDescriptors.getSelectedItem();
                String name = descriptor.descriptor.getName();
                String xlsFolder = ROIStatisticsTrackProcessor.this.getPreferencesRoot().get("xlsFolder", null);
                String path = SaveDialog.chooseFile((String)"Export statistics", (String)xlsFolder, (String)name, (String)".xls");
                if (path == null) {
                    return;
                }
                ROIStatisticsTrackProcessor.this.getPreferencesRoot().put("xlsFolder", FileUtil.getDirectory((String)path));
                try (AnnounceFrame message = new AnnounceFrame("Exporting statistics...", 0);){
                    Workbook wb = Workbooks.createEmptyWorkbook();
                    IcySpreadSheet sheet = Workbooks.getSheet((Workbook)wb, (String)name);
                    double tScale = ROIStatisticsTrackProcessor.this.trackPool.getDisplaySequence().getTimeInterval();
                    sheet.setValue(0, 0, (Object)"Time (sec.)");
                    for (int t = 0; t < ROIStatisticsTrackProcessor.this.trackPool.getDisplaySequence().getSizeT(); ++t) {
                        sheet.setValue(t + 1, 0, (Object)((double)t * tScale));
                    }
                    int column = 1;
                    for (Plot plot : ROIStatisticsTrackProcessor.this.plotPanel.getPlots()) {
                        double[][] data = plot.getData();
                        sheet.setValue(0, column, (Object)plot.getName());
                        for (double[] xy : data) {
                            int row = 1 + (int)Math.round(xy[0] / tScale);
                            sheet.setValue(row, column, (Object)xy[1]);
                        }
                        ++column;
                    }
                    WorkbookToFile.saveAsSpreadSheet((Workbook)wb, (String)path, (WorkbookToFile.MergePolicy)WorkbookToFile.MergePolicy.Overwrite);
                }
            }
        }.start();
    }

    private static class ROIDescriptorWrapper
    implements Comparable<ROIDescriptorWrapper> {
        final ROIDescriptor descriptor;

        public ROIDescriptorWrapper(ROIDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public String toString() {
            return this.descriptor.getName();
        }

        @Override
        public int compareTo(ROIDescriptorWrapper otherDescriptor) {
            return this.toString().compareTo(otherDescriptor.toString());
        }
    }
}

