/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.roi;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginROIDescriptor;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROI3D;
import icy.roi.ROIDescriptor;
import icy.sequence.Sequence;
import icy.type.point.Point3D;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3d;
import plugins.adufour.roi.Convexify;
import plugins.adufour.roi.ROIMeasures;
import plugins.adufour.roi.mesh.Vertex3D;
import plugins.adufour.roi.mesh.polygon.ROI3DPolygonalMesh;
import plugins.kernel.roi.roi2d.ROI2DRectShape;

public class ROIFeretDiameterDescriptor
extends Plugin
implements PluginROIDescriptor,
PluginBundled {
    private static final ROIFeretDiameter feretDiameter = new ROIFeretDiameter();

    public List<ROIDescriptor> getDescriptors() {
        ArrayList<ROIDescriptor> descriptors = new ArrayList<ROIDescriptor>(1);
        descriptors.add(feretDiameter);
        return descriptors;
    }

    public Map<ROIDescriptor, Object> compute(ROI roi, Sequence sequence) throws UnsupportedOperationException {
        HashMap<ROIDescriptor, Object> map = new HashMap<ROIDescriptor, Object>();
        map.put(feretDiameter, feretDiameter.compute(roi, sequence));
        return map;
    }

    public String getMainPluginClassName() {
        return ROIMeasures.class.getName();
    }

    public static class ROIFeretDiameter
    extends ROIDescriptor {
        protected ROIFeretDiameter() {
            super("Feret", Double.class);
        }

        public String getDescription() {
            return "Feret (aka caliper) diameter (maximum distance between any 2 points of this ROI)";
        }

        public String getUnit(Sequence sequence) {
            if (sequence == null) {
                return "px";
            }
            return "um";
        }

        public Object compute(ROI roi, Sequence sequence) throws UnsupportedOperationException {
            return ROIFeretDiameter.computeFeretDiameter(roi, sequence);
        }

        public static double computeFeretDiameter(ROI roi, Sequence sequence) {
            double scaleX = 1.0;
            double scaleY = 1.0;
            double scaleZ = 1.0;
            if (sequence != null) {
                scaleX = sequence.getPixelSizeX();
                scaleY = sequence.getPixelSizeY();
                scaleZ = sequence.getPixelSizeZ();
            }
            double maxDistance = 0.0;
            if (roi instanceof ROI2D) {
                if (roi instanceof ROI2DRectShape) {
                    Rectangle2D bounds = ((ROI2D)roi).getBounds2D();
                    maxDistance = Math.max(bounds.getWidth() * scaleX, bounds.getHeight() * scaleY);
                } else {
                    Point[] pts = ((ROI2D)roi).getBooleanMask(true).getContourPoints();
                    Point2D.Double pi = new Point2D.Double();
                    Point2D.Double pj = new Point2D.Double();
                    for (int i = 0; i < pts.length; ++i) {
                        ((Point2D)pi).setLocation(pts[i].getX() * scaleX, pts[i].getY() * scaleY);
                        for (int j = i + 1; j < pts.length; ++j) {
                            ((Point2D)pj).setLocation(pts[j].getX() * scaleX, pts[j].getY() * scaleY);
                            double distance = pi.distanceSq(pj);
                            if (!(distance > maxDistance)) continue;
                            maxDistance = distance;
                        }
                    }
                    maxDistance = Math.sqrt(maxDistance);
                }
            } else if (roi instanceof ROI3D) {
                Point3d[] points = null;
                if (roi.getNumberOfPoints() > 100.0) {
                    try {
                        roi = Convexify.createConvexROI((ROI)roi);
                        List vertices = ((ROI3DPolygonalMesh)roi).getVertices();
                        int n = vertices.size();
                        points = new Point3d[n];
                        for (int i = 0; i < n; ++i) {
                            Point3d p = new Point3d(((Vertex3D)vertices.get((int)i)).position);
                            p.x *= scaleX;
                            p.y *= scaleY;
                            p.z *= scaleZ;
                            points[i] = p;
                        }
                    }
                    catch (Throwable vertices) {
                        // empty catch block
                    }
                }
                if (points == null) {
                    Point3D.Integer[] pts = ((ROI3D)roi).getBooleanMask(true).getContourPoints();
                    points = new Point3d[pts.length];
                    for (int i = 0; i < pts.length; ++i) {
                        points[i] = new Point3d((double)pts[i].x * scaleX, (double)pts[i].y * scaleY, (double)pts[i].z * scaleZ);
                    }
                }
                for (int i = 0; i < points.length; ++i) {
                    for (int j = i + 1; j < points.length; ++j) {
                        double distance = points[i].distanceSquared(points[j]);
                        if (!(distance > maxDistance)) continue;
                        maxDistance = distance;
                    }
                }
                maxDistance = Math.sqrt(maxDistance);
            } else {
                System.err.println("Cannot compute Max. Feret diameter for ROI of type: " + roi.getClassName());
                maxDistance = 0.0;
            }
            return maxDistance;
        }
    }
}

