/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.vars.lang;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarMutable;
import plugins.adufour.vars.util.VarException;
import plugins.adufour.vars.util.VarListener;

public class VarMutableArray
extends VarMutable
implements Iterable<Object> {
    public VarMutableArray(String name, Class<?> initialType) throws IllegalArgumentException {
        this(name, initialType, (VarListener<?>)null);
    }

    public VarMutableArray(String name, Class<?> initialType, VarListener<?> defaultListener) throws IllegalArgumentException {
        super(name, initialType, defaultListener);
        if (!initialType.isArray()) {
            throw new IllegalArgumentException("The initial type " + initialType + " is not an array type");
        }
    }

    @Override
    public boolean isAssignableFrom(Var source) {
        return super.isAssignableFrom(source);
    }

    public <T> T getElementAt(int index) throws NullPointerException, ClassCastException {
        return (T)Array.get(this.getValue(), index);
    }

    public int size() {
        return this.getValue() == null ? -1 : Array.getLength(this.getValue());
    }

    @Override
    public void setType(Class<?> newType) throws IllegalArgumentException {
        if (!newType.isArray()) {
            throw new IllegalArgumentException("The new type " + newType + " is not an array type");
        }
        super.setType(newType);
    }

    public Object getValue(boolean forbidNull) throws VarException {
        Var reference = this.getReference();
        if (reference == null) {
            return super.getValue(forbidNull);
        }
        Object value = reference.getValue();
        if (value == null) {
            return super.getValue(forbidNull);
        }
        if (value.getClass().isArray()) {
            return value;
        }
        Object array = Array.newInstance(value.getClass(), 1);
        Array.set(array, 0, value);
        return array;
    }

    @Override
    public Iterator<Object> iterator() {
        if (this.getValue() == null) {
            return Collections.emptyList().iterator();
        }
        return Arrays.asList(this.getValue()).iterator();
    }
}

