/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.Microscopy.MicroManager.gui;

import icy.gui.component.button.IcyButton;
import icy.gui.component.button.IcyToggleButton;
import icy.gui.dialog.MessageDialog;
import icy.main.Icy;
import icy.math.FPSMeter;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;
import icy.system.IcyExceptionHandler;
import icy.util.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import mmcorej.CMMCore;
import mmcorej.TaggedImage;
import org.json.JSONObject;
import org.micromanager.MMStudio;
import plugins.tprovoost.Microscopy.MicroManager.MicroManager;
import plugins.tprovoost.Microscopy.MicroManager.event.LiveListener;
import plugins.tprovoost.Microscopy.MicroManager.gui.LiveSettingsPanel;
import plugins.tprovoost.Microscopy.MicroManager.gui.MMMainFrame;
import plugins.tprovoost.Microscopy.MicroManager.tools.MMUtils;
import plugins.tprovoost.Microscopy.MicroManager.tools.StageMover;

public class ActionsPanel
extends JPanel
implements LiveListener,
SequenceListener {
    private static final long serialVersionUID = -1799340043444887652L;
    final MMMainFrame mainFrame;
    Sequence liveSequence;
    Sequence albumSequence;
    final FPSMeter fpsMeter;
    StackAcquisitionProcessor stackAcquisitionProcessor;
    long liveDate;
    long albumDate;
    private IcyButton snapBtn;
    private IcyToggleButton liveBtn;
    private IcyButton albumBtn;
    private IcyButton advAcqBtn;
    private IcyButton refreshBtn;

    public ActionsPanel(MMMainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.liveSequence = null;
        this.liveDate = 0L;
        this.albumSequence = null;
        this.albumDate = 0L;
        this.fpsMeter = new FPSMeter();
        this.stackAcquisitionProcessor = null;
        this.initialize();
        this.snapBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionsPanel.this.doSnap();
            }
        });
        this.liveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionsPanel.this.setLiveMode(((IcyToggleButton)e.getSource()).isSelected());
            }
        });
        this.albumBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionsPanel.this.doAlbumSnap();
            }
        });
        this.advAcqBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionsPanel.this.startAdvAcq();
            }
        });
        this.refreshBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionsPanel.this.refreshGUI();
            }
        });
        MicroManager.addLiveListener(this);
    }

    private void initialize() {
        this.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Actions", 4, 2, null, new Color(0, 0, 0)));
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{80, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        this.snapBtn = new IcyButton("Snap", new IcyIcon(ResourceUtil.ICON_PHOTO));
        this.snapBtn.setToolTipText("Snap an image");
        this.snapBtn.setIconTextGap(12);
        GridBagConstraints gbc_snapBtn = new GridBagConstraints();
        gbc_snapBtn.fill = 1;
        gbc_snapBtn.insets = new Insets(0, 0, 5, 0);
        gbc_snapBtn.gridx = 0;
        gbc_snapBtn.gridy = 0;
        this.add((Component)this.snapBtn, gbc_snapBtn);
        this.liveBtn = new IcyToggleButton("Live", new IcyIcon("camera"));
        this.liveBtn.setToolTipText("Enable / Disable the live display");
        this.liveBtn.setIconTextGap(12);
        GridBagConstraints gbc_liveBtn = new GridBagConstraints();
        gbc_liveBtn.fill = 1;
        gbc_liveBtn.insets = new Insets(0, 0, 5, 0);
        gbc_liveBtn.gridx = 0;
        gbc_liveBtn.gridy = 1;
        this.add((Component)this.liveBtn, gbc_liveBtn);
        this.albumBtn = new IcyButton("Album", new IcyIcon("movie"));
        this.albumBtn.setToolTipText("Snap an image and store it in the album");
        this.albumBtn.setIconTextGap(12);
        GridBagConstraints gbc_albumBtn = new GridBagConstraints();
        gbc_albumBtn.fill = 1;
        gbc_albumBtn.insets = new Insets(0, 0, 5, 0);
        gbc_albumBtn.gridx = 0;
        gbc_albumBtn.gridy = 2;
        this.add((Component)this.albumBtn, gbc_albumBtn);
        this.advAcqBtn = new IcyButton("Multi-D Acq.", new IcyIcon(ResourceUtil.ICON_LAYER_V1));
        this.advAcqBtn.setToolTipText("Multi dimension acquisition");
        this.advAcqBtn.setIconTextGap(8);
        GridBagConstraints gbc_advAcqBtn = new GridBagConstraints();
        gbc_advAcqBtn.insets = new Insets(0, 0, 5, 0);
        gbc_advAcqBtn.fill = 1;
        gbc_advAcqBtn.gridx = 0;
        gbc_advAcqBtn.gridy = 3;
        this.add((Component)this.advAcqBtn, gbc_advAcqBtn);
        this.refreshBtn = new IcyButton("Refresh", new IcyIcon(ResourceUtil.ICON_RELOAD));
        this.refreshBtn.setToolTipText("Force GUI refresh");
        this.refreshBtn.setIconTextGap(12);
        GridBagConstraints gbc_refreshBtn = new GridBagConstraints();
        gbc_refreshBtn.fill = 1;
        gbc_refreshBtn.gridx = 0;
        gbc_refreshBtn.gridy = 4;
        this.add((Component)this.refreshBtn, gbc_refreshBtn);
    }

    public void shutdown() {
        MicroManager.removeLiveListener(this);
    }

    MMStudio getMMStudio() {
        return this.mainFrame.mmstudio;
    }

    CMMCore getCore() {
        return this.getMMStudio().getCore();
    }

    public void lock() {
        this.mainFrame.lock();
    }

    public void unlock() {
        this.mainFrame.unlock();
    }

    public void logError(Exception e) {
        this.getMMStudio().logError(e);
    }

    public void logError(Exception e, String msg) {
        this.getMMStudio().logError(e, msg);
    }

    public void setLiveMode(boolean enable) {
        if (!ActionsPanel.hasCamera(true)) {
            this.liveBtn.setSelected(false);
            return;
        }
        this.prepareSequences();
        if (enable) {
            try {
                MicroManager.startLiveMode();
                if (!Icy.getMainInterface().isOpened(this.liveSequence)) {
                    Icy.getMainInterface().addSequence(this.liveSequence);
                }
            }
            catch (Throwable t) {
                IcyExceptionHandler.handleException((Throwable)t, (boolean)true);
            }
        } else {
            try {
                MicroManager.stopLiveMode();
            }
            catch (Throwable t) {
                IcyExceptionHandler.handleException((Throwable)t, (boolean)true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSnap() {
        if (!ActionsPanel.hasCamera(true)) {
            return;
        }
        boolean liveRunning = MicroManager.isLiveRunning();
        LiveSettingsPanel livePanel = this.mainFrame.livePanel;
        String prefix = livePanel.hasCustomAcqName() ? livePanel.getAcqName() : "Image snap";
        Sequence sequence = new Sequence(prefix + (livePanel.hasDateSuffix() ? " - " + MMUtils.getDateString() : ""));
        try {
            if (liveRunning) {
                MicroManager.stopLiveMode();
            }
            if (livePanel.isZStackAcquisition()) {
                double start = livePanel.getZStart();
                double end = livePanel.getZEnd();
                double step = livePanel.getZStep();
                if (this.stackAcquisitionProcessor != null && this.stackAcquisitionProcessor.isAlive()) {
                    return;
                }
                this.stackAcquisitionProcessor = new StackAcquisitionProcessor(sequence, start, end, step, Calendar.getInstance().getTimeInMillis());
            } else {
                long tstart = Calendar.getInstance().getTimeInMillis();
                for (TaggedImage image : MicroManager.snapTaggedImage()) {
                    MMUtils.setImage(sequence, image, tstart);
                }
            }
            JSONObject metadata = MicroManager.getAcquisitionMetaData();
            if (metadata != null) {
                MMUtils.setMetadata(sequence, metadata);
            }
            Icy.getMainInterface().addSequence(sequence);
        }
        catch (Throwable t) {
            IcyExceptionHandler.handleException((Throwable)t, (boolean)true);
        }
        finally {
            try {
                if (liveRunning) {
                    MicroManager.startLiveMode();
                }
            }
            catch (Throwable t) {
                IcyExceptionHandler.handleException((Throwable)t, (boolean)true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAlbumSnap() {
        if (!ActionsPanel.hasCamera(true)) {
            return;
        }
        this.prepareSequences();
        LiveSettingsPanel livePanel = this.mainFrame.livePanel;
        boolean liveRunning = MicroManager.isLiveRunning();
        if (this.albumSequence.isEmpty()) {
            String prefix = livePanel.hasCustomAcqName() ? livePanel.getAcqName() : "Album";
            this.albumSequence.setName(prefix + (livePanel.hasDateSuffix() ? " - " + MMUtils.getDateString() : ""));
            this.albumDate = Calendar.getInstance().getTimeInMillis();
        }
        try {
            if (liveRunning) {
                MicroManager.stopLiveMode();
            }
            if (livePanel.isZStackAcquisition()) {
                double start = livePanel.getZStart();
                double end = livePanel.getZEnd();
                double step = livePanel.getZStep();
                if (this.stackAcquisitionProcessor != null && this.stackAcquisitionProcessor.isAlive()) {
                    return;
                }
                this.stackAcquisitionProcessor = new StackAcquisitionProcessor(this.albumSequence, start, end, step, this.albumDate);
            } else {
                for (TaggedImage image : MicroManager.snapTaggedImage()) {
                    int t = this.albumSequence.getSizeT();
                    MMUtils.setImageMetadata(image, t, 0, -1, 1, t + 1, -1);
                    MMUtils.setImage(this.albumSequence, image, this.albumDate);
                }
            }
        }
        catch (Throwable t) {
            IcyExceptionHandler.handleException((Throwable)t, (boolean)true);
        }
        finally {
            try {
                if (liveRunning) {
                    MicroManager.startLiveMode();
                }
            }
            catch (Throwable t) {
                IcyExceptionHandler.handleException((Throwable)t, (boolean)true);
            }
        }
        if (!Icy.getMainInterface().isOpened(this.albumSequence)) {
            Icy.getMainInterface().addSequence(this.albumSequence);
        }
    }

    public void startAdvAcq() {
        if (!ActionsPanel.hasCamera(true)) {
            return;
        }
        this.mainFrame.getAcquisitionHandler().getAcquisitionFrame().setVisible(true);
    }

    public static boolean hasCamera(boolean showError) {
        boolean result;
        try {
            boolean bl = result = !StringUtil.isEmpty((String)MicroManager.getCamera());
            if (!result && showError) {
                MessageDialog.showDialog((String)"No camera device: cannot capture image.", (int)1);
            }
        }
        catch (Throwable t) {
            result = false;
            IcyExceptionHandler.handleException((Throwable)t, (boolean)true);
        }
        return result;
    }

    public void refreshGUI() {
        this.mainFrame.refreshConfigs();
        this.mainFrame.refreshGUI();
    }

    void prepareSequences() {
        if (this.liveSequence == null) {
            this.liveSequence = new Sequence("Live mode");
            this.liveSequence.addListener((SequenceListener)this);
        }
        if (this.albumSequence == null) {
            this.albumSequence = new Sequence("Album");
            this.albumSequence.addListener((SequenceListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void liveImgReceived(List<TaggedImage> images) {
        this.prepareSequences();
        this.liveSequence.beginUpdate();
        try {
            LiveSettingsPanel livePanel;
            if (!MMUtils.isCompatible(this.liveSequence, images.get((int)0).tags)) {
                this.liveSequence.removeAllImages();
            }
            if ((livePanel = this.mainFrame.livePanel).isZStackAcquisition()) {
                double limit;
                boolean done;
                int z;
                double start = livePanel.getZStart();
                double end = livePanel.getZEnd();
                double step = livePanel.getZStep();
                StageMover.waitZToRespond();
                StageMover.waitZMoving();
                double curZ = StageMover.getZ();
                int numSlice = Math.min(1 + (int)Math.floor((end - start) / step), 100);
                if (this.liveSequence.getSizeZ() != numSlice) {
                    this.liveSequence.removeAllImages();
                }
                if ((z = (int)Math.round((curZ - start) / step)) >= 0 && z < 100) {
                    for (TaggedImage img : images) {
                        MMUtils.setImageMetadata(img, 0, z, -1, 1, numSlice, -1);
                        MMUtils.setImage(this.liveSequence, img, this.liveDate);
                    }
                }
                if (done = step < 0.0 ^ curZ > (limit = end - step / 2.0)) {
                    StageMover.moveZAbsolute(start, false);
                } else {
                    StageMover.moveZAbsolute(curZ + step, false);
                }
                if (z == 0) {
                    this.fpsMeter.update();
                    this.liveSequence.setName("Live mode - " + (int)(this.fpsMeter.getRate() * 60.0) + " stack(s) per minute");
                }
            } else {
                if (this.liveSequence.getSizeZ() > 1) {
                    this.liveSequence.removeAllImages();
                }
                for (TaggedImage img : images) {
                    MMUtils.setImageMetadata(img, 0, 0, -1, -1, -1, -1);
                    MMUtils.setImage(this.liveSequence, img, this.liveDate);
                }
                this.fpsMeter.update();
                this.liveSequence.setName("Live mode - " + this.fpsMeter.getFPS() + " frame(s) per second");
            }
        }
        catch (Exception e) {
            System.err.println("MicroManager: cannot update live image.");
            IcyExceptionHandler.showErrorMessage((Throwable)e, (boolean)false, (boolean)true);
        }
        finally {
            this.liveSequence.endUpdate();
        }
    }

    @Override
    public void liveStarted() {
        this.liveDate = Calendar.getInstance().getTimeInMillis();
        this.liveBtn.setSelected(true);
    }

    @Override
    public void liveStopped() {
        this.liveBtn.setSelected(false);
    }

    public void sequenceChanged(SequenceEvent sequenceEvent) {
    }

    public void sequenceClosed(Sequence sequence) {
        if (sequence == this.liveSequence) {
            this.setLiveMode(false);
        }
        if (sequence == this.albumSequence) {
            if (StringUtil.isEmpty((String)sequence.getFilename())) {
                // empty if block
            }
            sequence.removeAllImages();
        }
    }

    static class StackAcquisitionProcessor
    extends Thread {
        final Sequence dest;
        final double zstart;
        final double zend;
        final double zstep;
        final long tstart;

        public StackAcquisitionProcessor(Sequence dest, double zstart, double zend, double zstep, long tstart) {
            super("Z-Stack acquisition");
            this.dest = dest;
            this.zstart = zstart;
            this.zend = zend;
            this.zstep = zstep;
            this.tstart = tstart;
            this.start();
        }

        @Override
        public void run() {
            int t = this.dest.getSizeT();
            int numSlice = Math.min(1 + (int)Math.floor((this.zend - this.zstart) / this.zstep), 100);
            try {
                double zpos = this.zstart;
                for (int z = 0; z < numSlice; ++z) {
                    StageMover.moveZAbsolute(zpos, true);
                    StageMover.waitZMoving();
                    for (TaggedImage img : MicroManager.snapTaggedImage()) {
                        MMUtils.setImageMetadata(img, t, z, -1, t + 1, numSlice, -1);
                        MMUtils.setImage(this.dest, img, this.tstart);
                    }
                    zpos += this.zstep;
                }
            }
            catch (Exception e) {
                System.err.println("MicroManager: cannot process stack acquisition.");
                IcyExceptionHandler.handleException((Throwable)e, (boolean)true);
            }
        }
    }
}

