/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.Microscopy.MicroManager.gui;

import icy.gui.component.button.IcyButton;
import icy.gui.dialog.ConfirmDialog;
import icy.gui.dialog.MessageDialog;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.system.thread.ThreadUtil;
import icy.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import mmcorej.CMMCore;
import org.micromanager.ConfigGroupPad;
import org.micromanager.MMStudio;
import org.micromanager.api.ScriptInterface;
import org.micromanager.dialogs.GroupEditor;
import org.micromanager.dialogs.PresetEditor;
import plugins.tprovoost.Microscopy.MicroManager.gui.MMMainFrame;
import plugins.tprovoost.Microscopy.MicroManager.tools.MMUtils;

public class ConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 7458866395274126587L;
    final MMMainFrame mainFrame;
    ConfigGroupPad groupPad;
    final Runnable configsRefresher;
    final Runnable groupRefresher;
    String groupNameRefresh;
    String configNameRefresh;
    boolean fromCacheRefresh;

    public ConfigurationPanel(MMMainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.initialize();
        this.configsRefresher = new Runnable(){

            @Override
            public void run() {
                ThreadUtil.sleep((int)20);
                ThreadUtil.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ConfigurationPanel.this.refreshConfigsNow(ConfigurationPanel.this.fromCacheRefresh);
                    }
                });
            }
        };
        this.groupRefresher = new Runnable(){

            @Override
            public void run() {
                ThreadUtil.sleep((int)20);
                ThreadUtil.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ConfigurationPanel.this.refresgGroupNow(ConfigurationPanel.this.groupNameRefresh, ConfigurationPanel.this.configNameRefresh);
                    }
                });
            }
        };
    }

    private void initialize() {
        this.setBorder(new TitledBorder(null, "Configuration settings", 4, 2, null, null));
        this.groupPad = new ConfigGroupPad();
        this.groupPad.setFont(new Font("", 0, 10));
        this.groupPad.setCore(this.getCore());
        this.groupPad.setParentGUI((ScriptInterface)this.getMMStudio());
        JPanel configButtonPanel = new JPanel();
        configButtonPanel.setBorder(new EmptyBorder(1, 1, 1, 1));
        GridBagLayout gbl_configButtonPanel = new GridBagLayout();
        gbl_configButtonPanel.columnWidths = new int[]{50, 0, 0, 0, 16, 56, 50, 0, 0, 0, 16, 0, 0};
        gbl_configButtonPanel.rowHeights = new int[]{29, 0};
        gbl_configButtonPanel.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, Double.MIN_VALUE};
        gbl_configButtonPanel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        configButtonPanel.setLayout(gbl_configButtonPanel);
        IcyButton addGroupBtn = new IcyButton(new IcyIcon("sq_plus"));
        addGroupBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupEditor ge = new GroupEditor("", "", (ScriptInterface)ConfigurationPanel.this.getMMStudio(), ConfigurationPanel.this.getCore(), true);
                if (ge.getWidth() < 580) {
                    ge.setSize(580, ge.getHeight());
                }
                ge.addWindowListener((WindowListener)new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent e) {
                        ConfigurationPanel.this.refreshConfigs(false);
                    }
                });
            }
        });
        JLabel groupLabel = new JLabel(" Group ");
        GridBagConstraints gbc_groupLabel = new GridBagConstraints();
        gbc_groupLabel.anchor = 17;
        gbc_groupLabel.insets = new Insets(0, 0, 0, 5);
        gbc_groupLabel.gridx = 0;
        gbc_groupLabel.gridy = 0;
        configButtonPanel.add((Component)groupLabel, gbc_groupLabel);
        GridBagConstraints gbc_addGroupBtn = new GridBagConstraints();
        gbc_addGroupBtn.fill = 2;
        gbc_addGroupBtn.anchor = 11;
        gbc_addGroupBtn.insets = new Insets(0, 0, 0, 5);
        gbc_addGroupBtn.gridx = 1;
        gbc_addGroupBtn.gridy = 0;
        configButtonPanel.add((Component)addGroupBtn, gbc_addGroupBtn);
        IcyButton editGroupBtn = new IcyButton(new IcyIcon("doc_edit"));
        editGroupBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String groupName = MMUtils.getSelectedGroupName(ConfigurationPanel.this.groupPad);
                if (StringUtil.isEmpty((String)groupName)) {
                    MessageDialog.showDialog((String)"To edit a group, please select it first then press the edit group button.");
                } else {
                    GroupEditor ge = new GroupEditor(groupName, MMUtils.getSelectedPresetName(ConfigurationPanel.this.groupPad), (ScriptInterface)ConfigurationPanel.this.getMMStudio(), ConfigurationPanel.this.getCore(), false);
                    if (ge.getWidth() < 580) {
                        ge.setSize(580, ge.getHeight());
                    }
                    ge.addWindowListener((WindowListener)new WindowAdapter(){

                        @Override
                        public void windowClosed(WindowEvent e) {
                            ConfigurationPanel.this.refreshConfigs(false);
                        }
                    });
                }
            }
        });
        IcyButton removeGroupBtn = new IcyButton(new IcyIcon("sq_minus"));
        removeGroupBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String groupName = MMUtils.getSelectedGroupName(ConfigurationPanel.this.groupPad);
                if (StringUtil.isEmpty((String)groupName)) {
                    MessageDialog.showDialog((String)"To remove a group, please select it first then press the remove group button.");
                } else if (ConfirmDialog.confirm((String)"Remove group", (String)("Are you sure you want to remove group " + groupName + " and all associated presets ?"))) {
                    try {
                        ConfigurationPanel.this.getCore().deleteConfigGroup(groupName);
                    }
                    catch (Exception e1) {
                        ConfigurationPanel.this.getMMStudio().logError(e1);
                    }
                    ConfigurationPanel.this.refreshConfigs(false);
                }
            }
        });
        GridBagConstraints gbc_removeGroupBtn = new GridBagConstraints();
        gbc_removeGroupBtn.fill = 2;
        gbc_removeGroupBtn.anchor = 11;
        gbc_removeGroupBtn.insets = new Insets(0, 0, 0, 5);
        gbc_removeGroupBtn.gridx = 2;
        gbc_removeGroupBtn.gridy = 0;
        configButtonPanel.add((Component)removeGroupBtn, gbc_removeGroupBtn);
        GridBagConstraints gbc_editGroupBtn = new GridBagConstraints();
        gbc_editGroupBtn.fill = 2;
        gbc_editGroupBtn.anchor = 11;
        gbc_editGroupBtn.insets = new Insets(0, 0, 0, 5);
        gbc_editGroupBtn.gridx = 3;
        gbc_editGroupBtn.gridy = 0;
        configButtonPanel.add((Component)editGroupBtn, gbc_editGroupBtn);
        JLabel presetLabel = new JLabel(" Preset ");
        GridBagConstraints gbc_presetLabel = new GridBagConstraints();
        gbc_presetLabel.anchor = 17;
        gbc_presetLabel.insets = new Insets(0, 0, 0, 5);
        gbc_presetLabel.gridx = 6;
        gbc_presetLabel.gridy = 0;
        configButtonPanel.add((Component)presetLabel, gbc_presetLabel);
        IcyButton addPresetBtn = new IcyButton(new IcyIcon("sq_plus"));
        addPresetBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String groupName = MMUtils.getSelectedGroupName(ConfigurationPanel.this.groupPad);
                if (StringUtil.isEmpty((String)groupName)) {
                    MessageDialog.showDialog((String)"To add a preset to a group, please select the group first then press the add preset button.");
                } else {
                    PresetEditor pe = new PresetEditor(groupName, "", (ScriptInterface)ConfigurationPanel.this.getMMStudio(), ConfigurationPanel.this.getCore(), true);
                    pe.addWindowListener((WindowListener)new WindowAdapter(){

                        @Override
                        public void windowClosed(WindowEvent e) {
                            ConfigurationPanel.this.refreshConfigs(false);
                        }
                    });
                }
            }
        });
        GridBagConstraints gbc_addPresetBtn = new GridBagConstraints();
        gbc_addPresetBtn.fill = 2;
        gbc_addPresetBtn.anchor = 11;
        gbc_addPresetBtn.insets = new Insets(0, 0, 0, 5);
        gbc_addPresetBtn.gridx = 7;
        gbc_addPresetBtn.gridy = 0;
        configButtonPanel.add((Component)addPresetBtn, gbc_addPresetBtn);
        IcyButton editPresetBtn = new IcyButton(new IcyIcon("doc_edit"));
        editPresetBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String groupName = MMUtils.getSelectedGroupName(ConfigurationPanel.this.groupPad);
                String presetName = MMUtils.getSelectedPresetName(ConfigurationPanel.this.groupPad);
                if (StringUtil.isEmpty((String)groupName) || StringUtil.isEmpty((String)presetName)) {
                    MessageDialog.showDialog((String)"To edit a preset, please select the preset first then press the edit preset button.");
                } else {
                    PresetEditor pe = new PresetEditor(groupName, presetName, (ScriptInterface)ConfigurationPanel.this.getMMStudio(), ConfigurationPanel.this.getCore(), false);
                    pe.addWindowListener((WindowListener)new WindowAdapter(){

                        @Override
                        public void windowClosed(WindowEvent e) {
                            ConfigurationPanel.this.refreshConfigs(false);
                        }
                    });
                }
            }
        });
        IcyButton removePresetBtn = new IcyButton(new IcyIcon("sq_minus"));
        removePresetBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String groupName = MMUtils.getSelectedGroupName(ConfigurationPanel.this.groupPad);
                String presetName = MMUtils.getSelectedPresetName(ConfigurationPanel.this.groupPad);
                if (StringUtil.isEmpty((String)groupName) || StringUtil.isEmpty((String)presetName)) {
                    MessageDialog.showDialog((String)"To remove a preset from a group, please select preset first then press the remove button.");
                } else {
                    if (ConfigurationPanel.this.getCore().getAvailableConfigs(groupName).size() == 1L) {
                        if (ConfirmDialog.confirm((String)"Remove last preset in group", (String)("'" + presetName + "' is the last preset for the '" + groupName + "' group.\nDelete both preset and group ?"))) {
                            try {
                                ConfigurationPanel.this.getCore().deleteConfig(groupName, presetName);
                                ConfigurationPanel.this.getCore().deleteConfigGroup(groupName);
                            }
                            catch (Exception e1) {
                                ConfigurationPanel.this.getMMStudio().logError(e1);
                            }
                        }
                    } else if (ConfirmDialog.confirm((String)"Remove preset", (String)("Are you sure you want to remove preset '" + presetName + "' from the '" + groupName + "' group ?"))) {
                        try {
                            ConfigurationPanel.this.getCore().deleteConfig(groupName, presetName);
                        }
                        catch (Exception e1) {
                            ConfigurationPanel.this.getMMStudio().logError(e1);
                        }
                    }
                    ConfigurationPanel.this.refreshConfigs(false);
                }
            }
        });
        GridBagConstraints gbc_removePresetBtn = new GridBagConstraints();
        gbc_removePresetBtn.fill = 2;
        gbc_removePresetBtn.anchor = 11;
        gbc_removePresetBtn.insets = new Insets(0, 0, 0, 5);
        gbc_removePresetBtn.gridx = 8;
        gbc_removePresetBtn.gridy = 0;
        configButtonPanel.add((Component)removePresetBtn, gbc_removePresetBtn);
        GridBagConstraints gbc_editPresetBtn = new GridBagConstraints();
        gbc_editPresetBtn.fill = 2;
        gbc_editPresetBtn.anchor = 11;
        gbc_editPresetBtn.insets = new Insets(0, 0, 0, 5);
        gbc_editPresetBtn.gridx = 9;
        gbc_editPresetBtn.gridy = 0;
        configButtonPanel.add((Component)editPresetBtn, gbc_editPresetBtn);
        IcyButton saveBtn = new IcyButton(new IcyIcon(ResourceUtil.ICON_SAVE));
        saveBtn.setToolTipText("Save current presets to configuration file...");
        saveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigurationPanel.this.mainFrame.saveConfig();
            }
        });
        GridBagConstraints gbc_saveBtn = new GridBagConstraints();
        gbc_saveBtn.fill = 2;
        gbc_saveBtn.anchor = 11;
        gbc_saveBtn.gridx = 11;
        gbc_saveBtn.gridy = 0;
        configButtonPanel.add((Component)saveBtn, gbc_saveBtn);
        this.setLayout(new BorderLayout());
        this.add((Component)this.groupPad, "Center");
        this.add((Component)configButtonPanel, "South");
    }

    MMStudio getMMStudio() {
        return this.mainFrame.mmstudio;
    }

    CMMCore getCore() {
        return this.getMMStudio().getCore();
    }

    public void refresgGroupNow(String groupName, String configName) {
        this.groupPad.refreshGroup(this.groupNameRefresh, this.configNameRefresh);
    }

    public void refreshGroup(String groupName, String configName) {
        this.groupNameRefresh = groupName;
        this.configNameRefresh = configName;
        ThreadUtil.bgRunSingle((Runnable)this.groupRefresher);
    }

    public void refreshConfigsNow(boolean fromCache) {
        this.groupPad.refreshStructure(fromCache);
        this.groupPad.repaint();
    }

    public void refreshConfigs(boolean fromCache) {
        this.fromCacheRefresh = fromCache;
        ThreadUtil.bgRunSingle((Runnable)this.configsRefresher);
    }
}

