/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.vars.lang;

import java.lang.reflect.Array;
import plugins.adufour.vars.gui.VarEditor;
import plugins.adufour.vars.gui.VarEditorFactory;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.util.ArrayType;
import plugins.adufour.vars.util.VarListener;

public class VarGenericArray<A>
extends Var<A>
implements ArrayType {
    public VarGenericArray(String name, Class<A> type, A defaultValue) {
        this(name, type, defaultValue, (VarListener<A>)null);
    }

    public VarGenericArray(String name, Class<A> type, A defaultValue, VarListener<A> defaultListener) {
        super(name, type, defaultValue != null ? defaultValue : Array.newInstance(type.getComponentType(), 0), defaultListener);
    }

    @Override
    public VarEditor<A> createVarEditor() {
        return VarEditorFactory.getDefaultFactory().createTextField(this);
    }

    @Override
    public int getDimensions() {
        return 1;
    }

    @Override
    public Class<?> getInnerType() {
        return this.getType() == null ? null : this.getType().getComponentType();
    }

    @Override
    public String getSeparator(int dimension) {
        if (dimension == 0) {
            return " ";
        }
        throw new ArrayIndexOutOfBoundsException(dimension);
    }

    @Override
    public A getValue() {
        Object o = super.getValue();
        if (o == null) {
            return (A)Array.newInstance(this.getInnerType(), 0);
        }
        if (this.type == null) {
            return null;
        }
        if (!this.getInnerType().isArray() && o.getClass().isArray()) {
            return (A)o;
        }
        if (this.getInnerType().isAssignableFrom(o.getClass())) {
            Object array = Array.newInstance(o.getClass(), 1);
            Array.set(array, 0, o);
            return (A)array;
        }
        return (A)o;
    }

    @Override
    public boolean isAssignableFrom(Var<?> source) {
        Class<?> componentType = this.getInnerType();
        if (componentType == null) {
            return false;
        }
        if (source instanceof VarGenericArray) {
            VarGenericArray varNativeArray = (VarGenericArray)source;
            Class<?> sourceComponentType = varNativeArray.getInnerType();
            if (sourceComponentType == null) {
                return false;
            }
            return componentType.isAssignableFrom(sourceComponentType);
        }
        if (componentType.isAssignableFrom(source.getType())) {
            return true;
        }
        return super.isAssignableFrom(source);
    }

    @Override
    public A parse(String input) {
        Class<?> componentType = this.getInnerType();
        if ((input = input.trim()).isEmpty()) {
            return (A)Array.newInstance(componentType, 0);
        }
        String[] inputs = input.trim().split(this.getSeparator(0));
        Object array = Array.newInstance(componentType, inputs.length);
        for (int i = 0; i < inputs.length; ++i) {
            Array.set(array, i, this.parseComponent(inputs[i]));
        }
        return (A)array;
    }

    @Override
    public Object parseComponent(String s) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Parsing not implemented for type " + this.getClass().getSimpleName());
    }

    public int size() {
        return this.size(0);
    }

    @Override
    public int size(int dimension) throws ArrayIndexOutOfBoundsException {
        if (dimension > 0) {
            throw new ArrayIndexOutOfBoundsException(dimension);
        }
        A array = this.getValue();
        return array == null ? -1 : Array.getLength(array);
    }
}

