/*
 * Decompiled with CFR 0.152.
 */
package icy.file;

import icy.common.exception.UnsupportedFormatException;
import icy.file.FileImporter;
import icy.file.FileUtil;
import icy.file.Importer;
import icy.file.SequenceFileGroupImporter;
import icy.file.SequenceFileImporter;
import icy.file.SequenceFileSticher;
import icy.gui.dialog.ImporterSelectionDialog;
import icy.gui.dialog.SeriesSelectionDialog;
import icy.gui.frame.progress.FailedAnnounceFrame;
import icy.gui.frame.progress.FileFrame;
import icy.gui.menu.ApplicationMenu;
import icy.image.ChannelPosition;
import icy.image.IcyBufferedImage;
import icy.image.ImagePosition;
import icy.main.Icy;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLauncher;
import icy.plugin.PluginLoader;
import icy.preferences.GeneralPreferences;
import icy.sequence.MetaDataUtil;
import icy.sequence.Sequence;
import icy.sequence.SequenceIdImporter;
import icy.sequence.SequenceImporter;
import icy.sequence.SequencePersistent;
import icy.sequence.SequenceUtil;
import icy.system.IcyExceptionHandler;
import icy.system.SystemUtil;
import icy.system.thread.ThreadUtil;
import icy.type.DataType;
import icy.type.collection.CollectionUtil;
import icy.util.OMEUtil;
import icy.util.StringUtil;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadataImpl;
import ome.xml.meta.OMEXMLMetadata;
import plugins.kernel.importer.LociImporterPlugin;

public class Loader {
    private static final Set<String> nonImageExtensions = new HashSet<String>(CollectionUtil.asList("pdf", "doc", "docx", "rtf", "exe", "wav", "mp3", "app"));
    private static Set<String> reportedImporterPlugins = new HashSet<String>();
    private static Set<String> warnedImporterPlugins = new HashSet<String>();

    private static void handleImporterError(PluginDescriptor plugin, Throwable t) {
        String pluginId = plugin.getName() + " " + plugin.getVersion();
        if (t instanceof UnsupportedClassVersionError) {
            if (!warnedImporterPlugins.contains(pluginId)) {
                System.err.println("Plugin '" + plugin.getName() + "' " + plugin.getVersion() + " is not compatible with java " + (int)Math.floor(SystemUtil.getJavaVersionAsNumber()));
                System.err.println("You need to install a newer version of java to use it.");
                warnedImporterPlugins.add(pluginId);
            }
        } else if (!reportedImporterPlugins.contains(pluginId)) {
            IcyExceptionHandler.showErrorMessage(t, false, true);
            IcyExceptionHandler.report(plugin, IcyExceptionHandler.getErrorMessage(t, true));
            reportedImporterPlugins.add(pluginId);
        }
    }

    public static List<Importer> getImporters() {
        ArrayList<PluginDescriptor> plugins = PluginLoader.getPlugins(Importer.class);
        ArrayList<Importer> result = new ArrayList<Importer>();
        for (PluginDescriptor plugin : plugins) {
            try {
                result.add((Importer)((Object)PluginLauncher.create(plugin)));
            }
            catch (Throwable t) {
                Loader.handleImporterError(plugin, t);
            }
        }
        return result;
    }

    public static List<FileImporter> getFileImporters() {
        ArrayList<PluginDescriptor> plugins = PluginLoader.getPlugins(FileImporter.class);
        ArrayList<FileImporter> result = new ArrayList<FileImporter>();
        for (PluginDescriptor plugin : plugins) {
            try {
                result.add((FileImporter)((Object)PluginLauncher.create(plugin)));
            }
            catch (Throwable t) {
                Loader.handleImporterError(plugin, t);
            }
        }
        return result;
    }

    public static Map<FileImporter, List<String>> getFileImporters(List<FileImporter> importers, List<String> paths, boolean useFirstFound) {
        HashMap<FileImporter, List<String>> result = new HashMap<FileImporter, List<String>>(importers.size());
        HashMap<String, FileImporter> extensionImporters = new HashMap<String, FileImporter>(importers.size());
        for (String path : paths) {
            String ext = FileUtil.getFileExtension(path, false);
            FileImporter imp = (FileImporter)extensionImporters.get(ext);
            if (imp == null && (imp = Loader.getFileImporter(importers, path, useFirstFound)) != null) {
                extensionImporters.put(ext, imp);
            }
            if (imp == null) continue;
            ArrayList<String> list = (ArrayList<String>)result.get(imp);
            if (list == null) {
                list = new ArrayList<String>();
                result.put(imp, list);
            }
            list.add(path);
        }
        return result;
    }

    public static Map<FileImporter, List<String>> getFileImporters(List<String> paths, boolean useFirstFound) {
        return Loader.getFileImporters(Loader.getFileImporters(), paths, useFirstFound);
    }

    public static List<FileImporter> getFileImporters(List<FileImporter> importers, String path) {
        ArrayList<FileImporter> result = new ArrayList<FileImporter>(importers.size());
        for (FileImporter importer : importers) {
            if (!importer.acceptFile(path)) continue;
            result.add(importer);
        }
        return result;
    }

    public static List<FileImporter> getFileImporters(String path) {
        return Loader.getFileImporters(Loader.getFileImporters(), path);
    }

    public static FileImporter getFileImporter(List<FileImporter> importers, String path, boolean useFirstFound) {
        ArrayList<FileImporter> result = new ArrayList<FileImporter>(importers.size());
        for (FileImporter importer : importers) {
            if (!importer.acceptFile(path)) continue;
            if (useFirstFound) {
                return importer;
            }
            result.add(importer);
        }
        return Loader.selectFileImporter(result, path);
    }

    public static FileImporter getFileImporter(String path, boolean useFirstFound) {
        return Loader.getFileImporter(Loader.getFileImporters(), path, useFirstFound);
    }

    public static FileImporter selectFileImporter(final List<FileImporter> importers, final String path) {
        if (importers.size() == 0) {
            return null;
        }
        if (importers.size() == 1) {
            return importers.get(0);
        }
        if (Icy.getMainInterface().isHeadLess()) {
            return importers.get(0);
        }
        final Object[] result = new Object[1];
        ThreadUtil.invokeNow(new Runnable(){

            @Override
            public void run() {
                result[0] = new ImporterSelectionDialog(importers, path).getSelectedImporter();
            }
        });
        return (FileImporter)result[0];
    }

    public static List<SequenceImporter> getSequenceImporters() {
        ArrayList<PluginDescriptor> plugins = PluginLoader.getPlugins(SequenceImporter.class);
        ArrayList<SequenceImporter> result = new ArrayList<SequenceImporter>();
        for (PluginDescriptor plugin : plugins) {
            try {
                result.add((SequenceImporter)((Object)PluginLauncher.create(plugin)));
            }
            catch (Throwable t) {
                Loader.handleImporterError(plugin, t);
            }
        }
        return result;
    }

    public static List<SequenceIdImporter> getSequenceIdImporters() {
        ArrayList<PluginDescriptor> plugins = PluginLoader.getPlugins(SequenceIdImporter.class);
        ArrayList<SequenceIdImporter> result = new ArrayList<SequenceIdImporter>();
        for (PluginDescriptor plugin : plugins) {
            try {
                result.add((SequenceIdImporter)((Object)PluginLauncher.create(plugin)));
            }
            catch (Throwable t) {
                Loader.handleImporterError(plugin, t);
            }
        }
        return result;
    }

    public static List<SequenceFileImporter> getSequenceFileImporters() {
        ArrayList<PluginDescriptor> plugins = PluginLoader.getPlugins(SequenceFileImporter.class);
        ArrayList<SequenceFileImporter> result = new ArrayList<SequenceFileImporter>();
        for (PluginDescriptor plugin : plugins) {
            try {
                result.add((SequenceFileImporter)((Object)PluginLauncher.create(plugin)));
            }
            catch (Throwable t) {
                Loader.handleImporterError(plugin, t);
            }
        }
        return result;
    }

    public static <T extends SequenceFileImporter> Map<T, List<String>> getSequenceFileImporters(List<T> importers, List<String> paths, boolean useFirstFound) {
        HashMap<SequenceFileImporter, ArrayList<String>> result = new HashMap<SequenceFileImporter, ArrayList<String>>(importers.size());
        HashMap<String, SequenceFileImporter> extensionImporters = new HashMap<String, SequenceFileImporter>(importers.size());
        SequenceFileImporter imp = null;
        for (String path : paths) {
            String ext = FileUtil.getFileExtension(path, false);
            if (!StringUtil.isEmpty(ext)) {
                imp = (SequenceFileImporter)extensionImporters.get(ext);
            }
            if (imp != null && !imp.acceptFile(path)) {
                imp = null;
            }
            if (imp == null && (imp = Loader.getSequenceFileImporter(importers, path, useFirstFound)) != null && !StringUtil.isEmpty(ext)) {
                extensionImporters.put(ext, imp);
            }
            if (imp == null) continue;
            ArrayList<String> list = (ArrayList<String>)result.get(imp);
            if (list == null) {
                list = new ArrayList<String>();
                result.put(imp, list);
            }
            list.add(path);
        }
        return result;
    }

    public static Map<SequenceFileImporter, List<String>> getSequenceFileImporters(SequenceFileImporter defaultImporter, List<String> paths, boolean grouped, boolean useFirstFound) {
        if (paths.isEmpty()) {
            return new HashMap<SequenceFileImporter, List<String>>();
        }
        if (defaultImporter != null) {
            HashMap<SequenceFileImporter, List<String>> result = new HashMap<SequenceFileImporter, List<String>>();
            result.put(defaultImporter, paths);
            return result;
        }
        if (grouped) {
            HashMap<SequenceFileImporter, List<String>> result = new HashMap<SequenceFileImporter, List<String>>();
            for (String path : paths) {
                SequenceFileImporter imp = Loader.getSequenceFileImporter(path, useFirstFound);
                if (imp == null) continue;
                result.put(imp, paths);
                break;
            }
            return result;
        }
        return Loader.getSequenceFileImporters(paths, useFirstFound);
    }

    public static Map<SequenceFileImporter, List<String>> getSequenceFileImporters(List<String> paths, boolean useFirstFound) {
        return Loader.getSequenceFileImporters(Loader.getSequenceFileImporters(), paths, useFirstFound);
    }

    public static <T extends SequenceFileImporter> List<T> getSequenceFileImporters(List<T> importers, String path) {
        ArrayList<SequenceFileImporter> result = new ArrayList<SequenceFileImporter>(importers.size());
        for (SequenceFileImporter importer : importers) {
            if (!importer.acceptFile(path)) continue;
            result.add(importer);
        }
        return result;
    }

    public static List<SequenceFileImporter> getSequenceFileImporters(String path) {
        return Loader.getSequenceFileImporters(Loader.getSequenceFileImporters(), path);
    }

    public static <T extends SequenceFileImporter> T getSequenceFileImporter(List<T> importers, String path, boolean useFirstFound) {
        ArrayList<SequenceFileImporter> result = new ArrayList<SequenceFileImporter>(importers.size());
        for (SequenceFileImporter importer : importers) {
            if (!importer.acceptFile(path)) continue;
            if (useFirstFound) {
                return (T)importer;
            }
            result.add(importer);
        }
        return (T)Loader.selectSequenceFileImporter(result, path);
    }

    public static SequenceFileImporter getSequenceFileImporter(String path, boolean useFirstFound) {
        return Loader.getSequenceFileImporter(Loader.getSequenceFileImporters(), path, useFirstFound);
    }

    public static <T extends SequenceFileImporter> T selectSequenceFileImporter(final List<T> importers, final String path) {
        if (importers.size() == 0) {
            return null;
        }
        if (importers.size() == 1) {
            return (T)((SequenceFileImporter)importers.get(0));
        }
        if (Icy.getMainInterface().isHeadLess()) {
            return (T)((SequenceFileImporter)importers.get(0));
        }
        final Object[] result = new Object[1];
        ThreadUtil.invokeNow(new Runnable(){

            @Override
            public void run() {
                ImporterSelectionDialog selectionDialog = new ImporterSelectionDialog(importers, path);
                result[0] = !selectionDialog.isCanceled() ? selectionDialog.getSelectedImporter() : null;
            }
        });
        return (T)((SequenceFileImporter)result[0]);
    }

    @Deprecated
    public static SequenceFileImporter getSequenceFileImporter(List<SequenceFileImporter> importers, String path) {
        return Loader.getSequenceFileImporter(importers, path, true);
    }

    @Deprecated
    public static SequenceFileImporter getSequenceFileImporter(String path) {
        return Loader.getSequenceFileImporter(path, true);
    }

    static <T extends SequenceFileImporter> T cloneSequenceFileImporter(T importer) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (importer == null) {
            return null;
        }
        SequenceFileImporter result = (SequenceFileImporter)importer.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        if (result instanceof LociImporterPlugin) {
            LociImporterPlugin srcImp = (LociImporterPlugin)importer;
            LociImporterPlugin resImp = (LociImporterPlugin)result;
            resImp.setGroupFiles(srcImp.isGroupFiles());
            resImp.setReadOriginalMetadata(srcImp.getReadOriginalMetadata());
        }
        return (T)result;
    }

    static <T extends SequenceFileImporter> T cloneAndOpenSequenceFileImporter(T importer) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, IOException, UnsupportedFormatException {
        T result = Loader.cloneSequenceFileImporter(importer);
        if (result != null && !result.open(importer.getOpened(), 0)) {
            throw new UnsupportedFormatException("Image file '" + importer.getOpened() + "' could not be opened by " + result.toString() + " importer.");
        }
        return result;
    }

    public static boolean canDiscardImageFile(String path) {
        String ext = FileUtil.getFileExtension(path, false).toLowerCase();
        return nonImageExtensions.contains(ext);
    }

    public static boolean isSupportedImageFile(String path) {
        return Loader.getSequenceFileImporter(path, true) != null;
    }

    @Deprecated
    public static boolean isImageFile(String path) {
        return Loader.isSupportedImageFile(path);
    }

    public static List<String> getSupportedFiles(SequenceFileImporter importer, List<String> paths) {
        ArrayList<String> result = new ArrayList<String>();
        for (String path : paths) {
            if (!importer.acceptFile(path)) continue;
            result.add(path);
        }
        return result;
    }

    public static long checkOpeningPlane(int resolution, int sizeX, int sizeY, String messageSuffix) throws UnsupportedOperationException {
        long sizeXY = (long)sizeX * (long)sizeY;
        if ((sizeXY = (long)((double)sizeXY / Math.pow(4.0, resolution))) > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Cannot open image with a XY plane size >= 2^31." + (messageSuffix != null ? messageSuffix : ""));
        }
        return sizeXY;
    }

    public static void checkOpening(int resolution, int sizeX, int sizeY, int sizeC, int sizeZ, int sizeT, DataType dataType, String messageSuffix) throws UnsupportedOperationException, OutOfMemoryError {
        long sizeXY = Loader.checkOpeningPlane(resolution, sizeX, sizeY, messageSuffix);
        long freeInByte = SystemUtil.getJavaFreeMemory() - 0x1000000L;
        long sizeInByte = sizeXY * (long)sizeC * (long)sizeZ * (long)sizeT * (long)dataType.getSize() + sizeXY * 4L;
        if (sizeInByte > freeInByte) {
            System.gc();
            freeInByte = SystemUtil.getJavaFreeMemory() - 0x1000000L;
        }
        if (sizeInByte > freeInByte) {
            throw new OutOfMemoryError("Not enough memory to open the wanted image resolution." + (messageSuffix != null ? messageSuffix : ""));
        }
    }

    public static void checkOpening(OMEXMLMetadata meta, int series, int resolution, int sizeZ, int sizeT, String messageSuffix) throws UnsupportedOperationException, OutOfMemoryError {
        Loader.checkOpening(resolution, MetaDataUtil.getSizeX(meta, series), MetaDataUtil.getSizeY(meta, series), MetaDataUtil.getSizeC(meta, series), sizeZ, sizeT, MetaDataUtil.getDataType(meta, series), messageSuffix);
    }

    public static void checkOpening(OMEXMLMetadata meta, int series, int resolution, String messageSuffix) throws UnsupportedOperationException, OutOfMemoryError {
        Loader.checkOpening(meta, series, resolution, MetaDataUtil.getSizeZ(meta, series), MetaDataUtil.getSizeT(meta, series), messageSuffix);
    }

    @Deprecated
    public static IFormatReader getReader(String path) throws FormatException, IOException {
        return new ImageReader().getReader(path);
    }

    public static OMEXMLMetadata getOMEXMLMetaData(SequenceFileImporter importer, String path) throws UnsupportedFormatException, IOException {
        if (importer.open(path, 0)) {
            try {
                OMEXMLMetadata oMEXMLMetadata = importer.getOMEXMLMetaData();
                return oMEXMLMetadata;
            }
            finally {
                importer.close();
            }
        }
        return null;
    }

    public static OMEXMLMetadata getOMEXMLMetaData(String path) throws UnsupportedFormatException, IOException {
        UnsupportedFormatException lastError = null;
        for (SequenceFileImporter importer : Loader.getSequenceFileImporters(path)) {
            try {
                OMEXMLMetadata result = Loader.getOMEXMLMetaData(importer, path);
                if (result == null) continue;
                return result;
            }
            catch (UnsupportedFormatException e) {
                lastError = e;
            }
        }
        throw new UnsupportedFormatException("Image file '" + path + "' is not supported :\n", lastError);
    }

    @Deprecated
    public static OMEXMLMetadataImpl getMetaData(SequenceFileImporter importer, String path) throws UnsupportedFormatException, IOException {
        if (importer.open(path, 0)) {
            try {
                OMEXMLMetadataImpl oMEXMLMetadataImpl = importer.getMetaData();
                return oMEXMLMetadataImpl;
            }
            finally {
                importer.close();
            }
        }
        return null;
    }

    @Deprecated
    public static OMEXMLMetadataImpl getMetaData(String path) throws UnsupportedFormatException, IOException {
        UnsupportedFormatException lastError = null;
        for (SequenceFileImporter importer : Loader.getSequenceFileImporters(path)) {
            try {
                OMEXMLMetadataImpl result = Loader.getMetaData(importer, path);
                if (result == null) continue;
                return result;
            }
            catch (UnsupportedFormatException e) {
                lastError = e;
            }
        }
        throw new UnsupportedFormatException("Image file '" + path + "' is not supported :\n", lastError);
    }

    @Deprecated
    public static OMEXMLMetadataImpl getMetaData(File file) throws UnsupportedFormatException, IOException {
        return Loader.getMetaData(file.getAbsolutePath());
    }

    @Deprecated
    protected static OMEXMLMetadataImpl getMetaData(IFormatReader reader, String path) throws FormatException, IOException {
        reader.setMetadataStore((MetadataStore)((Object)OMEUtil.createOMEXMLMetadata()));
        reader.setId(path);
        return (OMEXMLMetadataImpl)reader.getMetadataStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IcyBufferedImage loadThumbnail(SequenceFileImporter importer, String path, int series) throws UnsupportedFormatException, IOException {
        if (importer.open(path, 0)) {
            try {
                IcyBufferedImage icyBufferedImage = importer.getThumbnail(series);
                return icyBufferedImage;
            }
            finally {
                importer.close();
            }
        }
        return null;
    }

    public static IcyBufferedImage loadThumbnail(String path, int series) throws UnsupportedFormatException, IOException {
        UnsupportedFormatException lastError = null;
        for (SequenceFileImporter importer : Loader.getSequenceFileImporters(path)) {
            try {
                IcyBufferedImage result = Loader.loadThumbnail(importer, path, series);
                if (result == null) continue;
                return result;
            }
            catch (UnsupportedFormatException e) {
                lastError = e;
            }
        }
        throw new UnsupportedFormatException("Image file '" + path + "' is not supported :\n", lastError);
    }

    @Deprecated
    public static IcyBufferedImage loadImage(IFormatReader reader, int z, int t) throws FormatException, IOException {
        return IcyBufferedImage.createFrom(reader, z, t);
    }

    @Deprecated
    public static IcyBufferedImage loadImage(IFormatReader reader) throws FormatException, IOException {
        return IcyBufferedImage.createFrom(reader, 0, 0);
    }

    @Deprecated
    public static IcyBufferedImage loadImage(File file, int z, int t) throws FormatException, IOException {
        return Loader.loadImage(file.getAbsolutePath(), z, t);
    }

    @Deprecated
    public static IcyBufferedImage loadImage(File file) throws UnsupportedFormatException, IOException {
        return Loader.loadImage(file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static IcyBufferedImage loadImage(String path, int z, int t) throws FormatException, IOException {
        IFormatReader reader = Loader.getReader(path);
        reader.setGroupFiles(false);
        reader.setId(path);
        try {
            IcyBufferedImage icyBufferedImage = IcyBufferedImage.createFrom(reader, z, t);
            return icyBufferedImage;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IcyBufferedImage loadImage(SequenceFileImporter importer, String path, int series, int z, int t) throws UnsupportedFormatException, IOException {
        if (importer == null || !importer.open(path, 0)) {
            throw new UnsupportedFormatException("Image file '" + path + "' is not supported !");
        }
        try {
            IcyBufferedImage icyBufferedImage = importer.getImage(series, z, t);
            return icyBufferedImage;
        }
        finally {
            importer.close();
        }
    }

    public static IcyBufferedImage loadImage(String path, int series, int z, int t) throws UnsupportedFormatException, IOException {
        return Loader.loadImage(Loader.getSequenceFileImporter(path, true), path, series, z, t);
    }

    public static IcyBufferedImage loadImage(String path) throws UnsupportedFormatException, IOException {
        return Loader.loadImage(path, 0, 0, 0);
    }

    @Deprecated
    public static Sequence[] loadSequences(File[] files, int[] series, boolean separate, boolean autoOrder, boolean showProgress) {
        ArrayList<Sequence> result = new ArrayList<Sequence>();
        List<String> paths = FileUtil.toPaths(CollectionUtil.asList(files));
        if (series == null) {
            result.addAll(Loader.loadSequences(paths, -1, separate, autoOrder, false, showProgress));
        } else {
            for (int s : series) {
                result.addAll(Loader.loadSequences(paths, s, separate, autoOrder, false, showProgress));
            }
        }
        return result.toArray(new Sequence[result.size()]);
    }

    @Deprecated
    public static List<Sequence> loadSequences(List<File> files, List<Integer> series, boolean separate, boolean autoOrder, boolean showProgress) {
        int[] seriesArray;
        if (series != null) {
            seriesArray = new int[series.size()];
            for (int i = 0; i < seriesArray.length; ++i) {
                seriesArray[i] = series.get(i);
            }
        } else {
            seriesArray = new int[]{0};
        }
        return Arrays.asList(Loader.loadSequences(files.toArray(new File[files.size()]), seriesArray, separate, autoOrder, showProgress));
    }

    @Deprecated
    public static List<Sequence> loadSequences(List<File> files, List<Integer> series, boolean separate, boolean showProgress) {
        return Loader.loadSequences(files, series, separate, true, showProgress);
    }

    @Deprecated
    public static List<Sequence> loadSequences(List<File> files, List<Integer> series, boolean separate) {
        return Loader.loadSequences(files, series, separate, true, true);
    }

    @Deprecated
    public static List<Sequence> loadSequences(List<File> files, List<Integer> series) {
        return Loader.loadSequences(files, series, false, true, true);
    }

    @Deprecated
    public static List<Sequence> loadSequences(List<File> files, boolean separate, boolean showProgress) {
        return Loader.loadSequences(files, null, separate, true, showProgress);
    }

    @Deprecated
    public static List<Sequence> loadSequences(List<File> files, boolean separate) {
        return Loader.loadSequences(files, null, separate, true, true);
    }

    @Deprecated
    public static List<Sequence> loadSequences(List<File> files, boolean separate, boolean display, boolean addToRecent) {
        return Loader.loadSequences(files, null, separate, true, true);
    }

    @Deprecated
    public static Sequence[] loadSequences(File file, int[] series, boolean showProgress) {
        return Loader.loadSequences(new File[]{file}, series, false, true, showProgress);
    }

    @Deprecated
    public static List<Sequence> loadSequences(File file, List<Integer> series, boolean showProgress) {
        int[] seriesArray;
        if (series != null) {
            seriesArray = new int[series.size()];
            for (int i = 0; i < seriesArray.length; ++i) {
                seriesArray[i] = series.get(i);
            }
        } else {
            seriesArray = new int[]{0};
        }
        return Arrays.asList(Loader.loadSequences(new File[]{file}, seriesArray, false, true, showProgress));
    }

    @Deprecated
    public static List<Sequence> loadSequences(File file, List<Integer> series) {
        return Loader.loadSequences(file, series, true);
    }

    @Deprecated
    public static List<Sequence> loadSequences(File file, List<Integer> series, boolean display, boolean addToRecent) {
        return Loader.loadSequences(file, series, true);
    }

    @Deprecated
    public static Sequence loadSequence(File file, boolean showProgress) {
        return Loader.loadSequence(new File[]{file}, -1, showProgress);
    }

    @Deprecated
    public static Sequence loadSequence(File file) {
        return Loader.loadSequence(new File[]{file}, -1, true);
    }

    @Deprecated
    public static Sequence[] loadSequences(File[] files, int series, boolean separate, boolean autoOrder, boolean showProgress) {
        List<Sequence> result = Loader.loadSequences(FileUtil.toPaths(CollectionUtil.asList(files)), series, separate, autoOrder, false, showProgress);
        return result.toArray(new Sequence[result.size()]);
    }

    @Deprecated
    public static Sequence loadSequence(File[] files, int series, boolean showProgress) {
        Sequence[] result = Loader.loadSequences(files, series, false, true, showProgress);
        if (result.length > 0) {
            return result[0];
        }
        return null;
    }

    @Deprecated
    public static Sequence loadSequence(File file, int series, boolean showProgress) {
        return Loader.loadSequence(new File[]{file}, series, showProgress);
    }

    public static List<Sequence> loadSequences(SequenceFileImporter importer, List<String> paths, int series, boolean forceVolatile, boolean separate, boolean autoOrder, boolean addToRecent, boolean showProgress) {
        ArrayList<Sequence> result = new ArrayList<Sequence>();
        boolean directory = paths.size() == 1 && new File(paths.get(0)).isDirectory();
        List<String> singlePaths = Loader.cleanNonImageFile(Loader.explode(paths));
        boolean adjSeparate = singlePaths.size() <= 1 || separate;
        Map<SequenceFileImporter, List<String>> sequenceFileImporters = Loader.getSequenceFileImporters(importer, singlePaths, !adjSeparate, false);
        for (Map.Entry<SequenceFileImporter, List<String>> entry : sequenceFileImporters.entrySet()) {
            SequenceFileImporter imp = entry.getKey();
            List<String> currPaths = entry.getValue();
            boolean dir = directory && sequenceFileImporters.size() == 1 && currPaths.size() == singlePaths.size();
            result.addAll(Loader.loadSequences(imp, currPaths, series, forceVolatile, adjSeparate, autoOrder, dir, addToRecent, showProgress));
            singlePaths.removeAll(currPaths);
        }
        for (int i = singlePaths.size() - 1; i >= 0; --i) {
            if (!SequencePersistent.isValidXMLPersitence(singlePaths.get(i))) continue;
            singlePaths.remove(i);
        }
        if (singlePaths.size() > 0) {
            Map<SequenceFileImporter, List<String>> importers = Loader.getSequenceFileImporters(singlePaths, true);
            for (List<String> values : importers.values()) {
                singlePaths.removeAll(values);
            }
            if (singlePaths.size() > 0) {
                System.err.println("No compatible importer found for the following files:");
                for (String path : singlePaths) {
                    System.err.println(path);
                }
                System.err.println();
            }
        }
        return result;
    }

    public static List<Sequence> loadSequences(SequenceFileImporter importer, List<String> paths, int series, boolean separate, boolean autoOrder, boolean addToRecent, boolean showProgress) {
        return Loader.loadSequences(importer, paths, series, false, separate, autoOrder, addToRecent, showProgress);
    }

    public static List<Sequence> loadSequences(List<String> paths, int series, boolean separate, boolean autoOrder, boolean addToRecent, boolean showProgress) {
        return Loader.loadSequences(null, paths, series, separate, autoOrder, addToRecent, showProgress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Sequence loadSequence(SequenceFileImporter importer, List<String> paths, boolean addToRecent, boolean showProgress) {
        Sequence result = null;
        ApplicationMenu mainMenu = addToRecent ? Icy.getMainInterface().getApplicationMenu() : null;
        try (FileFrame loadingFrame = showProgress && !Icy.getMainInterface().isHeadLess() ? new FileFrame("Loading", null) : null;){
            SequenceFileSticher.SequenceFileGroup group = SequenceFileSticher.groupFiles(importer, Loader.cleanNonImageFile(paths), showProgress, loadingFrame);
            result = Loader.internalLoadGroup(group, false, false, mainMenu, loadingFrame);
            if (GeneralPreferences.getSequencePersistence()) {
                result.loadXMLData();
            }
        }
        return result;
    }

    public static Sequence loadSequence(SequenceFileImporter importer, List<String> paths, boolean showProgress) {
        return Loader.loadSequence(importer, paths, false, showProgress);
    }

    @Deprecated
    public static Sequence loadSequence(List<?> files, boolean display, boolean addToRecent) {
        return Loader.loadSequence(files, true);
    }

    public static Sequence loadSequence(List<?> files, boolean showProgress) {
        if (files.size() == 0) {
            return null;
        }
        List<Object> paths = files.get(0) instanceof File ? FileUtil.toPaths(files) : files;
        return Loader.loadSequence(null, paths, showProgress);
    }

    public static Sequence loadSequence(List<?> files) {
        return Loader.loadSequence(files, true);
    }

    public static Sequence loadSequence(SequenceFileImporter importer, String path, int series, boolean addToRecent, boolean showProgress) {
        return Loader.loadSequence(importer, path, series, 0, null, -1, -1, -1, -1, -1, addToRecent, showProgress);
    }

    public static Sequence loadSequence(SequenceFileImporter importer, String path, int series, boolean showProgress) {
        return Loader.loadSequence(importer, path, series, false, showProgress);
    }

    public static Sequence loadSequence(String path, int series, boolean showProgress) {
        return Loader.loadSequence(null, path, series, showProgress);
    }

    @Deprecated
    public static void load(List<File> files) {
        Loader.load(files.toArray(new File[files.size()]), false, true, true);
    }

    @Deprecated
    public static void load(List<File> files, boolean separate) {
        Loader.load(files.toArray(new File[files.size()]), separate, true, true);
    }

    @Deprecated
    public static void load(List<File> files, boolean separate, boolean showProgress) {
        Loader.load(files.toArray(new File[files.size()]), separate, true, showProgress);
    }

    @Deprecated
    public static void load(File file) {
        Loader.load(new File[]{file}, false, false, true);
    }

    @Deprecated
    public static void load(final File[] files, final boolean separate, final boolean autoOrder, final boolean showProgress) {
        ThreadUtil.bgRun(new Runnable(){

            @Override
            public void run() {
                Sequence[] sequences;
                for (Sequence seq : sequences = Loader.loadSequences(files, -1, separate, autoOrder, showProgress)) {
                    Icy.getMainInterface().addSequence(seq);
                }
            }
        });
    }

    @Deprecated
    public static void load(File file, boolean showProgress) {
        Loader.load(new File[]{file}, false, false, showProgress);
    }

    public static void load(final FileImporter importer, final List<String> paths, final boolean showProgress) {
        ThreadUtil.bgRun(new Runnable(){

            @Override
            public void run() {
                List<String> singlePaths = Loader.explode(paths);
                if (singlePaths.size() > 0) {
                    Map<FileImporter, List<String>> fileImporters;
                    if (importer == null) {
                        fileImporters = Loader.getFileImporters(singlePaths, false);
                    } else {
                        fileImporters = new HashMap<FileImporter, List<String>>(1);
                        fileImporters.put(importer, new ArrayList<String>(singlePaths));
                    }
                    for (Map.Entry entry : fileImporters.entrySet()) {
                        FileImporter importer2 = (FileImporter)entry.getKey();
                        List currPaths = (List)entry.getValue();
                        Loader.loadFiles(importer2, paths, true, showProgress);
                        singlePaths.removeAll(currPaths);
                    }
                }
                if (singlePaths.size() > 0) {
                    Map<FileImporter, List<String>> importers = Loader.getFileImporters(singlePaths, true);
                    for (List list : importers.values()) {
                        singlePaths.removeAll(list);
                    }
                    if (singlePaths.size() > 0) {
                        System.err.println("No compatible importer found for the following files:");
                        for (String string : singlePaths) {
                            System.err.println(string);
                        }
                        System.err.println();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadFiles(FileImporter importer, List<String> paths, boolean addToRecent, boolean showProgress) {
        FileFrame loadingFrame;
        ApplicationMenu mainMenu = addToRecent ? Icy.getMainInterface().getApplicationMenu() : null;
        if (showProgress && !Icy.getMainInterface().isHeadLess()) {
            loadingFrame = new FileFrame("Loading", null);
            loadingFrame.setLength(paths.size());
            loadingFrame.setPosition(0.0);
        } else {
            loadingFrame = null;
        }
        try {
            for (String path : paths) {
                if (loadingFrame != null) {
                    loadingFrame.incPosition();
                }
                importer.load(path, loadingFrame);
                if (mainMenu == null) continue;
                mainMenu.addRecentLoadedFile(new File(FileUtil.getGenericPath(path)));
            }
        }
        catch (Throwable t) {
            IcyExceptionHandler.showErrorMessage(t, true);
            if (loadingFrame != null) {
                new FailedAnnounceFrame("Failed to open file(s), see the console output for more details.");
            }
        }
        finally {
            if (loadingFrame != null) {
                loadingFrame.close();
            }
        }
    }

    public static void load(final SequenceFileImporter importer, final String path, final int series, final int resolution, final Rectangle region, final int minZ, final int maxZ, final int minT, final int maxT, final int channel, final boolean forceVolatile, final boolean separate, final boolean addToRecent, final boolean showProgress) {
        ThreadUtil.bgRun(new Runnable(){

            @Override
            public void run() {
                if (resolution == 0 && region == null && minZ <= 0 && maxZ == -1 && minT <= 0 && maxT == -1 && channel == -1) {
                    List<Sequence> sequences = Loader.loadSequences(importer == null ? Loader.getSequenceFileImporter(path, !showProgress) : importer, CollectionUtil.asList(path), series, forceVolatile, separate, false, false, addToRecent, showProgress);
                    for (Sequence sequence : sequences) {
                        if (sequence == null) continue;
                        Icy.getMainInterface().addSequence(sequence);
                    }
                } else {
                    Sequence sequence = Loader.loadSequence(importer, path, series, resolution, region, minZ, maxZ, minT, maxT, channel, forceVolatile, addToRecent, showProgress);
                    if (sequence != null) {
                        Icy.getMainInterface().addSequence(sequence);
                    }
                }
            }
        });
    }

    public static void load(SequenceFileImporter importer, String path, int series, int resolution, Rectangle region, int minZ, int maxZ, int minT, int maxT, int channel, boolean separate, boolean addToRecent, boolean showProgress) {
        Loader.load(importer, path, series, resolution, region, minZ, maxZ, minT, maxT, channel, false, separate, addToRecent, showProgress);
    }

    public static void load(final List<String> paths, final int resolution, final Rectangle region, final int minZ, final int maxZ, final int minT, final int maxT, final int channel, final boolean directory, final boolean addToRecent, final boolean showProgress) {
        ThreadUtil.bgRun(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ApplicationMenu mainMenu = addToRecent ? Icy.getMainInterface().getApplicationMenu() : null;
                try (FileFrame loadingFrame = showProgress && !Icy.getMainInterface().isHeadLess() ? new FileFrame("Loading", null) : null;){
                    for (SequenceFileSticher.SequenceFileGroup group : SequenceFileSticher.groupAllFiles(null, Loader.cleanNonImageFile(paths), true, loadingFrame)) {
                        Sequence sequence = Loader.internalLoadGroup(group, resolution, region, minZ, maxZ, minT, maxT, channel, false, directory, mainMenu, loadingFrame);
                        if (sequence == null) continue;
                        if (GeneralPreferences.getSequencePersistence()) {
                            sequence.loadXMLData();
                        }
                        Icy.getMainInterface().addSequence(sequence);
                    }
                }
            }
        });
    }

    public static void load(final SequenceFileSticher.SequenceFileGroup group, final int resolution, final Rectangle region, final int minZ, final int maxZ, final int minT, final int maxT, final int channel, final boolean directory, final boolean addToRecent, final boolean showProgress) {
        ThreadUtil.bgRun(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ApplicationMenu mainMenu = addToRecent ? Icy.getMainInterface().getApplicationMenu() : null;
                try (FileFrame loadingFrame = showProgress && !Icy.getMainInterface().isHeadLess() ? new FileFrame("Loading", null) : null;){
                    Sequence sequence = Loader.internalLoadGroup(group, resolution, region, minZ, maxZ, minT, maxT, channel, false, directory, mainMenu, loadingFrame);
                    if (sequence != null) {
                        if (GeneralPreferences.getSequencePersistence()) {
                            sequence.loadXMLData();
                        }
                        Icy.getMainInterface().addSequence(sequence);
                    }
                }
            }
        });
    }

    public static void load(final SequenceFileImporter importer, final List<String> paths, final boolean separate, final boolean autoOrder, final boolean showProgress) {
        ThreadUtil.bgRun(new Runnable(){

            @Override
            public void run() {
                List<Sequence> sequences = Loader.loadSequences(importer, paths, -1, separate, autoOrder, true, showProgress);
                for (Sequence seq : sequences) {
                    Icy.getMainInterface().addSequence(seq);
                }
            }
        });
    }

    public static void load(final List<String> paths, final boolean forceVolatile, final boolean separate, final boolean autoOrder, final boolean showProgress) {
        ThreadUtil.bgRun(new Runnable(){

            @Override
            public void run() {
                boolean directory = paths.size() == 1 && new File((String)paths.get(0)).isDirectory();
                List<String> singlePaths = Loader.cleanNonImageFile(Loader.explode(paths));
                boolean adjSeparate = singlePaths.size() <= 1 || separate;
                Map<SequenceFileImporter, List<String>> sequenceFileImporters = Loader.getSequenceFileImporters(null, singlePaths, !adjSeparate, false);
                for (Map.Entry<SequenceFileImporter, List<String>> entry : sequenceFileImporters.entrySet()) {
                    SequenceFileImporter sequenceFileImporter = entry.getKey();
                    List<String> currPaths = entry.getValue();
                    boolean dir = directory && sequenceFileImporters.size() == 1 && currPaths.size() == singlePaths.size();
                    List<Sequence> sequences = Loader.loadSequences(sequenceFileImporter, currPaths, -1, forceVolatile, adjSeparate, autoOrder, dir, true, showProgress);
                    for (Sequence seq : sequences) {
                        Icy.getMainInterface().addSequence(seq);
                    }
                    singlePaths.removeAll(currPaths);
                }
                if (singlePaths.size() > 0) {
                    Map<FileImporter, List<String>> fileImporters = Loader.getFileImporters(singlePaths, false);
                    for (Map.Entry entry : fileImporters.entrySet()) {
                        FileImporter importer = (FileImporter)entry.getKey();
                        List currPaths = (List)entry.getValue();
                        Loader.loadFiles(importer, paths, true, showProgress);
                        singlePaths.removeAll(currPaths);
                    }
                }
                if (singlePaths.size() > 0) {
                    Map<SequenceFileImporter, List<String>> importers = Loader.getSequenceFileImporters(singlePaths, true);
                    for (List list : importers.values()) {
                        singlePaths.removeAll(list);
                    }
                    if (singlePaths.size() > 0) {
                        System.err.println("No compatible importer found for the following files:");
                        for (String string : singlePaths) {
                            System.err.println(string);
                        }
                        System.err.println();
                    }
                }
            }
        });
    }

    public static void load(List<String> paths, boolean separate, boolean autoOrder, boolean showProgress) {
        Loader.load(paths, false, separate, autoOrder, showProgress);
    }

    public static void load(String path, boolean showProgress) {
        Loader.load(CollectionUtil.createArrayList(path), false, false, showProgress);
    }

    @Deprecated
    static Sequence[] loadSequences(SequenceFileImporter importer, File[] files, int series, boolean separate, boolean autoOrder, boolean directory, boolean addToRecent, boolean showProgress) {
        List<String> paths = Loader.cleanNonImageFile(CollectionUtil.asList(FileUtil.toPaths(files)));
        List<Sequence> result = Loader.loadSequences(importer, paths, series, false, separate, autoOrder, directory, addToRecent, showProgress);
        return result.toArray(new Sequence[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Sequence loadSequence(SequenceFileImporter importer, String path, int series, int resolution, Rectangle region, int minZ, int maxZ, int minT, int maxT, int channel, boolean forceVolatile, boolean addToRecent, boolean showProgress) {
        Sequence result;
        ApplicationMenu mainMenu = addToRecent ? Icy.getMainInterface().getApplicationMenu() : null;
        FileFrame loadingFrame = showProgress && !Icy.getMainInterface().isHeadLess() ? new FileFrame("Loading", path) : null;
        SequenceFileImporter imp = importer == null ? Loader.getSequenceFileImporter(path, !showProgress) : importer;
        try {
            int selectedSerie;
            imp.open(path, 0);
            OMEXMLMetadata meta = imp.getOMEXMLMetaData();
            MetaDataUtil.clean(meta);
            if (series == -1) {
                try {
                    selectedSerie = Loader.selectSerie(Loader.cloneSequenceFileImporter(imp), path, meta, 0);
                }
                catch (Throwable t) {
                    IcyExceptionHandler.showErrorMessage(t, true, true);
                    System.err.print("Opening first series by default...");
                    selectedSerie = 0;
                }
                if (selectedSerie == -1) {
                    Sequence sequence = null;
                    return sequence;
                }
            } else {
                selectedSerie = series;
            }
            result = Loader.internalLoadSingle(imp, meta, selectedSerie, resolution, region, minZ, maxZ, minT, maxT, channel, forceVolatile, loadingFrame);
            if (mainMenu != null) {
                mainMenu.addRecentLoadedFile(new File(FileUtil.getGenericPath(path)));
            }
            if (GeneralPreferences.getSequencePersistence()) {
                result.loadXMLData();
            }
        }
        catch (Throwable t) {
            try {
                imp.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            IcyExceptionHandler.showErrorMessage(t, true);
            if (loadingFrame != null) {
                new FailedAnnounceFrame(t instanceof OutOfMemoryError ? t.getMessage() : "Failed to open file(s), see the console output for more details.");
            }
            Sequence sequence = null;
            return sequence;
        }
        finally {
            if (loadingFrame != null) {
                loadingFrame.close();
            }
        }
        return result;
    }

    public static Sequence loadSequence(SequenceFileImporter importer, String path, int series, int resolution, Rectangle region, int minZ, int maxZ, int minT, int maxT, int channel, boolean addToRecent, boolean showProgress) {
        return Loader.loadSequence(importer, path, series, resolution, region, minZ, maxZ, minT, maxT, channel, false, addToRecent, showProgress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Sequence loadSequence(SequenceFileImporter importer, List<String> paths, int resolution, Rectangle region, int minZ, int maxZ, int minT, int maxT, int channel, boolean forceVolatile, boolean directory, boolean addToRecent, boolean showProgress) {
        Sequence result = null;
        ApplicationMenu mainMenu = addToRecent ? Icy.getMainInterface().getApplicationMenu() : null;
        try (FileFrame loadingFrame = showProgress && !Icy.getMainInterface().isHeadLess() ? new FileFrame("Loading", null) : null;){
            SequenceFileSticher.SequenceFileGroup group = SequenceFileSticher.groupFiles(importer, Loader.cleanNonImageFile(paths), true, loadingFrame);
            result = Loader.internalLoadGroup(group, resolution, region, minZ, maxZ, minT, maxT, channel, forceVolatile, directory, mainMenu, loadingFrame);
            if (GeneralPreferences.getSequencePersistence()) {
                result.loadXMLData();
            }
        }
        return result;
    }

    public static Sequence loadSequence(List<String> paths, int resolution, Rectangle region, int minZ, int maxZ, int minT, int maxT, int channel, boolean forceVolatile, boolean directory, boolean addToRecent, boolean showProgress) {
        return Loader.loadSequence(null, paths, resolution, region, minZ, maxZ, minT, maxT, channel, forceVolatile, directory, addToRecent, showProgress);
    }

    public static Sequence loadSequence(List<String> paths, int resolution, Rectangle region, int minZ, int maxZ, int minT, int maxT, int channel, boolean directory, boolean addToRecent, boolean showProgress) {
        return Loader.loadSequence(null, paths, resolution, region, minZ, maxZ, minT, maxT, channel, false, directory, addToRecent, showProgress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<Sequence> loadSequences(SequenceFileImporter importer, List<String> paths, int series, boolean forceVolatile, boolean separate, boolean autoOrder, boolean directory, boolean addToRecent, boolean showProgress) {
        ArrayList<Sequence> result = new ArrayList<Sequence>();
        if (paths.size() <= 0) {
            return result;
        }
        ApplicationMenu mainMenu = addToRecent ? Icy.getMainInterface().getApplicationMenu() : null;
        try (FileFrame loadingFrame = showProgress && !Icy.getMainInterface().isHeadLess() ? new FileFrame("Loading", null) : null;){
            ArrayList<String> remainingFiles = new ArrayList<String>(paths);
            if (separate || paths.size() <= 1) {
                if (loadingFrame != null) {
                    loadingFrame.setLength((double)paths.size() * 100.0);
                    loadingFrame.setPosition(0.0);
                }
                if (separate && importer instanceof LociImporterPlugin) {
                    ((LociImporterPlugin)importer).setGroupFiles(false);
                }
                for (String string : paths) {
                    List<Sequence> sequences = Loader.internalLoadSingle(Loader.cloneSequenceFileImporter(importer), string, series, forceVolatile, !separate, loadingFrame);
                    if (sequences == null) {
                        remainingFiles.clear();
                    } else {
                        if (sequences.size() > 0) {
                            result.addAll(sequences);
                            remainingFiles.remove(string);
                            if (mainMenu != null) {
                                mainMenu.addRecentLoadedFile(new File(FileUtil.getGenericPath(string)));
                            }
                        }
                        if (loadingFrame == null || !loadingFrame.isCancelRequested()) continue;
                        remainingFiles.clear();
                    }
                    break;
                }
            } else {
                Collection<SequenceFileSticher.SequenceFileGroup> groups = SequenceFileSticher.groupAllFiles(importer, paths, autoOrder, loadingFrame);
                for (SequenceFileSticher.SequenceFileGroup group : groups) {
                    Sequence sequence = Loader.internalLoadGroup(group, forceVolatile, directory, mainMenu, loadingFrame);
                    if (loadingFrame != null && loadingFrame.isCancelRequested()) {
                        remainingFiles.clear();
                        break;
                    }
                    for (SequenceFileSticher.SequencePosition pos : group.positions) {
                        remainingFiles.remove(pos.getPath());
                    }
                    result.add(sequence);
                }
            }
            if (remainingFiles.size() > 0) {
                System.err.println("Cannot open the following file(s) (format not supported):");
                for (String string : remainingFiles) {
                    System.err.println(string);
                }
                if (loadingFrame != null) {
                    new FailedAnnounceFrame("Some file(s) could not be opened (format not supported). See the console output for more details.");
                }
            }
            if (GeneralPreferences.getSequencePersistence()) {
                for (Sequence sequence : result) {
                    sequence.loadXMLData();
                }
            }
        }
        return result;
    }

    static Sequence concatenateSequence(Sequence dest, Sequence src, boolean onT, boolean onZ) {
        int dsz;
        int dst;
        if (dest == null) {
            return src;
        }
        if (src == null) {
            return dest;
        }
        int sst = src.getSizeT();
        int ssz = src.getSizeZ();
        if (onT) {
            if (onZ) {
                dst = dest.getSizeT() - 1;
                dsz = dest.getSizeZ(dst);
            } else {
                dst = dest.getSizeT();
                dsz = 0;
            }
        } else {
            dst = 0;
            int n = dsz = onZ ? dest.getSizeZ() : 0;
        }
        if (!dest.isUpdating()) {
            dest.beginUpdate();
        }
        for (int t = 0; t < sst; ++t) {
            for (int z = 0; z < ssz; ++z) {
                dest.setImage(t + dst, z + dsz, (BufferedImage)src.getImage(t, z));
            }
        }
        return dest;
    }

    static void addSequences(List<Sequence> result, TreeMap<Integer, Sequence> map) {
        if (!map.isEmpty()) {
            Collection<Sequence> sequencesC = map.values();
            for (Sequence seq : sequencesC) {
                if (!seq.isUpdating()) continue;
                seq.endUpdate();
            }
            Sequence[] sequences = sequencesC.toArray(new Sequence[sequencesC.size()]);
            if (sequences.length > 1) {
                Sequence merged = SequenceUtil.concatC(sequences);
                merged.setName(sequences[0].getName());
                result.add(merged);
            } else {
                result.add(sequences[0]);
            }
            map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Sequence internalLoadSingle(SequenceIdImporter importer, OMEXMLMetadata metadata, int series, int resolution, Rectangle region, int minZ, int maxZ, int minT, int maxT, int channel, boolean forceVolatile, FileFrame loadingFrame) throws IOException, UnsupportedFormatException, OutOfMemoryError {
        int imgSizeX = MetaDataUtil.getSizeX(metadata, series);
        int imgSizeY = MetaDataUtil.getSizeY(metadata, series);
        Rectangle adjRegion = region != null ? new Rectangle(0, 0, imgSizeX, imgSizeY).intersection(region) : null;
        int sizeX = adjRegion == null ? imgSizeX : adjRegion.width;
        int sizeY = adjRegion == null ? imgSizeY : adjRegion.height;
        int sizeZ = MetaDataUtil.getSizeZ(metadata, series);
        int sizeT = MetaDataUtil.getSizeT(metadata, series);
        int sizeC = MetaDataUtil.getSizeC(metadata, series);
        DataType dataType = MetaDataUtil.getDataType(metadata, series);
        int adjMinZ = minZ < 0 ? 0 : Math.min(minZ, sizeZ);
        int adjMaxZ = maxZ < 0 ? sizeZ - 1 : Math.min(maxZ, sizeZ - 1);
        int adjMinT = minT < 0 ? 0 : Math.min(minT, sizeT);
        int adjMaxT = maxT < 0 ? sizeT - 1 : Math.min(maxT, sizeT - 1);
        boolean volatileImage = forceVolatile || GeneralPreferences.getVirtualMode();
        try {
            if (volatileImage) {
                Loader.checkOpeningPlane(resolution, sizeX, sizeY, " Try to open a sub resolution or sub part of the image only.");
            } else {
                Loader.checkOpening(resolution, sizeX, sizeY, channel == -1 ? sizeC : 1, adjMaxZ - adjMinZ + 1, adjMaxT - adjMinT + 1, dataType, " Try to open a sub resolution or sub part of the image only.");
            }
        }
        catch (OutOfMemoryError e) {
            volatileImage = true;
        }
        Sequence result = new Sequence(OMEUtil.createOMEXMLMetadata(metadata, series));
        Loader.setupSequence(result, importer, MetaDataUtil.getNumSeries(metadata) > 1, series, adjRegion, resolution, sizeZ, sizeT, sizeC, adjMinZ, adjMaxZ, adjMinT, adjMaxT, channel);
        int numImage = (adjMaxZ - adjMinZ + 1) * (adjMaxT - adjMinT + 1);
        if (numImage > 0) {
            double progressStep = 100.0 / (double)numImage;
            double progress = 0.0;
            boolean first = true;
            int resDivisor = Math.max(1, (int)Math.pow(2.0, resolution));
            int adjSizeX = sizeX / resDivisor;
            int adjSizeY = sizeY / resDivisor;
            if (loadingFrame != null) {
                progress = loadingFrame.getPosition();
            }
            result.beginUpdate();
            try {
                for (int t = adjMinT; t <= adjMaxT; ++t) {
                    for (int z = adjMinZ; z <= adjMaxZ; ++z) {
                        IcyBufferedImage image;
                        if (loadingFrame != null) {
                            if (loadingFrame.isCancelRequested()) {
                                Sequence sequence = result;
                                return sequence;
                            }
                            if (importer instanceof SequenceFileGroupImporter) {
                                loadingFrame.setFilename(((SequenceFileGroupImporter)importer).getPath(z, t, channel != -1 ? channel : 0));
                            }
                        }
                        if (first) {
                            image = channel == -1 ? importer.getImage(series, resolution, adjRegion, z, t) : importer.getImage(series, resolution, adjRegion, z, t, channel);
                            image.setVolatile(volatileImage);
                            first = false;
                        } else {
                            image = new IcyBufferedImage(adjSizeX, adjSizeY, sizeC, dataType, volatileImage);
                        }
                        image.setImageSourceInfo(importer, series, resolution, adjRegion, t, z, channel);
                        result.setImage(t - adjMinT, z - adjMinZ, (BufferedImage)image);
                        progress += progressStep;
                        if (loadingFrame == null) continue;
                        loadingFrame.setPosition(progress);
                    }
                }
            }
            finally {
                result.endUpdate();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<Sequence> internalLoadSingle(SequenceFileImporter importer, String path, int series, boolean forceVolatile, boolean groupSeries, FileFrame loadingFrame) throws IOException, UnsupportedFormatException, OutOfMemoryError {
        double endStep;
        if (loadingFrame != null) {
            loadingFrame.setFilename(path);
            endStep = loadingFrame.getPosition() + 100.0;
        } else {
            endStep = 0.0;
        }
        ArrayList<Sequence> result = new ArrayList<Sequence>();
        try {
            int[] selectedSeries;
            if (!importer.open(path, 0)) {
                throw new UnsupportedFormatException("Image file '" + path + "' is not supported by " + importer.toString() + " importer.");
            }
            OMEXMLMetadata meta = importer.getOMEXMLMetaData();
            MetaDataUtil.clean(meta);
            if (series == -1) {
                try {
                    selectedSeries = groupSeries ? Loader.groupSeries(meta) : Loader.selectSeries(Loader.cloneSequenceFileImporter(importer), path, meta, 0, false);
                }
                catch (Throwable t) {
                    IcyExceptionHandler.showErrorMessage(t, true, true);
                    System.err.print("Opening first series by default...");
                    selectedSeries = new int[]{0};
                }
                if (selectedSeries.length == 0) {
                    List<Sequence> t = null;
                    return t;
                }
            } else {
                selectedSeries = new int[]{series};
            }
            for (int s : selectedSeries) {
                SequenceFileImporter imp;
                block26: {
                    if (selectedSeries.length > 1 && !result.isEmpty()) {
                        try {
                            imp = Loader.cloneAndOpenSequenceFileImporter(importer);
                            break block26;
                        }
                        catch (IOException e) {
                            throw e;
                        }
                        catch (UnsupportedFormatException e) {
                            throw e;
                        }
                        catch (Throwable t) {
                            IcyExceptionHandler.showErrorMessage(t, true, true);
                            System.err.print("Couln't open, ignoring this series...");
                            continue;
                        }
                    }
                    imp = importer;
                }
                Sequence seq = Loader.internalLoadSingle(imp, meta, s, 0, null, -1, -1, -1, -1, -1, forceVolatile, loadingFrame);
                if (result.size() > 0 && groupSeries) {
                    Loader.concatenateSequence((Sequence)result.get(0), seq, true, false);
                    continue;
                }
                result.add(seq);
            }
            if (groupSeries && selectedSeries.length > 1) {
                Sequence seq = (Sequence)result.get(0);
                String imageName = MetaDataUtil.getName(meta, 0);
                if (StringUtil.isEmpty(imageName)) {
                    seq.setName("no name" + StringUtil.toString(seq.getId(), 3));
                } else {
                    seq.setName(imageName);
                }
            }
        }
        catch (Throwable t) {
            importer.close();
            if (importer.acceptFile(path)) {
                throw t;
            }
        }
        finally {
            if (loadingFrame != null) {
                loadingFrame.setPosition(endStep);
            }
        }
        return result;
    }

    static Sequence internalLoadGroup(SequenceFileSticher.SequenceFileGroup group, int resolution, Rectangle region, int minZ, int maxZ, int minT, int maxT, int channel, boolean forceVolatile, boolean directory, ApplicationMenu mainMenu, FileFrame loadingFrame) throws UnsupportedFormatException, IOException {
        Sequence result;
        double endStep;
        if (loadingFrame != null) {
            loadingFrame.setFilename(group.ident.base);
            loadingFrame.setAction("Loading image group");
            endStep = loadingFrame.getPosition() + 100.0;
        } else {
            endStep = 0.0;
        }
        SequenceFileGroupImporter groupImporter = new SequenceFileGroupImporter();
        try {
            groupImporter.open(group, 0);
            OMEXMLMetadata meta = groupImporter.getOMEXMLMetaData();
            MetaDataUtil.clean(meta);
            result = Loader.internalLoadSingle(groupImporter, meta, 0, resolution, region, minZ, maxZ, minT, maxT, channel, forceVolatile, loadingFrame);
            if (directory) {
                String fileDir = FileUtil.getDirectory(group.ident.base, false);
                result.setName(FileUtil.getFileName(fileDir, false));
                result.setFilename(fileDir);
                if (mainMenu != null) {
                    mainMenu.addRecentFile(fileDir);
                }
            } else if (mainMenu != null) {
                mainMenu.addRecentFile(group.getPaths());
            }
        }
        catch (Throwable t) {
            groupImporter.close();
            throw t;
        }
        finally {
            if (loadingFrame != null) {
                loadingFrame.setPosition(endStep);
            }
        }
        return result;
    }

    static Sequence internalLoadGroup(SequenceFileSticher.SequenceFileGroup group, boolean forceVolatile, boolean directory, ApplicationMenu mainMenu, FileFrame loadingFrame) throws UnsupportedFormatException, IOException {
        return Loader.internalLoadGroup(group, 0, null, -1, -1, -1, -1, -1, forceVolatile, directory, mainMenu, loadingFrame);
    }

    public static String getSequenceName(Sequence sequence, String path, boolean multiSerie, int series) {
        String name = FileUtil.getFileName(path, false);
        if (sequence.isDefaultName()) {
            if (multiSerie) {
                name = name + " - series " + StringUtil.toString(series);
            }
        } else {
            name = multiSerie ? name + " - " + sequence.getName() : sequence.getName();
        }
        return name;
    }

    public static void setupSequence(Sequence sequence, SequenceIdImporter importer, boolean multiSerie, int series, Rectangle region, int resolution, int sizeZ, int sizeT, int sizeC, int minZ, int maxZ, int minT, int maxT, int channel) {
        String path = FileUtil.getGenericPath(importer.getOpened());
        String name = Loader.getSequenceName(sequence, path, multiSerie, series);
        double psx = sequence.getPixelSizeX();
        double psy = sequence.getPixelSizeY();
        double psz = sequence.getPixelSizeZ();
        double posX = sequence.getPositionX();
        double posY = sequence.getPositionY();
        double posZ = sequence.getPositionZ();
        long posT = sequence.getPositionT();
        OMEXMLMetadata metadata = sequence.getOMEXMLMetadata();
        for (int t = sizeT - 1; t >= 0; --t) {
            for (int z = sizeZ - 1; z >= 0; --z) {
                for (int c = 0; c < sizeC; ++c) {
                    if (t >= minT && t <= maxT && z >= minZ && z <= maxZ) continue;
                    MetaDataUtil.removePlane(metadata, 0, maxT, maxZ, c);
                }
            }
        }
        if (channel != -1) {
            sequence.setOriginChannel(channel);
            for (int c = 0; c < sizeC; ++c) {
                if (c == channel) continue;
                MetaDataUtil.removePlanes(metadata, 0, -1, -1, c);
                MetaDataUtil.removeChannel(metadata, 0, c);
            }
        }
        if (region != null) {
            sequence.setOriginXYRegion(region);
            sequence.setPositionX(posX + (double)region.x * psx);
            sequence.setPositionY(posY + (double)region.y * psy);
        }
        if (minZ > 0) {
            sequence.setPositionZ(posZ + (double)minZ * psz);
        }
        if (minT > 0) {
            sequence.setTimeStamp(posT + (long)(sequence.getPositionTOffset(minT, minZ, Math.max(0, channel)) * 1000.0));
        }
        if (resolution > 0) {
            int divider = (int)Math.pow(2.0, resolution);
            sequence.setOriginResolution(resolution);
            sequence.setPixelSizeX(psx * (double)divider);
            sequence.setPixelSizeY(psy * (double)divider);
            name = name + " - binning=" + StringUtil.toString(resolution);
        }
        if (minZ > 0 || maxZ < sizeZ - 1) {
            sequence.setOriginZMin(minZ);
            sequence.setOriginZMax(maxZ);
            name = minZ == maxZ ? name + " - Z" + StringUtil.toString(minZ) : name + " - Z[" + StringUtil.toString(minZ) + "-" + StringUtil.toString(maxZ) + "]";
        }
        if (minT > 0 || maxT < sizeT - 1) {
            sequence.setOriginTMin(minT);
            sequence.setOriginTMax(maxT);
            name = minT == maxT ? name + " - T" + StringUtil.toString(minT) : name + " - T[" + StringUtil.toString(minT) + "-" + StringUtil.toString(maxT) + "]";
        }
        if (channel != -1) {
            name = name + " - C" + StringUtil.toString(channel);
        }
        sequence.setName(name);
        sequence.setFilename(path);
        sequence.setImageProvider(importer);
    }

    public static int[] selectSeries(final SequenceIdImporter importer, final String path, final OMEXMLMetadata meta, int defaultSerie, final boolean singleSelection) throws UnsupportedFormatException, IOException {
        int serieCount = MetaDataUtil.getNumSeries(meta);
        final int[] tmp = new int[serieCount + 1];
        if (serieCount > 0) {
            tmp[0] = 1;
            if (serieCount > 1) {
                if (!Icy.getMainInterface().isHeadLess()) {
                    final Exception[] exception = new Exception[]{null};
                    ThreadUtil.invokeNow(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                int[] series = new SeriesSelectionDialog(importer, path, meta, singleSelection).getSelectedSeries();
                                tmp[0] = series.length;
                                System.arraycopy(series, 0, tmp, 1, series.length);
                            }
                            catch (Exception e) {
                                exception[0] = e;
                            }
                        }
                    });
                    if (exception[0] instanceof UnsupportedFormatException) {
                        throw (UnsupportedFormatException)exception[0];
                    }
                    if (exception[0] instanceof IOException) {
                        throw (IOException)exception[0];
                    }
                } else {
                    tmp[1] = defaultSerie;
                }
            } else {
                tmp[1] = 0;
            }
        }
        int[] result = new int[tmp[0]];
        System.arraycopy(tmp, 1, result, 0, result.length);
        return result;
    }

    public static int[] groupSeries(OMEXMLMetadata meta) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int sizeS = MetaDataUtil.getNumSeries(meta);
        if (sizeS > 0) {
            int sizeX = MetaDataUtil.getSizeX(meta, 0);
            int sizeY = MetaDataUtil.getSizeY(meta, 0);
            int sizeZ = MetaDataUtil.getSizeZ(meta, 0);
            int sizeC = MetaDataUtil.getSizeC(meta, 0);
            DataType dataType = MetaDataUtil.getDataType(meta, 0);
            result.add(0);
            if (MetaDataUtil.getSizeT(meta, 0) == 1) {
                for (int s = 1; s < sizeS; ++s) {
                    int sx = MetaDataUtil.getSizeX(meta, s);
                    int sy = MetaDataUtil.getSizeY(meta, s);
                    int sz = MetaDataUtil.getSizeZ(meta, s);
                    int sc = MetaDataUtil.getSizeC(meta, s);
                    DataType dt = MetaDataUtil.getDataType(meta, s);
                    if (sx != sizeX || sy != sizeY || sz != sizeZ || sc != sizeC || dt != dataType || MetaDataUtil.getSizeT(meta, s) != 1) continue;
                    result.add(s);
                }
            }
        }
        int[] ires = new int[result.size()];
        for (int i = 0; i < ires.length; ++i) {
            ires[i] = (Integer)result.get(i);
        }
        return ires;
    }

    public static int[] selectSeries(SequenceFileImporter importer, String path, OMEXMLMetadata meta, int defaultSerie, boolean singleSelection) throws UnsupportedFormatException, IOException {
        return Loader.selectSeries((SequenceIdImporter)importer, path, meta, defaultSerie, singleSelection);
    }

    public static int[] selectSeries(SequenceFileImporter importer, String path, OMEXMLMetadataImpl meta, int defaultSerie, boolean singleSelection) throws UnsupportedFormatException, IOException {
        return Loader.selectSeries(importer, path, (OMEXMLMetadata)meta, defaultSerie, singleSelection);
    }

    public static int selectSerie(SequenceFileImporter importer, String path, OMEXMLMetadata meta, int defaultSerie) throws UnsupportedFormatException, IOException {
        int[] selected = Loader.selectSeries(importer, path, meta, defaultSerie, true);
        if (selected.length > 0) {
            return selected[0];
        }
        return -1;
    }

    @Deprecated
    public static int selectSerie(SequenceFileImporter importer, String path, OMEXMLMetadataImpl meta, int defaultSerie) throws UnsupportedFormatException, IOException {
        return Loader.selectSerie(importer, path, (OMEXMLMetadata)meta, defaultSerie);
    }

    public static List<String> explode(List<String> paths) {
        return FileUtil.toPaths(FileUtil.explode(FileUtil.toFiles(paths), null, true, false));
    }

    public static List<String> cleanNonImageFile(List<String> paths) {
        ArrayList<String> result = new ArrayList<String>();
        for (String path : paths) {
            if (Loader.canDiscardImageFile(path) || FileUtil.getFileExtension(path, false).toLowerCase().equals("xml") && SequencePersistent.isValidXMLPersitence(path)) continue;
            result.add(path);
        }
        return result;
    }

    @Deprecated
    public static List<FilePosition> getFilePositions(List<String> paths, boolean dimOrder, FileFrame loadingFrame) {
        ArrayList<FilePosition> result = new ArrayList<FilePosition>(paths.size());
        Collection<SequenceFileSticher.SequenceFileGroup> groups = SequenceFileSticher.groupAllFiles(null, paths, dimOrder, loadingFrame);
        for (SequenceFileSticher.SequenceFileGroup group : groups) {
            SequenceFileSticher.SequenceIdent ident = group.ident;
            for (SequenceFileSticher.SequencePosition pos : group.positions) {
                result.add(new FilePosition(pos.getPath(), ident.base, 0, pos.getIndexT(), pos.getIndexZ(), pos.getIndexC()));
            }
        }
        return result;
    }

    @Deprecated
    public static List<FilePosition> getFilePositions(List<String> paths, boolean dimOrder) {
        return Loader.getFilePositions(paths, dimOrder, null);
    }

    @Deprecated
    public static class FilePosition
    extends ChannelPosition {
        public final String path;
        public String basePath;
        int s;

        public FilePosition(String path, String basePath, int s, int t, int z, int c) {
            super(t, z, c);
            this.s = s;
            this.path = path;
            this.basePath = basePath;
        }

        @Deprecated
        public FilePosition(String path, int t, int z, int c) {
            super(t, z, c);
            this.path = path;
            this.basePath = "";
        }

        public FilePosition(String path) {
            this.path = path;
        }

        public FilePosition(FilePosition fp) {
            this(fp.path, fp.basePath, fp.s, fp.t, fp.z, fp.c);
        }

        public int getS() {
            return this.s;
        }

        public void setS(int s) {
            this.s = s;
        }

        public void set(int s, int t, int z, int c) {
            super.set(t, z, c);
            this.s = s;
        }

        @Override
        public int compareTo(ImagePosition o) {
            if (o instanceof FilePosition) {
                int result = this.basePath.compareTo(((FilePosition)o).basePath);
                if (result != 0) {
                    return result;
                }
                int sp = ((FilePosition)o).s;
                if (this.s > sp) {
                    return 1;
                }
                if (this.s < sp) {
                    return -1;
                }
            }
            return super.compareTo(o);
        }

        public String toString() {
            return "File=" + this.path + " Position=[S:" + this.s + " T:" + this.t + " Z:" + this.z + " C:" + this.c + "]";
        }
    }
}

