/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.dialog;

import icy.common.exception.UnsupportedFormatException;
import icy.file.Loader;
import icy.file.SequenceFileImporter;
import icy.gui.component.ThumbnailComponent;
import icy.gui.dialog.ActionDialog;
import icy.gui.util.ComponentUtil;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.main.Icy;
import icy.resource.ResourceUtil;
import icy.sequence.MetaDataUtil;
import icy.sequence.SequenceIdImporter;
import icy.util.OMEUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import loci.formats.IFormatReader;
import loci.formats.ome.OMEXMLMetadataImpl;
import ome.xml.meta.MetadataRetrieve;
import ome.xml.meta.OMEXMLMetadata;

public class SeriesSelectionDialog
extends ActionDialog
implements Runnable {
    private static final long serialVersionUID = -2133845128887305016L;
    protected static final int NUM_COL = 4;
    protected static final int THUMB_X = 160;
    protected static final int THUMB_Y = 140;
    protected JScrollPane scrollPane;
    protected JPanel gridPanel;
    protected ThumbnailComponent[] serieComponents;
    protected JButton selectAllBtn;
    protected JButton unselectAllBtn;
    protected IFormatReader reader;
    protected SequenceIdImporter importer;
    protected String id;
    protected OMEXMLMetadata metadata;
    protected boolean singleSelection;
    protected int[] selectedSeries;
    protected final MouseAdapter serieDoubleClickAction;
    protected final ActionListener serieSimpleClickAction;
    protected final Thread loadingThread;

    @Deprecated
    public SeriesSelectionDialog(IFormatReader reader) {
        super("Series selection", null, (Frame)((Object)Icy.getMainInterface().getMainFrame()));
        int series;
        this.reader = reader;
        this.selectedSeries = new int[0];
        this.singleSelection = false;
        this.initialize();
        this.serieSimpleClickAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        this.serieDoubleClickAction = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ThumbnailComponent thumb = (ThumbnailComponent)e.getSource();
                    for (int i = 0; i < SeriesSelectionDialog.this.serieComponents.length; ++i) {
                        if (SeriesSelectionDialog.this.serieComponents[i] != thumb) continue;
                        SeriesSelectionDialog.this.selectedSeries = new int[]{i};
                        SeriesSelectionDialog.this.dispose();
                    }
                }
            }
        };
        if (reader != null) {
            this.metadata = OMEUtil.getOMEXMLMetadata((MetadataRetrieve)((Object)reader.getMetadataStore()));
            series = reader.getSeriesCount();
        } else {
            this.metadata = null;
            series = 0;
        }
        this.serieComponents = new ThumbnailComponent[series];
        int numRow = series / 4;
        if (series > 4 * numRow) {
            ++numRow;
        }
        ((GridLayout)this.gridPanel.getLayout()).setRows(numRow);
        for (int i = 0; i < numRow; ++i) {
            for (int j = 0; j < 4; ++j) {
                int index = i * 4 + j;
                if (index < series) {
                    ThumbnailComponent thumb = new ThumbnailComponent(true);
                    thumb.addMouseListener(this.serieDoubleClickAction);
                    if (this.serieComponents[index] != null) {
                        this.serieComponents[index].removeMouseListener(this.serieDoubleClickAction);
                    }
                    this.serieComponents[index] = thumb;
                    thumb.setEnabled(true);
                    thumb.setTitle("loading...");
                    thumb.setInfos("");
                    thumb.setInfos2("");
                    this.gridPanel.add(thumb);
                    continue;
                }
                this.gridPanel.add(Box.createGlue());
            }
        }
        this.loadingThread = new Thread((Runnable)this, "Series thumbnail loading");
        this.loadingThread.start();
        this.setOkAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int numSelected = 0;
                for (int i = 0; i < SeriesSelectionDialog.this.serieComponents.length; ++i) {
                    if (!SeriesSelectionDialog.this.serieComponents[i].isSelected()) continue;
                    ++numSelected;
                }
                SeriesSelectionDialog.this.selectedSeries = new int[numSelected];
                int ind = 0;
                for (int i = 0; i < SeriesSelectionDialog.this.serieComponents.length; ++i) {
                    if (!SeriesSelectionDialog.this.serieComponents[i].isSelected()) continue;
                    SeriesSelectionDialog.this.selectedSeries[ind++] = i;
                }
            }
        });
        this.selectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (ThumbnailComponent thumb : SeriesSelectionDialog.this.serieComponents) {
                    thumb.setSelected(true);
                }
            }
        });
        this.unselectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (ThumbnailComponent thumb : SeriesSelectionDialog.this.serieComponents) {
                    thumb.setSelected(false);
                }
            }
        });
        this.setPreferredSize(new Dimension(740, 520));
        this.pack();
        ComponentUtil.center(this);
        this.setVisible(true);
    }

    public SeriesSelectionDialog(SequenceIdImporter importer, String id, OMEXMLMetadata metadata, boolean singleSelection) {
        super("Series selection", null, (Frame)((Object)Icy.getMainInterface().getMainFrame()));
        this.importer = importer;
        this.id = id;
        this.metadata = metadata;
        this.singleSelection = singleSelection;
        this.selectedSeries = new int[0];
        this.initialize();
        int series = MetaDataUtil.getNumSeries(metadata);
        this.serieSimpleClickAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (SeriesSelectionDialog.this.singleSelection) {
                    for (ThumbnailComponent thumb : SeriesSelectionDialog.this.serieComponents) {
                        if (thumb == source) continue;
                        thumb.setSelected(false);
                    }
                }
            }
        };
        this.serieDoubleClickAction = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ThumbnailComponent thumb = (ThumbnailComponent)e.getSource();
                    for (int i = 0; i < SeriesSelectionDialog.this.serieComponents.length; ++i) {
                        if (SeriesSelectionDialog.this.serieComponents[i] != thumb) continue;
                        SeriesSelectionDialog.this.selectedSeries = new int[]{i};
                        SeriesSelectionDialog.this.dispose();
                    }
                }
            }
        };
        this.serieComponents = new ThumbnailComponent[series];
        int numRow = series / 4;
        if (series > 4 * numRow) {
            ++numRow;
        }
        ((GridLayout)this.gridPanel.getLayout()).setRows(numRow);
        for (int i = 0; i < numRow; ++i) {
            for (int j = 0; j < 4; ++j) {
                int index = i * 4 + j;
                if (index < series) {
                    ThumbnailComponent thumb = new ThumbnailComponent(true);
                    thumb.addMouseListener(this.serieDoubleClickAction);
                    thumb.addActionListener(this.serieSimpleClickAction);
                    if (this.serieComponents[index] != null) {
                        this.serieComponents[index].removeMouseListener(this.serieDoubleClickAction);
                    }
                    this.serieComponents[index] = thumb;
                    thumb.setEnabled(true);
                    thumb.setTitle("loading...");
                    thumb.setInfos("");
                    thumb.setInfos2("");
                    this.gridPanel.add(thumb);
                    continue;
                }
                this.gridPanel.add(Box.createGlue());
            }
        }
        this.loadingThread = new Thread((Runnable)this, "Series thumbnail loading");
        this.loadingThread.start();
        this.setOkAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int numSelected = 0;
                for (int i = 0; i < SeriesSelectionDialog.this.serieComponents.length; ++i) {
                    if (!SeriesSelectionDialog.this.serieComponents[i].isSelected()) continue;
                    ++numSelected;
                }
                SeriesSelectionDialog.this.selectedSeries = new int[numSelected];
                int ind = 0;
                for (int i = 0; i < SeriesSelectionDialog.this.serieComponents.length; ++i) {
                    if (!SeriesSelectionDialog.this.serieComponents[i].isSelected()) continue;
                    SeriesSelectionDialog.this.selectedSeries[ind++] = i;
                }
            }
        });
        this.selectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (ThumbnailComponent thumb : SeriesSelectionDialog.this.serieComponents) {
                    thumb.setSelected(true);
                }
            }
        });
        this.unselectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (ThumbnailComponent thumb : SeriesSelectionDialog.this.serieComponents) {
                    thumb.setSelected(false);
                }
            }
        });
        this.selectAllBtn.setVisible(!singleSelection);
        this.unselectAllBtn.setVisible(!singleSelection);
        this.setPreferredSize(new Dimension(740, 520));
        this.pack();
        ComponentUtil.center(this);
        this.setVisible(true);
    }

    public SeriesSelectionDialog(SequenceFileImporter importer, String id, OMEXMLMetadata metadata, boolean singleSelection) {
        this((SequenceIdImporter)importer, id, metadata, singleSelection);
    }

    public SeriesSelectionDialog(SequenceFileImporter importer, String id, OMEXMLMetadata metadata) throws UnsupportedFormatException, IOException {
        this(importer, id, metadata, false);
    }

    @Deprecated
    public SeriesSelectionDialog(SequenceFileImporter importer, String id, OMEXMLMetadataImpl metadata) throws UnsupportedFormatException, IOException {
        this(importer, id, (OMEXMLMetadata)metadata);
    }

    public SeriesSelectionDialog(SequenceFileImporter importer, String id) throws UnsupportedFormatException, IOException {
        this(importer, id, Loader.getOMEXMLMetaData(importer, id));
    }

    public int[] getSelectedSeries() {
        return this.selectedSeries;
    }

    void initialize() {
        JPanel panel = new JPanel();
        this.getContentPane().add((Component)panel, "North");
        panel.setLayout(new FlowLayout(1, 5, 5));
        JLabel lblSelect = this.singleSelection ? new JLabel("Select the series and click 'Ok' or directly double click on it to open it.") : new JLabel("Click on a serie to select / unselect it and click 'Ok' or double click to directly open it.");
        ComponentUtil.setFontBold(lblSelect);
        ComponentUtil.setFontSize(lblSelect, 12);
        panel.add(lblSelect);
        this.scrollPane = new JScrollPane(22, 31);
        this.mainPanel.add((Component)this.scrollPane, "Center");
        this.gridPanel = new JPanel();
        this.scrollPane.setViewportView(this.gridPanel);
        this.gridPanel.setLayout(new GridLayout(2, 4, 0, 0));
        this.buttonPanel.removeAll();
        this.selectAllBtn = new JButton("Select all");
        this.unselectAllBtn = new JButton("Unselect all");
        this.buttonPanel.add(Box.createHorizontalStrut(4));
        this.buttonPanel.add(this.selectAllBtn);
        this.buttonPanel.add(Box.createHorizontalStrut(8));
        this.buttonPanel.add(this.unselectAllBtn);
        this.buttonPanel.add(Box.createHorizontalStrut(8));
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.add(Box.createHorizontalStrut(8));
        this.buttonPanel.add(this.okBtn);
        this.buttonPanel.add(Box.createHorizontalStrut(8));
        this.buttonPanel.add(this.cancelBtn);
        this.buttonPanel.add(Box.createHorizontalStrut(4));
    }

    @Override
    protected void onClosed() {
        super.onClosed();
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                if (SeriesSelectionDialog.this.loadingThread != null && SeriesSelectionDialog.this.loadingThread.isAlive()) {
                    try {
                        SeriesSelectionDialog.this.loadingThread.interrupt();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }, 2000L);
    }

    @Override
    public void run() {
        try {
            int i;
            for (i = 0; i < this.serieComponents.length; ++i) {
                if (this.isClosed()) {
                    return;
                }
                try {
                    int sizeC = MetaDataUtil.getSizeC(this.metadata, i);
                    this.serieComponents[i].setTitle(this.metadata.getImageName(i));
                    this.serieComponents[i].setInfos(MetaDataUtil.getSizeX(this.metadata, i) + " x " + MetaDataUtil.getSizeY(this.metadata, i) + " - " + MetaDataUtil.getSizeZ(this.metadata, i) + "Z x " + MetaDataUtil.getSizeT(this.metadata, i) + "T");
                    this.serieComponents[i].setInfos2(sizeC + (sizeC > 1 ? " channels (" : " channel (") + (Object)((Object)MetaDataUtil.getDataType(this.metadata, i)) + ")");
                }
                catch (Exception e) {
                    this.serieComponents[i].setTitle("Cannot read file");
                    this.serieComponents[i].setInfos("");
                    this.serieComponents[i].setInfos2("");
                }
                try {
                    this.serieComponents[i].setImage(ResourceUtil.ICON_PICTURE);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            for (i = 0; i < this.serieComponents.length; ++i) {
                if (this.isClosed()) {
                    return;
                }
                try {
                    if (this.importer.open(this.id, 0)) {
                        try {
                            IcyBufferedImage img = this.importer.getThumbnail(i);
                            this.serieComponents[i].setImage(IcyBufferedImageUtil.toBufferedImage(img, 2));
                            continue;
                        }
                        finally {
                            this.importer.close();
                        }
                    }
                    this.serieComponents[i].setImage(ResourceUtil.ICON_DELETE);
                    continue;
                }
                catch (OutOfMemoryError e) {
                    this.serieComponents[i].setImage(ResourceUtil.ICON_DELETE);
                    continue;
                }
                catch (Exception e) {
                    this.serieComponents[i].setImage(ResourceUtil.ICON_DELETE);
                }
            }
        }
        catch (ThreadDeath threadDeath) {
            // empty catch block
        }
    }
}

