/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.preferences;

import icy.gui.preferences.PreferenceFrame;
import icy.gui.preferences.WorkspaceListPreferencePanel;
import icy.preferences.RepositoryPreferences;
import icy.workspace.Workspace;
import icy.workspace.WorkspaceInstaller;
import icy.workspace.WorkspaceLoader;
import icy.workspace.WorkspaceRepositoryLoader;
import java.util.ArrayList;

public class WorkspaceOnlinePreferencePanel
extends WorkspaceListPreferencePanel
implements WorkspaceRepositoryLoader.WorkspaceRepositoryLoaderListener,
WorkspaceInstaller.WorkspaceInstallerListener {
    private static final long serialVersionUID = 5061606004171912231L;
    public static final String NODE_NAME = "Online Workspace";

    WorkspaceOnlinePreferencePanel(PreferenceFrame parent) {
        super(parent, NODE_NAME);
        WorkspaceRepositoryLoader.addListener(this);
        WorkspaceInstaller.addListener(this);
        this.repositoryPanel.setVisible(true);
        this.action1Button.setText("Install");
        this.action1Button.setVisible(true);
        this.updateButtonsState();
        this.updateRepositories();
    }

    @Override
    protected void closed() {
        super.closed();
        WorkspaceRepositoryLoader.removeListener(this);
        WorkspaceInstaller.removeListener(this);
    }

    private WorkspaceOnlineState getWorkspaceOnlineState(Workspace workspace) {
        if (workspace == null) {
            return WorkspaceOnlineState.NULL;
        }
        if (WorkspaceInstaller.isInstallingWorkspace(workspace)) {
            return WorkspaceOnlineState.INSTALLING;
        }
        if (WorkspaceInstaller.isDesinstallingWorkspace(workspace)) {
            return WorkspaceOnlineState.DELETING;
        }
        if (WorkspaceLoader.isLoaded(workspace)) {
            return WorkspaceOnlineState.INSTALLED;
        }
        return WorkspaceOnlineState.HAS_INSTALL;
    }

    @Override
    protected int getColumnCount() {
        return 3;
    }

    @Override
    protected void doAction1(Workspace workspace) {
        switch (this.getWorkspaceOnlineState(workspace)) {
            case HAS_INSTALL: {
                WorkspaceInstaller.install(workspace, true);
                this.refreshTableData();
                this.updateButtonsState();
                break;
            }
            case INSTALLED: {
                WorkspaceInstaller.desinstall(workspace, true);
                this.refreshTableData();
                this.updateButtonsState();
            }
        }
    }

    @Override
    protected void repositoryChanged() {
        this.refreshWorkspaces();
    }

    @Override
    protected void reloadWorkspaces() {
        WorkspaceRepositoryLoader.reload();
        this.refreshWorkspaces();
    }

    @Override
    protected String getStateValue(Workspace workspace) {
        switch (this.getWorkspaceOnlineState(workspace)) {
            case INSTALLING: {
                return "installing...";
            }
            case DELETING: {
                return "deleting...";
            }
            case INSTALLED: {
                return "installed";
            }
        }
        return "";
    }

    protected ArrayList<Workspace> getWorkspaces() {
        Object selectedItem = this.repository.getSelectedItem();
        if (selectedItem != null) {
            return WorkspaceRepositoryLoader.getWorkspaces((RepositoryPreferences.RepositoryInfo)selectedItem);
        }
        return WorkspaceRepositoryLoader.getWorkspaces();
    }

    @Override
    protected void updateButtonsStateInternal() {
        if (WorkspaceRepositoryLoader.isLoading()) {
            this.refreshButton.setText("Reloading...");
            this.refreshButton.setEnabled(false);
            this.repository.setEnabled(false);
        } else {
            this.refreshButton.setText("Reload list");
            this.refreshButton.setEnabled(true);
            this.repository.setEnabled(true);
        }
        Workspace workspace = this.getSelectedWorkspace();
        if (workspace == null) {
            this.action1Button.setEnabled(false);
            return;
        }
        switch (this.getWorkspaceOnlineState(workspace)) {
            case INSTALLING: {
                this.action1Button.setText("Installing...");
                this.action1Button.setEnabled(false);
                break;
            }
            case DELETING: {
                this.action1Button.setText("Deleting...");
                this.action1Button.setEnabled(false);
                break;
            }
            case HAS_INSTALL: {
                this.action1Button.setText("Install");
                this.action1Button.setEnabled(true);
                break;
            }
            case INSTALLED: {
                this.action1Button.setText("Delete");
                this.action1Button.setEnabled(true);
                break;
            }
            case NULL: {
                this.action1Button.setEnabled(false);
            }
        }
    }

    @Override
    public void workspaceRepositeryLoaderChanged() {
        this.workspacesChanged();
    }

    @Override
    public void workspaceInstalled(WorkspaceInstaller.WorkspaceInstallerEvent e) {
        this.refreshTableData();
        this.updateButtonsState();
    }

    @Override
    public void workspaceRemoved(WorkspaceInstaller.WorkspaceInstallerEvent e) {
        this.refreshTableData();
        this.updateButtonsState();
    }

    private static enum WorkspaceOnlineState {
        NULL,
        INSTALLING,
        DELETING,
        HAS_INSTALL,
        INSTALLED;

    }
}

