/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.preferences;

import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.main.MainFrame;
import icy.gui.preferences.PreferenceFrame;
import icy.gui.preferences.PreferencePanel;
import icy.main.Icy;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;

public class WorkspacePreferencePanel
extends PreferencePanel {
    private static final long serialVersionUID = -4200728138011886705L;
    public static final String NODE_NAME = "Workspace";
    final JCheckBox autoUpdateCheckBox = new JCheckBox("Enable auto update");
    final JCheckBox autoCheckUpdateCheckBox;
    private final JButton cleanButton;

    WorkspacePreferencePanel(PreferenceFrame parent) {
        super(parent, NODE_NAME, "Preferences");
        this.autoUpdateCheckBox.setToolTipText("Enable silent update for workspaces as soon a new version is available");
        this.autoUpdateCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WorkspacePreferencePanel.this.autoUpdateCheckBox.isSelected()) {
                    WorkspacePreferencePanel.this.autoCheckUpdateCheckBox.setSelected(true);
                }
                WorkspacePreferencePanel.this.autoCheckUpdateCheckBox.setEnabled(!WorkspacePreferencePanel.this.autoUpdateCheckBox.isSelected());
            }
        });
        this.autoCheckUpdateCheckBox = new JCheckBox("Check for update at startup");
        this.autoCheckUpdateCheckBox.setToolTipText("Check for new workspaces version at startup");
        this.cleanButton = new JButton("Clean workspaces");
        this.cleanButton.setToolTipText("Remove missing plugins from workspace description file");
        this.cleanButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame frame = Icy.getMainInterface().getMainFrame();
                if (frame != null) {
                    frame.getMainRibbon().cleanWorkspaces();
                }
                new AnnounceFrame("Worspaces cleaned !");
            }
        });
        this.load();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 3));
        this.mainPanel.add(this.cleanButton);
        this.mainPanel.add(Box.createVerticalStrut(10));
        this.mainPanel.add(Box.createVerticalGlue());
    }

    @Override
    protected void load() {
        this.autoCheckUpdateCheckBox.setEnabled(!this.autoUpdateCheckBox.isSelected());
    }

    @Override
    protected void save() {
    }
}

