/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.sequence;

import icy.file.FileUtil;
import icy.gui.component.button.IcyButton;
import icy.gui.frame.GenericFrame;
import icy.gui.main.ActiveSequenceListener;
import icy.gui.sequence.SequenceMetadataPanel;
import icy.gui.sequence.SequencePropertiesDialog;
import icy.main.Icy;
import icy.math.UnitUtil;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.system.IcyExceptionHandler;
import icy.system.SystemUtil;
import icy.system.thread.ThreadUtil;
import icy.util.EventUtil;
import icy.util.StringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SequenceInfosPanel
extends JPanel
implements ActiveSequenceListener {
    private static final long serialVersionUID = -6123324347914804260L;
    private JLabel dimensionLabel;
    private JLabel resXLabel;
    private JLabel resYLabel;
    private JLabel resZLabel;
    private JLabel resTLabel;
    private JLabel sizeLabel;
    private JLabel channelLabel;
    private IcyButton editBtn;
    private IcyButton detailBtn;
    private JLabel pathLabel;
    JTextField pathField;
    private JTextField nameField;
    private final Runnable infosRefresher;

    public SequenceInfosPanel() {
        this.initialize();
        this.editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sequence seq = Icy.getMainInterface().getActiveSequence();
                if (seq != null) {
                    new SequencePropertiesDialog(seq);
                }
            }
        });
        this.detailBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sequence seq = Icy.getMainInterface().getActiveSequence();
                if (seq != null) {
                    GenericFrame g = new GenericFrame(seq.getName() + " - Metadata", new SequenceMetadataPanel(seq));
                    g.addToDesktopPane();
                    g.center();
                    g.requestFocus();
                }
            }
        });
        this.infosRefresher = new Runnable(){

            @Override
            public void run() {
                ThreadUtil.invokeNow(new Runnable(){

                    @Override
                    public void run() {
                        SequenceInfosPanel.this.updateInfosInternal(Icy.getMainInterface().getActiveSequence());
                    }
                });
            }
        };
        this.updateInfosInternal(null);
    }

    public void initialize() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 40, 40, 40, 0};
        gridBagLayout.rowHeights = new int[]{18, 0, 18, 18, 18, 18, 18, 18, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 1.0, 1.0, 1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JLabel lbl_name = new JLabel("Name");
        lbl_name.setToolTipText("Sequence name");
        GridBagConstraints gbc_lbl_name = new GridBagConstraints();
        gbc_lbl_name.anchor = 17;
        gbc_lbl_name.fill = 3;
        gbc_lbl_name.insets = new Insets(0, 0, 5, 5);
        gbc_lbl_name.gridx = 0;
        gbc_lbl_name.gridy = 0;
        this.add((Component)lbl_name, gbc_lbl_name);
        this.nameField = new JTextField(){

            @Override
            public Dimension getPreferredSize() {
                Dimension result = super.getPreferredSize();
                result.width = 100;
                return result;
            }
        };
        this.nameField.setOpaque(false);
        this.nameField.setBorder(null);
        this.nameField.setEditable(false);
        GridBagConstraints gbc_scrollPane = new GridBagConstraints();
        gbc_scrollPane.fill = 1;
        gbc_scrollPane.gridwidth = 3;
        gbc_scrollPane.insets = new Insets(0, 0, 5, 0);
        gbc_scrollPane.gridx = 1;
        gbc_scrollPane.gridy = 0;
        this.add((Component)this.nameField, gbc_scrollPane);
        this.pathLabel = new JLabel("Path");
        this.pathLabel.setToolTipText("Sequence file path");
        GridBagConstraints gbc_pathLabel = new GridBagConstraints();
        gbc_pathLabel.fill = 3;
        gbc_pathLabel.anchor = 17;
        gbc_pathLabel.insets = new Insets(0, 0, 5, 5);
        gbc_pathLabel.gridx = 0;
        gbc_pathLabel.gridy = 1;
        this.add((Component)this.pathLabel, gbc_pathLabel);
        this.pathField = new JTextField(){

            @Override
            public Dimension getPreferredSize() {
                Dimension result = super.getPreferredSize();
                result.width = 100;
                return result;
            }
        };
        this.pathField.setOpaque(false);
        this.pathField.setBorder(null);
        this.pathField.setEditable(false);
        this.pathField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isConsumed()) {
                    return;
                }
                if (EventUtil.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    try {
                        SystemUtil.openFolder(FileUtil.getDirectory(SequenceInfosPanel.this.pathField.getText()));
                    }
                    catch (IOException e1) {
                        IcyExceptionHandler.showErrorMessage(e1, false, false);
                    }
                    e.consume();
                }
            }
        });
        GridBagConstraints gbc_scrollPane_1 = new GridBagConstraints();
        gbc_scrollPane_1.fill = 1;
        gbc_scrollPane_1.gridwidth = 3;
        gbc_scrollPane_1.insets = new Insets(0, 0, 5, 5);
        gbc_scrollPane_1.gridx = 1;
        gbc_scrollPane_1.gridy = 1;
        this.add((Component)this.pathField, gbc_scrollPane_1);
        JLabel lbl_dim = new JLabel("Dimension");
        lbl_dim.setToolTipText("Size of X, Y, Z and T dimension");
        GridBagConstraints gbc_lbl_dim = new GridBagConstraints();
        gbc_lbl_dim.anchor = 17;
        gbc_lbl_dim.fill = 3;
        gbc_lbl_dim.insets = new Insets(0, 0, 5, 5);
        gbc_lbl_dim.gridx = 0;
        gbc_lbl_dim.gridy = 2;
        this.add((Component)lbl_dim, gbc_lbl_dim);
        this.dimensionLabel = new JLabel();
        this.dimensionLabel.setText("---");
        GridBagConstraints gbc_dimensionLabel = new GridBagConstraints();
        gbc_dimensionLabel.anchor = 17;
        gbc_dimensionLabel.gridwidth = 3;
        gbc_dimensionLabel.fill = 3;
        gbc_dimensionLabel.insets = new Insets(0, 0, 5, 0);
        gbc_dimensionLabel.gridx = 1;
        gbc_dimensionLabel.gridy = 2;
        this.add((Component)this.dimensionLabel, gbc_dimensionLabel);
        JLabel lbl_channel = new JLabel("Channel");
        lbl_channel.setToolTipText("Number of channel - data type");
        GridBagConstraints gbc_lbl_channel = new GridBagConstraints();
        gbc_lbl_channel.anchor = 17;
        gbc_lbl_channel.fill = 3;
        gbc_lbl_channel.insets = new Insets(0, 0, 5, 5);
        gbc_lbl_channel.gridx = 0;
        gbc_lbl_channel.gridy = 3;
        this.add((Component)lbl_channel, gbc_lbl_channel);
        this.channelLabel = new JLabel();
        this.channelLabel.setText("---");
        GridBagConstraints gbc_channelLabel = new GridBagConstraints();
        gbc_channelLabel.anchor = 17;
        gbc_channelLabel.gridwidth = 3;
        gbc_channelLabel.fill = 3;
        gbc_channelLabel.insets = new Insets(0, 0, 5, 0);
        gbc_channelLabel.gridx = 1;
        gbc_channelLabel.gridy = 3;
        this.add((Component)this.channelLabel, gbc_channelLabel);
        JLabel lbl_size = new JLabel("Size");
        lbl_size.setToolTipText("Size");
        GridBagConstraints gbc_lbl_size = new GridBagConstraints();
        gbc_lbl_size.anchor = 17;
        gbc_lbl_size.fill = 3;
        gbc_lbl_size.insets = new Insets(0, 0, 5, 5);
        gbc_lbl_size.gridx = 0;
        gbc_lbl_size.gridy = 4;
        this.add((Component)lbl_size, gbc_lbl_size);
        this.sizeLabel = new JLabel();
        this.sizeLabel.setText("---");
        GridBagConstraints gbc_sizeLabel = new GridBagConstraints();
        gbc_sizeLabel.anchor = 17;
        gbc_sizeLabel.gridwidth = 3;
        gbc_sizeLabel.fill = 3;
        gbc_sizeLabel.insets = new Insets(0, 0, 5, 0);
        gbc_sizeLabel.gridx = 1;
        gbc_sizeLabel.gridy = 4;
        this.add((Component)this.sizeLabel, gbc_sizeLabel);
        JLabel lbl_psx = new JLabel("Pixel size");
        lbl_psx.setToolTipText("Pixel size for X, Y, Z dimension");
        GridBagConstraints gbc_lbl_psx = new GridBagConstraints();
        gbc_lbl_psx.anchor = 17;
        gbc_lbl_psx.fill = 3;
        gbc_lbl_psx.insets = new Insets(0, 0, 5, 5);
        gbc_lbl_psx.gridx = 0;
        gbc_lbl_psx.gridy = 5;
        this.add((Component)lbl_psx, gbc_lbl_psx);
        this.resXLabel = new JLabel();
        this.resXLabel.setText("---");
        GridBagConstraints gbc_resXLabel = new GridBagConstraints();
        gbc_resXLabel.anchor = 17;
        gbc_resXLabel.fill = 3;
        gbc_resXLabel.insets = new Insets(0, 0, 5, 5);
        gbc_resXLabel.gridx = 1;
        gbc_resXLabel.gridy = 5;
        this.add((Component)this.resXLabel, gbc_resXLabel);
        this.resYLabel = new JLabel();
        this.resYLabel.setText("---");
        GridBagConstraints gbc_resYLabel = new GridBagConstraints();
        gbc_resYLabel.anchor = 17;
        gbc_resYLabel.fill = 3;
        gbc_resYLabel.insets = new Insets(0, 0, 5, 5);
        gbc_resYLabel.gridx = 2;
        gbc_resYLabel.gridy = 5;
        this.add((Component)this.resYLabel, gbc_resYLabel);
        this.resZLabel = new JLabel();
        this.resZLabel.setText("---");
        GridBagConstraints gbc_resZLabel = new GridBagConstraints();
        gbc_resZLabel.anchor = 17;
        gbc_resZLabel.fill = 3;
        gbc_resZLabel.insets = new Insets(0, 0, 5, 0);
        gbc_resZLabel.gridx = 3;
        gbc_resZLabel.gridy = 5;
        this.add((Component)this.resZLabel, gbc_resZLabel);
        JLabel lbl_time = new JLabel("Time interval");
        lbl_time.setToolTipText("Time Interval");
        GridBagConstraints gbc_lbl_time = new GridBagConstraints();
        gbc_lbl_time.anchor = 17;
        gbc_lbl_time.fill = 3;
        gbc_lbl_time.insets = new Insets(0, 0, 5, 5);
        gbc_lbl_time.gridx = 0;
        gbc_lbl_time.gridy = 6;
        this.add((Component)lbl_time, gbc_lbl_time);
        this.resTLabel = new JLabel();
        this.resTLabel.setText("---");
        GridBagConstraints gbc_resTLabel = new GridBagConstraints();
        gbc_resTLabel.anchor = 17;
        gbc_resTLabel.gridwidth = 3;
        gbc_resTLabel.fill = 3;
        gbc_resTLabel.insets = new Insets(0, 0, 5, 0);
        gbc_resTLabel.gridx = 1;
        gbc_resTLabel.gridy = 6;
        this.add((Component)this.resTLabel, gbc_resTLabel);
        this.editBtn = new IcyButton("Edit", new IcyIcon(ResourceUtil.ICON_DOCEDIT));
        this.editBtn.setToolTipText("Edit sequence properties");
        GridBagConstraints gbc_editBtn = new GridBagConstraints();
        gbc_editBtn.gridwidth = 2;
        gbc_editBtn.fill = 1;
        gbc_editBtn.insets = new Insets(0, 0, 0, 5);
        gbc_editBtn.gridx = 0;
        gbc_editBtn.gridy = 7;
        this.add((Component)this.editBtn, gbc_editBtn);
        this.detailBtn = new IcyButton("Show metadata", new IcyIcon(ResourceUtil.ICON_PROPERTIES));
        this.detailBtn.setText("Metadata");
        this.detailBtn.setToolTipText("Show all associated metadata informations");
        GridBagConstraints gbc_detailBtn = new GridBagConstraints();
        gbc_detailBtn.gridwidth = 2;
        gbc_detailBtn.fill = 1;
        gbc_detailBtn.gridx = 2;
        gbc_detailBtn.gridy = 7;
        this.add((Component)this.detailBtn, gbc_detailBtn);
    }

    public void updateInfos() {
        ThreadUtil.runSingle(this.infosRefresher);
    }

    public void updateInfosInternal(Sequence sequence) {
        if (sequence != null) {
            int sizeX = sequence.getSizeX();
            int sizeY = sequence.getSizeY();
            int sizeZ = sequence.getSizeZ();
            int sizeT = sequence.getSizeT();
            int sizeC = sequence.getSizeC();
            double pxSizeX = sequence.getPixelSizeX();
            double pxSizeY = sequence.getPixelSizeY();
            double pxSizeZ = sequence.getPixelSizeZ();
            String path = sequence.getFilename();
            this.nameField.setText(sequence.getName());
            if (StringUtil.isEmpty(path)) {
                this.pathLabel.setVisible(false);
                this.pathField.setVisible(false);
            } else {
                this.pathLabel.setVisible(true);
                this.pathField.setVisible(true);
                this.pathField.setText(path);
            }
            this.dimensionLabel.setText(sizeX + " x " + sizeY + " x " + sizeZ + " x " + sizeT);
            this.channelLabel.setText(sizeC + " - " + sequence.getDataType_().toLongString());
            this.sizeLabel.setText(UnitUtil.getBytesString((double)sizeX * (double)sizeY * (double)sizeZ * (double)sizeT * (double)sizeC * (double)sequence.getDataType_().getSize()));
            this.resXLabel.setText(UnitUtil.getBestUnitInMeters(pxSizeX, 2, UnitUtil.UnitPrefix.MICRO));
            this.resYLabel.setText(UnitUtil.getBestUnitInMeters(pxSizeY, 2, UnitUtil.UnitPrefix.MICRO));
            this.resZLabel.setText(UnitUtil.getBestUnitInMeters(pxSizeZ, 2, UnitUtil.UnitPrefix.MICRO));
            this.resTLabel.setText(UnitUtil.displayTimeAsStringWithUnits(sequence.getTimeInterval() * 1000.0, false));
            this.nameField.setToolTipText(sequence.getName());
            this.pathField.setToolTipText(path + "    (double click to see file location)");
            this.dimensionLabel.setToolTipText("Size X : " + sizeX + "   Size Y : " + sizeY + "   Size Z : " + sizeZ + "   Size T : " + sizeT);
            if (sizeC > 1) {
                this.channelLabel.setToolTipText(sizeC + " channels - " + (Object)((Object)sequence.getDataType_()));
            } else {
                this.channelLabel.setToolTipText(sizeC + " channel - " + (Object)((Object)sequence.getDataType_()));
            }
            this.sizeLabel.setToolTipText(this.sizeLabel.getText());
            this.resXLabel.setToolTipText("X pixel resolution: " + this.resXLabel.getText());
            this.resYLabel.setToolTipText("Y pixel resolution: " + this.resYLabel.getText());
            this.resZLabel.setToolTipText("Z pixel resolution: " + this.resZLabel.getText());
            this.resTLabel.setToolTipText("T time resolution: " + this.resTLabel.getText());
            this.editBtn.setEnabled(true);
            this.detailBtn.setEnabled(true);
        } else {
            this.pathLabel.setVisible(false);
            this.pathField.setVisible(false);
            this.nameField.setText("-");
            this.dimensionLabel.setText("-");
            this.channelLabel.setText("-");
            this.sizeLabel.setText("-");
            this.resXLabel.setText("-");
            this.resYLabel.setText("-");
            this.resZLabel.setText("-");
            this.resTLabel.setText("-");
            this.nameField.setToolTipText("");
            this.dimensionLabel.setToolTipText("");
            this.channelLabel.setToolTipText("");
            this.sizeLabel.setToolTipText("");
            this.resXLabel.setToolTipText("X pixel resolution");
            this.resYLabel.setToolTipText("Y pixel resolution");
            this.resZLabel.setToolTipText("Z pixel resolution");
            this.resTLabel.setToolTipText("T time resolution");
            this.editBtn.setEnabled(false);
            this.detailBtn.setEnabled(false);
        }
        this.revalidate();
    }

    @Override
    public void sequenceActivated(Sequence sequence) {
        this.updateInfos();
    }

    @Override
    public void sequenceDeactivated(Sequence sequence) {
    }

    @Override
    public void activeSequenceChanged(SequenceEvent event) {
        switch (event.getSourceType()) {
            case SEQUENCE_DATA: 
            case SEQUENCE_TYPE: 
            case SEQUENCE_META: {
                this.updateInfos();
            }
        }
    }
}

