/*
 * Decompiled with CFR 0.152.
 */
package icy.preferences;

import icy.common.Version;
import icy.math.MathUtil;
import icy.preferences.IcyPreferences;
import icy.preferences.XMLPreferences;
import icy.system.SystemUtil;

public class ApplicationPreferences {
    private static final String PREF_ID = "icy";
    public static final String ID_ICY_ID = "id";
    public static final String ID_OS = "os";
    public static final String ID_UPDATE_REPOSITORY_BASE = "updateRepositoryBase";
    public static final String ID_UPDATE_REPOSITORY_FILE = "updateRepositoryFile";
    public static final String ID_MAX_MEMORY = "maxMemory";
    public static final String ID_STACK_SIZE = "stackSize";
    public static final String ID_CACHE_MEMORY_PERCENT = "cacheMemoryPercent";
    public static final String ID_CACHE_PATH = "cacheMemoryPath";
    public static final String ID_EXTRA_VMPARAMS = "extraVMParams";
    public static final String ID_OS_EXTRA_VMPARAMS = "osExtraVMParams";
    public static final String ID_APP_FOLDER = "appFolder";
    public static final String ID_APP_PARAMS = "appParams";
    public static final String ID_VERSION = "version";
    public static final String ID_SINGLE_INSTANCE = "singleInstance";
    private static final String DEFAULT_UPDATE_REPOSITORY_BASE = "http://icy.bioimageanalysis.org/update/";
    private static final String DEFAULT_UPDATE_REPOSITORY_FILE = "update.php";
    private static XMLPreferences preferences;

    public static void load() {
        preferences = IcyPreferences.root().node(PREF_ID);
        ApplicationPreferences.setMaxMemoryMB(ApplicationPreferences.getMaxMemoryMB());
    }

    public static XMLPreferences getPreferences() {
        return preferences;
    }

    public static String getOs() {
        return preferences.get(ID_OS, "");
    }

    public static void setOs(String value) {
        preferences.put(ID_OS, value);
    }

    public static int getId() {
        return preferences.getInt(ID_ICY_ID, -1);
    }

    public static void setId(int value) {
        preferences.putInt(ID_ICY_ID, value);
    }

    public static String getUpdateRepositoryBase() {
        return preferences.get(ID_UPDATE_REPOSITORY_BASE, DEFAULT_UPDATE_REPOSITORY_BASE);
    }

    public static void setUpdateRepositoryBase(String value) {
        preferences.put(ID_UPDATE_REPOSITORY_BASE, value);
    }

    public static String getUpdateRepositoryFile() {
        return preferences.get(ID_UPDATE_REPOSITORY_FILE, DEFAULT_UPDATE_REPOSITORY_FILE);
    }

    public static void setUpdateRepositoryFile(String value) {
        preferences.put(ID_UPDATE_REPOSITORY_FILE, value);
    }

    static int memoryAlign(int memMB) {
        return (int)MathUtil.prevMultiple(memMB, 32.0);
    }

    static int checkMem(int memMB) {
        return Math.min(ApplicationPreferences.getMaxMemoryMBLimit(), ApplicationPreferences.memoryAlign(memMB));
    }

    public static int getMaxMemoryMB() {
        int result = preferences.getInt(ID_MAX_MEMORY, -1);
        if (result == -1) {
            result = ApplicationPreferences.getDefaultMemoryMB();
        }
        return ApplicationPreferences.checkMem(result);
    }

    public static int getDefaultMemoryMB() {
        long freeMemory = SystemUtil.getFreeMemory();
        long calculatedMaxMem = SystemUtil.getTotalMemory() / 2L;
        if (calculatedMaxMem > freeMemory) {
            calculatedMaxMem -= (calculatedMaxMem - freeMemory) / 2L;
        }
        return ApplicationPreferences.checkMem((int)(calculatedMaxMem / 1024000L));
    }

    public static int getMaxMemoryMBLimit() {
        int result = (int)(SystemUtil.getTotalMemory() / 1024000L);
        if (SystemUtil.is32bits() && result > 1024) {
            result = 1024;
        }
        return ApplicationPreferences.memoryAlign(result);
    }

    public static int getStackSizeKB() {
        return preferences.getInt(ID_STACK_SIZE, 2048);
    }

    public static int getCacheMemoryPercent() {
        return preferences.getInt(ID_CACHE_MEMORY_PERCENT, 40);
    }

    public static int getCacheMemoryMB() {
        return (int)(SystemUtil.getJavaMaxMemory() / 0x100000L * (long)ApplicationPreferences.getCacheMemoryPercent() / 100L);
    }

    public static String getCachePath() {
        return preferences.get(ID_CACHE_PATH, SystemUtil.getTempDirectory());
    }

    public static String getExtraVMParams() {
        return preferences.get(ID_EXTRA_VMPARAMS, "-XX:+UseG1GC -XX:MaxGCPauseMillis=100 -XX:MaxPermSize=128M");
    }

    public static String getOSExtraVMParams() {
        String os = SystemUtil.getOSNameId();
        if (os.equals("win")) {
            return preferences.get("osExtraVMParamswin", "");
        }
        if (os.equals("mac")) {
            return preferences.get("osExtraVMParamsmac", "-Xdock:name=Icy");
        }
        if (os.equals("unix")) {
            return preferences.get("osExtraVMParamsunix", "");
        }
        return "";
    }

    public static String getAppFolder() {
        return preferences.get(ID_APP_FOLDER, "");
    }

    public static String getAppParams() {
        return preferences.get(ID_APP_PARAMS, "");
    }

    public static Version getVersion() {
        return new Version(preferences.get(ID_VERSION, "1.0.0.0"));
    }

    public static void setMaxMemoryMB(int value) {
        preferences.putInt(ID_MAX_MEMORY, Math.min(ApplicationPreferences.getMaxMemoryMBLimit(), value));
    }

    public static void setStackSizeKB(int value) {
        preferences.putInt(ID_STACK_SIZE, value);
    }

    public static void setCacheMemoryPercent(int value) {
        preferences.putInt(ID_CACHE_MEMORY_PERCENT, Math.min(80, Math.max(10, value)));
    }

    public static void setCachePath(String value) {
        preferences.put(ID_CACHE_PATH, value);
    }

    public static void setExtraVMParams(String value) {
        preferences.put(ID_EXTRA_VMPARAMS, value);
    }

    public static void setOSExtraVMParams(String value) {
        preferences.put(ID_OS_EXTRA_VMPARAMS + SystemUtil.getOSNameId(), value);
    }

    public static void setAppFolder(String value) {
        preferences.put(ID_APP_FOLDER, value);
    }

    public static void setAppParams(String value) {
        preferences.put(ID_APP_PARAMS, value);
    }

    public static void setVersion(Version value) {
        preferences.put(ID_VERSION, value.toString());
    }
}

