/*
 * Decompiled with CFR 0.152.
 */
package icy.roi;

import icy.roi.ROI2D;
import icy.type.TypeUtil;
import icy.type.collection.array.DynamicArray;
import icy.type.point.Point2DUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class BooleanMask2D
implements Cloneable {
    public Rectangle bounds;
    public boolean[] mask;

    private static int findStartPoint(int startOffset, boolean[] mask, boolean[] visitedMask) {
        for (int i = startOffset; i < mask.length; ++i) {
            if (!mask[i] || visitedMask[i]) continue;
            return i;
        }
        return -1;
    }

    private static List<Point> insertPoints(List<Point> result, List<Point> source) {
        if (result.isEmpty()) {
            result.addAll(source);
            return result;
        }
        if (source.isEmpty()) {
            return result;
        }
        Point firstPointSource = source.get(0);
        Point lastPointSource = source.get(source.size() - 1);
        int len = result.size();
        for (int i = 0; i < len; ++i) {
            Point p = result.get(i);
            if (Point2DUtil.areConnected(p, firstPointSource)) {
                ArrayList<Point> newResult = new ArrayList<Point>(result.subList(0, i + 1));
                newResult.addAll(source);
                if (i + 1 < len) {
                    newResult.addAll(new ArrayList<Point>(result.subList(i + 1, len)));
                }
                return newResult;
            }
            if (!Point2DUtil.areConnected(p, lastPointSource)) continue;
            ArrayList<Point> newResult = new ArrayList<Point>(result.subList(0, i + 1));
            Collections.reverse(source);
            newResult.addAll(source);
            if (i + 1 < len) {
                newResult.addAll(new ArrayList<Point>(result.subList(i + 1, len)));
            }
            return newResult;
        }
        return null;
    }

    private static List<Point> connect(List<Point> result, List<Point> source) {
        if (result.isEmpty()) {
            result.addAll(source);
            return result;
        }
        if (source.isEmpty()) {
            return result;
        }
        Point2D firstPointResult = result.get(0);
        Point2D lastPointResult = result.get(result.size() - 1);
        Point2D firstPointSource = source.get(0);
        Point2D lastPointSource = source.get(source.size() - 1);
        if (Point2DUtil.areConnected(firstPointSource, lastPointResult)) {
            result.addAll(source);
            return result;
        }
        if (Point2DUtil.areConnected(firstPointSource, firstPointResult)) {
            Collections.reverse(source);
            source.addAll(result);
            return source;
        }
        if (Point2DUtil.areConnected(lastPointSource, firstPointResult)) {
            source.addAll(result);
            return source;
        }
        if (Point2DUtil.areConnected(lastPointSource, lastPointResult)) {
            Collections.reverse(source);
            result.addAll(source);
            return result;
        }
        return null;
    }

    public static List<Point> getContourPoints(Rectangle bounds, boolean[] mask) {
        if (bounds.isEmpty()) {
            return new ArrayList<Point>(1);
        }
        ArrayList<Point> points = new ArrayList<Point>(mask.length / 16);
        int h = bounds.height;
        int w = bounds.width;
        int minx = bounds.x;
        int miny = bounds.y;
        int maxx = minx + (w - 1);
        int maxy = miny + (h - 1);
        boolean top = false;
        boolean bottom = false;
        boolean left = false;
        boolean right = false;
        int offset = 0;
        if (w == 1 && h == 1) {
            if (mask[0]) {
                points.add(new Point(minx, miny));
            }
        } else if (w == 1) {
            top = false;
            boolean current = mask[offset];
            bottom = mask[++offset];
            if (!(!current || top && bottom)) {
                points.add(new Point(minx, miny));
            }
            for (int y = miny + 1; y < maxy; ++y) {
                top = current;
                current = bottom;
                bottom = mask[++offset];
                if (!current || top && bottom) continue;
                points.add(new Point(minx, y));
            }
            top = current;
            current = bottom;
            bottom = false;
            if (!(!current || top && bottom)) {
                points.add(new Point(minx, maxy));
            }
        } else if (h == 1) {
            left = false;
            boolean current = mask[offset];
            right = mask[++offset];
            if (!(!current || left && right)) {
                points.add(new Point(minx, miny));
            }
            for (int x = minx + 1; x < maxx; ++x) {
                left = current;
                current = right;
                right = mask[++offset];
                if (!current || left && right) continue;
                points.add(new Point(x, miny));
            }
            left = current;
            current = right;
            right = false;
            if (!(!current || left && right)) {
                points.add(new Point(maxx, miny));
            }
        } else {
            int x;
            top = false;
            left = false;
            boolean current = mask[offset];
            bottom = mask[offset + w];
            right = mask[++offset];
            if (!(!current || top && left && right && bottom)) {
                points.add(new Point(minx, miny));
            }
            for (x = minx + 1; x < maxx; ++x) {
                left = current;
                current = right;
                bottom = mask[offset + w];
                right = mask[++offset];
                if (!current || top && left && right && bottom) continue;
                points.add(new Point(x, miny));
            }
            left = current;
            current = right;
            bottom = mask[offset + w];
            right = false;
            ++offset;
            if (!(!current || top && left && right && bottom)) {
                points.add(new Point(maxx, miny));
            }
            for (int y = miny + 1; y < maxy; ++y) {
                left = false;
                current = mask[offset];
                top = mask[offset - w];
                bottom = mask[offset + w];
                right = mask[++offset];
                if (!(!current || top && left && right && bottom)) {
                    points.add(new Point(minx, y));
                }
                for (int x2 = minx + 1; x2 < maxx; ++x2) {
                    left = current;
                    current = right;
                    top = mask[offset - w];
                    bottom = mask[offset + w];
                    right = mask[++offset];
                    if (!current || top && left && right && bottom) continue;
                    points.add(new Point(x2, y));
                }
                left = current;
                current = right;
                top = mask[offset - w];
                bottom = mask[offset + w];
                right = false;
                ++offset;
                if (!current || top && left && right && bottom) continue;
                points.add(new Point(maxx, y));
            }
            left = false;
            current = mask[offset];
            top = mask[offset - w];
            bottom = false;
            right = mask[++offset];
            if (!(!current || top && left && right && bottom)) {
                points.add(new Point(minx, maxy));
            }
            for (x = minx + 1; x < maxx; ++x) {
                left = current;
                current = right;
                top = mask[offset - w];
                right = mask[++offset];
                if (!current || top && left && right && bottom) continue;
                points.add(new Point(x, maxy));
            }
            left = current;
            current = right;
            top = mask[offset - w];
            right = false;
            if (!(!current || top && left && right && bottom)) {
                points.add(new Point(maxx, maxy));
            }
        }
        return points;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BooleanMask2D upscale(BooleanMask2D mask) {
        boolean[] srcMask;
        Rectangle srcBounds;
        BooleanMask2D booleanMask2D = mask;
        synchronized (booleanMask2D) {
            srcBounds = mask.bounds;
            srcMask = mask.mask;
        }
        int srcW = srcBounds.width;
        int srcH = srcBounds.height;
        boolean[] resMask = new boolean[srcW * srcH * 2 * 2];
        int offSrc = 0;
        int offRes = 0;
        for (int y = 0; y < srcH; ++y) {
            for (int x = 0; x < srcW; ++x) {
                boolean v;
                resMask[offRes + 0] = v = srcMask[offSrc++];
                resMask[offRes + 1] = v;
                resMask[offRes + srcW * 2 + 0] = v;
                resMask[offRes + srcW * 2 + 1] = v;
                offRes += 2;
            }
            offRes += srcW * 2;
        }
        return new BooleanMask2D(new Rectangle(srcBounds.x * 2, srcBounds.y * 2, srcW * 2, srcH * 2), resMask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getDownscaleValues(BooleanMask2D mask) {
        boolean[] srcMask;
        Rectangle srcBounds;
        BooleanMask2D booleanMask2D = mask;
        synchronized (booleanMask2D) {
            srcBounds = mask.bounds;
            srcMask = mask.mask;
        }
        int resW = srcBounds.width / 2;
        int resH = srcBounds.height / 2;
        byte[] resMask = new byte[resW * resH];
        int offSrc = 0;
        int offRes = 0;
        for (int y = 0; y < resH; ++y) {
            for (int x = 0; x < resW; ++x) {
                int v = 0;
                if (srcMask[offSrc + 0]) {
                    v = (byte)(v + 1);
                }
                if (srcMask[offSrc + 1]) {
                    v = (byte)(v + 1);
                }
                if (srcMask[offSrc + resW * 2 + 0]) {
                    v = (byte)(v + 1);
                }
                if (srcMask[offSrc + resW * 2 + 1]) {
                    v = (byte)(v + 1);
                }
                resMask[offRes++] = v;
                offSrc += 2;
            }
            offSrc += resW * 2;
            if ((srcBounds.width & 1) != 1) continue;
            offSrc += 2;
        }
        return resMask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BooleanMask2D downscale(BooleanMask2D mask, int nbPointForTrue) {
        Rectangle srcBounds;
        BooleanMask2D booleanMask2D = mask;
        synchronized (booleanMask2D) {
            srcBounds = mask.bounds;
        }
        int validPt = Math.min(Math.max(nbPointForTrue, 1), 4);
        int resW = srcBounds.width / 2;
        int resH = srcBounds.height / 2;
        byte[] valueMask = BooleanMask2D.getDownscaleValues(mask);
        boolean[] resMask = new boolean[resW * resH];
        for (int i = 0; i < valueMask.length; ++i) {
            resMask[i] = valueMask[i] >= validPt;
        }
        return new BooleanMask2D(new Rectangle(srcBounds.x / 2, srcBounds.y / 2, resW, resH), resMask);
    }

    public static BooleanMask2D downscale(BooleanMask2D mask) {
        return BooleanMask2D.downscale(mask, 2);
    }

    public static BooleanMask2D getUnion(List<BooleanMask2D> masks) {
        BooleanMask2D result = null;
        for (BooleanMask2D bm : masks) {
            if (result == null) {
                result = new BooleanMask2D(bm.bounds, bm.mask);
                continue;
            }
            result = BooleanMask2D.getUnion(result, bm);
        }
        if (result == null) {
            result = new BooleanMask2D();
        }
        return result;
    }

    public static BooleanMask2D getUnion(BooleanMask2D mask1, BooleanMask2D mask2) {
        if (mask1 == null && mask2 == null) {
            return new BooleanMask2D();
        }
        if (mask1 == null || mask1.isEmpty()) {
            return (BooleanMask2D)mask2.clone();
        }
        if (mask2 == null || mask2.isEmpty()) {
            return (BooleanMask2D)mask1.clone();
        }
        return BooleanMask2D.getUnion(mask1.bounds, mask1.mask, mask2.bounds, mask2.mask);
    }

    public static BooleanMask2D getUnion(Rectangle bounds1, boolean[] mask1, Rectangle bounds2, boolean[] mask2) {
        Rectangle union = bounds1.union(bounds2);
        if (!union.isEmpty()) {
            int x;
            int y;
            boolean[] mask = new boolean[union.width * union.height];
            int offDst = (bounds1.y - union.y) * union.width + (bounds1.x - union.x);
            int offSrc = 0;
            for (y = 0; y < bounds1.height; ++y) {
                for (x = 0; x < bounds1.width; ++x) {
                    int n = offDst + x;
                    mask[n] = mask[n] | mask1[offSrc++];
                }
                offDst += union.width;
            }
            offDst = (bounds2.y - union.y) * union.width + (bounds2.x - union.x);
            offSrc = 0;
            for (y = 0; y < bounds2.height; ++y) {
                for (x = 0; x < bounds2.width; ++x) {
                    int n = offDst + x;
                    mask[n] = mask[n] | mask2[offSrc++];
                }
                offDst += union.width;
            }
            return new BooleanMask2D(union, mask);
        }
        return new BooleanMask2D();
    }

    public static BooleanMask2D getIntersection(List<BooleanMask2D> masks) {
        BooleanMask2D result = null;
        for (BooleanMask2D bm : masks) {
            if (result == null) {
                result = new BooleanMask2D(bm.bounds, bm.mask);
                continue;
            }
            result = BooleanMask2D.getIntersection(result, bm);
        }
        if (result == null) {
            result = new BooleanMask2D();
        }
        return result;
    }

    public static BooleanMask2D getIntersection(BooleanMask2D mask1, BooleanMask2D mask2) {
        if (mask1 == null || mask2 == null) {
            return new BooleanMask2D();
        }
        return BooleanMask2D.getIntersection(mask1.bounds, mask1.mask, mask2.bounds, mask2.mask);
    }

    public static BooleanMask2D getIntersection(Rectangle bounds1, boolean[] mask1, Rectangle bounds2, boolean[] mask2) {
        Rectangle intersect = bounds1.intersection(bounds2);
        if (!intersect.isEmpty()) {
            boolean[] mask = new boolean[intersect.width * intersect.height];
            int off1 = (intersect.y - bounds1.y) * bounds1.width + (intersect.x - bounds1.x);
            int off2 = (intersect.y - bounds2.y) * bounds2.width + (intersect.x - bounds2.x);
            int off = 0;
            for (int y = 0; y < intersect.height; ++y) {
                for (int x = 0; x < intersect.width; ++x) {
                    mask[off++] = mask1[off1 + x] & mask2[off2 + x];
                }
                off1 += bounds1.width;
                off2 += bounds2.width;
            }
            return new BooleanMask2D(intersect, mask);
        }
        return new BooleanMask2D();
    }

    public static BooleanMask2D getExclusiveUnion(List<BooleanMask2D> masks) {
        BooleanMask2D result = null;
        for (BooleanMask2D bm : masks) {
            if (result == null) {
                result = new BooleanMask2D(bm.bounds, bm.mask);
                continue;
            }
            result = BooleanMask2D.getExclusiveUnion(result, bm);
        }
        if (result == null) {
            result = new BooleanMask2D();
        }
        return result;
    }

    public static BooleanMask2D getExclusiveUnion(BooleanMask2D mask1, BooleanMask2D mask2) {
        if (mask1 == null && mask2 == null) {
            return new BooleanMask2D();
        }
        if (mask1 == null || mask1.isEmpty()) {
            return (BooleanMask2D)mask2.clone();
        }
        if (mask2 == null || mask2.isEmpty()) {
            return (BooleanMask2D)mask1.clone();
        }
        return BooleanMask2D.getExclusiveUnion(mask1.bounds, mask1.mask, mask2.bounds, mask2.mask);
    }

    public static BooleanMask2D getExclusiveUnion(Rectangle bounds1, boolean[] mask1, Rectangle bounds2, boolean[] mask2) {
        Rectangle union = bounds1.union(bounds2);
        if (!union.isEmpty()) {
            int x;
            int y;
            boolean[] mask = new boolean[union.width * union.height];
            int offDst = (bounds1.y - union.y) * union.width + (bounds1.x - union.x);
            int offSrc = 0;
            for (y = 0; y < bounds1.height; ++y) {
                for (x = 0; x < bounds1.width; ++x) {
                    int n = offDst + x;
                    mask[n] = mask[n] ^ mask1[offSrc++];
                }
                offDst += union.width;
            }
            offDst = (bounds2.y - union.y) * union.width + (bounds2.x - union.x);
            offSrc = 0;
            for (y = 0; y < bounds2.height; ++y) {
                for (x = 0; x < bounds2.width; ++x) {
                    int n = offDst + x;
                    mask[n] = mask[n] ^ mask2[offSrc++];
                }
                offDst += union.width;
            }
            BooleanMask2D result = new BooleanMask2D(union, mask);
            result.optimizeBounds();
            return result;
        }
        return new BooleanMask2D();
    }

    public static BooleanMask2D getSubtraction(BooleanMask2D mask1, BooleanMask2D mask2) {
        if (mask1 == null) {
            return new BooleanMask2D();
        }
        if (mask2 == null) {
            return (BooleanMask2D)mask1.clone();
        }
        return BooleanMask2D.getSubtraction(mask1.bounds, mask1.mask, mask2.bounds, mask2.mask);
    }

    public static BooleanMask2D getSubtraction(Rectangle bounds1, boolean[] mask1, Rectangle bounds2, boolean[] mask2) {
        boolean[] mask = (boolean[])mask1.clone();
        Rectangle subtract = new Rectangle(bounds1);
        BooleanMask2D result = new BooleanMask2D(subtract, mask);
        Rectangle intersection = bounds1.intersection(bounds2);
        if (!intersection.isEmpty()) {
            int offDst = (intersection.y - subtract.y) * subtract.width + (intersection.x - subtract.x);
            int offSrc = (intersection.y - bounds2.y) * bounds2.width + (intersection.x - bounds2.x);
            for (int y = 0; y < intersection.height; ++y) {
                for (int x = 0; x < intersection.width; ++x) {
                    int n = offDst + x;
                    mask[n] = mask[n] & !mask2[offSrc + x];
                }
                offDst += subtract.width;
                offSrc += bounds2.width;
            }
            result.optimizeBounds();
        }
        return result;
    }

    @Deprecated
    public static BooleanMask2D getUnionBooleanMask(List<BooleanMask2D> masks) {
        return BooleanMask2D.getUnion(masks);
    }

    @Deprecated
    public static BooleanMask2D getUnionBooleanMask(ROI2D[] rois) {
        ArrayList<BooleanMask2D> masks = new ArrayList<BooleanMask2D>();
        for (ROI2D roi : rois) {
            masks.add(roi.getBooleanMask(true));
        }
        return BooleanMask2D.getUnionBooleanMask(masks);
    }

    @Deprecated
    public static BooleanMask2D getUnionBooleanMask(ArrayList<ROI2D> rois) {
        return BooleanMask2D.getUnionBooleanMask(rois.toArray(new ROI2D[rois.size()]));
    }

    @Deprecated
    public static BooleanMask2D getUnionBooleanMask(BooleanMask2D mask1, BooleanMask2D mask2) {
        return BooleanMask2D.getUnion(mask1, mask2);
    }

    @Deprecated
    public static BooleanMask2D getUnionBooleanMask(Rectangle bounds1, boolean[] mask1, Rectangle bounds2, boolean[] mask2) {
        return BooleanMask2D.getUnion(bounds1, mask1, bounds2, mask2);
    }

    @Deprecated
    public static BooleanMask2D getIntersectionBooleanMask(List<BooleanMask2D> masks) {
        return BooleanMask2D.getIntersection(masks);
    }

    @Deprecated
    public static BooleanMask2D getIntersectionBooleanMask(BooleanMask2D mask1, BooleanMask2D mask2) {
        return BooleanMask2D.getIntersection(mask1, mask2);
    }

    @Deprecated
    public static BooleanMask2D getIntersectionBooleanMask(Rectangle bounds1, boolean[] mask1, Rectangle bounds2, boolean[] mask2) {
        return BooleanMask2D.getIntersection(bounds1, mask1, bounds2, mask2);
    }

    @Deprecated
    public static BooleanMask2D getIntersectBooleanMask(ROI2D[] rois) {
        ArrayList<BooleanMask2D> masks = new ArrayList<BooleanMask2D>();
        for (ROI2D roi : rois) {
            masks.add(roi.getBooleanMask(true));
        }
        return BooleanMask2D.getIntersectionBooleanMask(masks);
    }

    @Deprecated
    public static BooleanMask2D getIntersectBooleanMask(ArrayList<ROI2D> rois) {
        return BooleanMask2D.getIntersectBooleanMask(rois.toArray(new ROI2D[rois.size()]));
    }

    @Deprecated
    public static BooleanMask2D getIntersectBooleanMask(BooleanMask2D mask1, BooleanMask2D mask2) {
        return BooleanMask2D.getIntersectionBooleanMask(mask1.bounds, mask1.mask, mask2.bounds, mask2.mask);
    }

    @Deprecated
    public static BooleanMask2D getIntersectBooleanMask(Rectangle bounds1, boolean[] mask1, Rectangle bounds2, boolean[] mask2) {
        return BooleanMask2D.getIntersectionBooleanMask(bounds1, mask1, bounds2, mask2);
    }

    @Deprecated
    public static BooleanMask2D getExclusiveUnionBooleanMask(List<BooleanMask2D> masks) {
        return BooleanMask2D.getExclusiveUnion(masks);
    }

    @Deprecated
    public static BooleanMask2D getExclusiveUnionBooleanMask(ROI2D[] rois) {
        ArrayList<BooleanMask2D> masks = new ArrayList<BooleanMask2D>();
        for (ROI2D roi : rois) {
            masks.add(roi.getBooleanMask(true));
        }
        return BooleanMask2D.getExclusiveUnion(masks);
    }

    @Deprecated
    public static BooleanMask2D getExclusiveUnionBooleanMask(ArrayList<ROI2D> rois) {
        return BooleanMask2D.getExclusiveUnionBooleanMask(rois.toArray(new ROI2D[rois.size()]));
    }

    @Deprecated
    public static BooleanMask2D getExclusiveUnionBooleanMask(BooleanMask2D mask1, BooleanMask2D mask2) {
        return BooleanMask2D.getExclusiveUnion(mask1, mask2);
    }

    @Deprecated
    public static BooleanMask2D getExclusiveUnionBooleanMask(Rectangle bounds1, boolean[] mask1, Rectangle bounds2, boolean[] mask2) {
        return BooleanMask2D.getExclusiveUnion(bounds1, mask1, bounds2, mask2);
    }

    @Deprecated
    public static BooleanMask2D getXorBooleanMask(ROI2D[] rois) {
        return BooleanMask2D.getExclusiveUnionBooleanMask(rois);
    }

    @Deprecated
    public static BooleanMask2D getXorBooleanMask(ArrayList<ROI2D> rois) {
        return BooleanMask2D.getExclusiveUnionBooleanMask(rois);
    }

    @Deprecated
    public static BooleanMask2D getXorBooleanMask(BooleanMask2D mask1, BooleanMask2D mask2) {
        return BooleanMask2D.getExclusiveUnionBooleanMask(mask1, mask2);
    }

    @Deprecated
    public static BooleanMask2D getXorBooleanMask(Rectangle bounds1, boolean[] mask1, Rectangle bounds2, boolean[] mask2) {
        return BooleanMask2D.getExclusiveUnionBooleanMask(bounds1, mask1, bounds2, mask2);
    }

    public BooleanMask2D() {
        this(new Rectangle(), new boolean[0]);
    }

    public BooleanMask2D(Rectangle bounds, boolean[] mask) {
        this.bounds = bounds;
        this.mask = mask;
    }

    public BooleanMask2D(Point[] points) {
        if (points == null || points.length == 0) {
            this.bounds = new Rectangle();
            this.mask = new boolean[0];
        } else {
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxY = Integer.MIN_VALUE;
            for (Point pt : points) {
                int x = pt.x;
                int y = pt.y;
                if (x < minX) {
                    minX = x;
                }
                if (x > maxX) {
                    maxX = x;
                }
                if (y < minY) {
                    minY = y;
                }
                if (y <= maxY) continue;
                maxY = y;
            }
            this.bounds = new Rectangle(minX, minY, maxX - minX + 1, maxY - minY + 1);
            this.mask = new boolean[this.bounds.width * this.bounds.height];
            for (Point pt : points) {
                this.mask[(pt.y - minY) * this.bounds.width + (pt.x - minX)] = true;
            }
        }
    }

    public BooleanMask2D(int[] points) {
        if (points == null || points.length == 0) {
            this.bounds = new Rectangle();
            this.mask = new boolean[0];
        } else {
            int y;
            int x;
            int i;
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxY = Integer.MIN_VALUE;
            for (i = 0; i < points.length; i += 2) {
                x = points[i + 0];
                y = points[i + 1];
                if (x < minX) {
                    minX = x;
                }
                if (x > maxX) {
                    maxX = x;
                }
                if (y < minY) {
                    minY = y;
                }
                if (y <= maxY) continue;
                maxY = y;
            }
            this.bounds = new Rectangle(minX, minY, maxX - minX + 1, maxY - minY + 1);
            this.mask = new boolean[this.bounds.width * this.bounds.height];
            for (i = 0; i < points.length; i += 2) {
                x = points[i + 0];
                y = points[i + 1];
                this.mask[(y - minY) * this.bounds.width + (x - minX)] = true;
            }
        }
    }

    public boolean isEmpty() {
        return this.bounds.isEmpty();
    }

    public boolean contains(int x, int y) {
        if (this.bounds.contains(x, y)) {
            return this.mask[x - this.bounds.x + (y - this.bounds.y) * this.bounds.width];
        }
        return false;
    }

    public boolean contains(BooleanMask2D booleanMask) {
        return this.contains(booleanMask.bounds, booleanMask.mask);
    }

    public boolean contains(Rectangle rect, boolean[] bmask) {
        Rectangle intersect = this.bounds.intersection(rect);
        if (intersect.equals(rect)) {
            int off1 = (intersect.y - this.bounds.y) * this.bounds.width + (intersect.x - this.bounds.x);
            int off2 = (intersect.y - rect.y) * rect.width + (intersect.x - rect.x);
            for (int y = 0; y < intersect.height; ++y) {
                for (int x = 0; x < intersect.width; ++x) {
                    if (!bmask[off2 + x] || this.mask[off1 + x]) continue;
                    return false;
                }
                off1 += this.bounds.width;
                off2 += rect.width;
            }
            return true;
        }
        return false;
    }

    public boolean intersects(BooleanMask2D booleanMask) {
        return this.intersects(booleanMask.bounds, booleanMask.mask);
    }

    public boolean intersects(Rectangle rect, boolean[] bmask) {
        Rectangle intersect = this.bounds.intersection(rect);
        if (!intersect.isEmpty()) {
            int off1 = (intersect.y - this.bounds.y) * this.bounds.width + (intersect.x - this.bounds.x);
            int off2 = (intersect.y - rect.y) * rect.width + (intersect.x - rect.x);
            for (int y = 0; y < intersect.height; ++y) {
                for (int x = 0; x < intersect.width; ++x) {
                    if (!this.mask[off1 + x] || !bmask[off2 + x]) continue;
                    return true;
                }
                off1 += this.bounds.width;
                off2 += rect.width;
            }
        }
        return false;
    }

    public int getNumberOfPoints() {
        int result = 0;
        int i = 0;
        while (i < this.mask.length) {
            if (!this.mask[i++]) continue;
            ++result;
        }
        return result;
    }

    public Point[] getPoints() {
        return TypeUtil.toPoint(this.getPointsAsIntArray());
    }

    public int[] getPointsAsIntArray() {
        if (this.bounds.isEmpty()) {
            return new int[0];
        }
        int[] points = new int[this.mask.length * 2];
        int maxx = this.bounds.x + this.bounds.width;
        int maxy = this.bounds.y + this.bounds.height;
        int pt = 0;
        int off = 0;
        for (int y = this.bounds.y; y < maxy; ++y) {
            for (int x = this.bounds.x; x < maxx; ++x) {
                if (!this.mask[off++]) continue;
                points[pt++] = x;
                points[pt++] = y;
            }
        }
        int[] result = new int[pt];
        System.arraycopy(points, 0, result, 0, pt);
        return result;
    }

    protected List<Component> getComponentsPointsInternal() {
        ArrayList<Object> components = new ArrayList<Object>();
        int w = this.bounds.width;
        int minx = this.bounds.x;
        int miny = this.bounds.y;
        Object[] line0 = new Component[w + 2];
        Object[] line1 = new Component[w + 2];
        Arrays.fill(line0, null);
        Arrays.fill(line1, null);
        Object[] prevLine = line0;
        Object[] currLine = line1;
        int offset = 0;
        for (int y = 0; y < this.bounds.height; ++y) {
            Object topleft = null;
            Object left = null;
            for (int x = 0; x < w; ++x) {
                Object top = prevLine[x + 1];
                if (this.mask[offset++]) {
                    if (topleft != null) {
                        if (left != null && left != topleft) {
                            ((Component)topleft).addComponent((Component)left);
                        }
                        left = topleft;
                    } else if (top != null) {
                        if (left != null && left != top) {
                            ((Component)top).addComponent((Component)left);
                        }
                        left = top;
                    } else if (left == null) {
                        left = new Component();
                        components.add(left);
                    }
                    ((Component)left).addPoint(x + minx, y + miny);
                } else {
                    if (left != null && top != null && left != top) {
                        ((Component)top).addComponent((Component)left);
                    }
                    left = null;
                }
                topleft = top;
                currLine[x + 1] = left;
            }
            Object[] pl = prevLine;
            prevLine = currLine;
            currLine = pl;
        }
        ArrayList<Component> result = new ArrayList<Component>();
        for (Component component : components) {
            if (!component.isRoot()) continue;
            result.add(component);
        }
        return result;
    }

    public Point[][] getComponentsPoints(boolean sorted) {
        if (this.bounds.isEmpty()) {
            return new Point[0][0];
        }
        Comparator<Point> pointComparator = sorted ? new Comparator<Point>(){

            @Override
            public int compare(Point p1, Point p2) {
                if (p1.y < p2.y) {
                    return -1;
                }
                if (p1.y > p2.y) {
                    return 1;
                }
                return 0;
            }
        } : null;
        int[][] cPoints = this.getComponentsPointsAsIntArray();
        Point[][] cResult = new Point[cPoints.length][];
        for (int i = 0; i < cPoints.length; ++i) {
            Point[] result = TypeUtil.toPoint(cPoints[i]);
            if (pointComparator != null) {
                Arrays.sort(result, pointComparator);
            }
            cResult[i] = result;
        }
        return cResult;
    }

    public int[][] getComponentsPointsAsIntArray() {
        if (this.bounds.isEmpty()) {
            return new int[0][0];
        }
        List<Component> components = this.getComponentsPointsInternal();
        int[][] result = new int[components.size()][];
        for (int i = 0; i < result.length; ++i) {
            result[i] = components.get(i).getAllPoints();
        }
        return result;
    }

    public BooleanMask2D[] getComponents() {
        if (this.bounds.isEmpty()) {
            return new BooleanMask2D[0];
        }
        int[][] componentsPoints = this.getComponentsPointsAsIntArray();
        ArrayList<BooleanMask2D> result = new ArrayList<BooleanMask2D>();
        for (int[] componentPoints : componentsPoints) {
            result.add(new BooleanMask2D(componentPoints));
        }
        return result.toArray(new BooleanMask2D[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Point> getConnectedContourPoints() {
        Rectangle contourBounds;
        boolean[] contourMask;
        int[] intArrayPoints = this.getContourPointsAsIntArray();
        ArrayList allPoints = new ArrayList();
        if (intArrayPoints.length == 0) {
            return new ArrayList<Point>(0);
        }
        BooleanMask2D booleanMask2D = this;
        synchronized (booleanMask2D) {
            contourMask = new boolean[this.mask.length];
            contourBounds = this.bounds;
        }
        int minx = contourBounds.x;
        int miny = contourBounds.y;
        int w = contourBounds.width;
        for (int i = 0; i < intArrayPoints.length; i += 2) {
            contourMask[intArrayPoints[i + 0] - minx + (intArrayPoints[i + 1] - miny) * w] = true;
        }
        int maxx = minx + (w - 1);
        int maxy = miny + (contourBounds.height - 1);
        boolean[] visitedMask = new boolean[contourMask.length];
        int startOffset = BooleanMask2D.findStartPoint(0, contourMask, visitedMask);
        while (startOffset != -1) {
            ArrayList<Point> points = new ArrayList<Point>(intArrayPoints.length / 2);
            int offset = startOffset;
            int x = offset % w + minx;
            int y = offset / w + miny;
            visitedMask[offset] = true;
            points.add(new Point(x, y));
            int scan = 0;
            int remain = 8;
            while (remain-- > 0) {
                switch (scan & 7) {
                    case 0: {
                        int tmpOff;
                        if (x >= maxx || !contourMask[tmpOff = offset + 1]) break;
                        if (visitedMask[tmpOff]) {
                            remain = 0;
                            break;
                        }
                        offset = tmpOff;
                        visitedMask[offset] = true;
                        points.add(new Point(++x, y));
                        scan = 6;
                        remain = 8;
                        break;
                    }
                    case 1: {
                        int tmpOff;
                        if (x >= maxx || y >= maxy || !contourMask[tmpOff = offset + w + 1]) break;
                        if (visitedMask[tmpOff]) {
                            remain = 0;
                            break;
                        }
                        offset = tmpOff;
                        visitedMask[offset] = true;
                        points.add(new Point(++x, ++y));
                        scan = 6;
                        remain = 8;
                        break;
                    }
                    case 2: {
                        int tmpOff;
                        if (y >= maxy || !contourMask[tmpOff = offset + w]) break;
                        if (visitedMask[tmpOff]) {
                            remain = 0;
                            break;
                        }
                        offset = tmpOff;
                        visitedMask[offset] = true;
                        points.add(new Point(x, ++y));
                        scan = 0;
                        remain = 8;
                        break;
                    }
                    case 3: {
                        int tmpOff;
                        if (x <= minx || y >= maxy || !contourMask[tmpOff = offset + w - 1]) break;
                        if (visitedMask[tmpOff]) {
                            remain = 0;
                            break;
                        }
                        offset = tmpOff;
                        visitedMask[offset] = true;
                        points.add(new Point(--x, ++y));
                        scan = 0;
                        remain = 8;
                        break;
                    }
                    case 4: {
                        int tmpOff;
                        if (x <= minx || !contourMask[tmpOff = offset - 1]) break;
                        if (visitedMask[tmpOff]) {
                            remain = 0;
                            break;
                        }
                        offset = tmpOff;
                        visitedMask[offset] = true;
                        points.add(new Point(--x, y));
                        scan = 2;
                        remain = 8;
                        break;
                    }
                    case 5: {
                        int tmpOff;
                        if (x <= minx || y <= miny || !contourMask[tmpOff = offset - (w + 1)]) break;
                        if (visitedMask[tmpOff]) {
                            remain = 0;
                            break;
                        }
                        offset = tmpOff;
                        visitedMask[offset] = true;
                        points.add(new Point(--x, --y));
                        scan = 2;
                        remain = 8;
                        break;
                    }
                    case 6: {
                        int tmpOff;
                        if (y <= miny || !contourMask[tmpOff = offset - w]) break;
                        if (visitedMask[tmpOff]) {
                            remain = 0;
                            break;
                        }
                        offset = tmpOff;
                        visitedMask[offset] = true;
                        points.add(new Point(x, --y));
                        scan = 4;
                        remain = 8;
                        break;
                    }
                    case 7: {
                        int tmpOff;
                        if (x >= maxx || y <= miny || !contourMask[tmpOff = offset - w + 1]) break;
                        if (visitedMask[tmpOff]) {
                            remain = 0;
                            break;
                        }
                        offset = tmpOff;
                        visitedMask[offset] = true;
                        points.add(new Point(++x, --y));
                        scan = 4;
                        remain = 8;
                    }
                }
                scan = scan + 1 & 7;
            }
            allPoints.add(points);
            startOffset = BooleanMask2D.findStartPoint(startOffset, contourMask, visitedMask);
        }
        List<Point> result = new ArrayList<Point>((Collection)allPoints.get(0));
        allPoints.remove(0);
        int i = 0;
        while (i < allPoints.size()) {
            List<Point> newResult = BooleanMask2D.connect(result, (List)allPoints.get(i));
            if (newResult != null) {
                result = newResult;
                allPoints.remove(i);
                i = 0;
                continue;
            }
            ++i;
        }
        i = 0;
        while (i < allPoints.size()) {
            List<Point> newResult = BooleanMask2D.insertPoints(result, (List)allPoints.get(i));
            if (newResult != null) {
                result = newResult;
                allPoints.remove(i);
                i = 0;
                continue;
            }
            ++i;
        }
        return result;
    }

    public Point[] getContourPoints() {
        return TypeUtil.toPoint(this.getContourPointsAsIntArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getContourPointsAsIntArray() {
        int y;
        Rectangle bounds;
        boolean[] mask;
        if (this.isEmpty()) {
            return new int[0];
        }
        BooleanMask2D booleanMask2D = this;
        synchronized (booleanMask2D) {
            mask = this.mask;
            bounds = this.bounds;
        }
        int[] points = new int[mask.length * 2];
        int h = bounds.height;
        int w = bounds.width;
        int maxx = bounds.x + (w - 1);
        int maxy = bounds.y + (h - 1);
        boolean top = false;
        boolean bottom = false;
        boolean left = false;
        boolean right = false;
        int offset = 0;
        int pt = 0;
        if (w <= 2 || h <= 2) {
            for (y = bounds.y; y <= maxy; ++y) {
                for (int x = bounds.x; x <= maxx; ++x) {
                    if (!mask[offset++]) continue;
                    points[pt++] = x;
                    points[pt++] = y;
                }
            }
        } else {
            int x;
            top = false;
            left = false;
            boolean current = mask[offset];
            bottom = mask[offset + w];
            right = mask[++offset];
            if (!(!current || top && left && right && bottom)) {
                points[pt++] = bounds.x;
                points[pt++] = bounds.y;
            }
            for (x = bounds.x + 1; x < maxx; ++x) {
                left = current;
                current = right;
                bottom = mask[offset + w];
                right = mask[++offset];
                if (!current || top && left && right && bottom) continue;
                points[pt++] = x;
                points[pt++] = bounds.y;
            }
            left = current;
            current = right;
            bottom = mask[offset + w];
            right = false;
            ++offset;
            if (!(!current || top && left && right && bottom)) {
                points[pt++] = maxx;
                points[pt++] = bounds.y;
            }
            for (y = bounds.y + 1; y < maxy; ++y) {
                left = false;
                current = mask[offset];
                top = mask[offset - w];
                bottom = mask[offset + w];
                right = mask[++offset];
                if (!(!current || top && left && right && bottom)) {
                    points[pt++] = bounds.x;
                    points[pt++] = y;
                }
                for (int x2 = bounds.x + 1; x2 < maxx; ++x2) {
                    left = current;
                    current = right;
                    top = mask[offset - w];
                    bottom = mask[offset + w];
                    right = mask[++offset];
                    if (!current || top && left && right && bottom) continue;
                    points[pt++] = x2;
                    points[pt++] = y;
                }
                left = current;
                current = right;
                top = mask[offset - w];
                bottom = mask[offset + w];
                right = false;
                ++offset;
                if (!current || top && left && right && bottom) continue;
                points[pt++] = maxx;
                points[pt++] = y;
            }
            left = false;
            current = mask[offset];
            top = mask[offset - w];
            bottom = false;
            right = mask[++offset];
            if (!(!current || top && left && right && bottom)) {
                points[pt++] = bounds.x;
                points[pt++] = maxy;
            }
            for (x = bounds.x + 1; x < maxx; ++x) {
                left = current;
                current = right;
                top = mask[offset - w];
                right = mask[++offset];
                if (!current || top && left && right && bottom) continue;
                points[pt++] = x;
                points[pt++] = maxy;
            }
            left = current;
            current = right;
            top = mask[offset - w];
            right = false;
            if (!(!current || top && left && right && bottom)) {
                points[pt++] = maxx;
                points[pt++] = maxy;
            }
        }
        int[] result = new int[pt];
        System.arraycopy(points, 0, result, 0, pt);
        return result;
    }

    @Deprecated
    public Point[] getEdgePoints() {
        return TypeUtil.toPoint(this.getContourPointsAsIntArray());
    }

    public double getContourLength() {
        double perimeter = 0.0;
        int[] edge = this.getContourPointsAsIntArray();
        int baseX = this.bounds.x;
        int baseY = this.bounds.y;
        int width = this.bounds.width;
        int height = this.bounds.height;
        double sideEdges = 0.0;
        double cornerEdges = 0.0;
        block17: for (int i = 0; i < edge.length; i += 2) {
            boolean bottomRightConnected;
            boolean bottomConnected;
            boolean bottomLeftConnected;
            boolean rightConnected;
            boolean topRightConnected;
            boolean topConnected;
            boolean topLeftConnected;
            int x = edge[i + 0] - baseX;
            int y = edge[i + 1] - baseY;
            int xy = x + y * width;
            if (y != 0) {
                topLeftConnected = x != 0 && this.mask[xy - 1 - width];
                topConnected = this.mask[xy + 0 - width];
                topRightConnected = x != width - 1 && this.mask[xy + 1 - width];
            } else {
                topLeftConnected = false;
                topConnected = false;
                topRightConnected = false;
            }
            boolean leftConnected = x != 0 && this.mask[xy - 1];
            boolean bl = rightConnected = x != width - 1 && this.mask[xy + 1];
            if (y != height - 1) {
                bottomLeftConnected = x != 0 && this.mask[xy - 1 + width];
                bottomConnected = this.mask[xy + 0 + width];
                bottomRightConnected = x != width - 1 && this.mask[xy + 1 + width];
            } else {
                bottomLeftConnected = false;
                bottomConnected = false;
                bottomRightConnected = false;
            }
            int directConnection = 0;
            int diagConnection = 0;
            if (topLeftConnected) {
                ++diagConnection;
            }
            if (topConnected) {
                ++directConnection;
            }
            if (topRightConnected) {
                ++diagConnection;
            }
            if (leftConnected) {
                ++directConnection;
            }
            if (rightConnected) {
                ++directConnection;
            }
            if (bottomLeftConnected) {
                ++diagConnection;
            }
            if (bottomConnected) {
                ++directConnection;
            }
            if (bottomRightConnected) {
                ++diagConnection;
            }
            switch (directConnection) {
                case 0: {
                    switch (diagConnection) {
                        case 0: {
                            perimeter += Math.PI;
                            continue block17;
                        }
                        case 1: {
                            cornerEdges += 1.0;
                            perimeter += Math.sqrt(2.0) + 1.5707963267948966;
                            continue block17;
                        }
                    }
                    cornerEdges += 2.0;
                    perimeter += 2.0 * Math.sqrt(2.0);
                    continue block17;
                }
                case 1: {
                    switch (diagConnection) {
                        case 0: {
                            sideEdges += 1.0;
                            perimeter += 2.5707963267948966;
                            continue block17;
                        }
                    }
                    cornerEdges += 1.0;
                    sideEdges += 1.0;
                    perimeter += 1.0 + Math.sqrt(2.0);
                    continue block17;
                }
                case 2: {
                    if (leftConnected && rightConnected || topConnected && bottomConnected) {
                        double dgc = (double)diagConnection * 0.5;
                        double dtc = 2.0 - dgc;
                        cornerEdges += dgc;
                        sideEdges += dtc;
                        perimeter += dtc + dgc * Math.sqrt(2.0);
                        continue block17;
                    }
                    cornerEdges += 1.0;
                    perimeter += Math.sqrt(2.0);
                    continue block17;
                }
                case 3: {
                    switch (diagConnection) {
                        default: {
                            sideEdges += 1.0;
                            perimeter += 1.0;
                            continue block17;
                        }
                        case 3: {
                            cornerEdges += 0.5;
                            sideEdges += 0.5;
                            perimeter += 0.5 + Math.sqrt(2.0) / 2.0;
                            continue block17;
                        }
                        case 4: 
                    }
                    cornerEdges += 1.0;
                    perimeter += Math.sqrt(2.0);
                    continue block17;
                }
            }
        }
        double overShoot = Math.min(sideEdges / 10.0, cornerEdges);
        return perimeter - overShoot;
    }

    public BooleanMask2D getIntersection(BooleanMask2D booleanMask) {
        return BooleanMask2D.getIntersection(this, booleanMask);
    }

    public BooleanMask2D getIntersection(Rectangle bounds, boolean[] mask) {
        return BooleanMask2D.getIntersection(this.bounds, this.mask, bounds, mask);
    }

    @Deprecated
    public BooleanMask2D getIntersect(BooleanMask2D booleanMask) {
        return this.getIntersection(booleanMask);
    }

    @Deprecated
    public BooleanMask2D getIntersect(Rectangle bounds, boolean[] mask) {
        return this.getIntersection(bounds, mask);
    }

    public BooleanMask2D getUnion(BooleanMask2D booleanMask) {
        return BooleanMask2D.getUnion(this, booleanMask);
    }

    public BooleanMask2D getUnion(Rectangle bounds, boolean[] mask) {
        return BooleanMask2D.getUnion(this.bounds, this.mask, bounds, mask);
    }

    public BooleanMask2D getExclusiveUnion(BooleanMask2D booleanMask) {
        return BooleanMask2D.getExclusiveUnion(this, booleanMask);
    }

    public BooleanMask2D getExclusiveUnion(Rectangle bounds, boolean[] mask) {
        return BooleanMask2D.getExclusiveUnion(this.bounds, this.mask, bounds, mask);
    }

    public BooleanMask2D getSubtraction(BooleanMask2D mask) {
        return BooleanMask2D.getSubtraction(this, mask);
    }

    public BooleanMask2D getSubtraction(Rectangle bounds, boolean[] mask) {
        return BooleanMask2D.getSubtraction(this.bounds, this.mask, bounds, mask);
    }

    @Deprecated
    public BooleanMask2D getXor(BooleanMask2D booleanMask) {
        return this.getExclusiveUnion(booleanMask);
    }

    @Deprecated
    public BooleanMask2D getXor(Rectangle bounds, boolean[] mask) {
        return this.getExclusiveUnion(bounds, mask);
    }

    public void add(BooleanMask2D booleanMask) {
        this.add(booleanMask.bounds, booleanMask.mask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Rectangle boundsToAdd, boolean[] maskToAdd) {
        if (this.bounds.contains(boundsToAdd)) {
            int offDst = (boundsToAdd.y - this.bounds.y) * this.bounds.width + (boundsToAdd.x - this.bounds.x);
            int offSrc = 0;
            for (int y = 0; y < boundsToAdd.height; ++y) {
                for (int x = 0; x < boundsToAdd.width; ++x) {
                    if (!maskToAdd[offSrc++]) continue;
                    this.mask[offDst + x] = true;
                }
                offDst += this.bounds.width;
            }
        } else {
            BooleanMask2D result = this.getUnion(boundsToAdd, maskToAdd);
            BooleanMask2D booleanMask2D = this;
            synchronized (booleanMask2D) {
                this.bounds = result.bounds;
                this.mask = result.mask;
            }
        }
    }

    public void intersect(BooleanMask2D booleanMask) {
        this.intersect(booleanMask.bounds, booleanMask.mask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intersect(Rectangle boundsToIntersect, boolean[] maskToIntersect) {
        BooleanMask2D result = this.getIntersection(boundsToIntersect, maskToIntersect);
        BooleanMask2D booleanMask2D = this;
        synchronized (booleanMask2D) {
            this.bounds = result.bounds;
            this.mask = result.mask;
        }
    }

    public void exclusiveAdd(BooleanMask2D booleanMask) {
        this.exclusiveAdd(booleanMask.bounds, booleanMask.mask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exclusiveAdd(Rectangle boundsToXAdd, boolean[] maskToXAdd) {
        if (this.bounds.contains(boundsToXAdd)) {
            int offDst = (boundsToXAdd.y - this.bounds.y) * this.bounds.width + (boundsToXAdd.x - this.bounds.x);
            int offSrc = 0;
            for (int y = 0; y < boundsToXAdd.height; ++y) {
                for (int x = 0; x < boundsToXAdd.width; ++x) {
                    if (!maskToXAdd[offSrc++]) continue;
                    this.mask[offDst + x] = !this.mask[offDst + x];
                }
                offDst += this.bounds.width;
            }
            this.optimizeBounds();
        } else {
            BooleanMask2D result = this.getExclusiveUnion(boundsToXAdd, maskToXAdd);
            BooleanMask2D booleanMask2D = this;
            synchronized (booleanMask2D) {
                this.bounds = result.bounds;
                this.mask = result.mask;
            }
        }
    }

    public void subtract(Rectangle boundsToSubtract, boolean[] maskToSubtract) {
        Rectangle intersection = this.bounds.intersection(boundsToSubtract);
        if (!intersection.isEmpty()) {
            int offDst = (intersection.y - this.bounds.y) * this.bounds.width + (intersection.x - this.bounds.x);
            int offSrc = (intersection.y - boundsToSubtract.y) * boundsToSubtract.width + (intersection.x - boundsToSubtract.x);
            for (int y = 0; y < intersection.height; ++y) {
                for (int x = 0; x < intersection.width; ++x) {
                    if (!maskToSubtract[offSrc + x]) continue;
                    this.mask[offDst + x] = false;
                }
                offDst += this.bounds.width;
                offSrc += boundsToSubtract.width;
            }
            this.optimizeBounds();
        }
    }

    @Deprecated
    public void union(BooleanMask2D booleanMask) {
        this.add(booleanMask.bounds, booleanMask.mask);
    }

    @Deprecated
    public void union(Rectangle bounds, boolean[] mask) {
        this.add(bounds, mask);
    }

    @Deprecated
    public void exclusiveUnion(BooleanMask2D booleanMask) {
        this.exclusiveAdd(booleanMask.bounds, booleanMask.mask);
    }

    @Deprecated
    public void exclusiveUnion(Rectangle bounds, boolean[] mask) {
        this.exclusiveAdd(bounds, mask);
    }

    @Deprecated
    public void xor(BooleanMask2D booleanMask) {
        this.exclusiveAdd(booleanMask);
    }

    @Deprecated
    public void xor(Rectangle bounds, boolean[] mask) {
        this.exclusiveAdd(bounds, mask);
    }

    public Rectangle getOptimizedBounds() {
        int sizeX = this.bounds.width;
        int sizeY = this.bounds.height;
        int minX = sizeX;
        int minY = sizeY;
        int maxX = -1;
        int maxY = -1;
        int offset = 0;
        for (int y = 0; y < sizeY; ++y) {
            for (int x = 0; x < sizeX; ++x) {
                if (!this.mask[offset++]) continue;
                if (x < minX) {
                    minX = x;
                }
                if (x > maxX) {
                    maxX = x;
                }
                if (y < minY) {
                    minY = y;
                }
                if (y <= maxY) continue;
                maxY = y;
            }
        }
        if (minX == sizeX) {
            return new Rectangle(this.bounds.x, this.bounds.y, 0, 0);
        }
        return new Rectangle(this.bounds.x + minX, this.bounds.y + minY, maxX - minX + 1, maxY - minY + 1);
    }

    public void optimizeBounds() {
        this.moveBounds(this.getOptimizedBounds());
    }

    @Deprecated
    public void setBounds(Rectangle value) {
        this.moveBounds(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveBounds(Rectangle value) {
        if (!this.bounds.equals(value)) {
            Rectangle oldBounds = new Rectangle(this.bounds);
            Rectangle newBounds = new Rectangle(value);
            oldBounds.translate(-this.bounds.x, -this.bounds.y);
            newBounds.translate(-this.bounds.x, -this.bounds.y);
            boolean[] newMask = new boolean[Math.max(0, newBounds.width) * Math.max(0, newBounds.height)];
            Rectangle intersect = newBounds.intersection(oldBounds);
            if (!intersect.isEmpty()) {
                int offSrc = 0;
                int offDst = 0;
                if (intersect.x > 0) {
                    offSrc += intersect.x;
                }
                if (intersect.y > 0) {
                    offSrc += intersect.y * oldBounds.width;
                }
                if (newBounds.x < 0) {
                    offDst += -newBounds.x;
                }
                if (newBounds.y < 0) {
                    offDst += -newBounds.y * newBounds.width;
                }
                for (int j = 0; j < intersect.height; ++j) {
                    System.arraycopy(this.mask, offSrc, newMask, offDst, intersect.width);
                    offSrc += oldBounds.width;
                    offDst += newBounds.width;
                }
            }
            BooleanMask2D booleanMask2D = this;
            synchronized (booleanMask2D) {
                this.mask = newMask;
                this.bounds = value;
            }
        }
    }

    public BooleanMask2D upscale() {
        return BooleanMask2D.upscale(this);
    }

    public BooleanMask2D downscale(int nbPointForTrue) {
        return BooleanMask2D.downscale(this, nbPointForTrue);
    }

    public BooleanMask2D downscale() {
        return BooleanMask2D.downscale(this);
    }

    public Object clone() {
        return new BooleanMask2D((Rectangle)this.bounds.clone(), (boolean[])this.mask.clone());
    }

    private static class Component {
        public DynamicArray.Int points = new DynamicArray.Int(0);
        public List<Component> children = new ArrayList<Component>();
        private Component root = this;

        public void addPoint(int x, int y) {
            this.points.addSingle(x);
            this.points.addSingle(y);
        }

        public void addComponent(Component c) {
            Component croot = c.root;
            if (c != this && croot != this.root) {
                this.children.add(croot);
                croot.setRoot(this.root);
            }
        }

        public boolean isRoot() {
            return this.root == this;
        }

        private void setRoot(Component value) {
            this.root = value;
            int size = this.children.size();
            for (int c = 0; c < size; ++c) {
                this.children.get(c).setRoot(value);
            }
        }

        public int getTotalSize() {
            int result = this.points.getSize();
            int size = this.children.size();
            for (int c = 0; c < size; ++c) {
                result += this.children.get(c).getTotalSize();
            }
            return result;
        }

        public int[] getAllPoints() {
            int[] result = new int[this.getTotalSize()];
            this.getAllPoints(result, 0);
            return result;
        }

        private int getAllPoints(int[] result, int offset) {
            int[] intPoints = this.points.asArray();
            System.arraycopy(intPoints, 0, result, offset, intPoints.length);
            int off = offset + intPoints.length;
            int csize = this.children.size();
            for (int c = 0; c < csize; ++c) {
                off = this.children.get(c).getAllPoints(result, off);
            }
            return off;
        }
    }
}

