/*
 * Decompiled with CFR 0.152.
 */
package icy.sequence;

import icy.file.FileUtil;
import icy.file.xml.XMLPersistent;
import icy.image.lut.LUT;
import icy.painter.Overlay;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.system.IcyExceptionHandler;
import icy.util.StringUtil;
import icy.util.XMLUtil;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SequencePersistent
implements XMLPersistent {
    private static final String ID_META = "meta";
    private static final String ID_ROIS = "rois";
    private static final String ID_OVERLAYS = "overlays";
    private static final String ID_LUT = "lut";
    private final Sequence sequence;
    private Document document;

    public SequencePersistent(Sequence sequence) {
        this.sequence = sequence;
        this.document = XMLUtil.createDocument(true);
    }

    private String getXMLFileName() {
        String baseName = this.sequence.getOutputFilename(false);
        if (StringUtil.isEmpty(baseName)) {
            return null;
        }
        return baseName + ".xml";
    }

    public boolean loadXMLData() {
        String xmlFilename = this.getXMLFileName();
        Exception exc = null;
        if (xmlFilename != null && FileUtil.exists(xmlFilename)) {
            boolean result;
            try {
                this.document = XMLUtil.loadDocument(xmlFilename, true);
                if (this.document != null) {
                    result = this.loadFromXML(this.getRootNode());
                } else {
                    this.document = XMLUtil.createDocument(true);
                    result = false;
                }
            }
            catch (Exception e) {
                exc = e;
                result = false;
            }
            if (!result) {
                String backupName = FileUtil.backup(xmlFilename);
                System.err.println("Error while loading Sequence XML persistent data.");
                System.err.println("The faulty file '" + xmlFilename + "' has been backuped as '" + backupName);
                if (exc != null) {
                    IcyExceptionHandler.showErrorMessage(exc, true);
                }
                return false;
            }
        }
        return true;
    }

    public boolean saveXMLData() throws Exception {
        String xmlFilename = this.getXMLFileName();
        if (xmlFilename == null) {
            return false;
        }
        this.refreshXMLData();
        return XMLUtil.saveDocument(this.document, xmlFilename);
    }

    public void refreshXMLData() {
        this.saveToXML(this.getRootNode());
    }

    @Override
    public boolean loadFromXML(Node node) {
        boolean result = true;
        String name = XMLUtil.getElementValue(node, "name", "");
        if (!StringUtil.isEmpty(name)) {
            this.sequence.setName(name);
        }
        if (!this.loadMetaDataFromXML(node)) {
            result = false;
        }
        if (!this.loadROIsFromXML(node)) {
            result = false;
        }
        this.loadOverlaysFromXML(node);
        if (!this.loadLUTFromXML(node)) {
            result = false;
        }
        return result;
    }

    private boolean loadMetaDataFromXML(Node node) {
        long l;
        Element nodeMeta = XMLUtil.getElement(node, ID_META);
        if (nodeMeta == null) {
            return true;
        }
        double d = XMLUtil.getElementDoubleValue(nodeMeta, "positionX", Double.NaN);
        if (!Double.isNaN(d)) {
            this.sequence.setPositionX(d);
        }
        if (!Double.isNaN(d = XMLUtil.getElementDoubleValue(nodeMeta, "positionY", Double.NaN))) {
            this.sequence.setPositionY(d);
        }
        if (!Double.isNaN(d = XMLUtil.getElementDoubleValue(nodeMeta, "positionZ", Double.NaN))) {
            this.sequence.setPositionZ(d);
        }
        if ((l = XMLUtil.getElementLongValue(nodeMeta, "positionT", -1L)) != -1L) {
            this.sequence.setPositionT(l);
        }
        if (!Double.isNaN(d = XMLUtil.getElementDoubleValue(nodeMeta, "pixelSizeX", Double.NaN))) {
            this.sequence.setPixelSizeX(d);
        }
        if (!Double.isNaN(d = XMLUtil.getElementDoubleValue(nodeMeta, "pixelSizeY", Double.NaN))) {
            this.sequence.setPixelSizeY(d);
        }
        if (!Double.isNaN(d = XMLUtil.getElementDoubleValue(nodeMeta, "pixelSizeZ", Double.NaN))) {
            this.sequence.setPixelSizeZ(d);
        }
        if (!Double.isNaN(d = XMLUtil.getElementDoubleValue(nodeMeta, "timeInterval", Double.NaN))) {
            this.sequence.setTimeInterval(d);
        }
        for (int c = 0; c < this.sequence.getSizeC(); ++c) {
            String s = XMLUtil.getElementValue(nodeMeta, "channelName" + c, "");
            if (StringUtil.isEmpty(s)) continue;
            this.sequence.setChannelName(c, s);
        }
        return true;
    }

    private boolean loadROIsFromXML(Node node) {
        Element roisNode = XMLUtil.getElement(node, ID_ROIS);
        if (roisNode == null) {
            return true;
        }
        int roiCount = ROI.getROICount(roisNode);
        List<ROI> rois = ROI.loadROIsFromXML(roisNode);
        for (ROI roi : rois) {
            this.sequence.addROI(roi);
        }
        return roiCount == rois.size();
    }

    private boolean loadOverlaysFromXML(Node node) {
        Element overlaysNode = XMLUtil.getElement(node, ID_OVERLAYS);
        if (overlaysNode == null) {
            return true;
        }
        int overlayCount = Overlay.getOverlayCount(overlaysNode);
        List<Overlay> overlays = Overlay.loadOverlaysFromXML(overlaysNode);
        for (Overlay overlay : overlays) {
            this.sequence.addOverlay(overlay);
        }
        return overlayCount == overlays.size();
    }

    private boolean loadLUTFromXML(Node node) {
        Element nodeLut = XMLUtil.getElement(node, ID_LUT);
        if (nodeLut == null) {
            return true;
        }
        LUT result = this.sequence.createCompatibleLUT();
        if (result.loadFromXML(nodeLut)) {
            this.sequence.setUserLUT(result);
        }
        return true;
    }

    @Override
    public boolean saveToXML(Node node) {
        XMLUtil.setElementValue(node, "name", this.sequence.getName());
        this.saveMetaDataToXML(node);
        this.saveROIsToXML(node);
        this.saveOverlaysToXML(node);
        this.saveLUTToXML(node);
        return true;
    }

    private void saveMetaDataToXML(Node node) {
        Element nodeMeta = XMLUtil.setElement(node, ID_META);
        if (nodeMeta != null) {
            XMLUtil.setElementDoubleValue(nodeMeta, "positionX", this.sequence.getPositionX());
            XMLUtil.setElementDoubleValue(nodeMeta, "positionY", this.sequence.getPositionY());
            XMLUtil.setElementDoubleValue(nodeMeta, "positionZ", this.sequence.getPositionZ());
            XMLUtil.setElementLongValue(nodeMeta, "positionT", this.sequence.getPositionT());
            XMLUtil.setElementDoubleValue(nodeMeta, "pixelSizeX", this.sequence.getPixelSizeX());
            XMLUtil.setElementDoubleValue(nodeMeta, "pixelSizeY", this.sequence.getPixelSizeY());
            XMLUtil.setElementDoubleValue(nodeMeta, "pixelSizeZ", this.sequence.getPixelSizeZ());
            XMLUtil.setElementDoubleValue(nodeMeta, "timeInterval", this.sequence.getTimeInterval());
            for (int c = 0; c < this.sequence.getSizeC(); ++c) {
                XMLUtil.setElementValue(nodeMeta, "channelName" + c, this.sequence.getChannelName(c));
            }
        }
    }

    private void saveROIsToXML(Node node) {
        Element nodeROIs = XMLUtil.setElement(node, ID_ROIS);
        if (nodeROIs != null) {
            XMLUtil.removeAllChildren(nodeROIs);
            List<ROI> rois = this.sequence.getROIs(true);
            ROI.saveROIsToXML(nodeROIs, rois);
        }
    }

    private void saveOverlaysToXML(Node node) {
        Element nodeOverlays = XMLUtil.setElement(node, ID_OVERLAYS);
        if (nodeOverlays != null) {
            XMLUtil.removeAllChildren(nodeOverlays);
            LinkedList<Overlay> overlays = new LinkedList<Overlay>(this.sequence.getOverlays());
            for (ROI roi : this.sequence.getROIs(false)) {
                overlays.remove(roi.getOverlay());
            }
            Overlay.saveOverlaysToXML(nodeOverlays, overlays);
        }
    }

    private void saveLUTToXML(Node node) {
        Element nodeLut;
        LUT lut;
        if (this.sequence.hasUserLUT() && (lut = this.sequence.getUserLUT()) != null && (nodeLut = XMLUtil.setElement(node, ID_LUT)) != null) {
            XMLUtil.removeAllChildren(nodeLut);
            lut.saveToXML(nodeLut);
        }
    }

    public Node getRootNode() {
        return XMLUtil.getRootElement(this.document);
    }

    public Node getNode(String name) {
        return XMLUtil.getChild(this.getRootNode(), name);
    }

    public Node setNode(String name) {
        return XMLUtil.setElement(this.getRootNode(), name);
    }

    public static boolean isValidXMLPersitence(Document doc) {
        if (doc == null) {
            return false;
        }
        Element rootNode = XMLUtil.getRootElement(doc);
        return XMLUtil.getElement(rootNode, "name") != null && XMLUtil.getElement(rootNode, ID_META) != null && XMLUtil.getElement(rootNode, ID_ROIS) != null && XMLUtil.getElement(rootNode, ID_OVERLAYS) != null;
    }

    public static boolean isValidXMLPersitence(String path) {
        if (path != null && FileUtil.exists(path)) {
            try {
                return SequencePersistent.isValidXMLPersitence(XMLUtil.loadDocument(path, true));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

