/*
 * Decompiled with CFR 0.152.
 */
package icy.swimmingPool;

import icy.util.ClassUtil;
import icy.util.DateUtil;
import icy.util.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.ImageIcon;

public class SwimmingObject {
    private static final String DEFAULT_NAME = "object";
    private static final ImageIcon DEFAULT_ICON = null;
    private static int id_gen = 1;
    private final Object object;
    private final String name;
    private final ImageIcon icon;
    private final int id;
    private final Date creationDate;

    public static ArrayList<String> getObjectTypes(ArrayList<SwimmingObject> objects) {
        ArrayList<String> result = new ArrayList<String>();
        for (SwimmingObject obj : objects) {
            String type = obj.getObjectClassName();
            if (result.contains(type)) continue;
            result.add(type);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwimmingObject(Object object, String name, ImageIcon icon) {
        Class<SwimmingObject> clazz = SwimmingObject.class;
        synchronized (SwimmingObject.class) {
            this.id = id_gen++;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.object = object;
            this.name = StringUtil.isEmpty(name) ? "object " + this.id : name;
            this.icon = icon == null ? DEFAULT_ICON : icon;
            this.creationDate = DateUtil.now();
            return;
        }
    }

    public SwimmingObject(Object object, String name) {
        this(object, name, null);
    }

    public SwimmingObject(Object object, ImageIcon icon) {
        this(object, null, icon);
    }

    public SwimmingObject(Object object) {
        this(object, null, null);
    }

    public Object getObject() {
        return this.object;
    }

    public String getName() {
        return this.name;
    }

    public String getObjectClassName() {
        if (this.object != null) {
            return this.object.getClass().getName();
        }
        return "";
    }

    public String getObjectSimpleClassName() {
        return ClassUtil.getSimpleClassName(this.getObjectClassName());
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public int getId() {
        return this.id;
    }
}

