/*
 * Decompiled with CFR 0.152.
 */
package icy.type.geom;

import icy.type.geom.Shape3D;
import icy.type.point.Point3D;
import icy.type.rectangle.Rectangle3D;

public class Line3D
implements Shape3D,
Cloneable {
    protected double x1;
    protected double y1;
    protected double z1;
    protected double x2;
    protected double y2;
    protected double z2;

    public Line3D() {
        this.setLine(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public Line3D(double x1, double y1, double z1, double x2, double y2, double z2) {
        this.setLine(x1, y1, z1, x2, y2, z2);
    }

    public Line3D(Point3D p1, Point3D p2) {
        this.setLine(p1, p2);
    }

    public Line3D(Line3D l) {
        this.setLine(l);
    }

    public double getX1() {
        return this.x1;
    }

    public double getY1() {
        return this.y1;
    }

    public double getZ1() {
        return this.z1;
    }

    public Point3D getP1() {
        return new Point3D.Double(this.getX1(), this.getY1(), this.getZ1());
    }

    public double getX2() {
        return this.x2;
    }

    public double getY2() {
        return this.y2;
    }

    public double getZ2() {
        return this.z2;
    }

    public Point3D getP2() {
        return new Point3D.Double(this.getX2(), this.getY2(), this.getZ2());
    }

    public Point3D getVector() {
        return new Point3D.Double(this.getX2() - this.getX1(), this.getY2() - this.getY1(), this.getZ2() - this.getZ1());
    }

    public void setLine(double x1, double y1, double z1, double x2, double y2, double z2) {
        this.x1 = x1;
        this.y1 = y1;
        this.z1 = z1;
        this.x2 = x2;
        this.y2 = y2;
        this.z2 = z2;
    }

    @Override
    public Rectangle3D getBounds() {
        double sizeZ;
        double z;
        double sizeY;
        double y;
        double sizeX;
        double x;
        if (this.x1 < this.x2) {
            x = this.x1;
            sizeX = this.x2 - this.x1;
        } else {
            x = this.x2;
            sizeX = this.x1 - this.x2;
        }
        if (this.y1 < this.y2) {
            y = this.y1;
            sizeY = this.y2 - this.y1;
        } else {
            y = this.y2;
            sizeY = this.y1 - this.y2;
        }
        if (this.z1 < this.z2) {
            z = this.z1;
            sizeZ = this.z2 - this.z1;
        } else {
            z = this.z2;
            sizeZ = this.z1 - this.z2;
        }
        return new Rectangle3D.Double(x, y, z, sizeX, sizeY, sizeZ);
    }

    public void setLine(Point3D p1, Point3D p2) {
        this.setLine(p1.getX(), p1.getY(), p1.getZ(), p2.getX(), p2.getY(), p2.getZ());
    }

    public void setLine(Line3D l) {
        this.setLine(l.getX1(), l.getY1(), l.getZ1(), l.getX2(), l.getY2(), l.getZ2());
    }

    public static boolean linesIntersect(double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, double x4, double y4, double z4) {
        Point3D.Double vC = new Point3D.Double(x3 - x1, y3 - y1, z3 - z1);
        Point3D.Double vA = new Point3D.Double(x2 - x1, y2 - y1, z2 - z1);
        Point3D.Double vB = new Point3D.Double(x4 - x3, y4 - y3, z4 - z3);
        Point3D crossAB = vA.crossProduct(vB);
        if (vC.dotProduct(crossAB) != 0.0) {
            return false;
        }
        double norm2 = crossAB.norm2();
        if (norm2 == 0.0) {
            return false;
        }
        Point3D crossCB = vC.crossProduct(vB);
        double dot = crossCB.dotProduct(crossAB);
        double s = dot / norm2;
        return s >= 0.0 && s <= 1.0;
    }

    public boolean intersectsLine(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Line3D.linesIntersect(x1, y1, z1, x2, y2, z2, this.getX1(), this.getY1(), this.getZ1(), this.getX2(), this.getY2(), this.getZ2());
    }

    public boolean intersectsLine(Line3D l) {
        return Line3D.linesIntersect(l.getX1(), l.getY1(), l.getZ1(), l.getX2(), l.getY2(), l.getZ2(), this.getX1(), this.getY1(), this.getZ1(), this.getX2(), this.getY2(), this.getZ2());
    }

    public static double ptSegDistSq(double x1, double y1, double z1, double x2, double y2, double z2, double px, double py, double pz) {
        double projlenSq;
        double lenSq;
        double dotprod = (px -= x1) * (x2 -= x1) + (py -= y1) * (y2 -= y1) + (pz -= z1) * (z2 -= z1);
        if ((lenSq = px * px + py * py + pz * pz - (projlenSq = dotprod <= 0.0 ? 0.0 : ((dotprod = (px = x2 - px) * x2 + (py = y2 - py) * y2 + (pz = z2 - pz) * z2) <= 0.0 ? 0.0 : dotprod * dotprod / (x2 * x2 + y2 * y2 + z2 * z2)))) < 0.0) {
            lenSq = 0.0;
        }
        return lenSq;
    }

    public static double ptSegDist(double x1, double y1, double z1, double x2, double y2, double z2, double px, double py, double pz) {
        return Math.sqrt(Line3D.ptSegDistSq(x1, y1, z1, x2, y2, z2, px, py, pz));
    }

    public double ptSegDistSq(double px, double py, double pz) {
        return Line3D.ptSegDistSq(this.getX1(), this.getY1(), this.getZ1(), this.getX2(), this.getY2(), this.getZ2(), px, py, pz);
    }

    public double ptSegDistSq(Point3D pt) {
        return Line3D.ptSegDistSq(this.getX1(), this.getY1(), this.getZ1(), this.getX2(), this.getY2(), this.getZ2(), pt.getX(), pt.getY(), pt.getZ());
    }

    public double ptSegDist(double px, double py, double pz) {
        return Line3D.ptSegDist(this.getX1(), this.getY1(), this.getZ1(), this.getX2(), this.getY2(), this.getZ2(), px, py, pz);
    }

    public double ptSegDist(Point3D pt) {
        return Line3D.ptSegDist(this.getX1(), this.getY1(), this.getZ1(), this.getX2(), this.getY2(), this.getZ2(), pt.getX(), pt.getY(), pt.getZ());
    }

    public static double ptLineDistSq(double x1, double y1, double z1, double x2, double y2, double z2, double px, double py, double pz) {
        double dotprod;
        double projlenSq;
        double lenSq;
        if ((lenSq = (px -= x1) * px + (py -= y1) * py + (pz -= z1) * pz - (projlenSq = (dotprod = px * (x2 -= x1) + py * (y2 -= y1) + pz * (z2 -= z1)) * dotprod / (x2 * x2 + y2 * y2 + z2 * z2))) < 0.0) {
            lenSq = 0.0;
        }
        return lenSq;
    }

    public static double ptLineDist(double x1, double y1, double z1, double x2, double y2, double z2, double px, double py, double pz) {
        return Math.sqrt(Line3D.ptLineDistSq(x1, y1, z1, x2, y2, z2, px, py, pz));
    }

    public double ptLineDistSq(double px, double py, double pz) {
        return Line3D.ptLineDistSq(this.getX1(), this.getY1(), this.getZ1(), this.getX2(), this.getY2(), this.getZ2(), px, py, pz);
    }

    public double ptLineDistSq(Point3D pt) {
        return Line3D.ptLineDistSq(this.getX1(), this.getY1(), this.getZ1(), this.getX2(), this.getY2(), this.getZ2(), pt.getX(), pt.getY(), pt.getZ());
    }

    public double ptLineDist(double px, double py, double pz) {
        return Line3D.ptLineDist(this.getX1(), this.getY1(), this.getZ1(), this.getX2(), this.getY2(), this.getZ2(), px, py, pz);
    }

    public double ptLineDist(Point3D pt) {
        return Line3D.ptLineDist(this.getX1(), this.getY1(), this.getZ1(), this.getX2(), this.getY2(), this.getZ2(), pt.getX(), pt.getY(), pt.getZ());
    }

    @Override
    public boolean contains(double x, double y, double z) {
        return false;
    }

    @Override
    public boolean contains(Point3D p) {
        return false;
    }

    @Override
    public boolean contains(double x, double y, double z, double sizeX, double sizeY, double sizeZ) {
        return false;
    }

    @Override
    public boolean contains(Rectangle3D r) {
        return false;
    }

    @Override
    public boolean intersects(double x, double y, double z, double sizeX, double sizeY, double sizeZ) {
        return this.intersects(new Rectangle3D.Double(x, y, z, sizeX, sizeY, sizeZ));
    }

    @Override
    public boolean intersects(Rectangle3D r) {
        return r.intersectsLine(this.getX1(), this.getY1(), this.getZ1(), this.getX2(), this.getY2(), this.getZ2());
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

