/*
 * Decompiled with CFR 0.152.
 */
package icy.vtk;

import icy.canvas.Layer;
import icy.common.exception.TooLargeArrayException;
import icy.image.colormap.IcyColorMap;
import icy.image.lut.LUT;
import icy.math.Scaler;
import icy.painter.Overlay;
import icy.painter.VtkPainter;
import icy.roi.BooleanMask2D;
import icy.roi.BooleanMask3D;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.type.DataType;
import icy.type.collection.array.Array2DUtil;
import icy.type.collection.array.ArrayUtil;
import icy.type.rectangle.Rectangle3D;
import icy.type.rectangle.Rectangle5D;
import icy.vtk.IcyVtkPanel;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import plugins.kernel.canvas.VtkCanvas;
import plugins.kernel.roi.roi2d.ROI2DArea;
import plugins.kernel.roi.roi3d.ROI3DArea;
import vtk.vtkAbstractTransform;
import vtk.vtkActor;
import vtk.vtkActor2D;
import vtk.vtkActor2DCollection;
import vtk.vtkActorCollection;
import vtk.vtkCellArray;
import vtk.vtkCollection;
import vtk.vtkColorTransferFunction;
import vtk.vtkContourFilter;
import vtk.vtkDataArray;
import vtk.vtkDataObject;
import vtk.vtkDataSet;
import vtk.vtkDataSetSurfaceFilter;
import vtk.vtkDoubleArray;
import vtk.vtkFloatArray;
import vtk.vtkIdTypeArray;
import vtk.vtkImageConstantPad;
import vtk.vtkImageData;
import vtk.vtkImageStencil;
import vtk.vtkIntArray;
import vtk.vtkLongArray;
import vtk.vtkOBJReader;
import vtk.vtkObject;
import vtk.vtkObjectBase;
import vtk.vtkPiecewiseFunction;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkPolyDataToImageStencil;
import vtk.vtkProp;
import vtk.vtkPropCollection;
import vtk.vtkRenderer;
import vtk.vtkShortArray;
import vtk.vtkTransform;
import vtk.vtkTransformPolyDataFilter;
import vtk.vtkUnsignedCharArray;
import vtk.vtkUnsignedIntArray;
import vtk.vtkUnsignedLongArray;
import vtk.vtkUnsignedShortArray;
import vtk.vtkVertexGlyphFilter;

public class VtkUtil {
    public static final int VTK_VOID = 0;
    public static final int VTK_BIT = 1;
    public static final int VTK_CHAR = 2;
    public static final int VTK_SIGNED_CHAR = 15;
    public static final int VTK_UNSIGNED_CHAR = 3;
    public static final int VTK_SHORT = 4;
    public static final int VTK_UNSIGNED_SHORT = 5;
    public static final int VTK_INT = 6;
    public static final int VTK_UNSIGNED_INT = 7;
    public static final int VTK_LONG = 8;
    public static final int VTK_UNSIGNED_LONG = 9;
    public static final int VTK_FLOAT = 10;
    public static final int VTK_DOUBLE = 11;
    public static final int VTK_ID = 12;
    public static final int VTK_NEAREST_INTERPOLATION = 0;
    public static final int VTK_LINEAR_INTERPOLATION = 1;
    public static final int VTK_CUBIC_INTERPOLATION = 2;
    public static final int VTK_FLY_OUTER_EDGES = 0;
    public static final int VTK_FLY_CLOSEST_TRIAD = 1;
    public static final int VTK_FLY_FURTHEST_TRIAD = 2;
    public static final int VTK_FLY_STATIC_TRIAD = 3;
    public static final int VTK_FLY_STATIC_EDGES = 4;
    public static final int VTK_TICKS_INSIDE = 0;
    public static final int VTK_TICKS_OUTSIDE = 1;
    public static final int VTK_TICKS_BOTH = 2;
    public static final int VTK_GRID_LINES_ALL = 0;
    public static final int VTK_GRID_LINES_CLOSEST = 1;
    public static final int VTK_GRID_LINES_FURTHEST = 2;

    public static int getVtkType(DataType type) {
        switch (type) {
            default: {
                return 3;
            }
            case USHORT: {
                return 5;
            }
            case SHORT: {
                return 4;
            }
            case UINT: {
                return 7;
            }
            case INT: {
                return 6;
            }
            case ULONG: {
                return 9;
            }
            case LONG: {
                return 8;
            }
            case FLOAT: {
                return 10;
            }
            case DOUBLE: 
        }
        return 11;
    }

    public static vtkDataArray getVtkArray(Object array, boolean signed) {
        switch (ArrayUtil.getDataType(array)) {
            case BYTE: {
                return VtkUtil.getUCharArray((byte[])array);
            }
            case SHORT: {
                if (signed) {
                    return VtkUtil.getUShortArray((short[])array);
                }
                return VtkUtil.getShortArray((short[])array);
            }
            case INT: {
                if (signed) {
                    return VtkUtil.getUIntArray((int[])array);
                }
                return VtkUtil.getIntArray((int[])array);
            }
            case LONG: {
                if (signed) {
                    return VtkUtil.getULongArray((long[])array);
                }
                return VtkUtil.getLongArray((long[])array);
            }
            case FLOAT: {
                return VtkUtil.getFloatArray((float[])array);
            }
            case DOUBLE: {
                return VtkUtil.getDoubleArray((double[])array);
            }
        }
        return null;
    }

    public static vtkUnsignedCharArray getUCharArray(byte[] array) {
        vtkUnsignedCharArray result = new vtkUnsignedCharArray();
        result.SetJavaArray(array);
        return result;
    }

    public static vtkUnsignedShortArray getUShortArray(short[] array) {
        vtkUnsignedShortArray result = new vtkUnsignedShortArray();
        result.SetJavaArray(array);
        return result;
    }

    public static vtkUnsignedIntArray getUIntArray(int[] array) {
        vtkUnsignedIntArray result = new vtkUnsignedIntArray();
        result.SetJavaArray(array);
        return result;
    }

    public static vtkUnsignedLongArray getULongArray(long[] array) {
        vtkUnsignedLongArray result = new vtkUnsignedLongArray();
        result.SetJavaArray(array);
        return result;
    }

    public static vtkShortArray getShortArray(short[] array) {
        vtkShortArray result = new vtkShortArray();
        result.SetJavaArray(array);
        return result;
    }

    public static vtkIntArray getIntArray(int[] array) {
        vtkIntArray result = new vtkIntArray();
        result.SetJavaArray(array);
        return result;
    }

    public static vtkLongArray getLongArray(long[] array) {
        vtkLongArray result = new vtkLongArray();
        result.SetJavaArray(array);
        return result;
    }

    public static vtkFloatArray getFloatArray(float[] array) {
        vtkFloatArray result = new vtkFloatArray();
        result.SetJavaArray(array);
        return result;
    }

    public static vtkDoubleArray getDoubleArray(double[] array) {
        vtkDoubleArray result = new vtkDoubleArray();
        result.SetJavaArray(array);
        return result;
    }

    public static vtkIdTypeArray getIdTypeArray(int[] array) {
        vtkIdTypeArray result = new vtkIdTypeArray();
        vtkIntArray iarray = VtkUtil.getIntArray(array);
        result.DeepCopy((vtkDataArray)iarray);
        iarray.Delete();
        return result;
    }

    public static Object getJavaArray(vtkDataArray dataArray) {
        switch (dataArray.GetDataType()) {
            case 3: {
                return ((vtkUnsignedCharArray)dataArray).GetJavaArray();
            }
            case 4: {
                return ((vtkShortArray)dataArray).GetJavaArray();
            }
            case 5: {
                return ((vtkUnsignedShortArray)dataArray).GetJavaArray();
            }
            case 6: {
                return ((vtkIntArray)dataArray).GetJavaArray();
            }
            case 7: {
                return ((vtkUnsignedIntArray)dataArray).GetJavaArray();
            }
            case 8: {
                return ((vtkLongArray)dataArray).GetJavaArray();
            }
            case 9: {
                return ((vtkUnsignedLongArray)dataArray).GetJavaArray();
            }
            case 10: {
                return ((vtkFloatArray)dataArray).GetJavaArray();
            }
            case 11: {
                return ((vtkDoubleArray)dataArray).GetJavaArray();
            }
        }
        return null;
    }

    public static int[] getJavaArray(vtkIdTypeArray array) {
        vtkIntArray iarray = new vtkIntArray();
        iarray.DeepCopy((vtkDataArray)array);
        int[] result = iarray.GetJavaArray();
        iarray.Delete();
        return result;
    }

    public static vtkObject[] vtkCollectionToArray(vtkCollection collection) {
        vtkObject[] result = new vtkObject[collection.GetNumberOfItems()];
        collection.InitTraversal();
        for (int i = 0; i < result.length; ++i) {
            result[i] = collection.GetNextItemAsObject();
        }
        return result;
    }

    public static vtkPoints getPoints(double[] points) {
        vtkPoints result = new vtkPoints();
        vtkDoubleArray array = VtkUtil.getDoubleArray(points);
        array.SetNumberOfComponents(3);
        result.SetData((vtkDataArray)array);
        return result;
    }

    public static vtkPoints getPoints(double[][] points) {
        return VtkUtil.getPoints(Array2DUtil.toDoubleArray1D(points));
    }

    public static vtkPoints getPoints(float[] points) {
        vtkPoints result = new vtkPoints();
        vtkFloatArray array = VtkUtil.getFloatArray(points);
        array.SetNumberOfComponents(3);
        result.SetData((vtkDataArray)array);
        return result;
    }

    public static vtkPoints getPoints(float[][] points) {
        return VtkUtil.getPoints(Array2DUtil.toFloatArray1D(points));
    }

    public static vtkPoints getPoints(int[] points) {
        vtkPoints result = new vtkPoints();
        vtkIntArray array = VtkUtil.getIntArray(points);
        array.SetNumberOfComponents(3);
        result.SetData((vtkDataArray)array);
        return result;
    }

    public static vtkPoints getPoints(int[][] points) {
        return VtkUtil.getPoints(Array2DUtil.toIntArray1D(points));
    }

    public static vtkCellArray getCells(int numCell, int[] cells) {
        vtkCellArray result = new vtkCellArray();
        result.SetCells(numCell, VtkUtil.getIdTypeArray(cells));
        return result;
    }

    public static vtkPolyData getPolyDataFromPoints(vtkPoints points) {
        vtkPolyData tmpPolyData = new vtkPolyData();
        vtkVertexGlyphFilter vertexFilter = new vtkVertexGlyphFilter();
        tmpPolyData.SetPoints(points);
        vertexFilter.SetInputData((vtkDataObject)tmpPolyData);
        vertexFilter.Update();
        vtkPolyData result = vertexFilter.GetOutput();
        vertexFilter.Delete();
        return result;
    }

    public static vtkPolyData getPolyDataFromDataSet(vtkDataSet dataSet) {
        vtkDataSetSurfaceFilter surfaceFilter = new vtkDataSetSurfaceFilter();
        surfaceFilter.SetInputData((vtkDataObject)dataSet);
        surfaceFilter.Update();
        vtkPolyData result = surfaceFilter.GetOutput();
        surfaceFilter.Delete();
        return result;
    }

    public static vtkProp[] getLayerProps(Layer layer) {
        Overlay overlay;
        if (layer != null && (overlay = layer.getOverlay()) instanceof VtkPainter) {
            return ((VtkPainter)((Object)overlay)).getProps();
        }
        return new vtkProp[0];
    }

    public static vtkProp[] getLayersProps(List<Layer> layers) {
        ArrayList<vtkProp[]> layersProps = new ArrayList<vtkProp[]>();
        int totalSize = 0;
        for (Layer layer : layers) {
            vtkProp[] props;
            Overlay overlay;
            if (layer == null || !((overlay = layer.getOverlay()) instanceof VtkPainter) || (props = ((VtkPainter)((Object)overlay)).getProps()).length <= 0) continue;
            layersProps.add(props);
            totalSize += props.length;
        }
        vtkProp[] result = new vtkProp[totalSize];
        int ind = 0;
        for (vtkProp[] props : layersProps) {
            int size = props.length;
            System.arraycopy(props, 0, result, ind, size);
            ind += size;
        }
        return result;
    }

    public static vtkProp[] getProps(vtkRenderer renderer) {
        if (renderer == null) {
            return new vtkProp[0];
        }
        vtkPropCollection collection = renderer.GetViewProps();
        vtkProp[] result = new vtkProp[collection.GetNumberOfItems()];
        collection.InitTraversal();
        for (int i = 0; i < result.length; ++i) {
            result[i] = collection.GetNextProp();
        }
        return result;
    }

    public static boolean hasProp(vtkRenderer renderer, vtkProp actor) {
        if (renderer == null || actor == null) {
            return false;
        }
        return renderer.HasViewProp(actor) != 0;
    }

    @Deprecated
    public static boolean findProp(vtkRenderer renderer, vtkProp actor) {
        return VtkUtil.hasProp(renderer, actor);
    }

    @Deprecated
    public static boolean findActor(vtkRenderer renderer, vtkActor actor) {
        if (renderer == null || actor == null) {
            return false;
        }
        vtkActorCollection actors = renderer.GetActors();
        actors.InitTraversal();
        for (int i = 0; i < actors.GetNumberOfItems(); ++i) {
            vtkActor curActor = actors.GetNextActor();
            if (curActor != actor) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean findActor2D(vtkRenderer renderer, vtkActor2D actor) {
        if (renderer == null || actor == null) {
            return false;
        }
        vtkActor2DCollection actors = renderer.GetActors2D();
        actors.InitTraversal();
        for (int i = 0; i < actors.GetNumberOfItems(); ++i) {
            vtkActor2D curActor = actors.GetNextActor2D();
            if (curActor != actor) continue;
            return true;
        }
        return false;
    }

    public static void addProp(vtkRenderer renderer, vtkProp prop) {
        if (renderer == null || prop == null) {
            return;
        }
        if (renderer.HasViewProp(prop) == 0) {
            renderer.AddViewProp(prop);
        }
    }

    @Deprecated
    public static void addActor(vtkRenderer renderer, vtkActor actor) {
        if (renderer == null || actor == null) {
            return;
        }
        if (!VtkUtil.findActor(renderer, actor)) {
            renderer.AddActor((vtkProp)actor);
        }
    }

    @Deprecated
    public static void addActor2D(vtkRenderer renderer, vtkActor2D actor) {
        if (renderer == null || actor == null) {
            return;
        }
        if (!VtkUtil.findActor2D(renderer, actor)) {
            renderer.AddActor2D((vtkProp)actor);
        }
    }

    public static void addProps(vtkRenderer renderer, vtkProp[] props) {
        if (renderer == null || props == null) {
            return;
        }
        for (vtkProp prop : props) {
            if (renderer.HasViewProp(prop) != 0) continue;
            renderer.AddViewProp(prop);
        }
    }

    public static void removeProp(vtkRenderer renderer, vtkProp actor) {
        renderer.RemoveViewProp(actor);
    }

    public static int[] prepareCells(int[][] indexes) {
        int len = indexes.length;
        int total_len = 0;
        for (int i = 0; i < len; ++i) {
            total_len += indexes[i].length + 1;
        }
        int[] result = new int[total_len];
        int offset = 0;
        for (int i = 0; i < len; ++i) {
            int[] s_cells = indexes[i];
            int s_len = s_cells.length;
            result[offset++] = s_len;
            for (int j = 0; j < s_len; ++j) {
                result[offset++] = s_cells[j];
            }
        }
        return result;
    }

    public static int[] prepareCells(int numVertexPerCell, int[] indexes) {
        int num_cells = indexes.length / numVertexPerCell;
        int[] result = new int[num_cells * (numVertexPerCell + 1)];
        int off_dst = 0;
        int off_src = 0;
        for (int i = 0; i < num_cells; ++i) {
            result[off_dst++] = numVertexPerCell;
            for (int j = 0; j < numVertexPerCell; ++j) {
                result[off_dst++] = indexes[off_src + j];
            }
            off_src += numVertexPerCell;
        }
        return result;
    }

    public static BooleanMask3D getBooleanMaskFromBinaryImage(vtkImageData image, boolean optimizeBounds) {
        vtkDataArray data = image.GetPointData().GetScalars();
        double[] origin = image.GetOrigin();
        int[] dim = image.GetDimensions();
        int sizeX = dim[0];
        int sizeY = dim[1];
        int sizeZ = dim[2];
        int sizeXY = sizeX * sizeY;
        Rectangle bounds2D = new Rectangle((int)origin[0], (int)origin[1], sizeX, sizeY);
        BooleanMask2D[] masks = new BooleanMask2D[sizeZ];
        if (sizeXY * sizeZ > 0xC800000) {
            int off = 0;
            for (int z = 0; z < sizeZ; ++z) {
                boolean[] mask = new boolean[sizeXY];
                for (int xy = 0; xy < sizeXY; ++xy) {
                    mask[xy] = data.GetTuple1(off++) != 0.0;
                }
                masks[z] = new BooleanMask2D(new Rectangle(bounds2D), mask);
            }
        } else {
            Object javaArray = VtkUtil.getJavaArray(data);
            int off = 0;
            switch (ArrayUtil.getDataType(javaArray)) {
                case BYTE: {
                    byte[] javaByteArray = (byte[])javaArray;
                    for (int z = 0; z < sizeZ; ++z) {
                        boolean[] mask = new boolean[sizeXY];
                        for (int xy = 0; xy < mask.length; ++xy) {
                            mask[xy] = javaByteArray[off++] != 0;
                        }
                        masks[z] = new BooleanMask2D(new Rectangle(bounds2D), mask);
                    }
                    break;
                }
                case SHORT: {
                    short[] javaShortArray = (short[])javaArray;
                    for (int z = 0; z < sizeZ; ++z) {
                        boolean[] mask = new boolean[sizeXY];
                        for (int xy = 0; xy < mask.length; ++xy) {
                            mask[xy] = javaShortArray[off++] != 0;
                        }
                        masks[z] = new BooleanMask2D(new Rectangle(bounds2D), mask);
                    }
                    break;
                }
                case INT: {
                    int[] javaIntArray = (int[])javaArray;
                    for (int z = 0; z < sizeZ; ++z) {
                        boolean[] mask = new boolean[sizeXY];
                        for (int xy = 0; xy < mask.length; ++xy) {
                            mask[xy] = javaIntArray[off++] != 0;
                        }
                        masks[z] = new BooleanMask2D(new Rectangle(bounds2D), mask);
                    }
                    break;
                }
                case LONG: {
                    long[] javaLongArray = (long[])javaArray;
                    for (int z = 0; z < sizeZ; ++z) {
                        boolean[] mask = new boolean[sizeXY];
                        for (int xy = 0; xy < mask.length; ++xy) {
                            mask[xy] = javaLongArray[off++] != 0L;
                        }
                        masks[z] = new BooleanMask2D(new Rectangle(bounds2D), mask);
                    }
                    break;
                }
                case FLOAT: {
                    float[] javaFloatArray = (float[])javaArray;
                    for (int z = 0; z < sizeZ; ++z) {
                        boolean[] mask = new boolean[sizeXY];
                        for (int xy = 0; xy < mask.length; ++xy) {
                            mask[xy] = javaFloatArray[off++] != 0.0f;
                        }
                        masks[z] = new BooleanMask2D(new Rectangle(bounds2D), mask);
                    }
                    break;
                }
                case DOUBLE: {
                    double[] javaDoubleArray = (double[])javaArray;
                    for (int z = 0; z < sizeZ; ++z) {
                        boolean[] mask = new boolean[sizeXY];
                        for (int xy = 0; xy < mask.length; ++xy) {
                            mask[xy] = javaDoubleArray[off++] != 0.0;
                        }
                        masks[z] = new BooleanMask2D(new Rectangle(bounds2D), mask);
                    }
                    break;
                }
            }
        }
        BooleanMask3D result = new BooleanMask3D(new Rectangle3D.Integer(bounds2D.x, bounds2D.y, (int)origin[2], sizeX, sizeY, sizeZ), masks);
        if (optimizeBounds) {
            result.optimizeBounds();
        }
        return result;
    }

    @Deprecated
    public static ROI getROIFromBinaryImage(vtkImageData image, boolean force3DROI) {
        BooleanMask3D mask = VtkUtil.getBooleanMaskFromBinaryImage(image, true);
        if (mask.bounds.getSizeZ() > 1.0 || force3DROI) {
            return new ROI3DArea(mask);
        }
        return new ROI2DArea(mask.getMask2D(mask.bounds.z));
    }

    public static vtkImageData getImageData(Sequence sequence, int posT, int posC) throws TooLargeArrayException, OutOfMemoryError {
        vtkImageData result;
        if (sequence == null || sequence.isEmpty()) {
            return null;
        }
        if (posC == -1) {
            Object data = sequence.getDataCopyCXYZ(posT);
            result = VtkUtil.getImageData(data, sequence.getDataType_(), sequence.getSizeX(), sequence.getSizeY(), sequence.getSizeZ(), sequence.getSizeC());
        } else {
            Object data = sequence.getDataCopyXYZ(posT, posC);
            result = VtkUtil.getImageData(data, sequence.getDataType_(), sequence.getSizeX(), sequence.getSizeY(), sequence.getSizeZ(), 1);
        }
        return result;
    }

    public static vtkImageData getImageData(Object data, DataType dataType, int sizeX, int sizeY, int sizeZ, int sizeC) {
        vtkImageData result = new vtkImageData();
        result.SetDimensions(sizeX, sizeY, sizeZ);
        result.SetExtent(0, sizeX - 1, 0, sizeY - 1, 0, sizeZ - 1);
        result.AllocateScalars(VtkUtil.getVtkType(dataType), sizeC);
        vtkDataArray array = result.GetPointData().GetScalars();
        switch (dataType) {
            case UBYTE: 
            case BYTE: {
                ((vtkUnsignedCharArray)array).SetJavaArray((byte[])data);
                break;
            }
            case USHORT: {
                ((vtkUnsignedShortArray)array).SetJavaArray((short[])data);
                break;
            }
            case SHORT: {
                ((vtkShortArray)array).SetJavaArray((short[])data);
                break;
            }
            case UINT: {
                ((vtkUnsignedIntArray)array).SetJavaArray((int[])data);
                break;
            }
            case INT: {
                ((vtkIntArray)array).SetJavaArray((int[])data);
                break;
            }
            case FLOAT: {
                ((vtkFloatArray)array).SetJavaArray((float[])data);
                break;
            }
            case DOUBLE: {
                ((vtkDoubleArray)array).SetJavaArray((double[])data);
                break;
            }
        }
        return result;
    }

    public static vtkPolyData getSurfaceFromImage(vtkImageData imageData, double threshold) {
        int[] extent = imageData.GetExtent();
        extent[0] = extent[0] - 1;
        extent[1] = extent[1] + 1;
        extent[2] = extent[2] - 1;
        extent[3] = extent[3] + 1;
        extent[4] = extent[4] - 1;
        extent[5] = extent[5] + 1;
        vtkImageConstantPad pad = new vtkImageConstantPad();
        pad.SetOutputWholeExtent(extent);
        pad.SetInputData((vtkDataObject)imageData);
        pad.Update();
        vtkImageData out = pad.GetOutput();
        out.SetOrigin(imageData.GetOrigin());
        pad.Delete();
        vtkContourFilter contourFilter = new vtkContourFilter();
        contourFilter.SetInputData((vtkDataObject)out);
        contourFilter.SetValue(0, threshold);
        contourFilter.Update();
        vtkPolyData result = contourFilter.GetOutput();
        contourFilter.GetInput().Delete();
        contourFilter.Delete();
        return result;
    }

    public static vtkImageData getBinaryImageData(ROI roi, int sz, int t) throws IllegalArgumentException {
        int sizeZ;
        int z;
        Rectangle5D bounds5d = roi.getBounds5D();
        int x = (int)bounds5d.getX();
        int y = (int)bounds5d.getY();
        int sizeX = (int)(bounds5d.getMaxX() - (double)x);
        int sizeY = (int)(bounds5d.getMaxY() - (double)y);
        if (bounds5d.isInfiniteZ()) {
            z = 0;
            sizeZ = sz;
        } else {
            z = (int)bounds5d.getZ();
            sizeZ = (int)(bounds5d.getMaxZ() - (double)z);
        }
        int c = bounds5d.isInfiniteC() ? 0 : (int)bounds5d.getC();
        long totalSize = sizeX;
        totalSize *= (long)sizeY;
        if ((totalSize *= (long)sizeZ) > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("VtkUtil.getBinaryImageData(ROI, ..): Input ROI is too large, can't allocate array (size > 2^31)");
        }
        int sizeXY = sizeX * sizeY;
        byte[] array = new byte[(int)totalSize];
        int offset = 0;
        if (bounds5d.isInfiniteZ()) {
            boolean[] mask = roi.getBooleanMask2D(x, y, sizeX, sizeY, 0, t, c, true);
            for (int curZ = z; curZ < z + sizeZ; ++curZ) {
                for (int i = 0; i < sizeXY; ++i) {
                    array[offset++] = mask[i] ? (byte)1 : 0;
                }
            }
        } else {
            for (int curZ = z; curZ < z + sizeZ; ++curZ) {
                boolean[] mask = roi.getBooleanMask2D(x, y, sizeX, sizeY, curZ, t, c, true);
                for (int i = 0; i < sizeXY; ++i) {
                    array[offset++] = mask[i] ? (byte)1 : 0;
                }
            }
        }
        vtkImageData result = new vtkImageData();
        result.SetDimensions(sizeX, sizeY, sizeZ);
        result.SetExtent(0, sizeX - 1, 0, sizeY - 1, 0, sizeZ - 1);
        result.AllocateScalars(3, 1);
        ((vtkUnsignedCharArray)result.GetPointData().GetScalars()).SetJavaArray(array);
        return result;
    }

    public static vtkImageData getBinaryImageData(vtkPolyData polyData, double[] space) {
        double[] dArray;
        vtkImageData whiteImage = new vtkImageData();
        double[] bounds = polyData.GetBounds();
        if (space == null) {
            double[] dArray2 = new double[3];
            dArray2[0] = 1.0;
            dArray2[1] = 1.0;
            dArray = dArray2;
            dArray2[2] = 1.0;
        } else {
            dArray = space;
        }
        double[] spacing = dArray;
        int[] dim = new int[3];
        double[] origin = new double[3];
        for (int i = 0; i < dim.length; ++i) {
            dim[i] = (int)Math.ceil((bounds[i * 2 + 1] - bounds[i * 2 + 0]) / spacing[i]);
        }
        long size = dim[0];
        size *= (long)dim[1];
        if ((size *= (long)dim[2]) < 0L) {
            throw new IllegalArgumentException("VtkUtil.getBinaryImageData(vtkPolyData, ..): Negative object size, cannot do the conversion !");
        }
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("VtkUtil.getBinaryImageData(vtkPolyData, ..): Object size is too large, can't allocate array (size > 2^31) !");
        }
        origin[0] = bounds[0] + 0.5;
        origin[1] = bounds[2] + 0.5;
        origin[2] = bounds[4] + 0.5;
        whiteImage.SetSpacing(spacing);
        whiteImage.SetDimensions(dim);
        whiteImage.SetExtent(0, dim[0] - 1, 0, dim[1] - 1, 0, dim[2] - 1);
        whiteImage.SetOrigin(origin);
        whiteImage.AllocateScalars(3, 1);
        int len = whiteImage.GetNumberOfPoints();
        byte[] javaArray = new byte[len];
        vtkUnsignedCharArray vtkArray = (vtkUnsignedCharArray)whiteImage.GetPointData().GetScalars();
        Arrays.fill(javaArray, (byte)1);
        vtkArray.SetJavaArray(javaArray);
        vtkPolyDataToImageStencil polyToImgStencil = new vtkPolyDataToImageStencil();
        polyToImgStencil.SetInputData(polyData);
        polyToImgStencil.SetOutputOrigin(origin);
        polyToImgStencil.SetOutputSpacing(spacing);
        polyToImgStencil.SetOutputWholeExtent(whiteImage.GetExtent());
        polyToImgStencil.SetTolerance(1.0E-4);
        polyToImgStencil.Update();
        vtkImageStencil imageStencil = new vtkImageStencil();
        imageStencil.SetInputData((vtkDataObject)whiteImage);
        imageStencil.SetStencilConnection(polyToImgStencil.GetOutputPort());
        imageStencil.ReverseStencilOff();
        imageStencil.SetBackgroundValue(0.0);
        imageStencil.Update();
        vtkImageData result = imageStencil.GetOutput();
        imageStencil.Delete();
        polyToImgStencil.Delete();
        whiteImage.GetPointData().GetScalars().Delete();
        whiteImage.GetPointData().Delete();
        whiteImage.Delete();
        return result;
    }

    @Deprecated
    public static vtkImageData polyDataToImageData(vtkPolyData polyData, double[] space) {
        return VtkUtil.getBinaryImageData(polyData, space);
    }

    public static vtkTransform getTransform(double[] off, double[] scale, double[] rot) {
        double[] dArray;
        double[] scaling;
        double[] dArray2;
        double[] offset;
        double[] dArray3;
        if (off == null) {
            double[] dArray4 = new double[3];
            dArray4[0] = 0.0;
            dArray4[1] = 0.0;
            dArray3 = dArray4;
            dArray4[2] = 0.0;
        } else {
            dArray3 = offset = off;
        }
        if (scale == null) {
            double[] dArray5 = new double[3];
            dArray5[0] = 1.0;
            dArray5[1] = 1.0;
            dArray2 = dArray5;
            dArray5[2] = 1.0;
        } else {
            dArray2 = scaling = scale;
        }
        if (rot == null) {
            double[] dArray6 = new double[3];
            dArray6[0] = 0.0;
            dArray6[1] = 0.0;
            dArray = dArray6;
            dArray6[2] = 0.0;
        } else {
            dArray = rot;
        }
        double[] rotation = dArray;
        vtkTransform result = new vtkTransform();
        result.Translate(offset);
        result.Scale(scaling);
        result.RotateX(rotation[0]);
        result.RotateY(rotation[1]);
        result.RotateZ(rotation[2]);
        result.Update();
        return result;
    }

    public static vtkPolyData transformPolyData(vtkPolyData polyData, vtkAbstractTransform transform) {
        vtkTransformPolyDataFilter transformFilter = new vtkTransformPolyDataFilter();
        transformFilter.SetInputData((vtkDataObject)polyData);
        transformFilter.SetTransform(transform);
        transformFilter.Update();
        vtkPolyData result = transformFilter.GetOutput();
        transformFilter.Delete();
        return result;
    }

    public static vtkPolyData transformPolyData(vtkPolyData polyData, double[] off, double[] scale, double[] rot) {
        vtkTransform transform = VtkUtil.getTransform(off, scale, rot);
        vtkPolyData result = VtkUtil.transformPolyData(polyData, (vtkAbstractTransform)transform);
        transform.Delete();
        return result;
    }

    public static vtkPolyData getSurfaceFromOBJ(String objPath) {
        vtkOBJReader reader = new vtkOBJReader();
        reader.SetFileName(objPath);
        reader.Update();
        vtkPolyData result = reader.GetOutput();
        reader.Delete();
        return result;
    }

    public static vtkColorTransferFunction getColorMap(LUT.LUTChannel lutChannel) {
        IcyColorMap colorMap = lutChannel.getColorMap();
        Scaler scaler = lutChannel.getScaler();
        vtkColorTransferFunction result = new vtkColorTransferFunction();
        result.SetRange(scaler.getLeftIn(), scaler.getRightIn());
        for (int i = 0; i < 256; ++i) {
            result.AddRGBPoint(scaler.unscale(i), (double)colorMap.getNormalizedRed(i), (double)colorMap.getNormalizedGreen(i), (double)colorMap.getNormalizedBlue(i));
        }
        return result;
    }

    public static vtkPiecewiseFunction getOpacityMap(LUT.LUTChannel lutChannel) {
        IcyColorMap colorMap = lutChannel.getColorMap();
        Scaler scaler = lutChannel.getScaler();
        vtkPiecewiseFunction result = new vtkPiecewiseFunction();
        if (colorMap.isEnabled()) {
            for (int i = 0; i < 256; ++i) {
                result.AddPoint(scaler.unscale(i), (double)colorMap.getNormalizedAlpha(i));
            }
        } else {
            for (int i = 0; i < 256; ++i) {
                result.AddPoint(scaler.unscale(i), 0.0);
            }
        }
        return result;
    }

    public static vtkColorTransferFunction getBinaryColorMap(Color color) {
        vtkColorTransferFunction result = new vtkColorTransferFunction();
        result.SetRange(0.0, 1.0);
        result.AddRGBPoint(0.0, 0.0, 0.0, 0.0);
        result.AddRGBPoint(1.0, (double)color.getRed() / 255.0, (double)color.getGreen() / 255.0, (double)color.getBlue() / 255.0);
        return result;
    }

    public static vtkPiecewiseFunction getBinaryOpacityMap(double opacity) {
        vtkPiecewiseFunction result = new vtkPiecewiseFunction();
        result.AddPoint(0.0, 1.0);
        result.AddPoint(1.0, opacity);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPolyDataColor(vtkPolyData polyData, Color color, VtkCanvas canvas) {
        IcyVtkPanel vtkPanel;
        int numPts = polyData.GetNumberOfPoints();
        vtkUnsignedCharArray colors = null;
        if (polyData.GetPointData() != null) {
            vtkDataArray dataArray = polyData.GetPointData().GetScalars();
            if (dataArray instanceof vtkUnsignedCharArray) {
                colors = (vtkUnsignedCharArray)dataArray;
            } else if (dataArray != null) {
                dataArray.Delete();
            }
        }
        if (colors == null || colors.GetNumberOfTuples() != numPts || colors.GetNumberOfComponents() != 3) {
            if (colors != null) {
                colors.Delete();
            }
            colors = new vtkUnsignedCharArray();
            colors.SetNumberOfComponents(3);
            colors.SetNumberOfTuples(numPts);
            polyData.GetPointData().SetScalars((vtkDataArray)colors);
        }
        int len = numPts * 3;
        byte r = (byte)color.getRed();
        byte g = (byte)color.getGreen();
        byte b = (byte)color.getBlue();
        byte[] data = new byte[len];
        for (int i = 0; i < len; i += 3) {
            data[i + 0] = r;
            data[i + 1] = g;
            data[i + 2] = b;
        }
        IcyVtkPanel icyVtkPanel = vtkPanel = canvas != null ? canvas.getVtkPanel() : null;
        if (vtkPanel != null) {
            vtkPanel.lock();
            try {
                colors.SetJavaArray(data);
                colors.Modified();
            }
            finally {
                vtkPanel.unlock();
            }
        } else {
            colors.SetJavaArray(data);
            colors.Modified();
        }
    }

    public static vtkPolyData getOutline(double xMin, double xMax, double yMin, double yMax, double zMin, double zMax) {
        double[][] points = new double[8][3];
        int[][] indexes = new int[][]{{0, 2, 3, 1}, {4, 5, 7, 6}, {0, 1, 5, 4}, {1, 3, 7, 5}, {0, 4, 6, 2}, {3, 2, 6, 7}};
        for (int i = 0; i < 8; ++i) {
            points[i][0] = (i & 1) == 0 ? xMin : xMax;
            points[i][1] = (i & 2) == 0 ? yMin : yMax;
            points[i][2] = (i & 4) == 0 ? zMin : zMax;
        }
        vtkCellArray vCells = VtkUtil.getCells(6, VtkUtil.prepareCells(indexes));
        vtkPoints vPoints = VtkUtil.getPoints(points);
        vtkPolyData result = new vtkPolyData();
        result.SetPolys(vCells);
        result.SetPoints(vPoints);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean setOutlineBounds(vtkPolyData outline, double xMin, double xMax, double yMin, double yMax, double zMin, double zMax, VtkCanvas canvas) {
        IcyVtkPanel vtkPanel;
        vtkPoints previousPoints = outline.GetPoints();
        if (previousPoints != null && previousPoints.GetNumberOfPoints() != 8) {
            return false;
        }
        double[][] newPoints = new double[8][3];
        for (int i = 0; i < 8; ++i) {
            newPoints[i][0] = (i & 1) == 0 ? xMin : xMax;
            newPoints[i][1] = (i & 2) == 0 ? yMin : yMax;
            newPoints[i][2] = (i & 4) == 0 ? zMin : zMax;
        }
        vtkPoints points = VtkUtil.getPoints(newPoints);
        IcyVtkPanel icyVtkPanel = vtkPanel = canvas != null ? canvas.getVtkPanel() : null;
        if (vtkPanel != null) {
            vtkPanel.lock();
            try {
                outline.SetPoints(points);
                outline.Modified();
                if (previousPoints == null) return true;
                previousPoints.Delete();
                return true;
            }
            finally {
                vtkPanel.unlock();
            }
        } else {
            outline.SetPoints(points);
            outline.Modified();
            if (previousPoints == null) return true;
            previousPoints.Delete();
        }
        return true;
    }

    public static void vtkGC() {
        vtkObjectBase.JAVA_OBJECT_MANAGER.gc(false);
    }
}

