/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.importer;

import icy.common.exception.UnsupportedFormatException;
import icy.common.listener.ProgressListener;
import icy.file.FileUtil;
import icy.file.Loader;
import icy.gui.dialog.LoaderDialog;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.image.ImageUtil;
import icy.image.colormap.IcyColorMap;
import icy.image.colormap.LinearColorMap;
import icy.plugin.abstract_.PluginSequenceFileImporter;
import icy.preferences.GeneralPreferences;
import icy.sequence.MetaDataUtil;
import icy.system.SystemUtil;
import icy.system.thread.Processor;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import icy.type.collection.array.Array2DUtil;
import icy.type.collection.array.ByteArrayConvert;
import icy.type.rectangle.Rectangle2DUtil;
import icy.util.ColorUtil;
import icy.util.OMEUtil;
import icy.util.StringUtil;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.filechooser.FileFilter;
import jxl.biff.drawing.PNGReader;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.MissingLibraryException;
import loci.formats.TileStitcher;
import loci.formats.UnknownFormatException;
import loci.formats.gui.AWTImageTools;
import loci.formats.gui.ExtensionFileFilter;
import loci.formats.in.APNGReader;
import loci.formats.in.DynamicMetadataOptions;
import loci.formats.in.JPEG2000Reader;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadataImpl;
import ome.xml.meta.OMEXMLMetadata;

public class LociImporterPlugin
extends PluginSequenceFileImporter {
    protected final ImageReader mainReader = new ImageReader();
    protected IFormatReader reader;
    protected IFormatReader internalReader;
    protected IFormatReader acceptReader;
    protected final List<IFormatReader> readersPool;
    protected final DynamicMetadataOptions options;
    protected boolean originalMetadata;
    protected boolean groupFiles;
    protected int[] resolutions;
    protected String openedPath;
    protected int openFlags;

    public LociImporterPlugin() {
        this.mainReader.setAllowOpenFiles(true);
        this.reader = null;
        this.internalReader = null;
        this.acceptReader = null;
        this.readersPool = new ArrayList<IFormatReader>();
        this.options = new DynamicMetadataOptions();
        this.options.setMetadataLevel(MetadataLevel.NO_OVERLAYS);
        this.options.setValidate(false);
        this.options.setBoolean("nativend2.chunkmap", Boolean.FALSE);
        this.originalMetadata = false;
        this.groupFiles = true;
        this.resolutions = null;
        this.openedPath = null;
        this.openFlags = 0;
    }

    protected void setReader(String path) throws FormatException, IOException {
        IFormatReader newReader = this.internalReader;
        if (this.internalReader == null) {
            newReader = this.mainReader.getReader(path);
        } else if (!(this.isOpen(path) || this.internalReader.isThisType(path, false) || this.internalReader.isThisType(path, true))) {
            newReader = this.mainReader.getReader(path);
        }
        if (this.internalReader != newReader) {
            this.internalReader = newReader;
            this.acceptReader = newReader;
            this.reader = this.groupFiles ? TileStitcher.makeTileStitcher(newReader) : newReader;
        }
    }

    protected void reportError(String title, String message, String filename) {
    }

    public boolean getReadOriginalMetadata() {
        return this.originalMetadata;
    }

    public void setReadOriginalMetadata(boolean value) {
        this.originalMetadata = value;
    }

    public boolean isGroupFiles() {
        return this.groupFiles;
    }

    public void setGroupFiles(boolean value) {
        this.groupFiles = value;
    }

    @Override
    public List<FileFilter> getFileFilters() {
        ArrayList<FileFilter> result = new ArrayList<FileFilter>();
        result.add(new LociAllFileFilter());
        result.add(new ExtensionFileFilter(new String[]{"tif", "tiff"}, "TIFF images / Bio-Formats"));
        result.add(new ExtensionFileFilter(new String[]{"png"}, "PNG images / Bio-Formats"));
        result.add(new ExtensionFileFilter(new String[]{"jpg", "jpeg"}, "JPEG images / Bio-Formats"));
        result.add(new ExtensionFileFilter(new String[]{"avi"}, "AVI videos / Bio-Formats"));
        return result;
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean acceptFile(String path) {
        if (Loader.canDiscardImageFile(path)) {
            return false;
        }
        String adjPath = new File(path).getAbsolutePath();
        while (true) {
            try {
                if (this.acceptReader == null || !this.acceptReader.isThisType(adjPath, false) && !this.acceptReader.isThisType(adjPath, true)) {
                    this.acceptReader = this.mainReader.getReader(adjPath);
                }
                return true;
            }
            catch (ClosedByInterruptException e) {
                Thread.interrupted();
                continue;
            }
            break;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isOpen(String path) {
        return StringUtil.equals(this.getOpened(), FileUtil.getGenericPath(path));
    }

    @Override
    public String getOpened() {
        return this.openedPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean open(String path, int flags) throws UnsupportedFormatException, IOException {
        if (this.isOpen(path)) {
            return true;
        }
        this.close();
        try {
            String adjPath = new File(path).getAbsolutePath();
            this.setReader(adjPath);
            this.openReader(this.reader, adjPath, flags);
            List<IFormatReader> list = this.readersPool;
            synchronized (list) {
                this.readersPool.add(this.reader);
            }
            this.openedPath = FileUtil.getGenericPath(path);
            this.openFlags = flags;
            this.resolutions = null;
            return true;
        }
        catch (FormatException e) {
            throw LociImporterPlugin.translateException(path, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.getOpened() != null) {
            this.openedPath = null;
            List<IFormatReader> list = this.readersPool;
            synchronized (list) {
                for (IFormatReader r : this.readersPool) {
                    r.close();
                }
                this.readersPool.clear();
            }
        }
    }

    protected void openReader(IFormatReader reader, String path, int flags) throws FormatException, IOException {
        reader.close();
        switch (flags & 3) {
            case 1: {
                this.options.setMetadataLevel(MetadataLevel.MINIMUM);
                reader.setOriginalMetadataPopulated(false);
                reader.setMetadataFiltered(false);
                break;
            }
            case 2: {
                this.options.setMetadataLevel(MetadataLevel.ALL);
                reader.setOriginalMetadataPopulated(true);
                reader.setMetadataFiltered(true);
                break;
            }
            default: {
                this.options.setMetadataLevel(MetadataLevel.NO_OVERLAYS);
                reader.setOriginalMetadataPopulated(this.originalMetadata);
                reader.setMetadataFiltered(true);
            }
        }
        reader.setFlattenedResolutions(false);
        reader.setGroupFiles(this.groupFiles);
        reader.setMetadataStore((MetadataStore)((Object)OMEUtil.createOMEXMLMetadata()));
        reader.setMetadataOptions(this.options);
        reader.setId(path);
    }

    protected IFormatReader cloneReader() throws FormatException, IOException, InstantiationException, IllegalAccessException {
        if (this.internalReader == null) {
            return null;
        }
        IFormatReader newReader = (IFormatReader)this.internalReader.getClass().newInstance();
        IFormatReader result = this.groupFiles ? TileStitcher.makeTileStitcher(newReader) : newReader;
        String path = this.getOpened();
        if (path != null) {
            this.openReader(result, new File(path).getAbsolutePath(), this.openFlags);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFormatReader getReader() throws FormatException, IOException {
        try {
            IFormatReader result;
            List<IFormatReader> list = this.readersPool;
            synchronized (list) {
                result = this.readersPool.isEmpty() ? this.cloneReader() : this.readersPool.remove(this.readersPool.size() - 1);
            }
            int s = this.reader.getSeries();
            int r = this.reader.getResolution();
            if (result.getSeries() != s) {
                result.setSeries(s);
            }
            if (result.getResolution() != r) {
                result.setResolution(r);
            }
            return result;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseReader(IFormatReader r) {
        List<IFormatReader> list = this.readersPool;
        synchronized (list) {
            this.readersPool.add(r);
        }
    }

    protected void prepareReader(int series) {
        if (this.reader.getSeries() != series) {
            this.reader.setSeries(series);
            this.resolutions = null;
        }
        if (this.resolutions == null) {
            this.reader.setResolution(0);
            double sizeX = this.reader.getSizeX();
            int resCount = this.reader.getResolutionCount();
            ArrayList<Integer> validResolutions = new ArrayList<Integer>(16);
            validResolutions.add(0);
            for (int r = 1; r < resCount; ++r) {
                this.reader.setResolution(r);
                double level = Math.log(sizeX / (double)this.reader.getSizeX()) / Math.log(2.0);
                double levelInt = Math.floor(level);
                if (!(Math.abs(level - levelInt) < 0.005)) continue;
                validResolutions.add((int)levelInt);
            }
            this.resolutions = new int[validResolutions.size()];
            for (int i = 0; i < this.resolutions.length; ++i) {
                this.resolutions[i] = (Integer)validResolutions.get(i);
            }
        }
    }

    protected int prepareReader(int series, int resolution) {
        this.prepareReader(series);
        if (resolution > 0) {
            int indRes;
            for (indRes = 1; indRes < this.resolutions.length && this.resolutions[indRes] <= resolution; ++indRes) {
            }
            this.reader.setResolution(--indRes);
            return resolution - this.resolutions[indRes];
        }
        this.reader.setResolution(0);
        return 0;
    }

    protected int getResolutionShift() {
        return this.resolutions[this.reader.getResolution()];
    }

    protected double getResolutionDiviserFactor() {
        return 1.0 / Math.pow(2.0, this.getResolutionShift());
    }

    @Override
    public OMEXMLMetadata getOMEXMLMetaData() throws UnsupportedFormatException, IOException {
        if (this.getOpened() == null) {
            return null;
        }
        OMEXMLMetadata result = (OMEXMLMetadata)((Object)this.reader.getMetadataStore());
        if (this.reader.getSeriesCount() == 1 && MetaDataUtil.getNumSeries(result) > 1) {
            MetaDataUtil.setNumSeries(result, 1);
            int sx = this.reader.getSizeX();
            int sy = this.reader.getSizeY();
            if (sx > 0 && sy > 0) {
                MetaDataUtil.setSizeX(result, 0, sx);
                MetaDataUtil.setSizeY(result, 0, sy);
            }
        }
        return result;
    }

    @Override
    @Deprecated
    public OMEXMLMetadataImpl getMetaData() throws UnsupportedFormatException, IOException {
        return (OMEXMLMetadataImpl)this.getOMEXMLMetaData();
    }

    @Override
    public int getTileWidth(int series) throws UnsupportedFormatException, IOException {
        if (this.getOpened() == null) {
            return 0;
        }
        this.prepareReader(series);
        int result = this.reader.getOptimalTileWidth();
        if (result == 0) {
            return result;
        }
        return (int)Math.pow(2.0, Math.floor(Math.log(result) / Math.log(2.0)));
    }

    @Override
    public int getTileHeight(int series) throws UnsupportedFormatException, IOException {
        if (this.getOpened() == null) {
            return 0;
        }
        this.prepareReader(series);
        int result = this.reader.getOptimalTileHeight();
        if (result == 0) {
            return result;
        }
        return (int)Math.pow(2.0, Math.floor(Math.log(result) / Math.log(2.0)));
    }

    @Override
    public boolean isResolutionAvailable(int series, int resolution) throws UnsupportedFormatException, IOException {
        if (this.getOpened() == null) {
            return resolution == 0;
        }
        this.prepareReader(series);
        if (resolution > 0) {
            for (int r : this.resolutions) {
                if (r != resolution) continue;
                return true;
            }
        }
        return resolution == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IcyBufferedImage getThumbnail(int series) throws UnsupportedFormatException, IOException {
        if (this.getOpened() == null) {
            return null;
        }
        if (this.reader.getSizeX() != this.internalReader.getSizeX() || this.reader.getSizeY() != this.internalReader.getSizeY()) {
            return super.getThumbnail(series);
        }
        this.prepareReader(series, 0);
        IFormatReader r = this.getReader();
        try {
            IcyBufferedImage icyBufferedImage = LociImporterPlugin.getThumbnail(r, r.getSizeZ() / 2, r.getSizeT() / 2);
            this.releaseReader(r);
            return icyBufferedImage;
        }
        catch (Throwable throwable) {
            try {
                this.releaseReader(r);
                throw throwable;
            }
            catch (FormatException e) {
                throw LociImporterPlugin.translateException(this.getOpened(), e);
            }
            catch (Throwable t) {
                return super.getThumbnail(series);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getPixels(int series, int resolution, Rectangle rectangle, int z, int t, int c) throws UnsupportedFormatException, IOException {
        if (this.getOpened() == null) {
            return null;
        }
        int downScaleLevel = this.prepareReader(series, resolution);
        IFormatReader r = this.getReader();
        Rectangle adjRect = rectangle != null ? Rectangle2DUtil.getScaledRectangle(rectangle, this.getResolutionDiviserFactor(), false, true).getBounds() : null;
        try {
            Object object = LociImporterPlugin.getPixelsInternal(r, adjRect, z, t, c, false, downScaleLevel);
            this.releaseReader(r);
            return object;
        }
        catch (Throwable throwable) {
            try {
                this.releaseReader(r);
                throw throwable;
            }
            catch (FormatException e) {
                throw LociImporterPlugin.translateException(this.getOpened(), e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IcyBufferedImage getImage(int series, int resolution, Rectangle rectangle, int z, int t, int c) throws UnsupportedFormatException, IOException {
        if (this.getOpened() == null) {
            return null;
        }
        try {
            int downScaleLevel = this.prepareReader(series, resolution);
            IFormatReader r = this.getReader();
            Rectangle adjRect = rectangle != null ? Rectangle2DUtil.getScaledRectangle(rectangle, this.getResolutionDiviserFactor(), false, true).getBounds() : null;
            try {
                IcyBufferedImage icyBufferedImage = LociImporterPlugin.getImage(r, adjRect, z, t, c, downScaleLevel);
                return icyBufferedImage;
            }
            catch (IOException e) {
                throw e;
            }
            catch (OutOfMemoryError e) {
                if (downScaleLevel <= 0) throw e;
                IcyBufferedImage icyBufferedImage = this.getImageByTile(series, resolution, rectangle, z, t, c, this.getTileWidth(series), this.getTileHeight(series), null);
                return icyBufferedImage;
            }
            catch (UnsupportedOperationException e) {
                if (downScaleLevel <= 0) throw e;
                IcyBufferedImage icyBufferedImage = this.getImageByTile(series, resolution, rectangle, z, t, c, this.getTileWidth(series), this.getTileHeight(series), null);
                return icyBufferedImage;
            }
            catch (FormatException e) {
                if (e.getCause() instanceof ClosedByInterruptException) throw e;
                if (downScaleLevel <= 0) throw e;
                IcyBufferedImage icyBufferedImage = this.getImageByTile(series, resolution, rectangle, z, t, c, this.getTileWidth(series), this.getTileHeight(series), null);
                return icyBufferedImage;
            }
            catch (Exception e) {
                if (downScaleLevel <= 0) throw new UnsupportedOperationException(e);
                IcyBufferedImage icyBufferedImage = this.getImageByTile(series, resolution, rectangle, z, t, c, this.getTileWidth(series), this.getTileHeight(series), null);
                return icyBufferedImage;
            }
            finally {
                this.releaseReader(r);
            }
        }
        catch (FormatException e) {
            throw LociImporterPlugin.translateException(this.getOpened(), e);
        }
    }

    public IcyBufferedImage getImageByTile(int series, int resolution, Rectangle region, int z, int t, int c, int tileW, int tileH, ProgressListener listener) throws UnsupportedFormatException, IOException {
        return (LociImporterPlugin)this.new LociTileImageReader((int)series, (int)resolution, (Rectangle)region, (int)z, (int)t, (int)c, (int)tileW, (int)tileH, (ProgressListener)listener).result;
    }

    @Override
    public Object getPixelsByTile(int series, int resolution, Rectangle region, int z, int t, int c, int tileW, int tileH, ProgressListener listener) throws UnsupportedFormatException, IOException {
        return (LociImporterPlugin)this.new LociTilePixelsReader((int)series, (int)resolution, (Rectangle)region, (int)z, (int)t, (int)c, (int)tileW, (int)tileH, (ProgressListener)listener).result;
    }

    public static IcyBufferedImage getThumbnail(IFormatReader reader, int z, int t) throws UnsupportedOperationException, OutOfMemoryError, FormatException, IOException {
        return LociImporterPlugin.getThumbnail(reader, z, t, -1);
    }

    public static IcyBufferedImage getThumbnail(IFormatReader reader, int z, int t, int c) throws UnsupportedOperationException, OutOfMemoryError, FormatException, IOException {
        try {
            if (c == -1) {
                return LociImporterPlugin.getImageInternal(reader, null, z, t, true, 0);
            }
            return LociImporterPlugin.getImageInternal(reader, null, z, t, c, true, 0);
        }
        catch (ClosedByInterruptException e) {
            return null;
        }
        catch (Exception e) {
            return LociImporterPlugin.getThumbnailCompatible(reader, z, t, c);
        }
    }

    public static IcyBufferedImage getThumbnailCompatible(IFormatReader reader, int z, int t) throws UnsupportedOperationException, OutOfMemoryError, FormatException, IOException {
        return LociImporterPlugin.getThumbnailCompatible(reader, z, t, -1);
    }

    public static IcyBufferedImage getThumbnailCompatible(IFormatReader reader, int z, int t, int c) throws UnsupportedOperationException, OutOfMemoryError, FormatException, IOException {
        IcyBufferedImage image = LociImporterPlugin.getImage(reader, null, z, t, c, 0);
        IcyBufferedImage result = IcyBufferedImageUtil.scale(image, reader.getThumbSizeX(), reader.getThumbSizeY(), IcyBufferedImageUtil.FilterType.BILINEAR);
        result.setColorMaps(image);
        return result;
    }

    public static IcyBufferedImage getImage(IFormatReader reader, Rectangle rect, int z, int t, int c, int downScaleLevel) throws UnsupportedOperationException, OutOfMemoryError, FormatException, IOException {
        if (c == -1) {
            return LociImporterPlugin.getImageInternal(reader, rect, z, t, false, downScaleLevel);
        }
        return LociImporterPlugin.getImageInternal(reader, rect, z, t, c, false, downScaleLevel);
    }

    public static IcyBufferedImage getImage(IFormatReader reader, Rectangle rect, int z, int t, int c) throws UnsupportedOperationException, OutOfMemoryError, FormatException, IOException {
        return LociImporterPlugin.getImage(reader, rect, z, t, c, 0);
    }

    public static IcyBufferedImage getImage(IFormatReader reader, Rectangle rect, int z, int t) throws UnsupportedOperationException, OutOfMemoryError, FormatException, IOException {
        return LociImporterPlugin.getImage(reader, rect, z, t, -1, 0);
    }

    public static IcyBufferedImage getImageCompatible(IFormatReader reader, int z, int t) throws FormatException, IOException {
        int sizeX = reader.getSizeX();
        int sizeY = reader.getSizeY();
        ArrayList<BufferedImage> imageList = new ArrayList<BufferedImage>();
        int sizeC = reader.getEffectiveSizeC();
        for (int c = 0; c < sizeC; ++c) {
            imageList.add(AWTImageTools.openImage(reader.openBytes(reader.getIndex(z, c, t)), reader, sizeX, sizeY));
        }
        return IcyBufferedImage.createFrom(imageList);
    }

    protected static Object getPixelsInternal(IFormatReader reader, Rectangle rect, int z, int t, int c, boolean thumbnail, int downScaleLevel, byte[] rawBuffer, byte[] channelBuffer, Object pixelBuffer) throws UnsupportedOperationException, OutOfMemoryError, FormatException, IOException {
        DataType dataType = DataType.getDataTypeFromFormatToolsType(reader.getPixelType());
        int rgbChanCount = reader.getRGBChannelCount();
        boolean interleaved = reader.isInterleaved();
        boolean little = reader.isLittleEndian();
        Object result = Array1DUtil.allocIfNull(pixelBuffer, dataType, rect.width * rect.height);
        int baseC = c / rgbChanCount;
        int subC = c % rgbChanCount;
        byte[] rawData = LociImporterPlugin.getBytesInternal(reader, reader.getIndex(z, baseC, t), rect, thumbnail, rawBuffer);
        int componentByteLen = rawData.length / rgbChanCount;
        if (interleaved) {
            byte[] channelData = Array1DUtil.getInterleavedData(rawData, subC, rgbChanCount, channelBuffer, 0, componentByteLen);
            ByteArrayConvert.byteArrayTo(channelData, 0, result, 0, componentByteLen, little);
        } else {
            ByteArrayConvert.byteArrayTo(rawData, subC * componentByteLen, result, 0, componentByteLen, little);
        }
        if (downScaleLevel <= 0) {
            return result;
        }
        int it = downScaleLevel;
        int sizeX = rect.width;
        int sizeY = rect.height;
        while (it-- > 0) {
            result = IcyBufferedImageUtil.downscaleBy2(result, sizeX, sizeY, dataType.isSigned(), true);
            sizeX /= 2;
            sizeY /= 2;
        }
        return result;
    }

    protected static Object getPixelsInternal(IFormatReader reader, Rectangle rect, int z, int t, int c, boolean thumbnail, int downScaleLevel) throws UnsupportedOperationException, OutOfMemoryError, FormatException, IOException {
        Rectangle r = thumbnail ? new Rectangle(0, 0, reader.getThumbSizeX(), reader.getThumbSizeY()) : (rect == null ? new Rectangle(0, 0, reader.getSizeX(), reader.getSizeY()) : rect);
        return LociImporterPlugin.getPixelsInternal(reader, r, z, t, c, thumbnail, downScaleLevel, null, null, null);
    }

    protected static IcyBufferedImage getImageInternal(IFormatReader reader, Rectangle rect, int z, int t, int c, boolean thumbnail, int downScaleLevel, byte[] rawBuffer, byte[] channelBuffer, Object pixelBuffer) throws UnsupportedOperationException, OutOfMemoryError, FormatException, IOException {
        Object pixelData = LociImporterPlugin.getPixelsInternal(reader, rect, z, t, c, thumbnail, downScaleLevel, rawBuffer, channelBuffer, pixelBuffer);
        DataType dataType = DataType.getDataTypeFromFormatToolsType(reader.getPixelType());
        int sizeX = rect.width;
        int sizeY = rect.height;
        for (int downScale = downScaleLevel; downScale > 0; --downScale) {
            sizeX /= 2;
            sizeY /= 2;
        }
        IcyBufferedImage result = new IcyBufferedImage(sizeX, sizeY, pixelData, dataType.isSigned());
        IcyColorMap map = null;
        int rgbChannel = reader.getRGBChannelCount();
        if (reader.isIndexed()) {
            switch (dataType.getJavaType()) {
                case BYTE: {
                    byte[][] bmap = reader.get8BitLookupTable();
                    if (bmap == null) break;
                    map = new IcyColorMap("Channel " + c, bmap);
                    break;
                }
                case SHORT: {
                    short[][] smap = reader.get16BitLookupTable();
                    if (smap == null) break;
                    map = new IcyColorMap("Channel " + c, smap);
                    break;
                }
            }
        }
        if (rgbChannel <= 1) {
            if (map == null || map.isBlack()) {
                OMEXMLMetadata metaData = (OMEXMLMetadata)((Object)reader.getMetadataStore());
                Color color = MetaDataUtil.getChannelColor(metaData, reader.getSeries(), c);
                map = color != null && !ColorUtil.isBlack(color) ? new LinearColorMap("Channel " + c, color) : null;
            }
        } else {
            switch (c) {
                case 0: {
                    map = LinearColorMap.red_;
                    break;
                }
                case 1: {
                    map = LinearColorMap.green_;
                    break;
                }
                case 2: {
                    map = LinearColorMap.blue_;
                    break;
                }
                case 3: {
                    map = LinearColorMap.alpha_;
                }
            }
        }
        if (map != null) {
            result.setColorMap(0, map, true);
        }
        return result;
    }

    protected static IcyBufferedImage getImageInternal(IFormatReader reader, Rectangle rect, int z, int t, int c, boolean thumbnail, int downScaleLevel) throws UnsupportedOperationException, OutOfMemoryError, FormatException, IOException {
        Rectangle r = thumbnail ? new Rectangle(0, 0, reader.getThumbSizeX(), reader.getThumbSizeY()) : (rect == null ? new Rectangle(0, 0, reader.getSizeX(), reader.getSizeY()) : rect);
        return LociImporterPlugin.getImageInternal(reader, r, z, t, c, thumbnail, downScaleLevel, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static IcyBufferedImage getImageInternal(IFormatReader reader, Rectangle rect, int z, int t, boolean thumbnail, int downScaleLevel, byte[] rawBuffer, byte[] channelBuffer, Object[] pixelBuffer) throws UnsupportedOperationException, OutOfMemoryError, FormatException, IOException {
        Object[] pixelData;
        DataType dataType = DataType.getDataTypeFromFormatToolsType(reader.getPixelType());
        int effSizeC = reader.getEffectiveSizeC();
        int rgbChanCount = reader.getRGBChannelCount();
        int sizeX = rect.width;
        int sizeY = rect.height;
        int sizeC = effSizeC * rgbChanCount;
        int series = reader.getSeries();
        boolean indexed = reader.isIndexed();
        boolean little = reader.isLittleEndian();
        OMEXMLMetadata metaData = (OMEXMLMetadata)((Object)reader.getMetadataStore());
        if (pixelBuffer == null) {
            pixelData = Array2DUtil.createArray(dataType, sizeC);
            for (int i = 0; i < sizeC; ++i) {
                pixelData[i] = Array1DUtil.createArray(dataType, sizeX * sizeY);
            }
        } else {
            pixelData = pixelBuffer;
        }
        IcyColorMap[] colormaps = new IcyColorMap[effSizeC];
        byte[] rawData = null;
        for (int effC = 0; effC < effSizeC; ++effC) {
            rawData = LociImporterPlugin.getBytesInternal(reader, reader.getIndex(z, effC, t), rect, thumbnail, rawBuffer);
            int c = effC * rgbChanCount;
            int componentByteLen = rawData.length / rgbChanCount;
            int inOffset = 0;
            if (reader.isInterleaved()) {
                byte[] channelData = channelBuffer == null ? new byte[componentByteLen] : channelBuffer;
                for (int sc = 0; sc < rgbChanCount; ++sc) {
                    Array1DUtil.getInterleavedData(rawData, inOffset, rgbChanCount, channelData, 0, componentByteLen);
                    ByteArrayConvert.byteArrayTo(channelData, 0, pixelData[c + sc], 0, componentByteLen, little);
                    ++inOffset;
                }
            } else {
                for (int sc = 0; sc < rgbChanCount; ++sc) {
                    ByteArrayConvert.byteArrayTo(rawData, inOffset, pixelData[c + sc], 0, componentByteLen, little);
                    inOffset += componentByteLen;
                }
            }
            if (indexed) {
                switch (dataType.getJavaType()) {
                    case BYTE: {
                        byte[][] bmap = reader.get8BitLookupTable();
                        if (bmap == null) break;
                        colormaps[effC] = new IcyColorMap("Channel " + effC, bmap);
                        break;
                    }
                    case SHORT: {
                        short[][] smap = reader.get16BitLookupTable();
                        if (smap == null) break;
                        colormaps[effC] = new IcyColorMap("Channel " + effC, smap);
                        break;
                    }
                    default: {
                        colormaps[effC] = null;
                    }
                }
            }
            if (rgbChanCount > 1 || colormaps[effC] != null && !colormaps[effC].isBlack()) continue;
            Color color = MetaDataUtil.getChannelColor(metaData, series, effC);
            colormaps[effC] = color != null && !ColorUtil.isBlack(color) ? new LinearColorMap("Channel " + effC, color) : null;
        }
        IcyBufferedImage result = new IcyBufferedImage(sizeX, sizeY, pixelData, dataType.isSigned());
        result = IcyBufferedImageUtil.downscaleBy2(result, true, downScaleLevel);
        result.beginUpdate();
        try {
            if (rgbChanCount > 1) {
                if (sizeC >= 3 && rgbChanCount >= 3) {
                    result.setColorMap(0, LinearColorMap.red_, true);
                    result.setColorMap(1, LinearColorMap.green_, true);
                    result.setColorMap(2, LinearColorMap.blue_, true);
                }
                if (sizeC >= 4 && (rgbChanCount >= 4 || reader instanceof PNGReader || reader instanceof APNGReader || reader instanceof JPEG2000Reader)) {
                    result.setColorMap(3, LinearColorMap.alpha_, true);
                }
            } else if (sizeC == effSizeC) {
                for (int comp = 0; comp < effSizeC; ++comp) {
                    if (colormaps[comp] == null) continue;
                    result.setColorMap(comp, colormaps[comp], true);
                }
            }
        }
        finally {
            result.endUpdate();
        }
        return result;
    }

    protected static IcyBufferedImage getImageInternal(IFormatReader reader, Rectangle rect, int z, int t, boolean thumbnail, int downScaleLevel) throws FormatException, IOException {
        Rectangle r = thumbnail ? new Rectangle(0, 0, reader.getThumbSizeX(), reader.getThumbSizeY()) : (rect == null ? new Rectangle(0, 0, reader.getSizeX(), reader.getSizeY()) : rect);
        return LociImporterPlugin.getImageInternal(reader, r, z, t, thumbnail, downScaleLevel, null, null, null);
    }

    protected static byte[] getBytesInternal(IFormatReader reader, int index, Rectangle rect, boolean thumbnail, byte[] buffer) throws FormatException, IOException {
        if (thumbnail) {
            return reader.openThumbBytes(index);
        }
        Rectangle imgRect = new Rectangle(0, 0, reader.getSizeX(), reader.getSizeY());
        if (buffer == null) {
            if (rect == null || rect.contains(imgRect)) {
                return reader.openBytes(index);
            }
            return reader.openBytes(index, rect.x, rect.y, rect.width, rect.height);
        }
        if (rect == null || rect.equals(imgRect)) {
            return reader.openBytes(index, buffer);
        }
        return reader.openBytes(index, buffer, rect.x, rect.y, rect.width, rect.height);
    }

    protected static UnsupportedFormatException translateException(String path, FormatException exception) {
        if (exception instanceof UnknownFormatException) {
            return new UnsupportedFormatException(path + ": Unknown image format.", exception);
        }
        if (exception instanceof MissingLibraryException) {
            return new UnsupportedFormatException(path + ": Missing library to load the image.", exception);
        }
        if (exception.getCause() instanceof ClosedByInterruptException) {
            return new UnsupportedFormatException(path + ": loading interrupted.", exception.getCause());
        }
        return new UnsupportedFormatException(path + ": Unsupported image.", exception);
    }

    class LociTileImageReader {
        final Rectangle imageRegion;
        final int downScaleLevel;
        final int resShift;
        final int z;
        final int t;
        final int c;
        final IcyBufferedImage result;
        final IcyColorMap[] colormaps;
        final Stack<TileImageWorkBuffer> buffers;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LociTileImageReader(int series, int resolution, Rectangle region, int z, int t, int c, int tileW, int tileH, ProgressListener listener) throws IOException, UnsupportedFormatException {
            this.z = z;
            this.t = t;
            this.c = c;
            OMEXMLMetadata meta = LociImporterPlugin.this.getOMEXMLMetaData();
            int sizeX = MetaDataUtil.getSizeX(meta, series);
            int sizeY = MetaDataUtil.getSizeY(meta, series);
            DataType type = MetaDataUtil.getDataType(meta, series);
            int sizeC = c == -1 ? MetaDataUtil.getSizeC(meta, series) : 1;
            Rectangle adjRegion = new Rectangle(sizeX, sizeY);
            if (region != null) {
                adjRegion = adjRegion.intersection(region);
            }
            this.downScaleLevel = LociImporterPlugin.this.prepareReader(series, resolution);
            this.resShift = LociImporterPlugin.this.getResolutionShift();
            this.imageRegion = new Rectangle(adjRegion.x >> resolution, adjRegion.y >> resolution, adjRegion.width >> resolution, adjRegion.height >> resolution);
            adjRegion = new Rectangle(adjRegion.x >> this.resShift, adjRegion.y >> this.resShift, adjRegion.width >> this.resShift, adjRegion.height >> this.resShift);
            this.result = new IcyBufferedImage(this.imageRegion.width, this.imageRegion.height, sizeC, type);
            this.colormaps = new IcyColorMap[sizeC];
            int rgbChannelCount = LociImporterPlugin.this.reader.getRGBChannelCount();
            int tw = tileW;
            int th = tileH;
            if (tw <= 0) {
                tw = LociImporterPlugin.this.getTileWidth(series);
            }
            if (tw <= 0) {
                tw = 512;
            }
            if (th <= 0) {
                th = LociImporterPlugin.this.getTileHeight(series);
            }
            if (th <= 0) {
                th = 512;
            }
            int numThread = Math.max(1, SystemUtil.getNumberOfCPUs() - 1);
            this.buffers = new Stack();
            for (int i = 0; i < numThread; ++i) {
                this.buffers.push(new TileImageWorkBuffer(tw, th, sizeC, rgbChannelCount, type));
            }
            Processor readerProcessor = new Processor(numThread);
            readerProcessor.setThreadName("Image tile reader");
            this.result.setVolatile(false);
            this.result.beginUpdate();
            try {
                List<Rectangle> tiles = ImageUtil.getTileList(adjRegion, tw, th);
                for (Rectangle tile : tiles) {
                    while (readerProcessor.isFull()) {
                        try {
                            Thread.sleep(0L);
                        }
                        catch (InterruptedException e) {
                            readerProcessor.shutdownNow();
                            break;
                        }
                    }
                    readerProcessor.submit(new TileImageReaderWorker(tile.intersection(adjRegion)));
                    if (listener == null || listener.notifyProgress(readerProcessor.getCompletedTaskCount(), tiles.size())) continue;
                    readerProcessor.shutdownNow();
                    break;
                }
                while (readerProcessor.isProcessing()) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        readerProcessor.shutdownNow();
                        break;
                    }
                    if (listener == null || listener.notifyProgress(readerProcessor.getCompletedTaskCount(), tiles.size())) continue;
                    readerProcessor.shutdownNow();
                    break;
                }
                readerProcessor.waitAll();
            }
            finally {
                this.result.endUpdate();
            }
            for (int i = 0; i < this.colormaps.length; ++i) {
                this.result.setColorMap(i, this.colormaps[i], true);
            }
            this.result.setVolatile(GeneralPreferences.getVirtualMode());
            this.buffers.clear();
        }

        class TileImageReaderWorker
        implements Runnable {
            final Rectangle region;
            boolean done;
            boolean failed;

            public TileImageReaderWorker(Rectangle region) {
                this.region = region;
                this.done = false;
                this.failed = false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    IFormatReader r = LociImporterPlugin.this.getReader();
                    TileImageWorkBuffer buf = LociTileImageReader.this.buffers.pop();
                    try {
                        IcyBufferedImage img;
                        try {
                            if (LociTileImageReader.this.c == -1) {
                                img = LociImporterPlugin.getImageInternal(r, this.region, LociTileImageReader.this.z, LociTileImageReader.this.t, false, LociTileImageReader.this.downScaleLevel, buf.rawBuffer, buf.channelBuffer, buf.pixelBuffer);
                                if (LociTileImageReader.this.colormaps[0] == null) {
                                    for (int c = 0; c < img.getSizeC(); ++c) {
                                        LociTileImageReader.this.colormaps[c] = img.getColorMap(c);
                                    }
                                }
                            } else {
                                img = LociImporterPlugin.getImageInternal(r, this.region, LociTileImageReader.this.z, LociTileImageReader.this.t, LociTileImageReader.this.c, false, LociTileImageReader.this.downScaleLevel, buf.rawBuffer, buf.channelBuffer, buf.pixelBuffer[0]);
                                if (LociTileImageReader.this.colormaps[0] == null) {
                                    LociTileImageReader.this.colormaps[0] = img.getColorMap(0);
                                }
                            }
                        }
                        finally {
                            LociImporterPlugin.this.releaseReader(r);
                        }
                        Point pt = new Point(this.region.x >> LociTileImageReader.this.downScaleLevel, this.region.y >> LociTileImageReader.this.downScaleLevel);
                        pt.translate(-LociTileImageReader.this.imageRegion.x, -LociTileImageReader.this.imageRegion.y);
                        LociTileImageReader.this.result.copyData(img, null, pt);
                    }
                    finally {
                        LociTileImageReader.this.buffers.push(buf);
                    }
                }
                catch (Exception e) {
                    this.failed = true;
                }
                this.done = true;
            }
        }

        class TileImageWorkBuffer {
            final byte[] rawBuffer;
            final byte[] channelBuffer;
            final Object[] pixelBuffer;

            public TileImageWorkBuffer(int sizeX, int sizeY, int sizeC, int rgbChannel, DataType dataType) {
                this.rawBuffer = new byte[sizeX * sizeY * rgbChannel * dataType.getSize()];
                this.channelBuffer = new byte[sizeX * sizeY * dataType.getSize()];
                this.pixelBuffer = Array2DUtil.createArray(dataType, sizeC);
                for (int i = 0; i < sizeC; ++i) {
                    this.pixelBuffer[i] = Array1DUtil.createArray(dataType, sizeX * sizeY);
                }
            }
        }
    }

    class LociTilePixelsReader {
        final Rectangle imageRegion;
        final int downScaleLevel;
        final int resShift;
        final int z;
        final int t;
        final int c;
        final boolean signed;
        final Object result;
        final Stack<TilePixelsWorkBuffer> buffers;

        public LociTilePixelsReader(int series, int resolution, Rectangle region, int z, int t, int c, int tileW, int tileH, ProgressListener listener) throws IOException, UnsupportedFormatException {
            this.z = z;
            this.t = t;
            this.c = c;
            OMEXMLMetadata meta = LociImporterPlugin.this.getOMEXMLMetaData();
            int sizeX = MetaDataUtil.getSizeX(meta, series);
            int sizeY = MetaDataUtil.getSizeY(meta, series);
            DataType type = MetaDataUtil.getDataType(meta, series);
            this.signed = type.isSigned();
            Rectangle adjRegion = new Rectangle(sizeX, sizeY);
            if (region != null) {
                adjRegion = adjRegion.intersection(region);
            }
            this.downScaleLevel = LociImporterPlugin.this.prepareReader(series, resolution);
            this.resShift = LociImporterPlugin.this.getResolutionShift();
            this.imageRegion = new Rectangle(adjRegion.x >> resolution, adjRegion.y >> resolution, adjRegion.width >> resolution, adjRegion.height >> resolution);
            adjRegion = new Rectangle(adjRegion.x >> this.resShift, adjRegion.y >> this.resShift, adjRegion.width >> this.resShift, adjRegion.height >> this.resShift);
            this.result = Array1DUtil.createArray(type, this.imageRegion.width * this.imageRegion.height);
            int rgbChannelCount = LociImporterPlugin.this.reader.getRGBChannelCount();
            int tw = tileW;
            int th = tileH;
            if (tw <= 0) {
                tw = LociImporterPlugin.this.getTileWidth(series);
            }
            if (tw <= 0) {
                tw = 512;
            }
            if (th <= 0) {
                th = LociImporterPlugin.this.getTileHeight(series);
            }
            if (th <= 0) {
                th = 512;
            }
            int numThread = Math.max(1, SystemUtil.getNumberOfCPUs() - 1);
            this.buffers = new Stack();
            for (int i = 0; i < numThread; ++i) {
                this.buffers.push(new TilePixelsWorkBuffer(tw, th, rgbChannelCount, type));
            }
            Processor readerProcessor = new Processor(numThread);
            readerProcessor.setThreadName("Pixels tile reader");
            List<Rectangle> tiles = ImageUtil.getTileList(adjRegion, tw, th);
            for (Rectangle tile : tiles) {
                while (readerProcessor.isFull()) {
                    try {
                        Thread.sleep(0L);
                    }
                    catch (InterruptedException e) {
                        readerProcessor.shutdownNow();
                        break;
                    }
                }
                readerProcessor.submit(new TilePixelsReaderWorker(tile.intersection(adjRegion)));
                if (listener == null || listener.notifyProgress(readerProcessor.getCompletedTaskCount(), tiles.size())) continue;
                readerProcessor.shutdownNow();
                break;
            }
            while (readerProcessor.isProcessing()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    readerProcessor.shutdownNow();
                    break;
                }
                if (listener == null || listener.notifyProgress(readerProcessor.getCompletedTaskCount(), tiles.size())) continue;
                readerProcessor.shutdownNow();
                break;
            }
            readerProcessor.waitAll();
            this.buffers.clear();
        }

        class TilePixelsReaderWorker
        implements Runnable {
            final Rectangle region;
            boolean done;
            boolean failed;

            public TilePixelsReaderWorker(Rectangle region) {
                this.region = region;
                this.done = false;
                this.failed = false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    IFormatReader r = LociImporterPlugin.this.getReader();
                    TilePixelsWorkBuffer buf = LociTilePixelsReader.this.buffers.pop();
                    try {
                        Object pixels;
                        try {
                            pixels = LociImporterPlugin.getPixelsInternal(r, this.region, LociTilePixelsReader.this.z, LociTilePixelsReader.this.t, LociTilePixelsReader.this.c, false, LociTilePixelsReader.this.downScaleLevel, buf.rawBuffer, buf.channelBuffer, buf.pixelBuffer);
                        }
                        finally {
                            LociImporterPlugin.this.releaseReader(r);
                        }
                        Rectangle adjRegion = new Rectangle(this.region);
                        for (int downScale = LociTilePixelsReader.this.downScaleLevel; downScale > 0; --downScale) {
                            adjRegion.setBounds(adjRegion.x / 2, adjRegion.y / 2, adjRegion.width / 2, adjRegion.height / 2);
                        }
                        Point pt = adjRegion.getLocation();
                        pt.translate(-LociTilePixelsReader.this.imageRegion.x, -LociTilePixelsReader.this.imageRegion.y);
                        Array1DUtil.copyRect(pixels, adjRegion.getSize(), null, LociTilePixelsReader.this.result, LociTilePixelsReader.this.imageRegion.getSize(), pt, LociTilePixelsReader.this.signed);
                    }
                    finally {
                        LociTilePixelsReader.this.buffers.push(buf);
                    }
                }
                catch (Exception e) {
                    this.failed = true;
                }
                this.done = true;
            }
        }

        class TilePixelsWorkBuffer {
            final byte[] rawBuffer;
            final byte[] channelBuffer;
            final Object pixelBuffer;

            public TilePixelsWorkBuffer(int sizeX, int sizeY, int rgbChannel, DataType dataType) {
                this.rawBuffer = new byte[sizeX * sizeY * rgbChannel * dataType.getSize()];
                this.channelBuffer = new byte[sizeX * sizeY * dataType.getSize()];
                this.pixelBuffer = Array1DUtil.createArray(dataType, sizeX * sizeY);
            }
        }
    }

    protected class LociAllFileFilter
    extends LoaderDialog.AllImagesFileFilter {
        protected LociAllFileFilter() {
        }

        @Override
        public String getDescription() {
            return "All image files / Bio-Formats";
        }
    }
}

