/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.roi2d;

import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.common.CollapsibleEvent;
import icy.gui.inspector.RoisPanel;
import icy.image.ImageUtil;
import icy.main.Icy;
import icy.resource.ResourceUtil;
import icy.roi.BooleanMask2D;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROIEvent;
import icy.roi.edit.Area2DChangeROIEdit;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import icy.type.point.Point5D;
import icy.type.rectangle.Rectangle3D;
import icy.util.EventUtil;
import icy.util.GraphicsUtil;
import icy.util.ShapeUtil;
import icy.util.StringUtil;
import icy.util.XMLUtil;
import icy.vtk.IcyVtkPanel;
import icy.vtk.VtkUtil;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import org.w3c.dom.Node;
import plugins.kernel.canvas.VtkCanvas;
import plugins.kernel.roi.roi2d.ROI2DShape;
import vtk.vtkActor;
import vtk.vtkImageData;
import vtk.vtkInformation;
import vtk.vtkMapper;
import vtk.vtkPolyData;
import vtk.vtkPolyDataMapper;
import vtk.vtkProp;

public class ROI2DArea
extends ROI2D {
    protected static final float DEFAULT_CURSOR_SIZE = 15.0f;
    protected static final Ellipse2D brush = new Ellipse2D.Double();
    protected static Color brushColor = Color.red;
    protected static float brushSize = 15.0f;
    public static final String ID_BOUNDS_X = "boundsX";
    public static final String ID_BOUNDS_Y = "boundsY";
    public static final String ID_BOUNDS_W = "boundsW";
    public static final String ID_BOUNDS_H = "boundsH";
    public static final String ID_BOOLMASK_DATA = "boolMaskData";
    protected BufferedImage imageMask;
    protected Rectangle bounds = new Rectangle();
    protected final byte[] red = new byte[256];
    protected final byte[] green = new byte[256];
    protected final byte[] blue = new byte[256];
    protected IndexColorModel colorModel;
    protected byte[] maskData;
    protected double translateX = 0.0;
    protected double translateY = 0.0;
    protected Color previousColor = this.getDisplayColor();
    protected boolean boundsNeedUpdate = false;
    protected boolean roiModifiedByMouse = false;
    protected BooleanMask2D undoSave = null;

    public ROI2DArea() {
        this.red[1] = (byte)this.previousColor.getRed();
        this.green[1] = (byte)this.previousColor.getGreen();
        this.blue[1] = (byte)this.previousColor.getBlue();
        this.colorModel = new IndexColorModel(8, 256, this.red, this.green, this.blue, 0);
        this.imageMask = new BufferedImage(1, 1, 13, this.colorModel);
        this.maskData = ((DataBufferByte)this.imageMask.getRaster().getDataBuffer()).getData();
        this.setIcon(ResourceUtil.ICON_ROI_AREA);
    }

    @Deprecated
    public ROI2DArea(Point2D position, boolean cm) {
        this(position);
    }

    public ROI2DArea(Point2D position) {
        this();
        this.addBrush(position);
    }

    public ROI2DArea(Point5D position) {
        this(position.toPoint2D());
    }

    public ROI2DArea(BooleanMask2D mask) {
        this();
        this.setAsBooleanMask(mask);
    }

    public ROI2DArea(ROI2DArea area) {
        this.red[1] = (byte)this.previousColor.getRed();
        this.green[1] = (byte)this.previousColor.getGreen();
        this.blue[1] = (byte)this.previousColor.getBlue();
        this.colorModel = new IndexColorModel(8, 256, this.red, this.green, this.blue, 0);
        this.imageMask = new BufferedImage(area.bounds.width, area.bounds.height, 13, this.colorModel);
        this.maskData = ((DataBufferByte)this.imageMask.getRaster().getDataBuffer()).getData();
        System.arraycopy(area.maskData, 0, this.maskData, 0, this.maskData.length);
        this.bounds.setBounds(area.bounds);
        this.setIcon(ResourceUtil.ICON_ROI_AREA);
    }

    @Override
    public String getDefaultName() {
        return "Area2D";
    }

    void addToBounds(Rectangle bnd) {
        Rectangle newBounds;
        if (this.bounds.isEmpty()) {
            newBounds = new Rectangle(bnd);
        } else {
            newBounds = new Rectangle(this.bounds);
            newBounds.add(bnd);
        }
        try {
            this.updateImage(newBounds);
        }
        catch (Error E) {
            System.err.println("can't enlarge ROI, no enough memory !");
        }
    }

    @Deprecated
    public void optimizeBounds(boolean removeIfEmpty) {
        this.optimizeBounds();
        if (removeIfEmpty && this.bounds.isEmpty()) {
            this.remove();
        }
    }

    @Override
    public boolean isEmpty() {
        byte[] data;
        if (this.bounds.isEmpty()) {
            return true;
        }
        for (byte b : data = this.maskData) {
            if (b == 0) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean optimizeBounds() {
        Rectangle bnds;
        byte[] data;
        this.boundsNeedUpdate = false;
        ROI2DArea rOI2DArea = this;
        synchronized (rOI2DArea) {
            data = this.maskData;
            bnds = this.bounds;
        }
        int sizeX = bnds.width;
        int sizeY = bnds.height;
        int maxY = 0;
        int minY = 0;
        int maxX = 0;
        int minX = 0;
        boolean empty = true;
        int offset = 0;
        for (int y = 0; y < sizeY; ++y) {
            for (int x = 0; x < sizeX; ++x) {
                if (data[offset++] == 0) continue;
                if (empty) {
                    minX = maxX = x;
                    minY = maxY = y;
                    empty = false;
                    continue;
                }
                if (x < minX) {
                    minX = x;
                } else if (x > maxX) {
                    maxX = x;
                }
                if (y < minY) {
                    minY = y;
                    continue;
                }
                if (y <= maxY) continue;
                maxY = y;
            }
        }
        if (!empty) {
            return this.updateImage(new Rectangle(bnds.x + minX, bnds.y + minY, maxX - minX + 1, maxY - minY + 1));
        }
        return this.updateImage(new Rectangle(bnds.x, bnds.y, 0, 0));
    }

    @Deprecated
    public Color getMaskColor() {
        return this.getOverlay().getDisplayColor();
    }

    void updateMaskColor(boolean rebuildImage) {
        Color color = this.getOverlay().getDisplayColor();
        if (!this.previousColor.equals(color)) {
            this.red[1] = (byte)color.getRed();
            this.green[1] = (byte)color.getGreen();
            this.blue[1] = (byte)color.getBlue();
            this.colorModel = new IndexColorModel(8, 256, this.red, this.green, this.blue, 0);
            if (rebuildImage) {
                this.imageMask = ImageUtil.createIndexedImage(this.imageMask.getWidth(), this.imageMask.getHeight(), this.colorModel, this.maskData);
            }
            this.previousColor = color;
        }
    }

    public BufferedImage getImageMask() {
        return this.imageMask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateImage(Rectangle newBnd) {
        Rectangle bnds;
        byte[] data;
        ROI2DArea rOI2DArea = this;
        synchronized (rOI2DArea) {
            data = this.maskData;
            bnds = this.bounds;
        }
        Rectangle oldBounds = new Rectangle(bnds);
        Rectangle newBounds = new Rectangle(newBnd);
        oldBounds.translate(-bnds.x, -bnds.y);
        newBounds.translate(-bnds.x, -bnds.y);
        if (oldBounds.width != newBounds.width || oldBounds.height != newBounds.height) {
            byte[] newMaskData;
            BufferedImage newImageMask;
            if (!newBounds.isEmpty()) {
                newImageMask = new BufferedImage(newBounds.width, newBounds.height, 13, this.colorModel);
                newMaskData = ((DataBufferByte)newImageMask.getRaster().getDataBuffer()).getData();
                Rectangle intersect = newBounds.intersection(oldBounds);
                if (!intersect.isEmpty()) {
                    int offSrc = 0;
                    int offDst = 0;
                    if (intersect.x > 0) {
                        offSrc += intersect.x;
                    }
                    if (intersect.y > 0) {
                        offSrc += intersect.y * oldBounds.width;
                    }
                    if (newBounds.x < 0) {
                        offDst += -newBounds.x;
                    }
                    if (newBounds.y < 0) {
                        offDst += -newBounds.y * newBounds.width;
                    }
                    for (int j = 0; j < intersect.height; ++j) {
                        System.arraycopy(data, offSrc, newMaskData, offDst, intersect.width);
                        offSrc += oldBounds.width;
                        offDst += newBounds.width;
                    }
                }
            } else {
                newImageMask = new BufferedImage(1, 1, 13, this.colorModel);
                newMaskData = ((DataBufferByte)newImageMask.getRaster().getDataBuffer()).getData();
            }
            ROI2DArea rOI2DArea2 = this;
            synchronized (rOI2DArea2) {
                this.imageMask = newImageMask;
                this.maskData = newMaskData;
                this.bounds = newBnd;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPoint(int x, int y, boolean value) {
        if (value) {
            this.addToBounds(new Rectangle(x, y, 1, 1));
            ROI2DArea rOI2DArea = this;
            synchronized (rOI2DArea) {
                byte[] data = this.maskData;
                Rectangle bnds = this.bounds;
            }
            data[x - bnds.x + (y - bnds.y) * bnds.width] = 1;
            this.roiChanged(true);
        } else {
            Rectangle bnds;
            ROI2DArea rOI2DArea = this;
            synchronized (rOI2DArea) {
                byte[] data = this.maskData;
                bnds = this.bounds;
            }
            if (bnds.contains(x, y)) {
                data[x - bnds.x + (y - bnds.y) * bnds.width] = 0;
                this.boundsNeedUpdate = true;
                this.roiChanged(true);
            }
        }
    }

    @Deprecated
    public void updateMask(int x, int y, boolean remove) {
        this.setPoint(x, y, !remove);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ROI2DArea roi) {
        Rectangle bnds;
        Rectangle boundsToAdd = roi.getBounds();
        byte[] maskToAdd = roi.maskData;
        this.addToBounds(boundsToAdd);
        ROI2DArea rOI2DArea = this;
        synchronized (rOI2DArea) {
            byte[] data = this.maskData;
            bnds = this.bounds;
        }
        int offDst = (boundsToAdd.y - bnds.y) * bnds.width + (boundsToAdd.x - bnds.x);
        int offSrc = 0;
        for (int y = 0; y < boundsToAdd.height; ++y) {
            for (int x = 0; x < boundsToAdd.width; ++x) {
                if (maskToAdd[offSrc++] == 0) continue;
                data[offDst + x] = 1;
            }
            offDst += bnds.width;
        }
        this.roiChanged(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(BooleanMask2D mask) {
        Rectangle bnds;
        Rectangle boundsToAdd = mask.bounds;
        boolean[] maskToAdd = mask.mask;
        this.addToBounds(boundsToAdd);
        ROI2DArea rOI2DArea = this;
        synchronized (rOI2DArea) {
            byte[] data = this.maskData;
            bnds = this.bounds;
        }
        int offDst = (boundsToAdd.y - bnds.y) * bnds.width + (boundsToAdd.x - bnds.x);
        int offSrc = 0;
        for (int y = 0; y < boundsToAdd.height; ++y) {
            for (int x = 0; x < boundsToAdd.width; ++x) {
                if (!maskToAdd[offSrc++]) continue;
                data[offDst + x] = 1;
            }
            offDst += bnds.width;
        }
        this.roiChanged(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exclusiveAdd(ROI2DArea roi) {
        Rectangle bnds;
        byte[] data;
        Rectangle boundsToXAdd = roi.getBounds();
        byte[] maskToXAdd = roi.maskData;
        this.addToBounds(boundsToXAdd);
        ROI2DArea rOI2DArea = this;
        synchronized (rOI2DArea) {
            data = this.maskData;
            bnds = this.bounds;
        }
        int offDst = (boundsToXAdd.y - bnds.y) * bnds.width + (boundsToXAdd.x - bnds.x);
        int offSrc = 0;
        for (int y = 0; y < boundsToXAdd.height; ++y) {
            for (int x = 0; x < boundsToXAdd.width; ++x) {
                if (maskToXAdd[offSrc++] == 0) continue;
                int n = offDst + x;
                data[n] = (byte)(data[n] ^ 1);
            }
            offDst += bnds.width;
        }
        if (this.isUpdating()) {
            this.boundsNeedUpdate = true;
        } else {
            this.optimizeBounds();
        }
        this.roiChanged(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exclusiveAdd(BooleanMask2D mask) {
        Rectangle bnds;
        byte[] data;
        Rectangle boundsToXAdd = mask.bounds;
        boolean[] maskToXAdd = mask.mask;
        this.addToBounds(boundsToXAdd);
        ROI2DArea rOI2DArea = this;
        synchronized (rOI2DArea) {
            data = this.maskData;
            bnds = this.bounds;
        }
        int offDst = (boundsToXAdd.y - bnds.y) * bnds.width + (boundsToXAdd.x - bnds.x);
        int offSrc = 0;
        for (int y = 0; y < boundsToXAdd.height; ++y) {
            for (int x = 0; x < boundsToXAdd.width; ++x) {
                if (!maskToXAdd[offSrc++]) continue;
                int n = offDst + x;
                data[n] = (byte)(data[n] ^ 1);
            }
            offDst += bnds.width;
        }
        if (this.isUpdating()) {
            this.boundsNeedUpdate = true;
        } else {
            this.optimizeBounds();
        }
        this.roiChanged(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subtract(ROI2DArea roi) {
        Rectangle bnds;
        Rectangle boundsToRemove = roi.getBounds();
        byte[] maskToRemove = roi.maskData;
        ROI2DArea rOI2DArea = this;
        synchronized (rOI2DArea) {
            byte[] data = this.maskData;
            bnds = this.bounds;
        }
        Rectangle intersection = bnds.intersection(boundsToRemove);
        if (intersection.isEmpty()) {
            return;
        }
        int offDst = (intersection.y - bnds.y) * bnds.width + (intersection.x - bnds.x);
        int offSrc = (intersection.y - boundsToRemove.y) * boundsToRemove.width + (intersection.x - boundsToRemove.x);
        for (int y = 0; y < intersection.height; ++y) {
            for (int x = 0; x < intersection.width; ++x) {
                if (maskToRemove[offSrc + x] == 0) continue;
                data[offDst + x] = 0;
            }
            offDst += bnds.width;
            offSrc += boundsToRemove.width;
        }
        if (this.isUpdating()) {
            this.boundsNeedUpdate = true;
        } else {
            this.optimizeBounds();
        }
        this.roiChanged(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subtract(BooleanMask2D mask) {
        Rectangle bnds;
        Rectangle boundsToRemove = mask.bounds;
        boolean[] maskToRemove = mask.mask;
        ROI2DArea rOI2DArea = this;
        synchronized (rOI2DArea) {
            byte[] data = this.maskData;
            bnds = this.bounds;
        }
        Rectangle intersection = bnds.intersection(boundsToRemove);
        if (intersection.isEmpty()) {
            return;
        }
        int offDst = (intersection.y - bnds.y) * bnds.width + (intersection.x - bnds.x);
        int offSrc = (intersection.y - boundsToRemove.y) * boundsToRemove.width + (intersection.x - boundsToRemove.x);
        for (int y = 0; y < intersection.height; ++y) {
            for (int x = 0; x < intersection.width; ++x) {
                if (!maskToRemove[offSrc + x]) continue;
                data[offDst + x] = 0;
            }
            offDst += bnds.width;
            offSrc += boundsToRemove.width;
        }
        if (this.isUpdating()) {
            this.boundsNeedUpdate = true;
        } else {
            this.optimizeBounds();
        }
        this.roiChanged(true);
    }

    @Deprecated
    public void remove(ROI2DArea roi) {
        this.subtract(roi);
    }

    @Deprecated
    public void remove(BooleanMask2D mask) {
        this.subtract(mask);
    }

    public void updateMask(Shape shape, boolean remove, boolean inclusive, boolean accurate, boolean immediateUpdate) {
        if (remove) {
            if (!this.bounds.intersects(shape.getBounds2D())) {
                return;
            }
            if (this.isUpdating() || !immediateUpdate) {
                this.boundsNeedUpdate = true;
            }
        } else {
            this.addToBounds(shape.getBounds());
        }
        Graphics2D g = this.imageMask.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (accurate) {
            g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        }
        g.setComposite(AlphaComposite.Src);
        if (remove) {
            g.setColor(new Color(this.colorModel.getRGB(0), true));
        } else {
            g.setColor(new Color(this.colorModel.getRGB(1), true));
        }
        g.translate(-((double)this.bounds.x + 0.5), -((double)this.bounds.y + 0.5));
        g.fill(ShapeUtil.getClosedPath(shape));
        if (inclusive) {
            g.draw(shape);
        }
        g.dispose();
        if (remove && !this.isUpdating() && immediateUpdate) {
            this.optimizeBounds();
        }
        this.roiChanged(true);
    }

    public void updateMask(Shape shape, boolean remove) {
        this.updateMask(shape, remove, true, false, false);
    }

    @Override
    @Deprecated
    public ROI2DAreaPainter getPainter() {
        return this.getOverlay();
    }

    @Override
    public ROI2DAreaPainter getOverlay() {
        return (ROI2DAreaPainter)this.painter;
    }

    @Override
    protected ROI2DAreaPainter createPainter() {
        return new ROI2DAreaPainter();
    }

    @Override
    public boolean hasSelectedPoint() {
        return false;
    }

    @Deprecated
    public boolean canAddPoint() {
        return true;
    }

    @Deprecated
    public boolean canRemovePoint() {
        return true;
    }

    @Deprecated
    public boolean addPointAt(Point2D pos, boolean ctrl) {
        this.addBrush(pos);
        return true;
    }

    @Deprecated
    public boolean removePointAt(IcyCanvas canvas, Point2D pos) {
        this.removeBrush(pos);
        return true;
    }

    @Deprecated
    protected boolean removeSelectedPoint(IcyCanvas canvas, Point2D imagePoint) {
        return false;
    }

    public void addBrush(Point2D pos) {
        this.getOverlay().addToMask(pos);
    }

    public void removeBrush(Point2D pos) {
        this.getOverlay().removeFromMask(pos);
    }

    public void addPoint(Point pos) {
        this.addPoint(pos.x, pos.y);
    }

    public void addPoint(int x, int y) {
        this.setPoint(x, y, true);
    }

    public void removePoint(Point pos) {
        this.removePoint(pos.x, pos.y);
    }

    public void removePoint(int x, int y) {
        this.setPoint(x, y, false);
    }

    public void addRect(Rectangle r) {
        this.updateMask(r, false, false, true, true);
    }

    public void addRect(int x, int y, int w, int h) {
        this.addRect(new Rectangle(x, y, w, h));
    }

    public void removeRect(Rectangle r) {
        this.updateMask(r, true, false, true, true);
    }

    public void removeRect(int x, int y, int w, int h) {
        this.removeRect(new Rectangle(x, y, w, h));
    }

    public void addShape(Shape s) {
        this.updateMask(s, false, false, true, true);
    }

    public void removeShape(Shape s) {
        this.updateMask(s, true, false, true, true);
    }

    @Override
    public ROI add(ROI roi, boolean allowCreate) throws UnsupportedOperationException {
        if (roi instanceof ROI2D) {
            ROI2D roi2d = (ROI2D)roi;
            if (this.getZ() == roi2d.getZ() && this.getT() == roi2d.getT() && this.getC() == roi2d.getC()) {
                if (roi2d instanceof ROI2DArea) {
                    this.add((ROI2DArea)roi2d);
                } else if (roi2d instanceof ROI2DShape) {
                    this.updateMask(((ROI2DShape)roi2d).getShape(), false, true, true, true);
                } else {
                    this.add(roi2d.getBooleanMask(true));
                }
                return this;
            }
        }
        return super.add(roi, allowCreate);
    }

    @Override
    public ROI intersect(ROI roi, boolean allowCreate) throws UnsupportedOperationException {
        if (roi instanceof ROI2D) {
            ROI2D roi2d = (ROI2D)roi;
            if (this.getZ() == roi2d.getZ() && this.getT() == roi2d.getT() && this.getC() == roi2d.getC()) {
                Rectangle intersection = this.getBounds().intersection(roi2d.getBounds());
                BooleanMask2D mask = new BooleanMask2D(intersection, this.getBooleanMask(intersection, true));
                BooleanMask2D roiMask = new BooleanMask2D(intersection, roi2d.getBooleanMask(intersection, true));
                this.setAsBooleanMask(BooleanMask2D.getIntersection(mask, roiMask));
                return this;
            }
        }
        return super.intersect(roi, allowCreate);
    }

    @Override
    public ROI exclusiveAdd(ROI roi, boolean allowCreate) throws UnsupportedOperationException {
        if (roi instanceof ROI2D) {
            ROI2D roi2d = (ROI2D)roi;
            if (this.getZ() == roi2d.getZ() && this.getT() == roi2d.getT() && this.getC() == roi2d.getC()) {
                if (roi2d instanceof ROI2DArea) {
                    this.exclusiveAdd((ROI2DArea)roi2d);
                } else {
                    this.exclusiveAdd(roi2d.getBooleanMask(true));
                }
                return this;
            }
        }
        return super.exclusiveAdd(roi, allowCreate);
    }

    @Override
    public ROI subtract(ROI roi, boolean allowCreate) throws UnsupportedOperationException {
        if (roi instanceof ROI2D) {
            ROI2D roi2d = (ROI2D)roi;
            if (this.getZ() == roi2d.getZ() && this.getT() == roi2d.getT() && this.getC() == roi2d.getC()) {
                if (roi2d instanceof ROI2DArea) {
                    this.subtract((ROI2DArea)roi2d);
                } else if (roi2d instanceof ROI2DShape) {
                    this.updateMask(((ROI2DShape)roi2d).getShape(), true, true, true, true);
                } else {
                    this.subtract(roi2d.getBooleanMask(true));
                }
                return this;
            }
        }
        return super.subtract(roi, allowCreate);
    }

    public boolean getBoundsNeedUpdate() {
        return this.boundsNeedUpdate;
    }

    public void clear() {
        this.updateImage(new Rectangle());
    }

    @Override
    public boolean isOverEdge(IcyCanvas canvas, double x, double y) {
        double strk = this.getAdjustedStroke(canvas) * 3.0;
        Rectangle2D.Double rect = new Rectangle2D.Double(x - strk * 0.5, y - strk * 0.5, strk, strk);
        if (this.getBounds2D().intersects(rect)) {
            return ShapeUtil.pathIntersects(this.bounds.getPathIterator(null, 0.1), rect);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(double x, double y) {
        Rectangle bnds;
        byte[] data;
        ROI2DArea rOI2DArea = this;
        synchronized (rOI2DArea) {
            data = this.maskData;
            bnds = this.bounds;
        }
        if (!bnds.contains(x, y)) {
            return false;
        }
        int yi = (int)y - bnds.y;
        int xi = (int)x - bnds.x;
        return data[yi * bnds.width + xi] != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(double x, double y, double w, double h) {
        Rectangle bnds;
        byte[] data;
        ROI2DArea rOI2DArea = this;
        synchronized (rOI2DArea) {
            data = this.maskData;
            bnds = this.bounds;
        }
        if (!bnds.contains(x, y, w, h)) {
            return false;
        }
        int xi = (int)x - bnds.x;
        int yi = (int)y - bnds.y;
        int wi = (int)(x + w) - (int)x;
        int hi = (int)(y + h) - (int)y;
        int offset = yi * bnds.width + xi;
        for (int j = 0; j < hi; ++j) {
            for (int i = 0; i < wi; ++i) {
                if (data[offset++] != 0) continue;
                return false;
            }
            offset += bnds.width - wi;
        }
        return true;
    }

    @Override
    public Rectangle2D computeBounds2D() {
        return this.bounds;
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.bounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean intersects(double x, double y, double w, double h) {
        Rectangle bnds;
        byte[] data;
        ROI2DArea rOI2DArea = this;
        synchronized (rOI2DArea) {
            data = this.maskData;
            bnds = this.bounds;
        }
        if (!bnds.intersects(x, y, w, h)) {
            return false;
        }
        int xi = (int)x - bnds.x;
        int yi = (int)y - bnds.y;
        int wi = (int)(x + w) - (int)x;
        int hi = (int)(y + h) - (int)y;
        if (xi < 0) {
            wi += xi;
            xi = 0;
        }
        if (yi < 0) {
            hi += yi;
            yi = 0;
        }
        if (xi + wi > bnds.width) {
            wi -= xi + wi - bnds.width;
        }
        if (yi + hi > bnds.height) {
            hi -= yi + hi - bnds.height;
        }
        int offset = yi * bnds.width + xi;
        for (int j = 0; j < hi; ++j) {
            for (int i = 0; i < wi; ++i) {
                if (data[offset++] == 0) continue;
                return true;
            }
            offset += bnds.width - wi;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean[] getBooleanMask(int x, int y, int w, int h, boolean inclusive) {
        Rectangle bnds;
        byte[] data;
        boolean[] result = new boolean[Math.max(0, w) * Math.max(0, h)];
        ROI2DArea rOI2DArea = this;
        synchronized (rOI2DArea) {
            data = this.maskData;
            bnds = this.bounds;
        }
        Rectangle intersect = bnds.intersection(new Rectangle(x, y, w, h));
        if (intersect.isEmpty()) {
            return result;
        }
        int offSrc = 0;
        int offDst = 0;
        if (intersect.x > bnds.x) {
            offSrc += intersect.x - bnds.x;
        }
        if (intersect.y > bnds.y) {
            offSrc += (intersect.y - bnds.y) * bnds.width;
        }
        if (bnds.x > x) {
            offDst += bnds.x - x;
        }
        if (bnds.y > y) {
            offDst += (bnds.y - y) * w;
        }
        for (int j = 0; j < intersect.height; ++j) {
            for (int i = 0; i < intersect.width; ++i) {
                result[offDst++] = data[offSrc++] != 0;
            }
            offSrc += bnds.width - intersect.width;
            offDst += w - intersect.width;
        }
        return result;
    }

    @Override
    public double computeNumberOfPoints() {
        double result = 0.0;
        byte[] data = this.maskData;
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == 0) continue;
            result += 1.0;
        }
        return result;
    }

    @Override
    public boolean canTranslate() {
        return true;
    }

    @Override
    public void translate(double dx, double dy) {
        this.translateX += dx;
        this.translateY += dy;
        int dxi = (int)this.translateX;
        int dyi = (int)this.translateY;
        this.translateX -= (double)dxi;
        this.translateY -= (double)dyi;
        if (dxi != 0 || dyi != 0) {
            this.bounds.translate(dxi, dyi);
            this.roiChanged(false);
        }
    }

    @Override
    public boolean canSetPosition() {
        return true;
    }

    @Override
    public void setPosition2D(Point2D newPosition) {
        this.bounds = new Rectangle((int)newPosition.getX(), (int)newPosition.getY(), this.bounds.width, this.bounds.height);
        this.roiChanged(false);
    }

    public void setAsBooleanMask(BooleanMask2D mask) {
        if (mask == null || mask.isEmpty()) {
            this.clear();
        } else {
            this.setAsBooleanMask(mask.bounds, mask.mask, false);
        }
    }

    protected void setAsByteMask(Rectangle r, byte[] mask, boolean doBoundsOptimization) {
        this.updateImage(r);
        System.arraycopy(mask, 0, this.maskData, 0, r.width * r.height);
        if (doBoundsOptimization) {
            if (this.isUpdating()) {
                this.boundsNeedUpdate = true;
            } else {
                this.optimizeBounds();
            }
        }
        this.roiChanged(true);
    }

    protected void setAsBooleanMask(Rectangle r, boolean[] booleanMask, boolean doBoundsOptimization) {
        this.updateImage(r);
        byte[] data = this.maskData;
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)(booleanMask[i] ? 1 : 0);
        }
        if (doBoundsOptimization) {
            if (this.isUpdating()) {
                this.boundsNeedUpdate = true;
            } else {
                this.optimizeBounds();
            }
        }
        this.roiChanged(true);
    }

    public void setAsBooleanMask(Rectangle r, boolean[] booleanMask) {
        this.setAsBooleanMask(r, booleanMask, true);
    }

    public void setAsBooleanMask(int x, int y, int w, int h, boolean[] booleanMask) {
        this.setAsBooleanMask(new Rectangle(x, y, w, h), booleanMask);
    }

    public void upscale() {
        this.setAsBooleanMask(this.getBooleanMask(true).upscale());
    }

    public void downscale(int nbPointForTrue) {
        this.setAsBooleanMask(this.getBooleanMask(true).downscale(nbPointForTrue));
    }

    public void downscale() {
        this.setAsBooleanMask(this.getBooleanMask(true).downscale());
    }

    @Override
    public void onChanged(CollapsibleEvent object) {
        ROIEvent event = (ROIEvent)object;
        switch (event.getType()) {
            case ROI_CHANGED: {
                if (this.boundsNeedUpdate && !this.roiModifiedByMouse && this.optimizeBounds()) {
                    this.roiChanged(true);
                }
                if (StringUtil.equals(event.getPropertyName(), "all")) {
                    this.getOverlay().needRebuild = true;
                    break;
                }
                ROI2DAreaPainter overlay = this.getOverlay();
                if (overlay.lastBuildPosZ != this.getZ()) {
                    overlay.needRebuild = true;
                    break;
                }
                overlay.updateVtkObjectsBounds();
                break;
            }
            case FOCUS_CHANGED: 
            case SELECTION_CHANGED: {
                this.getOverlay().updateVtkDisplayProperties();
                break;
            }
            case PROPERTY_CHANGED: {
                String property = event.getPropertyName();
                if (!StringUtil.equals(property, "stroke") && !StringUtil.equals(property, "color") && !StringUtil.equals(property, "opacity")) break;
                this.getOverlay().updateVtkDisplayProperties();
                break;
            }
        }
        super.onChanged(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadFromXML(Node node) {
        this.beginUpdate();
        try {
            if (!super.loadFromXML(node)) {
                boolean bl = false;
                return bl;
            }
            Rectangle rect = new Rectangle();
            rect.x = XMLUtil.getElementIntValue(node, ID_BOUNDS_X, 0);
            rect.y = XMLUtil.getElementIntValue(node, ID_BOUNDS_Y, 0);
            rect.width = XMLUtil.getElementIntValue(node, ID_BOUNDS_W, 0);
            rect.height = XMLUtil.getElementIntValue(node, ID_BOUNDS_H, 0);
            byte[] data = XMLUtil.getElementBytesValue(node, ID_BOOLMASK_DATA, new byte[0]);
            if (data == null) {
                boolean bl = false;
                return bl;
            }
            this.setAsByteMask(rect, data, false);
        }
        finally {
            this.endUpdate();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveToXML(Node node) {
        if (!super.saveToXML(node)) {
            return false;
        }
        byte[] byArray = this.maskData;
        synchronized (this.maskData) {
            byte[] data = (byte[])this.maskData.clone();
            Rectangle bnds = new Rectangle(this.bounds);
            // ** MonitorExit[var4_2] (shouldn't be in output)
            int len = bnds.width * bnds.height;
            if (len > 0 && len != data.length) {
                return false;
            }
            XMLUtil.setElementIntValue(node, ID_BOUNDS_X, bnds.x);
            XMLUtil.setElementIntValue(node, ID_BOUNDS_Y, bnds.y);
            XMLUtil.setElementIntValue(node, ID_BOUNDS_W, bnds.width);
            XMLUtil.setElementIntValue(node, ID_BOUNDS_H, bnds.height);
            if (len > 0) {
                XMLUtil.setElementBytesValue(node, ID_BOOLMASK_DATA, data);
            }
            return true;
        }
    }

    public class ROI2DAreaPainter
    extends ROI2D.ROI2DPainter
    implements Runnable {
        @Deprecated
        public static final float CONTENT_ALPHA = 0.3f;
        private static final float MIN_CURSOR_SIZE = 0.3f;
        private static final float MAX_CURSOR_SIZE = 500.0f;
        protected vtkPolyData outline;
        protected vtkPolyDataMapper outlineMapper;
        protected vtkActor outlineActor;
        protected vtkInformation vtkInfo;
        protected vtkPolyData polyData;
        protected vtkPolyDataMapper polyMapper;
        protected vtkActor surfaceActor;
        protected boolean needRebuild;
        protected double[] scaling;
        protected WeakReference<VtkCanvas> canvas3d;
        protected int lastBuildPosZ;
        protected boolean hovered;
        protected final Point2D brushPosition;

        public ROI2DAreaPainter() {
            super(ROI2DArea.this);
            this.brushPosition = new Point2D.Double();
            this.outline = null;
            this.outlineMapper = null;
            this.outlineActor = null;
            this.vtkInfo = null;
            this.polyData = null;
            this.polyMapper = null;
            this.surfaceActor = null;
            this.scaling = new double[3];
            Arrays.fill(this.scaling, 1.0);
            this.needRebuild = true;
            this.canvas3d = new WeakReference<Object>(null);
            this.lastBuildPosZ = ROI2DArea.this.getZ();
            this.hovered = false;
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (this.surfaceActor != null) {
                this.surfaceActor.Delete();
            }
            if (this.polyMapper != null) {
                this.polyMapper.Delete();
            }
            if (this.polyData != null) {
                this.polyData.GetPointData().GetScalars().Delete();
                this.polyData.GetPointData().Delete();
                this.polyData.Delete();
            }
            if (this.outlineActor != null) {
                this.outlineActor.SetPropertyKeys(null);
                this.outlineActor.Delete();
            }
            if (this.vtkInfo != null) {
                this.vtkInfo.Remove(VtkCanvas.visibilityKey);
                this.vtkInfo.Delete();
            }
            if (this.outlineMapper != null) {
                this.outlineMapper.Delete();
            }
            if (this.outline != null) {
                this.outline.GetPointData().GetScalars().Delete();
                this.outline.GetPointData().Delete();
                this.outline.Delete();
            }
        }

        protected void initVtkObjects() {
            this.outline = VtkUtil.getOutline(0.0, 1.0, 0.0, 1.0, 0.0, 1.0);
            this.outlineMapper = new vtkPolyDataMapper();
            this.outlineMapper.SetInputData(this.outline);
            this.outlineActor = new vtkActor();
            this.outlineActor.SetMapper((vtkMapper)this.outlineMapper);
            this.outlineActor.SetPickable(0);
            this.outlineActor.GetProperty().SetRepresentationToWireframe();
            this.vtkInfo = new vtkInformation();
            this.vtkInfo.Set(VtkCanvas.visibilityKey, 0);
            this.outlineActor.SetPropertyKeys(this.vtkInfo);
            this.polyMapper = new vtkPolyDataMapper();
            this.surfaceActor = new vtkActor();
            this.surfaceActor.SetMapper((vtkMapper)this.polyMapper);
            Color col = this.getColor();
            double r = (double)col.getRed() / 255.0;
            double g = (double)col.getGreen() / 255.0;
            double b = (double)col.getBlue() / 255.0;
            this.outlineActor.GetProperty().SetColor(r, g, b);
            this.surfaceActor.GetProperty().SetColor(r, g, b);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void rebuildVtkObjects() {
            VtkCanvas canvas = (VtkCanvas)this.canvas3d.get();
            if (canvas == null) {
                return;
            }
            IcyVtkPanel vtkPanel = canvas.getVtkPanel();
            if (vtkPanel == null) {
                return;
            }
            Sequence seq = canvas.getSequence();
            if (seq == null) {
                return;
            }
            vtkPolyData previousPolyData = this.polyData;
            vtkImageData imageData = VtkUtil.getBinaryImageData(ROI2DArea.this, seq.getSizeZ(), canvas.getPositionT());
            imageData.SetSpacing(this.scaling[0], this.scaling[1], this.scaling[2]);
            this.polyData = VtkUtil.getSurfaceFromImage(imageData, 0.5);
            Rectangle3D bounds = ROI2DArea.this.getBounds5D().toRectangle3D();
            bounds.setX(bounds.getX() * this.scaling[0]);
            bounds.setSizeX(bounds.getSizeX() * this.scaling[0]);
            bounds.setY(bounds.getY() * this.scaling[1]);
            bounds.setSizeY(bounds.getSizeY() * this.scaling[1]);
            if (bounds.isInfiniteZ()) {
                bounds.setZ(0.0);
                bounds.setSizeZ((double)seq.getSizeZ() * this.scaling[2]);
                this.lastBuildPosZ = -1;
            } else {
                this.lastBuildPosZ = ROI2DArea.this.getZ();
                bounds.setZ(bounds.getZ() * this.scaling[2]);
                bounds.setSizeZ(1.0 * this.scaling[2]);
            }
            vtkPanel.lock();
            try {
                VtkUtil.setOutlineBounds(this.outline, bounds.getMinX(), bounds.getMaxX(), bounds.getMinY(), bounds.getMaxY(), bounds.getMinZ(), bounds.getMaxZ(), canvas);
                this.outlineMapper.Update();
                this.polyMapper.SetInputData(this.polyData);
                this.polyMapper.Update();
                this.surfaceActor.SetPosition(bounds.getX(), bounds.getY(), bounds.getZ());
                imageData.GetPointData().GetScalars().Delete();
                imageData.GetPointData().Delete();
                imageData.Delete();
                if (previousPolyData != null) {
                    previousPolyData.GetPointData().GetScalars().Delete();
                    previousPolyData.GetPointData().Delete();
                    previousPolyData.Delete();
                }
            }
            finally {
                vtkPanel.unlock();
            }
            this.updateVtkDisplayProperties();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateVtkDisplayProperties() {
            IcyVtkPanel vtkPanel;
            if (this.surfaceActor == null) {
                return;
            }
            VtkCanvas cnv = (VtkCanvas)this.canvas3d.get();
            Color col = this.getDisplayColor();
            double r = (double)col.getRed() / 255.0;
            double g = (double)col.getGreen() / 255.0;
            double b = (double)col.getBlue() / 255.0;
            IcyVtkPanel icyVtkPanel = vtkPanel = cnv != null ? cnv.getVtkPanel() : null;
            if (vtkPanel != null) {
                vtkPanel.lock();
            }
            try {
                this.outlineActor.GetProperty().SetColor(r, g, b);
                if (ROI2DArea.this.isSelected()) {
                    this.outlineActor.GetProperty().SetRepresentationToWireframe();
                    this.outlineActor.SetVisibility(1);
                    this.vtkInfo.Set(VtkCanvas.visibilityKey, 1);
                } else {
                    this.outlineActor.GetProperty().SetRepresentationToPoints();
                    this.outlineActor.SetVisibility(0);
                    this.vtkInfo.Set(VtkCanvas.visibilityKey, 0);
                }
                this.surfaceActor.GetProperty().SetColor(r, g, b);
                this.setVtkObjectsColor(col);
            }
            finally {
                if (vtkPanel != null) {
                    vtkPanel.unlock();
                }
            }
            this.painterChanged();
        }

        protected void setVtkObjectsColor(Color color) {
            if (this.outline != null) {
                VtkUtil.setPolyDataColor(this.outline, color, (VtkCanvas)this.canvas3d.get());
            }
            if (this.polyData != null) {
                VtkUtil.setPolyDataColor(this.polyData, color, (VtkCanvas)this.canvas3d.get());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateVtkObjectsBounds() {
            VtkCanvas canvas = (VtkCanvas)this.canvas3d.get();
            if (canvas == null) {
                return;
            }
            IcyVtkPanel vtkPanel = canvas.getVtkPanel();
            if (vtkPanel == null) {
                return;
            }
            Sequence seq = canvas.getSequence();
            if (seq == null) {
                return;
            }
            Rectangle3D bounds = ROI2DArea.this.getBounds5D().toRectangle3D();
            bounds.setX(bounds.getX() * this.scaling[0]);
            bounds.setSizeX(bounds.getSizeX() * this.scaling[0]);
            bounds.setY(bounds.getY() * this.scaling[1]);
            bounds.setSizeY(bounds.getSizeY() * this.scaling[1]);
            if (bounds.isInfiniteZ()) {
                bounds.setZ(0.0);
                bounds.setSizeZ((double)seq.getSizeZ() * this.scaling[2]);
            } else {
                bounds.setZ(bounds.getZ() * this.scaling[2]);
                bounds.setSizeZ(1.0 * this.scaling[2]);
            }
            vtkPanel.lock();
            try {
                VtkUtil.setOutlineBounds(this.outline, bounds.getMinX(), bounds.getMaxX(), bounds.getMinY(), bounds.getMaxY(), bounds.getMinZ(), bounds.getMaxZ(), canvas);
                this.outlineMapper.Update();
                this.surfaceActor.SetPosition(bounds.getX(), bounds.getY(), bounds.getZ());
            }
            finally {
                vtkPanel.unlock();
            }
        }

        void updateCursor() {
            double x = this.brushPosition.getX();
            double y = this.brushPosition.getY();
            brush.setFrameFromDiagonal(x - (double)brushSize, y - (double)brushSize, x + (double)brushSize, y + (double)brushSize);
            if (ROI2DArea.this.isSelected()) {
                this.painterChanged();
            }
        }

        public Point2D getBrushPosition() {
            return (Point)this.brushPosition.clone();
        }

        public void setBrushPosition(Point2D position) {
            if (!this.brushPosition.equals(position)) {
                this.brushPosition.setLocation(position);
                this.updateCursor();
            }
        }

        @Deprecated
        public Point2D getCursorPosition() {
            return this.getBrushPosition();
        }

        @Deprecated
        public void setCursorPosition(Point2D position) {
            this.setBrushPosition(position);
        }

        public float getBrushSize() {
            return brushSize;
        }

        public void setBrushSize(float value) {
            float adjValue = Math.max(Math.min(value, 500.0f), 0.3f);
            if (brushSize != adjValue) {
                brushSize = adjValue;
                this.updateCursor();
            }
        }

        @Deprecated
        public float getCursorSize() {
            return this.getBrushSize();
        }

        @Deprecated
        public void setCursorSize(float value) {
            this.setBrushSize(value);
        }

        public Color getBrushColor() {
            return brushColor;
        }

        public void setBrushColor(Color value) {
            if (!brushColor.equals(value)) {
                brushColor = value;
                this.painterChanged();
            }
        }

        @Deprecated
        public Color getCursorColor() {
            return this.getBrushColor();
        }

        @Deprecated
        public void setCursorColor(Color value) {
            this.setBrushColor(value);
        }

        public void addToMask(Point2D pos) {
            this.setBrushPosition(pos);
            ROI2DArea.this.updateMask(brush, false);
        }

        public void removeFromMask(Point2D pos) {
            this.setBrushPosition(pos);
            ROI2DArea.this.updateMask(brush, true);
        }

        @Override
        public void painterChanged() {
            ROI2DArea.this.updateMaskColor(true);
            super.painterChanged();
        }

        @Override
        protected boolean updateFocus(InputEvent e, Point5D imagePoint, IcyCanvas canvas) {
            if (canvas instanceof VtkCanvas) {
                boolean focused = this.surfaceActor != null && this.surfaceActor == ((VtkCanvas)canvas).getPickedObject();
                ROI2DArea.this.setFocused(focused);
                return focused;
            }
            this.setHovered(ROI2DArea.this.contains(imagePoint.getX(), imagePoint.getY()));
            return super.updateFocus(e, imagePoint, canvas);
        }

        public void setHovered(boolean value) {
            if (this.hovered != value) {
                this.hovered = value;
                ROI2DArea.this.roiChanged(false);
            }
        }

        public boolean isHovered() {
            return this.hovered;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void keyPressed(KeyEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            super.keyPressed(e, imagePoint, canvas);
            if (canvas instanceof VtkCanvas) {
                return;
            }
            if (e.isConsumed()) return;
            if (this.isReadOnly()) return;
            if (!ROI2DArea.this.isActiveFor(canvas)) return;
            ROI2DArea.this.beginUpdate();
            try {
                switch (e.getKeyChar()) {
                    case '+': {
                        if (!ROI2DArea.this.isSelected()) return;
                        this.setBrushSize(this.getBrushSize() * 1.1f);
                        e.consume();
                        return;
                    }
                    case '-': {
                        if (!ROI2DArea.this.isSelected()) return;
                        this.setBrushSize(this.getBrushSize() * 0.9f);
                        e.consume();
                        return;
                    }
                }
                return;
            }
            finally {
                ROI2DArea.this.endUpdate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mousePressed(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            super.mousePressed(e, imagePoint, canvas);
            if (canvas instanceof VtkCanvas) {
                return;
            }
            if (imagePoint == null) {
                return;
            }
            if (!e.isConsumed() && !this.isReadOnly() && ROI2DArea.this.isSelected() && !ROI2DArea.this.isFocused() && ROI2DArea.this.isActiveFor(canvas)) {
                ROI2DArea.this.roiModifiedByMouse = false;
                ROI2DArea.this.undoSave = ROI2DArea.this.getBooleanMask(true);
                ROI2DArea.this.beginUpdate();
                try {
                    if (EventUtil.isLeftMouseButton(e)) {
                        this.addToMask(imagePoint.toPoint2D());
                        ROI2DArea.this.roiModifiedByMouse = true;
                        e.consume();
                    } else if (EventUtil.isRightMouseButton(e)) {
                        this.removeFromMask(imagePoint.toPoint2D());
                        ROI2DArea.this.roiModifiedByMouse = true;
                        e.consume();
                    }
                }
                finally {
                    ROI2DArea.this.endUpdate();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            super.mouseReleased(e, imagePoint, canvas);
            if (!this.isReadOnly() && ROI2DArea.this.roiModifiedByMouse) {
                if (ROI2DArea.this.boundsNeedUpdate && ROI2DArea.this.optimizeBounds()) {
                    ROI2DArea.this.roiChanged(true);
                    if (ROI2DArea.this.bounds.isEmpty()) {
                        ROI2DArea.this.remove();
                        return;
                    }
                }
                Sequence sequence = canvas.getSequence();
                try {
                    if (sequence != null && ROI2DArea.this.undoSave != null) {
                        sequence.addUndoableEdit(new Area2DChangeROIEdit(ROI2DArea.this, ROI2DArea.this.undoSave));
                    }
                }
                catch (OutOfMemoryError err) {
                    System.out.println("Warning: not enough memory to create undo point for ROI area change");
                    sequence.clearUndoManager();
                }
                ROI2DArea.this.undoSave = null;
                ROI2DArea.this.roiModifiedByMouse = false;
            }
        }

        @Override
        public void mouseClick(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            RoisPanel roiPanel;
            int clickCount;
            if (imagePoint != null) {
                this.mouseClick(e, imagePoint.toPoint2D(), canvas);
            } else {
                this.mouseClick(e, (Point2D)null, canvas);
            }
            if (!e.isConsumed() && ROI2DArea.this.isActiveFor(canvas) && (clickCount = e.getClickCount()) == 2 && ROI2DArea.this.isFocused() && (roiPanel = Icy.getMainInterface().getRoisPanel()) != null) {
                roiPanel.scrollTo(ROI2DArea.this);
                e.consume();
            }
        }

        @Override
        public void mouseMove(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            super.mouseMove(e, imagePoint, canvas);
            if (canvas instanceof VtkCanvas) {
                return;
            }
            if (imagePoint == null) {
                return;
            }
            if (!e.isConsumed() && !this.isReadOnly() && ROI2DArea.this.isSelected() && ROI2DArea.this.isActiveFor(canvas)) {
                this.setBrushPosition(imagePoint.toPoint2D());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseDrag(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            super.mouseDrag(e, imagePoint, canvas);
            if (canvas instanceof VtkCanvas) {
                return;
            }
            if (imagePoint == null) {
                return;
            }
            if (!e.isConsumed() && !this.isReadOnly() && ROI2DArea.this.isSelected() && ROI2DArea.this.isActiveFor(canvas)) {
                ROI2DArea.this.beginUpdate();
                try {
                    if (EventUtil.isLeftMouseButton(e)) {
                        this.addToMask(imagePoint.toPoint2D());
                        ROI2DArea.this.roiModifiedByMouse = true;
                        e.consume();
                    } else if (EventUtil.isRightMouseButton(e)) {
                        this.removeFromMask(imagePoint.toPoint2D());
                        ROI2DArea.this.roiModifiedByMouse = true;
                        e.consume();
                    }
                }
                finally {
                    ROI2DArea.this.endUpdate();
                }
            }
        }

        @Override
        public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
            super.paint(g, sequence, canvas);
            if (ROI2DArea.this.isActiveFor(canvas) && ROI2DArea.this.isSelected() && !ROI2DArea.this.isFocused() && !this.isReadOnly()) {
                this.drawCursor(g, sequence, canvas);
            }
        }

        @Override
        public void drawROI(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
            if (canvas instanceof IcyCanvas2D) {
                if (g == null) {
                    return;
                }
                Rectangle bounds = ROI2DArea.this.getBounds();
                boolean shapeVisible = GraphicsUtil.isVisible((Graphics)g, bounds);
                if (shapeVisible) {
                    boolean small;
                    Graphics2D g2 = (Graphics2D)g.create();
                    if (ROI2DArea.this.isCreating()) {
                        small = false;
                    } else {
                        double scale = Math.max(Math.abs(canvas.getScaleX()), Math.abs(canvas.getScaleY()));
                        boolean bl = small = Math.max(scale * bounds.getWidth(), scale * bounds.getHeight()) < 10.0;
                    }
                    if (small) {
                        g2.setColor(this.getDisplayColor());
                        g2.drawImage(ROI2DArea.this.imageMask, null, bounds.x, bounds.y);
                    } else {
                        AlphaComposite prevAlpha = (AlphaComposite)g2.getComposite();
                        float newAlpha = prevAlpha.getAlpha() * this.getOpacity();
                        newAlpha = Math.min(1.0f, newAlpha);
                        newAlpha = Math.max(0.0f, newAlpha);
                        g2.setComposite(prevAlpha.derive(newAlpha));
                        g2.drawImage(ROI2DArea.this.imageMask, null, bounds.x, bounds.y);
                        g2.setComposite(prevAlpha);
                        if (ROI2DArea.this.isSelected()) {
                            g2.setStroke(new BasicStroke((float)ROI.getAdjustedStroke(canvas, this.stroke + 1.0)));
                            g2.setColor(this.getDisplayColor());
                            g2.draw(bounds);
                        } else if (ROI2DArea.this.isFocused() || this.isHovered()) {
                            g2.setStroke(new BasicStroke((float)ROI.getAdjustedStroke(canvas, this.stroke + 1.0)));
                            g2.setColor(Color.black);
                            g2.draw(bounds);
                            g2.setStroke(new BasicStroke((float)ROI.getAdjustedStroke(canvas, this.stroke)));
                            g2.setColor(this.getDisplayColor());
                            g2.draw(bounds);
                        }
                    }
                    g2.dispose();
                }
            }
            if (canvas instanceof VtkCanvas) {
                double[] s;
                VtkCanvas cnv = (VtkCanvas)canvas;
                if (this.canvas3d.get() != cnv) {
                    this.canvas3d = new WeakReference<VtkCanvas>(cnv);
                }
                if (this.surfaceActor == null) {
                    this.initVtkObjects();
                }
                if (!Arrays.equals(this.scaling, s = cnv.getVolumeScale())) {
                    this.scaling = s;
                    this.needRebuild = true;
                }
                if (this.needRebuild) {
                    ThreadUtil.runSingle(this);
                    this.needRebuild = false;
                }
            }
        }

        protected void drawCursor(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
            if (canvas instanceof IcyCanvas2D) {
                if (g == null) {
                    return;
                }
                Rectangle bounds = brush.getBounds();
                boolean shapeVisible = GraphicsUtil.isVisible((Graphics)g, bounds);
                if (shapeVisible) {
                    boolean tiny;
                    Graphics2D g2 = (Graphics2D)g.create();
                    if (ROI2DArea.this.isCreating()) {
                        tiny = false;
                    } else {
                        double scale = Math.max(canvas.getScaleX(), canvas.getScaleY());
                        boolean bl = tiny = Math.max(scale * bounds.getWidth(), scale * bounds.getHeight()) < 4.0;
                    }
                    if (tiny) {
                        g2.setColor(brushColor);
                        g2.fill(brush);
                    } else {
                        AlphaComposite prevAlpha = (AlphaComposite)g2.getComposite();
                        float newAlpha = prevAlpha.getAlpha() * this.getOpacity() * 2.0f;
                        newAlpha = Math.min(1.0f, newAlpha);
                        newAlpha = Math.max(0.0f, newAlpha);
                        g2.setComposite(prevAlpha.derive(newAlpha));
                        g2.setColor(Color.black);
                        g2.setStroke(new BasicStroke((float)ROI.getAdjustedStroke(canvas, this.stroke)));
                        g2.draw(brush);
                        g2.setColor(brushColor);
                        g2.fill(brush);
                    }
                    g2.dispose();
                }
            }
        }

        @Override
        public vtkProp[] getProps() {
            if (this.surfaceActor == null) {
                this.initVtkObjects();
            }
            return new vtkActor[]{this.surfaceActor, this.outlineActor};
        }

        @Override
        public void run() {
            this.rebuildVtkObjects();
        }
    }
}

