/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.roi2d;

import icy.painter.Anchor2D;
import icy.painter.PathAnchor2D;
import icy.resource.ResourceUtil;
import icy.roi.ROI;
import icy.type.point.Point5D;
import icy.util.ShapeUtil;
import icy.util.XMLUtil;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.kernel.roi.roi2d.ROI2DShape;

public class ROI2DPath
extends ROI2DShape {
    public static final String ID_POINTS = "points";
    public static final String ID_POINT = "point";
    public static final String ID_WINDING = "winding";
    protected Area closedArea;
    protected Path2D openPath;

    static Path2D initPath(Point2D position) {
        Path2D.Double result = new Path2D.Double();
        result.reset();
        if (position != null) {
            ((Path2D)result).moveTo(position.getX(), position.getY());
        }
        return result;
    }

    public ROI2DPath(Path2D path, Area closedArea, Path2D openPath) {
        super(path);
        this.rebuildControlPointsFromPath();
        this.closedArea = closedArea == null ? new Area(ShapeUtil.getClosedPath(path)) : closedArea;
        this.openPath = openPath == null ? ShapeUtil.getOpenPath(path) : openPath;
        this.setIcon(ResourceUtil.ICON_ROI_POLYLINE);
    }

    public ROI2DPath(Path2D path) {
        this(path, null, null);
    }

    public ROI2DPath(Shape shape) {
        this(new Path2D.Double(shape), shape instanceof Area ? (Area)shape : null, null);
    }

    @Deprecated
    public ROI2DPath(Point2D pt, boolean cm) {
        this(pt);
    }

    public ROI2DPath(Point2D position) {
        this(ROI2DPath.initPath(position));
    }

    public ROI2DPath(Point5D pt) {
        this(pt.toPoint2D());
    }

    public ROI2DPath() {
        this(new Path2D.Double(1));
    }

    @Override
    public String getDefaultName() {
        return "Path2D";
    }

    @Override
    protected Anchor2D createAnchor(Point2D pos) {
        return new PathAnchor2D(pos.getX(), pos.getY(), this.getColor(), this.getFocusedColor());
    }

    protected void rebuildControlPointsFromPath() {
        this.beginUpdate();
        try {
            this.removeAllPoint();
            for (Anchor2D anchor2D : ShapeUtil.getAnchorsFromShape(this.getPath(), this.getColor(), this.getFocusedColor())) {
                this.addPoint(anchor2D);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    protected Path2D getPath() {
        return (Path2D)this.shape;
    }

    public Area getClosedArea() {
        return this.closedArea;
    }

    public Path2D getOpenPath() {
        return this.openPath;
    }

    @Override
    public boolean canAddPoint() {
        return false;
    }

    @Override
    public boolean contains(double x, double y) {
        return ShapeUtil.getClosedPath(this.getPath()).contains(x, y);
    }

    @Override
    public boolean contains(Point2D p) {
        return ShapeUtil.getClosedPath(this.getPath()).contains(p);
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return ShapeUtil.getClosedPath(this.getPath()).contains(x, y, w, h);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return ShapeUtil.getClosedPath(this.getPath()).contains(r);
    }

    @Override
    public boolean contains(ROI roi) {
        if (!ShapeUtil.isClosed(this.shape)) {
            return false;
        }
        return super.contains(roi);
    }

    @Override
    public ROI add(ROI roi, boolean allowCreate) throws UnsupportedOperationException {
        if (roi instanceof ROI2DShape) {
            ROI2DShape roiShape = (ROI2DShape)roi;
            if (this.getZ() == roiShape.getZ() && this.getT() == roiShape.getT() && this.getC() == roiShape.getC()) {
                Path2D path = this.getPath();
                if (roi instanceof ROI2DPath) {
                    ROI2DPath roiPath = (ROI2DPath)roi;
                    this.closedArea.add(roiPath.closedArea);
                    this.openPath.append(roiPath.openPath, false);
                } else {
                    if (roiShape.getShape() instanceof Area) {
                        this.closedArea.add((Area)roiShape.getShape());
                    } else {
                        this.closedArea.add(new Area(ShapeUtil.getClosedPath(roiShape)));
                    }
                    this.openPath.append(ShapeUtil.getOpenPath(roiShape), false);
                }
                path.reset();
                path.append(this.closedArea, false);
                path.append(this.openPath, false);
                this.rebuildControlPointsFromPath();
                this.roiChanged(true);
                return this;
            }
        }
        return super.add(roi, allowCreate);
    }

    @Override
    public ROI intersect(ROI roi, boolean allowCreate) throws UnsupportedOperationException {
        if (roi instanceof ROI2DShape) {
            ROI2DShape roiShape = (ROI2DShape)roi;
            if (this.getZ() == roiShape.getZ() && this.getT() == roiShape.getT() && this.getC() == roiShape.getC()) {
                Path2D path = this.getPath();
                if (roi instanceof ROI2DPath) {
                    ROI2DPath roiPath = (ROI2DPath)roi;
                    this.closedArea.intersect(roiPath.closedArea);
                    this.openPath.reset();
                } else {
                    if (roiShape.getShape() instanceof Area) {
                        this.closedArea.intersect((Area)roiShape.getShape());
                    } else {
                        this.closedArea.intersect(new Area(ShapeUtil.getClosedPath(roiShape)));
                    }
                    this.openPath.reset();
                }
                path.reset();
                path.append(this.closedArea, false);
                this.rebuildControlPointsFromPath();
                this.roiChanged(true);
                return this;
            }
        }
        return super.intersect(roi, allowCreate);
    }

    @Override
    public ROI exclusiveAdd(ROI roi, boolean allowCreate) throws UnsupportedOperationException {
        if (roi instanceof ROI2DShape) {
            ROI2DShape roiShape = (ROI2DShape)roi;
            if (this.getZ() == roiShape.getZ() && this.getT() == roiShape.getT() && this.getC() == roiShape.getC()) {
                Path2D path = this.getPath();
                if (roi instanceof ROI2DPath) {
                    ROI2DPath roiPath = (ROI2DPath)roi;
                    this.closedArea.exclusiveOr(roiPath.closedArea);
                    this.openPath.append(roiPath.openPath, false);
                } else {
                    if (roiShape.getShape() instanceof Area) {
                        this.closedArea.exclusiveOr((Area)roiShape.getShape());
                    } else {
                        this.closedArea.exclusiveOr(new Area(ShapeUtil.getClosedPath(roiShape)));
                    }
                    this.openPath.append(ShapeUtil.getOpenPath(roiShape), false);
                }
                path.reset();
                path.append(this.closedArea, false);
                path.append(this.openPath, false);
                this.rebuildControlPointsFromPath();
                this.roiChanged(true);
                return this;
            }
        }
        return super.exclusiveAdd(roi, allowCreate);
    }

    @Override
    public ROI subtract(ROI roi, boolean allowCreate) throws UnsupportedOperationException {
        if (roi instanceof ROI2DShape) {
            ROI2DShape roiShape = (ROI2DShape)roi;
            if (this.getZ() == roiShape.getZ() && this.getT() == roiShape.getT() && this.getC() == roiShape.getC()) {
                Path2D path = this.getPath();
                if (roi instanceof ROI2DPath) {
                    ROI2DPath roiPath = (ROI2DPath)roi;
                    this.closedArea.exclusiveOr(roiPath.closedArea);
                    if (!roiPath.closedArea.isEmpty()) {
                        this.openPath.reset();
                    }
                } else {
                    Area area = roiShape.getShape() instanceof Area ? (Area)roiShape.getShape() : new Area(ShapeUtil.getClosedPath(roiShape));
                    if (!area.isEmpty()) {
                        this.closedArea.exclusiveOr(area);
                        this.openPath.reset();
                    }
                }
                path.reset();
                path.append(this.closedArea, false);
                path.append(this.openPath, false);
                this.rebuildControlPointsFromPath();
                this.roiChanged(true);
                return this;
            }
        }
        return super.subtract(roi, allowCreate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PathAnchor2D> getPathAnchors() {
        ArrayList<PathAnchor2D> result = new ArrayList<PathAnchor2D>();
        List list = this.controlPoints;
        synchronized (list) {
            for (Anchor2D pt : this.controlPoints) {
                result.add((PathAnchor2D)pt);
            }
        }
        return result;
    }

    protected void updateCachedStructures() {
        this.closedArea = new Area(ShapeUtil.getClosedPath(this.getPath()));
        this.openPath = ShapeUtil.getOpenPath(this.getPath());
    }

    @Override
    protected void updateShape() {
        ShapeUtil.buildPathFromAnchors(this.getPath(), this.getPathAnchors(), false);
        this.updateCachedStructures();
        super.updateShape();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadFromXML(Node node) {
        this.beginUpdate();
        try {
            if (!super.loadFromXML(node)) {
                boolean bl = false;
                return bl;
            }
            this.removeAllPoint();
            ArrayList<Node> nodesPoint = XMLUtil.getChildren(XMLUtil.getElement(node, ID_POINTS), ID_POINT);
            if (nodesPoint != null) {
                for (Node n : nodesPoint) {
                    PathAnchor2D pt = (PathAnchor2D)this.createAnchor(new Point2D.Double());
                    pt.loadPositionFromXML(n);
                    this.addPoint(pt);
                }
            }
            this.getPath().setWindingRule(XMLUtil.getElementIntValue(node, ID_WINDING, 1));
        }
        finally {
            this.endUpdate();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveToXML(Node node) {
        if (!super.saveToXML(node)) {
            return false;
        }
        Element points = XMLUtil.setElement(node, ID_POINTS);
        List list = this.controlPoints;
        synchronized (list) {
            for (Anchor2D pt : this.controlPoints) {
                pt.savePositionToXML(XMLUtil.addElement(points, ID_POINT));
            }
        }
        XMLUtil.setElementIntValue(node, ID_WINDING, this.getPath().getWindingRule());
        return true;
    }
}

