/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.tool;

import icy.canvas.IcyCanvas;
import icy.roi.ROI;
import icy.roi.ROIUtil;
import icy.sequence.Sequence;
import icy.sequence.edit.ROIReplacesSequenceEdit;
import icy.system.thread.ThreadUtil;
import icy.type.point.Point5D;
import icy.type.rectangle.Rectangle2DUtil;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.List;
import plugins.kernel.roi.roi2d.ROI2DLine;
import plugins.kernel.roi.roi2d.ROI2DShape;

public class ROILineCutter
extends ROI2DLine {
    public ROILineCutter(Point5D pt) {
        super(pt);
    }

    public ROILineCutter() {
    }

    @Override
    protected ROI2DShape.ROI2DShapePainter createPainter() {
        return new ROILineCutterPainter();
    }

    protected Line2D getExtendedLine(Sequence sequence) {
        return Rectangle2DUtil.getIntersectionLine(sequence.getBounds2D(), this.getLine());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean splitOverlappedROIs(List<Sequence> sequences) {
        boolean result = false;
        for (Sequence sequence : sequences) {
            ArrayList<ROI> removedROI = new ArrayList<ROI>();
            ArrayList<ROI> addedROI = new ArrayList<ROI>();
            sequence.beginUpdate();
            try {
                for (ROI roi : sequence.getROIs()) {
                    List<ROI> resultRois = ROIUtil.split(roi, this.getLine());
                    if (resultRois == null) continue;
                    removedROI.add(roi);
                    addedROI.addAll(resultRois);
                    result = true;
                }
                if (removedROI.isEmpty()) continue;
                sequence.removeROIs(removedROI, false);
                sequence.addROIs(addedROI, false);
                sequence.addUndoableEdit(new ROIReplacesSequenceEdit(sequence, removedROI, addedROI));
            }
            finally {
                sequence.endUpdate();
            }
        }
        return result;
    }

    public class ROILineCutterPainter
    extends ROI2DLine.ROI2DLinePainter {
        public ROILineCutterPainter() {
            super(ROILineCutter.this);
        }

        @Override
        public void mouseReleased(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            super.mouseReleased(e, imagePoint, canvas);
            ThreadUtil.bgRun(new Runnable(){

                @Override
                public void run() {
                    List<Sequence> sequences = ROILineCutterPainter.this.getSequences();
                    ROILineCutter.this.remove(false);
                    ROILineCutter.this.splitOverlappedROIs(sequences);
                }
            });
        }

        @Override
        protected void drawShape(Graphics2D g, Sequence sequence, IcyCanvas canvas, boolean simplified) {
            Line2D extendedLine = ROILineCutter.this.getExtendedLine(sequence);
            if (extendedLine != null) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setStroke(new BasicStroke((float)(ROI.getAdjustedStroke(canvas, this.stroke) / 2.0)));
                g2.setColor(this.getDisplayColor());
                g2.draw(extendedLine);
                g2.dispose();
            }
            super.drawShape(g, sequence, canvas, ROILineCutter.this.getLine(), simplified);
        }
    }
}

