/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.searchprovider;

import icy.gui.plugin.PluginRichToolTip;
import icy.network.NetworkUtil;
import icy.plugin.PluginDescriptor;
import icy.search.SearchResult;
import icy.search.SearchResultProducer;
import icy.util.StringUtil;
import java.awt.Image;
import java.util.List;
import org.pushingpixels.flamingo.api.common.RichTooltip;

public abstract class PluginSearchResult
extends SearchResult {
    protected final PluginDescriptor plugin;
    protected final int priority;
    protected String description;

    public PluginSearchResult(SearchResultProducer provider, PluginDescriptor plugin, String text, List<SearchResultProducer.SearchWord> words, int priority) {
        super(provider);
        this.plugin = plugin;
        this.priority = priority;
        this.description = "";
        for (int wi = 0; StringUtil.isEmpty(this.description) && wi < words.size(); ++wi) {
            SearchResultProducer.SearchWord sw = words.get(wi);
            if (sw.reject) continue;
            this.description = StringUtil.trunc(text, sw.word, 80);
        }
        if (!StringUtil.isEmpty(this.description)) {
            this.description = this.description.replace("\n", "");
            for (SearchResultProducer.SearchWord sw : words) {
                if (sw.reject || sw.length() <= 2) continue;
                this.description = StringUtil.htmlBoldSubstring(this.description, sw.word, true);
            }
        }
    }

    public PluginDescriptor getPlugin() {
        return this.plugin;
    }

    @Override
    public String getTitle() {
        return this.plugin.getName();
    }

    @Override
    public Image getImage() {
        if (this.plugin.isIconLoaded()) {
            return this.plugin.getIconAsImage();
        }
        return PluginDescriptor.DEFAULT_ICON.getImage();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void executeAlternate() {
        String url = this.plugin.getWeb();
        if (!StringUtil.isEmpty(url)) {
            NetworkUtil.openBrowser(url);
        }
    }

    @Override
    public RichTooltip getRichToolTip() {
        return new PluginRichToolTip(this.plugin);
    }

    @Override
    public int compareTo(SearchResult o) {
        if (o instanceof PluginSearchResult) {
            return ((PluginSearchResult)o).priority - this.priority;
        }
        return super.compareTo(o);
    }
}

