/*
 * Decompiled with CFR 0.152.
 */
package microTiPi.microscopy;

import mitiv.array.Array3D;
import mitiv.base.Shape;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;
import mitiv.psf.PsfModel;

public abstract class MicroscopeModel
extends PsfModel {
    protected int PState = 0;
    protected static final boolean NORMALIZED = true;
    protected static final double DEUXPI = Math.PI * 2;
    protected double dxy;
    protected double dz;
    protected int Nx;
    protected int Ny;
    protected int Nz;
    protected Array3D psf;
    protected DoubleShapedVectorSpace[] parameterSpace;
    protected DoubleShapedVector[] parameterCoefs;

    public MicroscopeModel(Shape psfShape, double dxy, double dz, boolean single) {
        super(psfShape, single);
        this.dxy = dxy;
        this.dz = dz;
        if (psfShape.rank() != 3) {
            throw new IllegalArgumentException("Microscope PSF  should be 3D");
        }
        this.Nx = psfShape.dimension(0);
        this.Ny = psfShape.dimension(1);
        this.Nz = psfShape.dimension(2);
        this.psfShape = psfShape;
        this.setSingle(single);
    }

    public abstract DoubleShapedVector apply_Jacobian(ShapedVector var1, ShapedVectorSpace var2);

    public abstract int[] getParametersFlags();

    protected abstract void computePsf();
}

