/*
 * Decompiled with CFR 0.152.
 */
package microTiPi.microscopy;

import microTiPi.microscopy.MicroscopeModel;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.conv.WeightedConvolutionCost;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;
import mitiv.linalg.shaped.FloatShapedVectorSpace;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;
import mitiv.optim.BoundProjector;
import mitiv.optim.LineSearch;
import mitiv.optim.MoreThuenteLineSearch;
import mitiv.optim.OptimTask;
import mitiv.optim.ReverseCommunicationOptimizer;
import mitiv.optim.VMLMB;

public class PSF_Estimation {
    private double gatol = 0.0;
    private double grtol = 0.001;
    private int limitedMemorySize = 5;
    private double lowerBound = Double.NEGATIVE_INFINITY;
    private double upperBound = Double.POSITIVE_INFINITY;
    private int maxiter = 20;
    private int maxeval = 20;
    private ShapedArray data = null;
    private ShapedArray obj = null;
    private double fcost = 0.0;
    private ShapedVector gcost = null;
    private MicroscopeModel pupil = null;
    private ReverseCommunicationOptimizer minimizer = null;
    private ShapedArray weights = null;
    private boolean single;
    private boolean run = true;
    private boolean debug = false;

    public PSF_Estimation(MicroscopeModel pupil) {
        if (pupil != null) {
            this.pupil = pupil;
            this.single = pupil.isSingle();
        } else {
            PSF_Estimation.fatal("pupil not specified");
        }
    }

    public void enablePositivity(Boolean positivity) {
        this.setLowerBound(positivity != false ? 0.0 : Double.NEGATIVE_INFINITY);
    }

    private static void fatal(String reason) {
        throw new IllegalArgumentException(reason);
    }

    public void fitPSF(int flag) {
        FloatShapedVectorSpace objSpace;
        FloatShapedVectorSpace dataSpace;
        this.run = true;
        DoubleShapedVector x = null;
        double best_cost = Double.POSITIVE_INFINITY;
        if (this.data == null) {
            PSF_Estimation.fatal("Input data not specified.");
        }
        x = this.pupil.parameterCoefs[flag];
        Shape dataShape = this.data.getShape();
        int rank = this.data.getRank();
        DoubleShapedVector best_x = x.clone();
        if (this.obj == null) {
            PSF_Estimation.fatal("Object not specified.");
        }
        if (this.obj.getRank() != rank) {
            PSF_Estimation.fatal("Obj must have same rank as data.");
        }
        if (this.single) {
            dataSpace = new FloatShapedVectorSpace(dataShape);
            objSpace = new FloatShapedVectorSpace(dataShape);
        } else {
            dataSpace = new DoubleShapedVectorSpace(dataShape);
            objSpace = new DoubleShapedVectorSpace(dataShape);
        }
        DoubleShapedVectorSpace variableSpace = x.getSpace();
        int[] off = new int[]{0, 0, 0};
        WeightedConvolutionCost fdata = WeightedConvolutionCost.build((ShapedVectorSpace)objSpace, (ShapedVectorSpace)dataSpace);
        fdata.setPSF(this.obj, off);
        fdata.setData(this.data);
        fdata.setWeights(this.weights, true);
        if (this.debug) {
            System.out.println("Vector space initialization complete.");
        }
        this.gcost = objSpace.create();
        best_cost = this.fcost = fdata.computeCostAndGradient(1.0, (Vector)objSpace.create(this.pupil.getPsf()), (Vector)this.gcost, true);
        best_x = x.clone();
        if (this.debug) {
            System.out.println("Cost function initialization complete.");
        }
        MoreThuenteLineSearch lineSearch = null;
        VMLMB vmlmb = null;
        BoundProjector projector = null;
        int bounded = 0;
        this.limitedMemorySize = 0;
        if (this.lowerBound != Double.NEGATIVE_INFINITY) {
            bounded |= 1;
        }
        if (this.upperBound != Double.POSITIVE_INFINITY) {
            bounded |= 2;
        }
        if (this.debug) {
            System.out.println("bounded");
            System.out.println(bounded);
        }
        lineSearch = new MoreThuenteLineSearch(0.05, 0.1, 1.0E-17);
        int m = this.limitedMemorySize > 1 ? this.limitedMemorySize : 5;
        vmlmb = new VMLMB((VectorSpace)variableSpace, projector, m, (LineSearch)lineSearch);
        vmlmb.setAbsoluteTolerance(this.gatol);
        vmlmb.setRelativeTolerance(this.grtol);
        this.minimizer = vmlmb;
        if (this.debug) {
            System.out.println("Optimization method initialization complete.");
        }
        DoubleShapedVector gX = variableSpace.create();
        OptimTask task = this.minimizer.start();
        while (this.run) {
            if (task == OptimTask.COMPUTE_FG) {
                this.pupil.setParam(x);
                this.pupil.computePsf();
                this.fcost = fdata.computeCostAndGradient(1.0, (Vector)objSpace.create(this.pupil.getPsf()), (Vector)this.gcost, true);
                if (this.fcost < best_cost) {
                    best_cost = this.fcost;
                    best_x = x.clone();
                    if (this.debug) {
                        System.out.println("Cost: " + best_cost);
                    }
                }
                gX = this.pupil.apply_Jacobian(this.gcost, (ShapedVectorSpace)x.getSpace());
            } else if (task == OptimTask.NEW_X || task == OptimTask.FINAL_X) {
                boolean stop;
                boolean bl = stop = task == OptimTask.FINAL_X;
                if (!stop && this.maxiter >= 0 && this.minimizer.getIterations() >= this.maxiter) {
                    if (this.debug) {
                        System.out.format("Warning: too many iterations (%d).\n", this.maxiter);
                    }
                    stop = true;
                }
                if (stop) {
                    break;
                }
            } else {
                if (!this.debug) break;
                System.out.println("TiPi: PSF_Estimation, " + task + " : " + this.minimizer.getReason());
                break;
            }
            if (this.debug) {
                System.out.println("Evaluations");
                System.out.println(this.minimizer.getEvaluations());
                System.out.println("Iterations");
                System.out.println(this.minimizer.getIterations());
            }
            if (this.minimizer.getEvaluations() >= this.maxeval) {
                if (!this.debug) break;
                System.out.format("Warning: too many evaluation (%d).\n", this.maxeval);
                break;
            }
            task = this.minimizer.iterate((Vector)x, this.fcost, (Vector)gX);
        }
        this.pupil.setParam(best_x);
    }

    public void setDebugMode(boolean value) {
        this.debug = value;
    }

    public void setMaximumIterations(int value) {
        this.maxiter = value;
        this.maxeval = 2 * value;
    }

    public void setLimitedMemorySize(int value) {
        this.limitedMemorySize = value;
    }

    public void setAbsoluteTolerance(double value) {
        this.gatol = value;
    }

    public void setRelativeTolerance(double value) {
        this.grtol = value;
    }

    public void setLowerBound(double value) {
        this.lowerBound = value;
    }

    public void setUpperBound(double value) {
        this.upperBound = value;
    }

    public void abort() {
        this.run = false;
    }

    public void setWeight(ShapedArray shapedArray) {
        this.weights = shapedArray;
    }

    public void setPupil(MicroscopeModel pupil) {
        this.pupil = pupil;
    }

    public MicroscopeModel getPupil() {
        return this.pupil;
    }

    public ShapedArray getData() {
        return this.data;
    }

    public void setData(ShapedArray shapedArray) {
        this.data = shapedArray;
    }

    public ShapedArray getPsf() {
        return this.pupil.getPsf();
    }

    public int getIterations() {
        return this.minimizer == null ? 0 : this.minimizer.getIterations();
    }

    public int getEvaluations() {
        return this.minimizer == null ? 0 : this.minimizer.getEvaluations();
    }

    public double getCost() {
        return this.fcost;
    }

    public void setObj(ShapedArray objArray) {
        this.obj = objArray;
    }

    public MicroscopeModel getModel() {
        return this.pupil;
    }

    public void freeMem() {
        this.pupil.freeMem();
    }
}

