/*
 * Decompiled with CFR 0.152.
 */
package microTiPi.microscopy;

import microTiPi.microUtils.BlindDeconvJob;
import mitiv.array.ByteArray;
import mitiv.array.ShapedArray;
import mitiv.jobs.DeconvolutionJob;
import mitiv.utils.HistoMap;
import mitiv.utils.WeightFactory;
import mitiv.utils.WeightUpdater;

public class weightsFromModel
implements WeightUpdater {
    private ShapedArray dataArray;
    private ByteArray badpixArray;
    private ShapedArray wghtArray;
    private double alpha;
    private double beta;

    public weightsFromModel(ShapedArray dataArray, ByteArray badpixArray) {
        this.dataArray = dataArray;
        this.badpixArray = badpixArray;
    }

    public void update(Object caller) {
        String tmp = caller.getClass().getSimpleName();
        if (caller instanceof BlindDeconvJob) {
            ShapedArray modelArray = ((BlindDeconvJob)caller).getDeconvolver().getModel();
            HistoMap hm = new HistoMap(modelArray, this.dataArray, this.badpixArray);
            WeightFactory.normalize((ShapedArray)this.wghtArray);
            this.alpha = hm.getAlpha();
            this.beta = hm.getBeta();
            this.wghtArray = hm.computeWeightMap(modelArray);
            ((BlindDeconvJob)caller).getDeconvolver().updateWeight(this.wghtArray);
        } else if (caller instanceof DeconvolutionJob) {
            ShapedArray modelArray = ((DeconvolutionJob)caller).getModel();
            HistoMap hm = new HistoMap(modelArray, this.dataArray, this.badpixArray);
            this.wghtArray = hm.computeWeightMap(modelArray);
            this.alpha = hm.getAlpha();
            this.beta = hm.getBeta();
            WeightFactory.normalize((ShapedArray)this.wghtArray);
            ((DeconvolutionJob)caller).updateWeight(this.wghtArray);
        }
    }

    public ShapedArray getWeights() {
        return this.wghtArray;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }
}

