/*
 * Decompiled with CFR 0.152.
 */
package plugins.ferreol.demics;

import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.frame.progress.FailedAnnounceFrame;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginInstaller;
import icy.plugin.PluginRepositoryLoader;
import icy.plugin.PluginUpdater;
import icy.sequence.MetaDataUtil;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import icy.util.OMEUtil;
import icy.util.StringUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import mitiv.array.ArrayFactory;
import mitiv.array.ArrayUtils;
import mitiv.array.ByteArray;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.conv.WeightedConvolutionCost;
import mitiv.cost.DifferentiableCostFunction;
import mitiv.jobs.DeconvolutionJob;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;
import mitiv.linalg.shaped.FloatShapedVectorSpace;
import mitiv.linalg.shaped.ShapedVectorSpace;
import mitiv.utils.FFTUtils;
import mitiv.utils.HistoMap;
import mitiv.utils.WeightFactory;
import mitiv.utils.WeightUpdater;
import ome.xml.meta.OMEXMLMetadata;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzButton;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarChannel;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarDoubleArrayNative;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarListener;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.ezplug.EzVarText;
import plugins.adufour.vars.lang.Var;
import plugins.mitiv.io.Icy2TiPi;
import plugins.mitiv.io.IcyImager;

public abstract class DEMICSPlug
extends EzPlug
implements Block,
EzStoppable {
    protected EzVarSequence dataEV;
    protected EzVarChannel channelEV;
    protected OMEXMLMetadata metDat = null;
    protected EzVarDouble logmu;
    protected EzVarDouble mu;
    protected EzVarSequence restartEV;
    protected EzVarChannel channelRestartEV;
    protected EzVarBoolean positivityEV;
    protected EzButton startDecButton;
    protected EzButton showFullObjectButton;
    protected EzVarText dataSizeTxt;
    protected EzVarText outputSizeTxt;
    protected EzVarDouble dy_nm;
    protected EzVarDouble dx_nm;
    protected EzVarDouble dz_nm;
    protected EzVarDouble na;
    protected EzVarDouble lambda;
    protected EzVarDouble ni;
    protected EzVarInteger nbIterDeconv;
    protected EzVarBoolean singlePrecision;
    protected EzVarDoubleArrayNative scale;
    protected EzVarInteger paddingSizeXY;
    protected EzVarInteger paddingSizeZ;
    protected EzGroup ezDeconvolutionGroup;
    protected int sizeX = 128;
    protected int sizeY = 128;
    protected int sizeZ = 64;
    protected int Nx = 128;
    protected int Ny = 128;
    protected int Nz = 64;
    protected Shape psfShape = new Shape(this.Nx, this.Ny, this.Nz);
    protected Shape outputShape;
    protected Sequence dataSeq = null;
    protected Sequence cursequence;
    protected Shape dataShape;
    protected ShapedArray wgtArray;
    protected ShapedArray dataArray;
    protected ShapedArray psfArray;
    protected ShapedArray objArray;
    protected ShapedArray modelArray = null;
    protected ByteArray badpixArray = null;
    protected EzGroup ezWeightingGroup;
    protected EzGroup groupVisu;
    protected EzVarText weightsMethod;
    protected final String[] weightOptions = new String[]{"Variance =1", "Inverse variance map", "Variance map", "Computed variance", "Automatic variance estimation"};
    protected EzVarDouble gain;
    protected EzVarDouble noise;
    protected EzVarSequence weightsSeq;
    protected EzVarSequence badpixMap;
    protected EzButton showWeightButton;
    protected EzGroup ezPaddingGroup;
    protected EzVarFile saveFile;
    protected EzVarFile loadFile;
    protected EzVarBoolean showIteration;
    protected EzVarSequence outputHeadlessImage = null;
    protected EzVarSequence outputHeadlessWght = null;
    protected EzButton saveParam;
    protected EzButton loadParam;
    protected String outputPath = null;
    protected DeconvolutionJob deconvolver;
    protected ShapedVectorSpace dataSpace;
    protected ShapedVectorSpace objectSpace;
    protected int vectorSpaceType;
    protected DifferentiableCostFunction fprior;
    protected WeightedConvolutionCost fdata;
    protected EzVarListener<Integer> zeroPadActionListener;
    protected WeightUpdater wghtUpdt;
    private boolean debug = false;
    private boolean verbose = false;

    protected void initialize() {
        PluginRepositoryLoader.waitLoaded();
        PluginDescriptor desc = PluginRepositoryLoader.getPlugin((String)"plugins.mitiv.deconv.MitivDeconvolution");
        if (desc != null && desc.isInstalled()) {
            if (!this.isHeadLess()) {
                new AnnounceFrame("Removing the now useless MitivDeconvolution plugin.");
            }
            PluginInstaller.desinstall((PluginDescriptor)desc, (boolean)false, (boolean)false);
            while (PluginUpdater.isCheckingForUpdate() || PluginInstaller.isProcessing() || PluginInstaller.isInstalling() || PluginInstaller.isDesinstalling()) {
                ThreadUtil.sleep((int)1);
            }
        }
        if (!this.isHeadLess()) {
            this.getUI().setParametersIOVisible(false);
            this.getUI().setActionPanelVisible(false);
        }
        this.dataEV = new EzVarSequence("Data:");
        this.channelEV = new EzVarChannel("Data channel:", (Var)this.dataEV.getVariable(), false);
        this.restartEV = new EzVarSequence("Starting point:");
        this.restartEV.setNoSequenceSelection();
        this.channelRestartEV = new EzVarChannel("Initialization channel :", (Var)this.restartEV.getVariable(), false);
        this.dataSizeTxt = new EzVarText("Data size:");
        this.outputSizeTxt = new EzVarText("Output size:");
        this.paddingSizeZ = new EzVarInteger("padding in z :", 0, Integer.MAX_VALUE, 1);
        this.dx_nm = new EzVarDouble("dx(nm):", 64.5, 0.0, Double.MAX_VALUE, 1.0);
        this.dy_nm = new EzVarDouble("dy(nm):", 64.5, 0.0, Double.MAX_VALUE, 1.0);
        this.dz_nm = new EzVarDouble("dz(nm):", 64.5, 0.0, Double.MAX_VALUE, 1.0);
        this.dataSizeTxt.setVisible(false);
        this.outputSizeTxt.setVisible(false);
        this.dataEV.setNoSequenceSelection();
        this.zeroPadActionListener = new EzVarListener<Integer>(){

            public void variableChanged(EzVar<Integer> source, Integer newValue) {
                DEMICSPlug.this.updateImageSize();
                DEMICSPlug.this.updatePaddedSize();
            }
        };
        this.paddingSizeZ.addVarChangeListener(this.zeroPadActionListener);
        this.restartEV.addVarChangeListener((EzVarListener)new EzVarListener<Sequence>(){

            public void variableChanged(EzVar<Sequence> source, Sequence newValue) {
                newValue = (Sequence)DEMICSPlug.this.restartEV.getValue();
                if (DEMICSPlug.this.debug && (newValue != null || newValue != null && newValue.isEmpty())) {
                    System.out.println("restart changed:" + newValue.getName());
                }
            }
        });
        this.channelEV.addVarChangeListener((EzVarListener)new EzVarListener<Integer>(){

            public void variableChanged(EzVar<Integer> source, Integer newValue) {
                DEMICSPlug.this.channelRestartEV.setValue((Object)newValue);
                DEMICSPlug.this.dataChanged();
                DEMICSPlug.this.modelArray = null;
            }
        });
        this.weightsMethod = new EzVarText("Weighting:", this.weightOptions, 4, Boolean.valueOf(false));
        this.weightsSeq = new EzVarSequence("Map:");
        this.gain = new EzVarDouble("Gain:", 1.0, Double.MIN_VALUE, Double.MAX_VALUE, 0.1);
        this.noise = new EzVarDouble("Readout Noise:", 10.0, 0.0, Double.MAX_VALUE, 0.1);
        this.badpixMap = new EzVarSequence("Bad data map:");
        this.weightsSeq.setNoSequenceSelection();
        this.weightsMethod.addVarChangeListener((EzVarListener)new EzVarListener<String>(){

            public void variableChanged(EzVar<String> source, String newValue) {
                if (DEMICSPlug.this.debug) {
                    System.out.println("weight:" + (String)DEMICSPlug.this.weightsMethod.getValue() + ".");
                    System.out.println("weight:" + newValue + ".");
                    System.out.println("weight:" + DEMICSPlug.this.weightOptions[3] + ".");
                    System.out.println("weight:" + DEMICSPlug.this.weightOptions[3] == newValue);
                }
                if (StringUtil.equals((String)((String)DEMICSPlug.this.weightsMethod.getValue()), (String)DEMICSPlug.this.weightOptions[0])) {
                    DEMICSPlug.this.weightsSeq.setVisible(false);
                    DEMICSPlug.this.gain.setVisible(false);
                    DEMICSPlug.this.noise.setVisible(false);
                } else if (StringUtil.equals((String)((String)DEMICSPlug.this.weightsMethod.getValue()), (String)DEMICSPlug.this.weightOptions[1]) || StringUtil.equals((String)((String)DEMICSPlug.this.weightsMethod.getValue()), (String)DEMICSPlug.this.weightOptions[2])) {
                    DEMICSPlug.this.weightsSeq.setVisible(true);
                    DEMICSPlug.this.gain.setVisible(false);
                    DEMICSPlug.this.noise.setVisible(false);
                    DEMICSPlug.this.weightsSeq.setNoSequenceSelection();
                } else if (StringUtil.equals((String)((String)DEMICSPlug.this.weightsMethod.getValue()), (String)DEMICSPlug.this.weightOptions[3]) || StringUtil.equals((String)((String)DEMICSPlug.this.weightsMethod.getValue()), (String)DEMICSPlug.this.weightOptions[4])) {
                    DEMICSPlug.this.weightsSeq.setVisible(false);
                    DEMICSPlug.this.gain.setVisible(true);
                    DEMICSPlug.this.noise.setVisible(true);
                    DEMICSPlug.this.weightsSeq.setNoSequenceSelection();
                } else {
                    DEMICSPlug.this.throwError("Invalid argument passed to weight method");
                    return;
                }
            }
        });
        this.weightsSeq.setVisible(false);
        this.gain.setVisible(false);
        this.noise.setVisible(false);
        this.badpixMap.setVisible(true);
        this.badpixMap.setNoSequenceSelection();
        this.showWeightButton = new EzButton("Show weight map", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sequence dataSeq = (Sequence)DEMICSPlug.this.dataEV.getValue();
                if (DEMICSPlug.this.wgtArray != null) {
                    IcyImager.show(DEMICSPlug.this.wgtArray, null, "Weight map", false);
                } else if (dataSeq != null) {
                    DEMICSPlug.this.dataArray = Icy2TiPi.sequenceToArray(dataSeq, (Integer)DEMICSPlug.this.channelEV.getValue()).toDouble();
                    DEMICSPlug.this.createWeights(true);
                    IcyImager.show(DEMICSPlug.this.wgtArray, null, "Weight map", false);
                }
                if (DEMICSPlug.this.debug) {
                    System.out.println("Weight compute");
                }
            }
        });
        this.mu = new EzVarDouble("Regularization level:", 1.0, 0.0, Double.MAX_VALUE, 0.01);
        this.logmu = new EzVarDouble("Log10 of the Regularization level:", 0.0, -1.7976931348623157E308, Double.MAX_VALUE, 1.0);
        this.nbIterDeconv = new EzVarInteger("Number of iterations: ", 50, 1, Integer.MAX_VALUE, 1);
        this.positivityEV = new EzVarBoolean("Enforce nonnegativity:", true);
        this.singlePrecision = new EzVarBoolean("Compute in single precision:", false);
        this.showIteration = new EzVarBoolean("Show intermediate results:", true);
        this.scale = new EzVarDoubleArrayNative("Aspect ratio of a voxel", (double[][])new double[][]{{1.0, 1.0, 1.0}}, true);
        if (this.isHeadLess()) {
            this.showIteration.setValue((Object)false);
        }
        this.showFullObjectButton = new EzButton("Show the full (padded) object", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DEMICSPlug.this.debug) {
                    System.out.println("showFullObjectButton");
                }
                Sequence fSeq = new Sequence("Deconvolved image");
                fSeq.copyMetaDataFrom((Sequence)DEMICSPlug.this.dataEV.getValue(), false);
                if (DEMICSPlug.this.objArray != null) {
                    IcyImager.show(DEMICSPlug.this.objArray, fSeq, "Deconvolved " + ((Sequence)DEMICSPlug.this.dataEV.getValue()).getName() + "with padding. mu=" + DEMICSPlug.this.mu.getValue(), DEMICSPlug.this.isHeadLess());
                } else {
                    IcyImager.show(ArrayUtils.extract((ShapedArray)DEMICSPlug.this.dataArray, (Shape)DEMICSPlug.this.outputShape), fSeq, "data " + ((Sequence)DEMICSPlug.this.dataEV.getValue()).getName() + "with padding. mu=" + DEMICSPlug.this.mu.getValue(), DEMICSPlug.this.isHeadLess());
                }
            }
        });
        EzVarListener<Double> logmuActionListener = new EzVarListener<Double>(){

            public void variableChanged(EzVar<Double> source, Double newValue) {
                DEMICSPlug.this.mu.setValue((Object)Math.pow(10.0, (Double)DEMICSPlug.this.logmu.getValue()));
                DEMICSPlug.this.mu.setEnabled(false);
            }
        };
        this.logmu.addVarChangeListener((EzVarListener)logmuActionListener);
        this.groupVisu = new EzGroup("Visualization", new EzComponent[]{this.showIteration, this.showFullObjectButton});
        this.groupVisu.setFoldedState(true);
        this.saveFile = new EzVarFile("Save parameters in", "");
        this.saveParam = new EzButton("Save parameters", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DEMICSPlug.this.saveParamClicked();
                if (DEMICSPlug.this.debug) {
                    System.out.println("Save parameters");
                }
            }
        });
        this.loadFile = new EzVarFile("Load parameters from", "", "*.xml");
        this.loadParam = new EzButton("Load parameters", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DEMICSPlug.this.loadFile.getValue() != null) {
                    DEMICSPlug.this.loadParamClicked();
                }
                if (DEMICSPlug.this.debug) {
                    System.out.println("Load parameters");
                }
            }
        });
    }

    protected abstract void loadParamClicked();

    protected void saveParamClicked() {
        File pathName = (File)this.saveFile.getValue();
        if (pathName != null) {
            if (!pathName.getName().endsWith(".xml")) {
                pathName = new File(pathName.getAbsolutePath() + ".xml");
            }
            this.saveParameters(pathName);
        }
    }

    protected void createWeights(boolean normalize) {
        this.badpixArray = (ByteArray)ArrayFactory.create((int)0, (Shape)this.dataShape);
        if (WeightFactory.flagBads((ShapedArray)this.dataArray, (ByteArray)this.badpixArray, (double)this.dataSeq.getChannelTypeMax(((Integer)this.channelEV.getValue()).intValue())) && !this.isHeadLess()) {
            new AnnounceFrame("Warning, saturated pixel detected, accounting them as dead pixels", "show", new Runnable(){

                @Override
                public void run() {
                    Sequence deadSequence = new Sequence("Saturations map");
                    deadSequence.copyMetaDataFrom(DEMICSPlug.this.dataSeq, false);
                    IcyImager.show((ShapedArray)DEMICSPlug.this.badpixArray, deadSequence, "saturations map", DEMICSPlug.this.isHeadLess());
                }
            }, 3);
        }
        if (this.weightsMethod.getValue() == this.weightOptions[1]) {
            Sequence seq = (Sequence)this.weightsSeq.getValue();
            if (seq != null) {
                this.wgtArray = Icy2TiPi.sequenceToArray(seq);
                if (!this.wgtArray.equals(this.dataArray)) {
                    this.throwError("Weight map must have the same size than the data");
                }
            }
        } else if (this.weightsMethod.getValue() == this.weightOptions[2]) {
            Sequence seq = (Sequence)this.weightsSeq.getValue();
            if (seq != null) {
                ShapedArray varArray = Icy2TiPi.sequenceToArray(seq);
                if (!varArray.equals(this.dataArray)) {
                    this.throwError("Variance map must have the same size than the data");
                }
                this.wgtArray = WeightFactory.computeWeightsFromVariance((ShapedArray)varArray);
            }
        } else if (this.weightsMethod.getValue() == this.weightOptions[3]) {
            double gamma = (Double)this.gain.getValue();
            double sigma = (Double)this.noise.getValue();
            double alpha = gamma;
            double beta = sigma / gamma * (sigma / gamma);
            this.wgtArray = WeightFactory.computeWeightsFromData((ShapedArray)this.dataArray, (double)alpha, (double)beta);
        } else if (this.weightsMethod.getValue() == this.weightOptions[4]) {
            if (this.modelArray == null) {
                double gamma = (Double)this.gain.getValue();
                double sigma = (Double)this.noise.getValue();
                double alpha = gamma;
                double beta = sigma / gamma * (sigma / gamma);
                this.wgtArray = WeightFactory.computeWeightsFromData((ShapedArray)this.dataArray, (double)alpha, (double)beta);
            } else {
                HistoMap hm = new HistoMap(this.modelArray, this.dataArray, this.badpixArray);
                this.gain.setValue((Object)hm.getAlpha());
                this.noise.setValue((Object)(Math.sqrt(hm.getBeta()) / hm.getAlpha()));
                this.wgtArray = hm.computeWeightMap(this.modelArray);
            }
        }
        WeightFactory.removeBads((ShapedArray)this.wgtArray, (ShapedArray)this.badpixArray);
        if (normalize) {
            WeightFactory.normalize((ShapedArray)this.wgtArray);
        }
    }

    protected void createWeights() {
        this.createWeights(false);
    }

    protected void dataChanged() {
        this.dataSizeTxt.setVisible(false);
        this.outputSizeTxt.setVisible(false);
        this.dataSeq = (Sequence)this.dataEV.getValue();
        if (this.dataSeq != null) {
            this.sizeX = this.dataSeq.getSizeX();
            this.sizeY = this.dataSeq.getSizeY();
            this.sizeZ = this.dataSeq.getSizeZ();
            this.restartEV.setValue(this.dataSeq);
            this.channelRestartEV.setValue(this.channelEV.getValue());
            this.metDat = this.dataSeq.getOMEXMLMetadata();
            this.dx_nm.setValue((Object)(this.dataSeq.getPixelSizeX() * 1000.0));
            this.dy_nm.setValue((Object)(this.dataSeq.getPixelSizeY() * 1000.0));
            this.dz_nm.setValue((Object)(this.dataSeq.getPixelSizeZ() * 1000.0));
            try {
                this.lambda.setValue((Object)(this.metDat.getChannelEmissionWavelength(0, ((Integer)this.channelEV.getValue()).intValue()).value().doubleValue() * 1000.0));
            }
            catch (Exception e) {
                System.out.println("Failed to get wavelength from metadata, will use default values ");
                this.lambda.setValue((Object)500.0);
            }
            try {
                this.na.setValue((Object)this.metDat.getObjectiveLensNA(0, 0));
            }
            catch (Exception e) {
                System.out.println("Failed to get numerical aperture from metadata, will use default values ");
                this.na.setValue((Object)1.4);
            }
            try {
                this.ni.setValue((Object)this.metDat.getObjectiveSettingsRefractiveIndex(0));
            }
            catch (Exception e) {
                System.out.println("Failed to get refractive index from metadata, will use default values ");
                this.ni.setValue((Object)1.518);
            }
            if (this.sizeZ == 1) {
                this.dataShape = new Shape(this.sizeX, this.sizeY);
                this.scale.setValue((Object)new double[]{1.0, (Double)this.dx_nm.getValue() / (Double)this.dy_nm.getValue()});
            } else {
                this.dataShape = new Shape(this.sizeX, this.sizeY, this.sizeZ);
                this.scale.setValue((Object)new double[]{1.0, (Double)this.dx_nm.getValue() / (Double)this.dy_nm.getValue(), (Double)this.dx_nm.getValue() / (Double)this.dz_nm.getValue()});
            }
            this.updatePaddedSize();
            this.updateOutputSize();
            this.updateImageSize();
            this.dataSizeTxt.setVisible(true);
            this.outputSizeTxt.setVisible(true);
            this.outputSizeTxt.setEnabled(false);
            this.dataSizeTxt.setEnabled(false);
            this.startDecButton.setEnabled(true);
        } else {
            this.startDecButton.setEnabled(false);
        }
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("image", (Var)this.dataEV.getVariable());
        inputMap.add("image channel", this.channelEV.getVariable());
        inputMap.add("starting point", (Var)this.restartEV.getVariable());
        this.channelRestartEV = new EzVarChannel("Initialization channel :", (Var)this.restartEV.getVariable(), false);
        inputMap.add("starting point channel", this.channelRestartEV.getVariable());
        inputMap.add("weights Method", this.weightsMethod.getVariable());
        inputMap.add("badpixMap", (Var)this.badpixMap.getVariable());
        inputMap.add("gain", this.gain.getVariable());
        inputMap.add("noise", this.noise.getVariable());
        inputMap.add("mu", this.mu.getVariable());
        inputMap.add("scale", this.scale.getVariable());
        inputMap.add("nbIteration", this.nbIterDeconv.getVariable());
        inputMap.add("positivity", this.positivityEV.getVariable());
        inputMap.add("single precision", this.singlePrecision.getVariable());
        this.saveFile = new EzVarFile("Save parameters in", "");
        inputMap.add("saveFile", this.saveFile.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("outputSizeTxt", this.outputSizeTxt.getVariable());
        outputMap.add("output", (Var)this.outputHeadlessImage.getVariable());
        outputMap.add("weightmap", (Var)this.outputHeadlessWght.getVariable());
    }

    protected void setDefaultValue() {
        this.weightsMethod.setValue((Object)this.weightOptions[4]);
        this.dataEV.setNoSequenceSelection();
        this.badpixMap.setNoSequenceSelection();
        this.paddingSizeZ.setValue((Object)30);
        this.badpixMap.setNoSequenceSelection();
    }

    protected void updateImageSize() {
        String text = this.Nz == 1 ? this.sizeX + "x" + this.sizeY : this.sizeX + "x" + this.sizeY + "x" + this.sizeZ;
        this.dataSizeTxt.setValue((Object)text);
    }

    protected void updateMetaData() {
        Sequence seq = (Sequence)this.dataEV.getValue();
        if (seq != null) {
            OMEXMLMetadata newMetdat = MetaDataUtil.generateMetaData((Sequence)seq, (boolean)true);
            newMetdat.setPixelsPhysicalSizeX(OMEUtil.getLength((double)((Double)this.dx_nm.getValue() * 0.001)), 0);
            newMetdat.setPixelsPhysicalSizeY(OMEUtil.getLength((double)((Double)this.dy_nm.getValue() * 0.001)), 0);
            newMetdat.setPixelsPhysicalSizeZ(OMEUtil.getLength((double)((Double)this.dz_nm.getValue() * 0.001)), 0);
            newMetdat.setObjectiveLensNA((Double)this.na.getValue(), 0, 0);
            newMetdat.setChannelEmissionWavelength(OMEUtil.getLength((double)((Double)this.lambda.getValue() * 0.001)), 0, ((Integer)this.channelEV.getValue()).intValue());
            newMetdat.setObjectiveSettingsRefractiveIndex((Double)this.ni.getValue(), 0);
            seq.setMetaData(newMetdat);
        } else {
            new AnnounceFrame("Nothing to save");
        }
    }

    protected void updateOutputSize() {
        String text = this.Nz == 1 ? this.Nx + "x" + this.Ny : this.Nx + "x" + this.Ny + "x" + this.Nz;
        this.outputSizeTxt.setValue((Object)text);
        if (1.0 * (double)this.Nx * (double)this.Ny * (double)this.Nz > Math.pow(2.0, 30.0)) {
            this.throwError("Padded image is too large (>2^30)");
        }
    }

    protected void updatePaddedSize() {
        if ((double)((Integer)this.paddingSizeXY.getValue()).intValue() < 0.0) {
            this.throwError("Padding value cannot be negative");
            return;
        }
        if ((double)((Integer)this.paddingSizeZ.getValue()).intValue() < 0.0) {
            this.throwError("Padding value cannot be negative");
            return;
        }
        this.Nx = FFTUtils.bestDimension((int)(this.sizeX + (Integer)this.paddingSizeXY.getValue()));
        this.Ny = FFTUtils.bestDimension((int)(this.sizeY + (Integer)this.paddingSizeXY.getValue()));
        this.Nz = FFTUtils.bestDimension((int)(this.sizeZ + (Integer)this.paddingSizeZ.getValue()));
        this.outputShape = new Shape(this.Nx, this.Ny, this.Nz);
        if (this.debug) {
            System.out.println(" UpdatePaddedSize" + this.paddingSizeXY.getValue() + this.outputShape.toString());
        }
    }

    protected void throwError(String s) {
        if (this.isHeadLess()) {
            throw new IllegalArgumentException(s);
        }
        new FailedAnnounceFrame(s);
    }

    protected void buildVectorSpaces() {
        this.vectorSpaceType = (Boolean)this.singlePrecision.getValue() != false ? 4 : (this.dataArray.getType() == 5 || this.psfArray != null && this.psfArray.getType() == 5 || this.wgtArray != null && this.wgtArray.getType() == 5 ? 5 : 4);
        if (this.vectorSpaceType == 4) {
            this.dataSpace = new FloatShapedVectorSpace(this.dataShape);
            this.objectSpace = new FloatShapedVectorSpace(this.outputShape);
        } else {
            this.dataSpace = new DoubleShapedVectorSpace(this.dataShape);
            this.objectSpace = new DoubleShapedVectorSpace(this.outputShape);
        }
    }
}

