/*
 * Decompiled with CFR 0.152.
 */
package plugins.ferreol.demics;

import icy.file.Loader;
import icy.gui.frame.progress.AnnounceFrame;
import icy.image.colormap.IceColorMap;
import icy.image.colormap.IcyColorMap;
import icy.main.Icy;
import icy.sequence.Sequence;
import icy.util.OMEUtil;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.SwingUtilities;
import microTiPi.epifluorescence.WideFieldModel;
import microTiPi.microUtils.BlindDeconvJob;
import microTiPi.microscopy.PSF_Estimation;
import microTiPi.microscopy.weightsFromModel;
import mitiv.array.ArrayUtils;
import mitiv.array.Double2D;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.conv.WeightedConvolutionCost;
import mitiv.cost.DifferentiableCostFunction;
import mitiv.cost.HyperbolicTotalVariation;
import mitiv.jobs.DeconvolutionJob;
import mitiv.linalg.shaped.ShapedVectorSpace;
import mitiv.utils.Histogram;
import mitiv.utils.TiPiHook;
import ome.xml.meta.MetadataRetrieve;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzButton;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzLabel;
import plugins.adufour.ezplug.EzPanel;
import plugins.adufour.ezplug.EzTabs;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarDoubleArrayNative;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarListener;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.ezplug.EzVarText;
import plugins.adufour.vars.lang.Var;
import plugins.ferreol.demics.DEMICSPlug;
import plugins.mitiv.io.DeconvHook;
import plugins.mitiv.io.Icy2TiPi;
import plugins.mitiv.io.IcyImager;

public class EpiDEMIC
extends DEMICSPlug {
    private EzTabs tabbedPane;
    private EzPanel dataPanel;
    private EzButton saveMetaData;
    private EzButton showPSF;
    private EzVarDouble dxy_nm;
    private EzPanel noisePanel;
    private EzPanel deconvPanel;
    private EzVarDouble epsilon;
    protected int Nxy = 32;
    private EzPanel bdecPanel;
    private EzVarText nbAlphaCoef;
    private EzVarText nbBetaCoef;
    private final String[] nAlphaOptions = new String[]{"0", "1", "3", "7", "8", "12", "18", "19", "25", "33", "34", "42", "52", "53", "63", "75", "76", "88", "102", "103"};
    private final String[] nBetaOptions = new String[]{"0", "3", "4", "6", "10", "11", "15", "21", "22", "28", "36", "37", "45", "55", "56", "66", "78", "79", "91", "105", "106"};
    private final String[] nAlphaOptionsR = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    private final String[] nBetaOptionsR = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    private EzVarBoolean radial;
    private EzButton showPSF2;
    private EzButton showModulus;
    private EzButton showPhase;
    private EzButton startBlind;
    private EzButton showFullObject2;
    private EzButton resetPSF;
    private EzLabel docDec;
    private EzVarInteger totalNbOfBlindDecLoop;
    private EzVarInteger maxIterDefocus;
    private EzVarInteger maxIterPhase;
    private EzVarInteger maxIterModulus;
    private EzLabel docBlind;
    private EzGroup visuPSF;
    private EzGroup ezBlindDeconvolutionGroup;
    private EzVarDoubleArrayNative pupilShift;
    private EzVarDoubleArrayNative phaseCoefs;
    private EzVarDoubleArrayNative modulusCoefs;
    private EzVarSequence outputHeadlessPSF = null;
    private PSF_Estimation psfEstimation;
    private WideFieldModel pupil = null;
    private boolean debug = false;
    private EzPanel debuggingPanel;
    private EzVarText resultCostPrior;
    private EzVarText resultDefocus;
    private EzVarText resultPhase;
    private EzVarText resultModulus;
    private String psfPath = null;
    private BlindDeconvJob bdec;

    public void clean() {
    }

    @Override
    protected void updatePaddedSize() {
        super.updatePaddedSize();
        this.Nx = this.Ny = (this.Nxy = Math.max(this.Nx, this.Ny));
        this.psfShape = new Shape(this.Nxy, this.Nxy, this.Nz);
        this.outputShape = new Shape(this.Nxy, this.Nxy, this.Nz);
    }

    @Override
    protected void setDefaultValue() {
        super.setDefaultValue();
        this.radial.setValue((Object)false);
        this.paddingSizeXY.setValue((Object)30);
        if (this.debug) {
            this.resultCostPrior.setValue((Object)"No results yet");
            this.resultDefocus.setValue((Object)"No results yet");
            this.resultModulus.setValue((Object)"No results yet");
            this.resultPhase.setValue((Object)"No results yet");
        }
        if (!this.isHeadLess() && this.debug) {
            this.resultCostPrior.setEnabled(false);
            this.resultDefocus.setEnabled(false);
            this.resultModulus.setEnabled(false);
            this.resultPhase.setEnabled(false);
        }
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.tabbedPane = new EzTabs("BlindTabs", EzTabs.TabPlacement.TOP);
        this.dataPanel = new EzPanel("Step 1: Data", new EzComponent[0]);
        this.saveMetaData = new EzButton("Save metadata", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EpiDEMIC.this.debug) {
                    System.out.println("Saving metadata");
                }
                EpiDEMIC.this.updateMetaData();
            }
        });
        this.paddingSizeXY = new EzVarInteger("padding in x and y:", 0, Integer.MAX_VALUE, 1);
        EzVarListener<Integer> zeroPadActionListener = new EzVarListener<Integer>(){

            public void variableChanged(EzVar<Integer> source, Integer newValue) {
                EpiDEMIC.this.updatePaddedSize();
                EpiDEMIC.this.updateImageSize();
                EpiDEMIC.this.updateOutputSize();
                EpiDEMIC.this.pupil = null;
            }
        };
        this.paddingSizeXY.addVarChangeListener((EzVarListener)zeroPadActionListener);
        this.paddingSizeZ.addVarChangeListener((EzVarListener)zeroPadActionListener);
        this.dataEV.addVarChangeListener((EzVarListener)new EzVarListener<Sequence>(){

            public void variableChanged(EzVar<Sequence> source, Sequence newValue) {
                if (EpiDEMIC.this.debug) {
                    System.out.println("Seq ch..." + newValue);
                }
                EpiDEMIC.this.dataChanged();
                if (EpiDEMIC.this.sizeZ == 1) {
                    EpiDEMIC.this.startDecButton.setEnabled(false);
                    EpiDEMIC.this.startBlind.setEnabled(false);
                    EpiDEMIC.this.throwError("Input channel must be 3D");
                    return;
                }
                if (EpiDEMIC.this.dataSeq != null) {
                    EpiDEMIC.this.startBlind.setEnabled(true);
                    if (EpiDEMIC.this.dataSeq.getPixelSizeX() != EpiDEMIC.this.dataSeq.getPixelSizeY()) {
                        EpiDEMIC.this.startDecButton.setEnabled(false);
                        EpiDEMIC.this.startBlind.setEnabled(false);
                        EpiDEMIC.this.throwError("Input channel must have the same scale in X and Y");
                        return;
                    }
                    EpiDEMIC.this.dxy_nm.setValue((Object)(EpiDEMIC.this.dataSeq.getPixelSizeX() * 1000.0));
                    EpiDEMIC.this.dz_nm.setValue((Object)(EpiDEMIC.this.dataSeq.getPixelSizeZ() * 1000.0));
                    EpiDEMIC.this.scale.setValue((Object)new double[]{1.0, 1.0, (Double)EpiDEMIC.this.dxy_nm.getValue() / (Double)EpiDEMIC.this.dz_nm.getValue()});
                    try {
                        EpiDEMIC.this.lambda.setValue((Object)(EpiDEMIC.this.metDat.getChannelEmissionWavelength(0, ((Integer)EpiDEMIC.this.channelEV.getValue()).intValue()).value().doubleValue() * 1000.0));
                    }
                    catch (Exception e) {
                        System.out.println("Failed to get some wavelength metadatas, will use default values ");
                        EpiDEMIC.this.lambda.setValue((Object)500.0);
                    }
                    try {
                        EpiDEMIC.this.na.setValue((Object)EpiDEMIC.this.metDat.getObjectiveLensNA(0, 0));
                    }
                    catch (Exception e) {
                        System.out.println("Failed to get na metadatas, will use default values ");
                        EpiDEMIC.this.na.setValue((Object)1.4);
                    }
                    try {
                        EpiDEMIC.this.ni.setValue((Object)EpiDEMIC.this.metDat.getObjectiveSettingsRefractiveIndex(0));
                    }
                    catch (Exception e) {
                        System.out.println("Failed to get refractive index from metadata, will use default values ");
                        EpiDEMIC.this.ni.setValue((Object)1.518);
                    }
                    if (EpiDEMIC.this.debug) {
                        System.out.println("Seq changed:" + EpiDEMIC.this.sizeX + "  " + EpiDEMIC.this.Nxy);
                    }
                } else {
                    EpiDEMIC.this.startDecButton.setEnabled(false);
                    EpiDEMIC.this.startBlind.setEnabled(false);
                }
            }
        });
        EzVarListener<Double> metaActionListener = new EzVarListener<Double>(){

            public void variableChanged(EzVar<Double> source, Double newValue) {
                EpiDEMIC.this.scale.setValue((Object)new double[]{1.0, 1.0, (Double)EpiDEMIC.this.dz_nm.getValue() / (Double)EpiDEMIC.this.dxy_nm.getValue()});
                EpiDEMIC.this.pupilShift.setValue((Object)new double[]{0.0, 0.0});
                EpiDEMIC.this.pupil = null;
            }
        };
        this.dxy_nm = new EzVarDouble("dxy(nm):", 64.5, 0.0, Double.MAX_VALUE, 1.0);
        this.dxy_nm.addVarChangeListener((EzVarListener)metaActionListener);
        this.dx_nm = new EzVarDouble("dx(nm):", 64.5, 0.0, Double.MAX_VALUE, 1.0);
        this.dx_nm.addVarChangeListener((EzVarListener)metaActionListener);
        this.dy_nm = new EzVarDouble("dy(nm):", 64.5, 0.0, Double.MAX_VALUE, 1.0);
        this.dy_nm.addVarChangeListener((EzVarListener)metaActionListener);
        this.dz_nm = new EzVarDouble("dz(nm):", 128.0, 0.0, Double.MAX_VALUE, 1.0);
        this.dz_nm.addVarChangeListener((EzVarListener)metaActionListener);
        this.na = new EzVarDouble("NA:", 1.4, 0.0, Double.MAX_VALUE, 0.05);
        this.na.addVarChangeListener((EzVarListener)metaActionListener);
        this.ni = new EzVarDouble("ni:", 1.518, 1.0, 2.0, 0.01);
        this.ni.addVarChangeListener((EzVarListener)metaActionListener);
        this.lambda = new EzVarDouble("\u03bb(nm):", 540.0, 10.0, 15000.0, 5.0);
        this.lambda.addVarChangeListener((EzVarListener)metaActionListener);
        this.showPSF = new EzButton("Show PSF", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EpiDEMIC.this.psfClicked();
                if (EpiDEMIC.this.debug) {
                    System.out.println("Showing PSF Button");
                }
            }
        });
        this.ezPaddingGroup = new EzGroup("Padding", new EzComponent[]{this.paddingSizeXY, this.paddingSizeZ});
        this.ezPaddingGroup.setFoldedState(true);
        this.noisePanel = new EzPanel("Step 2: Noise model", new EzComponent[0]);
        this.deconvPanel = new EzPanel("Step 3: Deconvolution", new EzComponent[0]);
        this.epsilon = new EzVarDouble("Threshold level:", 0.01, 0.0, Double.MAX_VALUE, 1.0);
        this.singlePrecision.addVarChangeListener((EzVarListener)new EzVarListener<Boolean>(){

            public void variableChanged(EzVar<Boolean> source, Boolean newValue) {
                EpiDEMIC.this.pupil = null;
                EpiDEMIC.this.psfEstimation = null;
                EpiDEMIC.this.cursequence = null;
            }
        });
        this.docDec = new EzLabel("Launch a deconvolution using the current PSF", Color.red);
        this.startDecButton = new EzButton("Start Deconvolution", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EpiDEMIC.this.launchClicked(false);
            }
        });
        this.ezDeconvolutionGroup = new EzGroup("Expert  parameters", new EzComponent[]{this.epsilon, this.scale, this.positivityEV, this.singlePrecision});
        this.ezDeconvolutionGroup.setFoldedState(true);
        this.bdecPanel = new EzPanel("Step 4: Blind deconvolution", new EzComponent[0]);
        this.pupilShift = new EzVarDoubleArrayNative("pupilShift", (double[][])new double[][]{{0.0, 0.0}}, false);
        this.pupilShift.setVisible(false);
        this.phaseCoefs = new EzVarDoubleArrayNative("phase coefs", (double[][])null, false);
        this.phaseCoefs.setVisible(false);
        this.modulusCoefs = new EzVarDoubleArrayNative("modulusCoefs", (double[][])new double[][]{{1.0}}, 0, false);
        this.modulusCoefs.setVisible(false);
        this.nbAlphaCoef = new EzVarText("Number of phase coefs N\u03b1:", this.nAlphaOptions, 3, Boolean.valueOf(false));
        this.nbBetaCoef = new EzVarText("Number of modulus coefs N\u03b2:", this.nBetaOptions, 0, Boolean.valueOf(false));
        this.radial = new EzVarBoolean("Radially symmetric PSF", false);
        this.maxIterDefocus = new EzVarInteger("Max. nb. of iterations for defocus:", 20, 0, Integer.MAX_VALUE, 1);
        this.maxIterPhase = new EzVarInteger("Max. nb. of iterations for phase:", 20, 0, Integer.MAX_VALUE, 1);
        this.maxIterModulus = new EzVarInteger("Max. nb. of iterations for modulus:", 0, 0, Integer.MAX_VALUE, 1);
        this.totalNbOfBlindDecLoop = new EzVarInteger("Number of loops:", 2, 0, Integer.MAX_VALUE, 1);
        this.showIteration = new EzVarBoolean("Show intermediate results:", true);
        if (this.isHeadLess()) {
            this.showIteration.setValue((Object)false);
        }
        this.resetPSF = new EzButton("Reset PSF", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EpiDEMIC.this.pupil = null;
                EpiDEMIC.this.phaseCoefs.setValue((Object)new double[Integer.parseInt((String)EpiDEMIC.this.nbAlphaCoef.getValue())]);
                double[] tmp = new double[Math.max(1, Integer.parseInt((String)EpiDEMIC.this.nbBetaCoef.getValue()))];
                tmp[0] = 1.0;
                EpiDEMIC.this.modulusCoefs.setValue((Object)tmp);
                EpiDEMIC.this.pupilShift.setValue((Object)new double[]{0.0, 0.0});
                if (EpiDEMIC.this.metDat != null) {
                    EpiDEMIC.this.ni.setValue((Object)1.518);
                } else {
                    EpiDEMIC.this.ni.setValue((Object)1.518);
                }
            }
        });
        this.nbAlphaCoef.addVarChangeListener((EzVarListener)new EzVarListener<String>(){

            public void variableChanged(EzVar<String> source, String newValue) {
                EpiDEMIC.this.pupil = null;
            }
        });
        this.nbBetaCoef.addVarChangeListener((EzVarListener)new EzVarListener<String>(){

            public void variableChanged(EzVar<String> source, String newValue) {
                EpiDEMIC.this.pupil = null;
            }
        });
        this.radial.addVarChangeListener((EzVarListener)new EzVarListener<Boolean>(){

            public void variableChanged(EzVar<Boolean> source, Boolean newValue) {
                if (newValue.booleanValue()) {
                    EpiDEMIC.this.nbAlphaCoef.setDefaultValues((Object[])EpiDEMIC.this.nAlphaOptionsR, 3, false);
                    EpiDEMIC.this.nbBetaCoef.setDefaultValues((Object[])EpiDEMIC.this.nBetaOptionsR, 1, false);
                    EpiDEMIC.this.pupil = null;
                } else {
                    EpiDEMIC.this.nbAlphaCoef.setDefaultValues((Object[])EpiDEMIC.this.nAlphaOptions, 7, false);
                    EpiDEMIC.this.nbBetaCoef.setDefaultValues((Object[])EpiDEMIC.this.nBetaOptions, 0, false);
                    EpiDEMIC.this.pupil = null;
                }
            }
        });
        this.showPSF2 = new EzButton("Show PSF", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EpiDEMIC.this.psfClicked();
                if (EpiDEMIC.this.debug) {
                    System.out.println("First PSF compute");
                }
            }
        });
        this.showPhase = new EzButton("Phase of the pupil function", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EpiDEMIC.this.phaseClicked();
                if (EpiDEMIC.this.debug) {
                    System.out.println("Show phase");
                }
            }
        });
        this.showModulus = new EzButton("Modulus of the pupil function", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EpiDEMIC.this.modulusClicked();
                if (EpiDEMIC.this.debug) {
                    System.out.println("Show modulus");
                }
            }
        });
        this.docBlind = new EzLabel("Joint estimation of the image and PSF", Color.RED);
        this.startBlind = new EzButton("Blind deconvolution", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EpiDEMIC.this.launchClicked(true);
            }
        });
        this.showFullObject2 = new EzButton("Show the full (padded) object", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EpiDEMIC.this.debug) {
                    System.out.println("showFull");
                }
                Sequence fSeq = new Sequence("Deconvolved image");
                fSeq.copyMetaDataFrom((Sequence)EpiDEMIC.this.dataEV.getValue(), false);
                fSeq.setMetaData(OMEUtil.createOMEXMLMetadata((MetadataRetrieve)((Sequence)EpiDEMIC.this.dataEV.getValue()).getOMEXMLMetadata()));
                if (EpiDEMIC.this.objArray != null) {
                    IcyImager.show(EpiDEMIC.this.objArray, fSeq, "Deconvolved " + ((Sequence)EpiDEMIC.this.dataEV.getValue()).getName() + " with padding. mu " + EpiDEMIC.this.mu.getValue(), EpiDEMIC.this.isHeadLess());
                } else {
                    IcyImager.show(ArrayUtils.extract((ShapedArray)EpiDEMIC.this.dataArray, (Shape)EpiDEMIC.this.outputShape), fSeq, "Deconvolved " + ((Sequence)EpiDEMIC.this.dataEV.getValue()).getName() + "with padding. mu=" + EpiDEMIC.this.mu.getValue(), EpiDEMIC.this.isHeadLess());
                }
            }
        });
        this.visuPSF = new EzGroup("Visualization", new EzComponent[]{this.showFullObject2, this.showIteration, this.showPSF2, this.showPhase, this.showModulus});
        this.saveFile = new EzVarFile("Save parameters in", "");
        this.saveParam = new EzButton("Save parameters", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EpiDEMIC.this.saveParamClicked();
                if (EpiDEMIC.this.debug) {
                    System.out.println("Save parameters");
                }
            }
        });
        this.ezBlindDeconvolutionGroup = new EzGroup("Expert  parameters", new EzComponent[]{this.nbAlphaCoef, this.nbBetaCoef, this.radial, this.maxIterDefocus, this.maxIterPhase, this.maxIterModulus});
        this.ezBlindDeconvolutionGroup.setFoldedState(true);
        this.debuggingPanel = new EzPanel("Results", new EzComponent[0]);
        this.resultCostPrior = new EzVarText("Costs");
        this.resultDefocus = new EzVarText("Defocus");
        this.resultModulus = new EzVarText("Modulus");
        this.resultPhase = new EzVarText("Phase");
        this.dataEV.setToolTipText("Sequence to  deconvolve");
        this.weightsSeq.setToolTipText("Map of space varying noise variance or precision");
        this.weightsMethod.setToolTipText("Map of space varying noise variance or precision");
        this.badpixMap.setToolTipText("The binary map with 0 for bad pixels");
        this.channelEV.setToolTipText("Choose the image channel to use for the deconvolution");
        this.dxy_nm.setToolTipText("Lateral pixel size (nm)");
        this.dz_nm.setToolTipText("Axial pixel size (nm)");
        this.na.setToolTipText("Numerical Aperture");
        this.lambda.setToolTipText("Wavelength (nm)");
        this.ni.setToolTipText("Refractive index of the immersion medium");
        this.gain.setToolTipText("The detector gain in electrons per analog digital unit (ADU)");
        this.noise.setToolTipText("The standard deviation of the readout noise in e-/pixel");
        this.mu.setToolTipText("Hyper-parameter");
        this.epsilon.setToolTipText("Threshold of hyperbolic TV");
        this.nbIterDeconv.setToolTipText("Maximum number of iterations");
        this.paddingSizeXY.setToolTipText("Pad with X lines");
        this.paddingSizeZ.setToolTipText("Pad with X lines");
        this.nbAlphaCoef.setToolTipText("Number of zernike describing the pupil phase");
        this.nbBetaCoef.setToolTipText("Number of zernike describing the pupil modulus");
        this.totalNbOfBlindDecLoop.setToolTipText("The maximum number of loops of the algorithm, the higher the potentially longer");
        this.restartEV.setToolTipText("Restart from previous result, if enabled will start with last image and PSF");
        this.positivityEV.setToolTipText("Enforce the positivity of the solution");
        this.showFullObjectButton.setToolTipText("Crop the output with the same field of view as the input.");
        this.showFullObject2.setToolTipText("Crop the output with the same field of view as the input.");
        this.debuggingPanel.setToolTipText("The output size as the nearest power of 2 size");
        this.dataPanel.add(new EzComponent[]{this.dataEV});
        this.dataPanel.add(new EzComponent[]{this.channelEV});
        this.dataPanel.add(new EzComponent[]{this.dataSizeTxt});
        this.dataPanel.add(new EzComponent[]{this.ezPaddingGroup});
        this.dataPanel.add(new EzComponent[]{this.outputSizeTxt});
        this.dataPanel.add(new EzComponent[]{this.dxy_nm});
        this.dataPanel.add(new EzComponent[]{this.dz_nm});
        this.dataPanel.add(new EzComponent[]{this.na});
        this.dataPanel.add(new EzComponent[]{this.ni});
        this.dataPanel.add(new EzComponent[]{this.lambda});
        this.dataPanel.add(new EzComponent[]{this.saveMetaData});
        this.dataPanel.add(new EzComponent[]{this.showPSF});
        this.dataPanel.add(new EzComponent[]{this.loadFile});
        this.dataPanel.add(new EzComponent[]{this.loadParam});
        this.tabbedPane.add(new EzComponent[]{this.dataPanel});
        this.noisePanel.add(new EzComponent[]{new EzLabel("The noise is supposed Gaussian with variance given by:\n")});
        this.noisePanel.add(new EzComponent[]{this.weightsMethod});
        this.noisePanel.add(new EzComponent[]{this.weightsSeq});
        this.noisePanel.add(new EzComponent[]{this.gain});
        this.noisePanel.add(new EzComponent[]{this.noise});
        this.noisePanel.add(new EzComponent[]{this.badpixMap});
        this.noisePanel.add(new EzComponent[]{this.showWeightButton});
        this.tabbedPane.add(new EzComponent[]{this.noisePanel});
        this.deconvPanel.add(new EzComponent[]{this.logmu});
        this.deconvPanel.add(new EzComponent[]{this.mu});
        this.deconvPanel.add(new EzComponent[]{this.nbIterDeconv});
        this.deconvPanel.add(new EzComponent[]{this.restartEV});
        this.deconvPanel.add(new EzComponent[]{this.channelRestartEV});
        this.deconvPanel.add(new EzComponent[]{this.ezDeconvolutionGroup});
        this.deconvPanel.add(new EzComponent[]{this.docDec});
        this.deconvPanel.add(new EzComponent[]{this.startDecButton});
        this.tabbedPane.add(new EzComponent[]{this.deconvPanel});
        this.bdecPanel.add(new EzComponent[]{this.resetPSF});
        this.bdecPanel.add(new EzComponent[]{this.totalNbOfBlindDecLoop});
        this.bdecPanel.add(new EzComponent[]{this.ezBlindDeconvolutionGroup});
        this.bdecPanel.add(new EzComponent[]{this.docBlind});
        this.bdecPanel.add(new EzComponent[]{this.startBlind});
        this.bdecPanel.add(new EzComponent[]{this.visuPSF});
        this.bdecPanel.add(new EzComponent[]{this.saveFile});
        this.bdecPanel.add(new EzComponent[]{this.saveParam});
        this.tabbedPane.add(new EzComponent[]{this.bdecPanel});
        if (this.debug) {
            this.debuggingPanel.add(new EzComponent[]{this.resultCostPrior});
            this.debuggingPanel.add(new EzComponent[]{this.resultDefocus});
            this.debuggingPanel.add(new EzComponent[]{this.resultModulus});
            this.debuggingPanel.add(new EzComponent[]{this.resultPhase});
            this.tabbedPane.add(new EzComponent[]{this.debuggingPanel});
        }
        this.addEzComponent((EzComponent)this.pupilShift);
        this.addEzComponent((EzComponent)this.phaseCoefs);
        this.addEzComponent((EzComponent)this.modulusCoefs);
        this.addEzComponent((EzComponent)this.tabbedPane);
        this.visuPSF.setFoldedState(true);
        this.setDefaultValue();
        this.updatePaddedSize();
        this.updateOutputSize();
        this.updateImageSize();
        if (this.isHeadLess()) {
            this.outputSizeTxt.setEnabled(false);
            this.dataSizeTxt.setEnabled(false);
            this.mu.setEnabled(false);
        } else {
            this.outputHeadlessImage = new EzVarSequence("Output Image");
            this.outputHeadlessPSF = new EzVarSequence("Output PSF");
            this.outputHeadlessWght = new EzVarSequence("Computed weight");
        }
    }

    private void launchClicked(final boolean flag) {
        if (this.deconvolver != null && this.deconvolver.isRunning()) {
            this.stopExecution();
        } else if (this.bdec != null && this.bdec.isRunning()) {
            this.stopExecution();
        } else {
            Thread workerThread = new Thread(){

                @Override
                public void run() {
                    EpiDEMIC.this.launch(flag);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (EpiDEMIC.this.debug) {
                                System.out.println("invoke later");
                            }
                            EpiDEMIC.this.restartEV.setValue(EpiDEMIC.this.cursequence);
                            EpiDEMIC.this.channelRestartEV.setValue((Object)0);
                        }
                    });
                }
            };
            workerThread.start();
        }
    }

    @Override
    protected void loadParamClicked() {
        File loadName = (File)this.loadFile.getValue();
        if (!this.isHeadLess()) {
            new AnnounceFrame("Loading deconvolution parameters from " + loadName.getAbsolutePath().toString(), 3);
        }
        this.loadParameters((File)this.loadFile.getValue());
        this.loadFile.setValue((Object)loadName);
        this.buildpupil();
        this.pupil.setPupilAxis((double[])this.pupilShift.getValue());
        this.pupil.setNi((Double)this.ni.getValue());
        this.pupil.setModulus((double[])this.modulusCoefs.getValue());
        this.pupil.setPhase((double[])this.phaseCoefs.getValue());
        if (this.dataSeq != null) {
            this.sizeX = this.dataSeq.getSizeX();
            this.sizeY = this.dataSeq.getSizeY();
            this.sizeZ = this.dataSeq.getSizeZ();
            if (this.sizeZ == 1) {
                this.throwError("Input data must be 3D");
                return;
            }
            this.updatePaddedSize();
            this.updateOutputSize();
            this.updateImageSize();
            this.dataShape = new Shape(this.sizeX, this.sizeY, this.sizeZ);
        }
    }

    @Override
    protected void saveParamClicked() {
        File pathName;
        if (this.pupil != null) {
            this.pupilShift.setValue((Object)this.pupil.getPupilShift());
            if (this.pupil.getPhaseCoefs() != null) {
                this.phaseCoefs.setValue((Object)this.pupil.getPhaseCoefs().getData());
            }
            this.modulusCoefs.setValue((Object)this.pupil.getModulusCoefs().getData());
        }
        if (this.debug) {
            System.out.println("--------------");
            System.out.println("defocus");
            System.out.println(this.pupil.getDefocus().toString());
        }
        if ((pathName = (File)this.saveFile.getValue()) != null) {
            if (!pathName.getName().endsWith(".xml")) {
                pathName = new File(pathName.getAbsolutePath() + ".xml");
            }
            if (!this.isHeadLess()) {
                new AnnounceFrame("Saving deconvolution parameters in " + pathName.getAbsolutePath().toString(), 3);
            }
            this.saveParameters(pathName);
        }
    }

    protected void execute() {
        if (this.isHeadLess()) {
            if (Icy.getCommandLinePluginArgs().length != 0) {
                this.initialize();
                this.parseCmdLine();
            }
            this.showIteration.setValue((Object)false);
            this.dataChanged();
        }
        long startTime = System.currentTimeMillis();
        this.launch(true);
        long stopTime = System.currentTimeMillis();
        long elapsedTime = stopTime - startTime;
        System.out.println("time: " + elapsedTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launch(boolean runBdec) {
        try {
            this.startBlind.setText("Emergency stop");
            this.startDecButton.setText("Emergency stop");
            this.buildpupil();
            if (this.debug || this.isHeadLess()) {
                System.out.println("-------------IMAGE-------------------");
                System.out.println("File: " + this.dataEV.getValue());
                System.out.println("Canal: " + this.channelEV.getValue());
                System.out.println("image size: " + (String)this.dataSizeTxt.getValue());
                System.out.println("--------------PSF------------------");
                System.out.println("dxy: " + (Double)this.dxy_nm.getValue() * 1.0E-9);
                System.out.println("dz: " + (Double)this.dz_nm.getValue() * 1.0E-9);
                System.out.println("Nxy: " + this.Nxy);
                System.out.println("Nx: " + this.Nz);
                System.out.println("NA: " + this.na.getValue());
                System.out.println("\u03bb: " + (Double)this.lambda.getValue() * 1.0E-9);
                System.out.println("ni: " + this.ni.getValue());
                System.out.println("--------------Variance------------------");
                System.out.println("Weights method: " + (String)this.weightsMethod.getValue());
                System.out.println("Weights: " + this.weightsSeq.getValue());
                System.out.println("Gain: " + this.gain.getValue());
                System.out.println("Noise: " + this.noise.getValue());
                System.out.println("deadPix: " + this.badpixMap.getValue());
                System.out.println("--------------DECONV------------------");
                System.out.println("zeroPad xy: " + this.paddingSizeXY.getValue());
                System.out.println("zeroPad z: " + this.paddingSizeZ.getValue());
                System.out.println("nbIter: " + this.nbIterDeconv.getValue());
                System.out.println("Restart: " + this.restartEV.getValue());
                System.out.println("Positivity: " + this.positivityEV.getValue());
                System.out.println("--------------BDEC------------------");
                System.out.println("output size: " + (String)this.outputSizeTxt.getValue());
                System.out.println("nbIter: " + this.nbIterDeconv.getValue());
                System.out.println("Number of total iterations: " + this.totalNbOfBlindDecLoop.getValue());
                System.out.println("------------------------------------");
                System.out.println("");
            }
            if (runBdec) {
                int nbAlpha = Integer.parseInt((String)this.nbAlphaCoef.getValue());
                int nbBeta = Integer.parseInt((String)this.nbBetaCoef.getValue());
                if (nbAlpha == 0) {
                    this.maxIterPhase.setValue((Object)0);
                } else {
                    this.pupil.setNPhase(nbAlpha);
                }
                if (nbBeta == 0) {
                    this.maxIterModulus.setValue((Object)0);
                } else {
                    this.pupil.setNModulus(nbBeta);
                }
                this.psfEstimation = new PSF_Estimation(this.pupil);
                this.psfArray = ArrayUtils.roll((ShapedArray)this.pupil.getPsf());
                this.preProcessing();
                this.psfEstimation.setWeight(ArrayUtils.pad((ShapedArray)this.wgtArray, (Shape)this.outputShape));
                this.psfEstimation.setData(ArrayUtils.pad((ShapedArray)this.dataArray, (Shape)this.outputShape));
                this.psfEstimation.enablePositivity(false);
                this.psfEstimation.setAbsoluteTolerance(0.0);
                int[] bMaxIter = new int[]{(Integer)this.maxIterDefocus.getValue(), (Integer)this.maxIterPhase.getValue(), (Integer)this.maxIterModulus.getValue()};
                this.bdec = new BlindDeconvJob((Integer)this.totalNbOfBlindDecLoop.getValue(), this.pupil.getParametersFlags(), bMaxIter, this.psfEstimation, this.deconvolver, this.wghtUpdt, this.debug);
                this.objArray = this.bdec.blindDeconv(this.objArray);
                this.wgtArray = this.wghtUpdt.getWeights();
                this.gain.setValue((Object)((weightsFromModel)this.wghtUpdt).getAlpha());
                this.noise.setValue((Object)(Math.sqrt(((weightsFromModel)this.wghtUpdt).getBeta()) / (Double)this.gain.getValue()));
                if ((Integer)this.maxIterDefocus.getValue() > 0) {
                    this.ni.setValue((Object)((WideFieldModel)this.psfEstimation.getModel()).getNi());
                    this.pupilShift.setValue((Object)((WideFieldModel)this.psfEstimation.getModel()).getPupilShift());
                }
                if ((Integer)this.maxIterPhase.getValue() > 0) {
                    this.phaseCoefs.setValue((Object)((WideFieldModel)this.psfEstimation.getModel()).getPhaseCoefs().getData());
                }
                if ((Integer)this.maxIterModulus.getValue() > 0) {
                    this.modulusCoefs.setValue((Object)((WideFieldModel)this.psfEstimation.getModel()).getModulusCoefs().getData());
                }
                this.pupil = (WideFieldModel)this.psfEstimation.getModel();
                this.bdec = null;
            } else {
                this.psfArray = ArrayUtils.roll((ShapedArray)this.pupil.getPsf());
                this.pupil.freeMem();
                this.preProcessing();
                this.deconv();
            }
            if (this.pupil != null) {
                this.pupil.freeMem();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EpiDEMIC.this.enableVars(true);
                    EpiDEMIC.this.restartEV.setValue(EpiDEMIC.this.cursequence);
                    EpiDEMIC.this.channelRestartEV.setValue((Object)0);
                    if (EpiDEMIC.this.isHeadLess()) {
                        if (EpiDEMIC.this.outputHeadlessImage == null) {
                            EpiDEMIC.this.outputHeadlessImage = new EzVarSequence("Output Image");
                        }
                        if (EpiDEMIC.this.outputHeadlessPSF == null) {
                            EpiDEMIC.this.outputHeadlessPSF = new EzVarSequence("Output PSF");
                        }
                        if (EpiDEMIC.this.outputHeadlessWght == null) {
                            EpiDEMIC.this.outputHeadlessWght = new EzVarSequence("Computed weightsSeq");
                        }
                        Sequence psfSequence = null;
                        psfSequence = Icy2TiPi.arrayToSequence(ArrayUtils.roll((ShapedArray)EpiDEMIC.this.pupil.getPsf()), psfSequence);
                        EpiDEMIC.this.outputHeadlessPSF.setValue(psfSequence);
                        EpiDEMIC.this.outputHeadlessImage.setValue(EpiDEMIC.this.cursequence);
                        EpiDEMIC.this.outputHeadlessWght.setValue(Icy2TiPi.arrayToSequence(EpiDEMIC.this.wgtArray));
                        if (EpiDEMIC.this.outputPath != null) {
                            IcyImager.save(EpiDEMIC.this.cursequence, EpiDEMIC.this.outputPath);
                        }
                        if (EpiDEMIC.this.psfPath != null) {
                            IcyImager.save(psfSequence, EpiDEMIC.this.psfPath);
                        }
                        if (EpiDEMIC.this.saveFile.getValue() != null) {
                            EpiDEMIC.this.saveParamClicked();
                        }
                    }
                }
            });
        }
        catch (IllegalArgumentException e) {
            if (!this.isHeadLess()) {
                new AnnounceFrame("Oops, Error: " + e.getMessage());
            }
            this.enableVars(true);
            if (this.debug) {
                e.printStackTrace();
            }
        }
        finally {
            this.startBlind.setText("Guess PSF");
            this.startDecButton.setText("Start Deconvolution");
        }
    }

    private void enableVars(boolean flag) {
        if (!this.isHeadLess()) {
            this.nbAlphaCoef.setEnabled(flag);
            this.nbBetaCoef.setEnabled(flag);
            this.radial.setEnabled(flag);
            this.na.setEnabled(flag);
            this.lambda.setEnabled(flag);
            this.dxy_nm.setEnabled(flag);
            this.dz_nm.setEnabled(flag);
            this.ni.setEnabled(flag);
            this.dataEV.setEnabled(flag);
            this.channelEV.setEnabled(flag);
            this.paddingSizeXY.setEnabled(flag);
            this.paddingSizeZ.setEnabled(flag);
            this.singlePrecision.setEnabled(flag);
            this.loadParam.setEnabled(flag);
        }
    }

    private void buildpupil() {
        if (this.pupil == null) {
            this.pupil = new WideFieldModel(this.psfShape, Integer.parseInt((String)this.nbAlphaCoef.getValue()), Integer.parseInt((String)this.nbBetaCoef.getValue()), (Double)this.na.getValue(), (Double)this.lambda.getValue() * 1.0E-9, (Double)this.ni.getValue(), (Double)this.dxy_nm.getValue() * 1.0E-9, (Double)this.dz_nm.getValue() * 1.0E-9, (Boolean)this.radial.getValue(), (Boolean)this.singlePrecision.getValue());
            this.pupil.setPupilAxis((double[])this.pupilShift.getValue());
            this.pupil.setModulus((double[])this.modulusCoefs.getValue());
            if (this.phaseCoefs.getValue() != null) {
                this.pupil.setPhase((double[])this.phaseCoefs.getValue());
            }
        }
    }

    private void psfClicked() {
        Thread workerThread = new Thread(){

            @Override
            public void run() {
                if (EpiDEMIC.this.pupil == null) {
                    EpiDEMIC.this.buildpupil();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Sequence psfSequence = new Sequence();
                        if (EpiDEMIC.this.dataSeq != null) {
                            psfSequence.copyMetaDataFrom(EpiDEMIC.this.dataSeq, false);
                        }
                        if (EpiDEMIC.this.bdec != null && EpiDEMIC.this.bdec.isRunning()) {
                            IcyImager.show(EpiDEMIC.this.bdec.getPsf(), psfSequence, "Estimated PSF", EpiDEMIC.this.isHeadLess());
                        } else {
                            IcyImager.show(ArrayUtils.roll((ShapedArray)EpiDEMIC.this.pupil.getPsf()), psfSequence, "Estimated PSF", EpiDEMIC.this.isHeadLess());
                        }
                        psfSequence.getFirstViewer().getLut().getLutChannel(0).setColorMap((IcyColorMap)new IceColorMap(), false);
                    }
                });
            }
        };
        workerThread.start();
    }

    private void phaseClicked() {
        if (this.pupil == null) {
            this.buildpupil();
        }
        Double2D phase = this.bdec != null && this.bdec.isRunning() ? Double2D.wrap((double[])((WideFieldModel)this.bdec.getPupil()).getPhi(), (Shape)new Shape(this.Nxy, this.Nxy)) : Double2D.wrap((double[])this.pupil.getPhi(), (Shape)new Shape(this.Nxy, this.Nxy));
        IcyImager.show(ArrayUtils.roll((ShapedArray)phase), null, "Phase of the pupil", false);
    }

    private void modulusClicked() {
        if (this.pupil == null) {
            this.buildpupil();
        }
        Double2D modulus = this.bdec != null && this.bdec.isRunning() ? Double2D.wrap((double[])((WideFieldModel)this.bdec.getPupil()).getRho(), (Shape)new Shape(this.Nxy, this.Nxy)) : Double2D.wrap((double[])this.pupil.getRho(), (Shape)new Shape(this.Nxy, this.Nxy));
        IcyImager.show(ArrayUtils.roll((ShapedArray)modulus), null, "Modulus of the pupil", false);
    }

    private void showWeightClicked() {
        this.dataSeq = (Sequence)this.dataEV.getValue();
        this.dataArray = (Boolean)this.singlePrecision.getValue() != false ? Icy2TiPi.sequenceToArray(this.dataSeq, (Integer)this.channelEV.getValue()).toFloat() : Icy2TiPi.sequenceToArray(this.dataSeq, (Integer)this.channelEV.getValue()).toDouble();
        this.createWeights(true);
        IcyImager.show(this.wgtArray, null, "Weight map", false);
    }

    public void stopExecution() {
        if (this.deconvolver != null) {
            this.deconvolver.abort();
        }
        if (this.bdec != null) {
            this.bdec.abort();
        }
    }

    private void preProcessing() {
        this.dataSeq = (Sequence)this.dataEV.getValue();
        if (this.dataSeq == null) {
            this.throwError("No image/sequence");
            return;
        }
        this.dataArray = (Boolean)this.singlePrecision.getValue() != false ? Icy2TiPi.sequenceToArray(this.dataSeq, (Integer)this.channelEV.getValue()).toFloat() : Icy2TiPi.sequenceToArray(this.dataSeq, (Integer)this.channelEV.getValue()).toDouble();
        this.dataShape = this.dataArray.getShape();
        Sequence restartSeq = (Sequence)this.restartEV.getValue();
        if (restartSeq != null) {
            this.objArray = Icy2TiPi.sequenceToArray(restartSeq, (Integer)this.channelRestartEV.getValue());
            if (this.debug) {
                System.out.println("restart seq:" + restartSeq.getName());
            }
        } else if (this.debug) {
            System.out.println("restart seq is null:");
        }
        if (((double[])this.scale.getValue()).length != 3) {
            this.throwError("Pixel scale must have 3 elements");
            return;
        }
        this.createWeights(true);
        if (this.weightsMethod.getValue() == this.weightOptions[4]) {
            this.wghtUpdt = new weightsFromModel(this.dataArray, this.badpixArray);
        }
        if (this.cursequence == null) {
            this.cursequence = new Sequence("Current Iterate");
            this.cursequence.copyMetaDataFrom((Sequence)this.dataEV.getValue(), false);
        }
        IcyImager curImager = new IcyImager(this.cursequence, this.isHeadLess());
        DeconvHook dHook = new DeconvHook(curImager, this.dataShape, null, this.debug);
        DeconvHook dHookfinal = new DeconvHook(curImager, this.dataShape, "Deconvolved " + this.dataSeq.getName(), this.debug);
        this.buildVectorSpaces();
        HyperbolicTotalVariation fprior = new HyperbolicTotalVariation(this.objectSpace, ((Double)this.epsilon.getValue()).doubleValue(), (double[])this.scale.getValue());
        WeightedConvolutionCost fdata = WeightedConvolutionCost.build((ShapedVectorSpace)this.objectSpace, (ShapedVectorSpace)this.dataSpace);
        fdata.setData(this.dataArray);
        fdata.setWeights(this.wgtArray, true);
        fdata.setPSF(this.psfArray);
        this.deconvolver = new DeconvolutionJob((DifferentiableCostFunction)fdata, ((Double)this.mu.getValue()).doubleValue(), (DifferentiableCostFunction)fprior, ((Boolean)this.positivityEV.getValue()).booleanValue(), ((Integer)this.nbIterDeconv.getValue()).intValue(), (TiPiHook)dHook, (TiPiHook)dHookfinal);
        this.objArray = ArrayUtils.extract((ShapedArray)this.objArray, (Shape)this.outputShape, (double)0.0);
    }

    private void deconv() {
        if (this.debug) {
            System.out.println("Launch it:" + this.nbIterDeconv.getValue());
        }
        this.objArray = this.deconvolver.deconv(this.objArray);
        if (this.wghtUpdt != null) {
            this.wghtUpdt.update((Object)this.deconvolver);
        }
        this.wgtArray = this.wghtUpdt.getWeights();
        this.gain.setValue((Object)((weightsFromModel)this.wghtUpdt).getAlpha());
        this.noise.setValue((Object)(Math.sqrt(((weightsFromModel)this.wghtUpdt).getBeta()) / (Double)this.gain.getValue()));
    }

    @Override
    public void declareInput(VarList inputMap) {
        this.initialize();
        super.declareInput(inputMap);
        inputMap.add("dxy", this.dxy_nm.getVariable());
        inputMap.add("dz", this.dz_nm.getVariable());
        inputMap.add("NA", this.na.getVariable());
        inputMap.add("ni", this.ni.getVariable());
        inputMap.add("lambda", this.lambda.getVariable());
        inputMap.add("espilon", this.epsilon.getVariable());
        inputMap.add("padding xy", this.paddingSizeXY.getVariable());
        inputMap.add("padding z", this.paddingSizeZ.getVariable());
        inputMap.add("radial", this.radial.getVariable());
        inputMap.add("nbAlphaCoef", this.nbAlphaCoef.getVariable());
        inputMap.add("nbBetaCoef", this.nbBetaCoef.getVariable());
        inputMap.add("defocusMaxIter", this.maxIterDefocus.getVariable());
        inputMap.add("phaseMaxIter", this.maxIterPhase.getVariable());
        inputMap.add("modulusMaxIter", this.maxIterModulus.getVariable());
        inputMap.add("bDecTotalIteration", this.totalNbOfBlindDecLoop.getVariable());
        inputMap.add("loadFile", this.loadFile.getVariable());
        this.badpixMap.setNoSequenceSelection();
    }

    @Override
    public void declareOutput(VarList outputMap) {
        super.declareOutput(outputMap);
        outputMap.add("outputPSF", (Var)this.outputHeadlessPSF.getVariable());
        outputMap.add("pupilShift", this.pupilShift.getVariable());
        outputMap.add("phaseCoefs", this.phaseCoefs.getVariable());
        outputMap.add("modulusCoefs", this.modulusCoefs.getVariable());
    }

    private void parseCmdLine() {
        String[] args = Icy.getCommandLinePluginArgs();
        this.loadFile.setValue((Object)new File(args[0]));
        this.loadParamClicked();
        System.out.println("Load Param... " + args[0]);
        block18: for (int i = 1; i < args.length; ++i) {
            switch (args[i]) {
                case "-i": {
                    if (i + 1 >= args.length || args[i + 1].startsWith("-")) continue block18;
                    System.out.println("load image:" + args[i + 1]);
                    this.dataEV.setValue(Loader.loadSequence((String)args[i + 1], (int)0, (boolean)false));
                    this.dataChanged();
                    if (i + 3 >= args.length) continue block18;
                    if (args[i + 2].equalsIgnoreCase("-c")) {
                        this.channelEV.setValue((Object)Integer.parseInt(args[i + 3]));
                        i += 3;
                        continue block18;
                    }
                    ++i;
                    continue block18;
                }
                case "-r": {
                    if (i + 1 >= args.length || args[i + 1].startsWith("-")) continue block18;
                    System.out.println("load restart:" + args[i + 1]);
                    this.restartEV.setValue(Loader.loadSequence((String)args[i + 1], (int)0, (boolean)false));
                    if (i + 3 >= args.length) continue block18;
                    if (args[i + 2].equalsIgnoreCase("-c")) {
                        System.out.println("channel restart:" + Integer.parseInt(args[i + 3]));
                        this.channelRestartEV.setValue((Object)Integer.parseInt(args[i + 3]));
                        i += 3;
                        continue block18;
                    }
                    ++i;
                    continue block18;
                }
                case "-o": {
                    if (i + 1 >= args.length || args[i + 1].startsWith("-")) continue block18;
                    this.outputPath = args[i + 1];
                    ++i;
                    continue block18;
                }
                case "-p": {
                    if (i + 1 >= args.length || args[i + 1].startsWith("-")) continue block18;
                    this.psfPath = args[i + 1];
                    ++i;
                    continue block18;
                }
                case "-s": {
                    if (i + 1 >= args.length || args[i + 1].startsWith("-")) continue block18;
                    this.saveFile.setValue((Object)new File(args[i + 1]));
                    ++i;
                    continue block18;
                }
                case "-badpix": {
                    if (i + 1 >= args.length || args[i + 1].startsWith("-")) continue block18;
                    this.badpixMap.setValue(Loader.loadSequence((String)args[i + 1], (int)0, (boolean)false));
                    ++i;
                    continue block18;
                }
                case "-wghtmap": {
                    if (i + 1 >= args.length || args[i + 1].startsWith("-")) continue block18;
                    this.weightsSeq.setValue(Loader.loadSequence((String)args[i + 1], (int)0, (boolean)false));
                    ++i;
                    continue block18;
                }
                default: {
                    System.out.println("Wrong command line");
                    System.out.println("-i input channel file");
                    System.out.println("-r restart file");
                    System.out.println("-o deconvolved output file");
                    System.out.println("-p psf output file");
                    System.out.println("-s parameter output file");
                    System.out.println("-badpix bad pixels file");
                    System.out.println("-wghtmap weight or variance map file");
                }
            }
        }
    }

    @Override
    protected void dataChanged() {
        super.dataChanged();
        if (this.dataSeq != null) {
            this.epsilon.setValue((Object)(new Histogram(Icy2TiPi.sequenceToArray(this.dataSeq, (Integer)this.channelEV.getValue())).getMaximumValue() / 1000.0));
        }
        this.badpixArray = null;
        this.psfEstimation = null;
        this.cursequence = null;
        this.pupil = null;
        this.deconvolver = null;
    }
}

