/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.util.Properties;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MetadataOptions;

public class DynamicMetadataOptions
implements MetadataOptions {
    public static final String METADATA_LEVEL_KEY = "metadata.level";
    public static final MetadataLevel METADATA_LEVEL_DEFAULT = MetadataLevel.ALL;
    public static final String READER_VALIDATE_KEY = "reader.validate.input";
    public static final boolean READER_VALIDATE_DEFAULT = false;
    private Properties props = new Properties();

    public DynamicMetadataOptions() {
        this(METADATA_LEVEL_DEFAULT);
    }

    public DynamicMetadataOptions(MetadataLevel level) {
        this.setEnum(METADATA_LEVEL_KEY, level);
        this.setBoolean(READER_VALIDATE_KEY, false);
    }

    @Override
    public MetadataLevel getMetadataLevel() {
        return this.getEnum(METADATA_LEVEL_KEY, METADATA_LEVEL_DEFAULT);
    }

    @Override
    public void setMetadataLevel(MetadataLevel level) {
        this.setEnum(METADATA_LEVEL_KEY, level);
    }

    @Override
    public boolean isValidate() {
        return this.getBoolean(READER_VALIDATE_KEY, false);
    }

    @Override
    public void setValidate(boolean validateMetadata) {
        this.setBoolean(READER_VALIDATE_KEY, validateMetadata);
    }

    public void set(String name, String value) {
        if (null == name) {
            throw new IllegalArgumentException("name cannot be null");
        }
        try {
            this.props.setProperty(name, value);
        }
        catch (NullPointerException e) {
            this.props.remove(name);
        }
    }

    public String get(String name) {
        return this.props.getProperty(name);
    }

    public String get(String name, String defaultValue) {
        return this.props.getProperty(name, defaultValue);
    }

    public <T extends Enum<T>> void setEnum(String name, T value) {
        if (null == value) {
            this.set(name, null);
        } else {
            this.set(name, value.toString());
        }
    }

    public <T extends Enum<T>> T getEnum(String name, T defaultValue) {
        if (null == defaultValue) {
            throw new IllegalArgumentException("default value can't be null");
        }
        String val = this.get(name);
        if (null == val) {
            return defaultValue;
        }
        return Enum.valueOf(defaultValue.getDeclaringClass(), val);
    }

    public void setBoolean(String name, Boolean value) {
        if (null == value) {
            this.set(name, null);
        } else {
            this.set(name, Boolean.toString(value));
        }
    }

    public Boolean getBoolean(String name) {
        return this.getBoolean(name, null);
    }

    public Boolean getBoolean(String name, Boolean defaultValue) {
        String val = this.get(name);
        if (null == val) {
            return defaultValue;
        }
        if (val.equalsIgnoreCase("true")) {
            return true;
        }
        if (val.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalArgumentException(val + "does not represent a boolean");
    }

    public void setInteger(String name, Integer value) {
        if (null == value) {
            this.set(name, null);
        } else {
            this.set(name, Integer.toString(value));
        }
    }

    public Integer getInteger(String name) {
        return this.getInteger(name, null);
    }

    public Integer getInteger(String name, Integer defaultValue) {
        String val = this.get(name);
        if (null == val) {
            return defaultValue;
        }
        return Integer.parseInt(val);
    }

    public void setLong(String name, Long value) {
        if (null == value) {
            this.set(name, null);
        } else {
            this.set(name, Long.toString(value));
        }
    }

    public Long getLong(String name) {
        return this.getLong(name, null);
    }

    public Long getLong(String name, Long defaultValue) {
        String val = this.get(name);
        if (null == val) {
            return defaultValue;
        }
        return Long.parseLong(val);
    }

    public void setFloat(String name, Float value) {
        if (null == value) {
            this.set(name, null);
        } else {
            this.set(name, Float.toString(value.floatValue()));
        }
    }

    public Float getFloat(String name) {
        return this.getFloat(name, null);
    }

    public Float getFloat(String name, Float defaultValue) {
        String val = this.get(name);
        if (null == val) {
            return defaultValue;
        }
        return Float.valueOf(Float.parseFloat(val));
    }

    public void setDouble(String name, Double value) {
        if (null == value) {
            this.set(name, null);
        } else {
            this.set(name, Double.toString(value));
        }
    }

    public Double getDouble(String name) {
        return this.getDouble(name, null);
    }

    public Double getDouble(String name, Double defaultValue) {
        String val = this.get(name);
        if (null == val) {
            return defaultValue;
        }
        return Double.parseDouble(val);
    }

    public void setClass(String name, Class<?> value) {
        if (null == value) {
            this.set(name, null);
        } else {
            this.set(name, value.getName());
        }
    }

    public Class<?> getClass(String name) throws ClassNotFoundException {
        return this.getClass(name, null);
    }

    public Class<?> getClass(String name, Class<?> defaultValue) throws ClassNotFoundException {
        String val = this.get(name);
        if (null == val) {
            return defaultValue;
        }
        return Class.forName(val);
    }

    public void setFile(String name, File value) {
        if (null == value) {
            this.set(name, null);
        } else {
            this.set(name, value.toString());
        }
    }

    public File getFile(String name) {
        return this.getFile(name, null);
    }

    public File getFile(String name, File defaultValue) {
        String val = this.get(name);
        if (null == val) {
            return defaultValue;
        }
        return new File(val);
    }
}

