/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.LightSource;
import ome.xml.model.MapPair;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GenericExcitationSource
extends LightSource {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericExcitationSource.class);
    private List<MapPair> map;

    public GenericExcitationSource() {
    }

    public GenericExcitationSource(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public GenericExcitationSource(GenericExcitationSource orig) {
        super(orig);
        this.map = orig.map;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        List<Element> Map_nodeList = GenericExcitationSource.getChildrenByTagName(element, "Map");
        if (Map_nodeList.size() > 1) {
            throw new RuntimeException(String.format("Map node list size %d != 1", Map_nodeList.size()));
        }
        if (Map_nodeList.size() != 0) {
            ArrayList<MapPair> p = new ArrayList<MapPair>();
            NodeList children = Map_nodeList.get(0).getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                p.add(new MapPair(((Element)child).getAttribute("K"), child.getTextContent()));
            }
            this.setMap(p);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", (Object)reference.getClass());
        return false;
    }

    public List<MapPair> getMap() {
        return this.map;
    }

    public void setMap(List<MapPair> map) {
        this.map = map;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element GenericExcitationSource_element) {
        if (GenericExcitationSource_element == null) {
            GenericExcitationSource_element = document.createElementNS(NAMESPACE, "GenericExcitationSource");
        }
        super.asXMLElement(document, GenericExcitationSource_element);
        if (this.map != null) {
            Element map_child = document.createElementNS(NAMESPACE, "Map");
            for (MapPair entry : this.map) {
                Element pair = document.createElementNS(NAMESPACE, "M");
                pair.setAttribute("K", entry.getName());
                pair.setTextContent(entry.getValue());
                map_child.appendChild(pair);
            }
            GenericExcitationSource_element.appendChild(map_child);
        }
        return GenericExcitationSource_element;
    }
}

