/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory.partition;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import thredds.filesystem.MFileOS7;
import thredds.inventory.CollectionAbstract;
import thredds.inventory.MFile;
import ucar.nc2.util.CloseableIterator;

public class DirectoryCollection
extends CollectionAbstract {
    final String topCollection;
    final Path collectionDir;
    final long olderThanMillis;
    final boolean isTop;
    private static final boolean debug = false;
    private static int debugCount = 0;

    public static String makeCollectionName(String topCollectionName, Path dir) {
        int last = dir.getNameCount() - 1;
        Path lastDir = dir.getName(last);
        String lastDirName = lastDir.toString();
        return topCollectionName + "-" + lastDirName;
    }

    public static Path makeCollectionIndexPath(String topCollectionName, Path dir) {
        String collectionName = DirectoryCollection.makeCollectionName(topCollectionName, dir);
        return Paths.get(dir.toString(), collectionName + ".ncx3");
    }

    public DirectoryCollection(String topCollectionName, String topDirS, boolean isTop, String olderThan, Logger logger) {
        this(topCollectionName, Paths.get(topDirS, new String[0]), isTop, olderThan, logger);
    }

    public DirectoryCollection(String topCollectionName, Path collectionDir, boolean isTop, String olderThan, Logger logger) {
        super(null, logger);
        this.topCollection = DirectoryCollection.cleanName(topCollectionName);
        this.collectionDir = collectionDir;
        this.collectionName = isTop ? this.topCollection : DirectoryCollection.makeCollectionName(this.topCollection, collectionDir);
        this.isTop = isTop;
        this.olderThanMillis = this.parseOlderThanString(olderThan);
    }

    @Override
    public String getRoot() {
        return this.collectionDir.toString();
    }

    @Override
    public String getIndexFilename() {
        if (this.isTop) {
            return super.getIndexFilename();
        }
        Path indexPath = DirectoryCollection.makeCollectionIndexPath(this.topCollection, this.collectionDir);
        return indexPath.toString();
    }

    @Override
    public Iterable<MFile> getFilesSorted() throws IOException {
        return this.makeFileListSorted();
    }

    @Override
    public CloseableIterator<MFile> getFileIterator() throws IOException {
        return new MyFileIterator(this.collectionDir);
    }

    @Override
    public void close() {
    }

    public void iterateOverMFileCollection(Visitor visit) throws IOException {
        boolean count = false;
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(this.collectionDir, new CollectionAbstract.MyStreamFilter(this));){
            for (Path p : ds) {
                BasicFileAttributes attr = Files.readAttributes(p, BasicFileAttributes.class, new LinkOption[0]);
                if (attr.isDirectory()) continue;
                visit.consume(new MFileOS7(p));
            }
        }
    }

    public static interface Visitor {
        public void consume(MFile var1);
    }

    private class MyFileIterator
    implements CloseableIterator<MFile> {
        int debugNum;
        DirectoryStream<Path> dirStream;
        Iterator<Path> dirStreamIterator;
        MFile nextMFile;
        int count = 0;

        MyFileIterator(Path dir) throws IOException {
            try {
                this.dirStream = Files.newDirectoryStream(dir, new CollectionAbstract.MyStreamFilter(DirectoryCollection.this));
                this.dirStreamIterator = this.dirStream.iterator();
            }
            catch (IOException ioe) {
                DirectoryCollection.this.logger.error("Files.newDirectoryStream failed to open directory " + dir.getFileName(), ioe);
                throw ioe;
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public boolean hasNext() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public MFile next() {
            if (this.nextMFile == null) {
                throw new NoSuchElementException();
            }
            return this.nextMFile;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws IOException {
            this.dirStream.close();
        }
    }
}

