/*
 * Decompiled with CFR 0.152.
 */
package icy.preferences;

import icy.network.AuthenticationInfo;
import icy.preferences.ApplicationPreferences;
import icy.preferences.XMLPreferences;
import icy.util.StringUtil;
import java.util.ArrayList;
import java.util.HashSet;

public class RepositoryPreferences {
    private static final String PREF_ID = "repositories";
    private static XMLPreferences preferences;
    public static final String DEFAULT_REPOSITERY_NAME = "default";
    public static final String DEFAULT_REPOSITERY_LOCATION = "http://icy.bioimageanalysis.org/repository/";
    public static final String DEFAULT_REPOSITERY_LOCATION_OLD = "http://www.bioimageanalysis.org/icy/repository/";

    public static void load() {
        preferences = ApplicationPreferences.getPreferences().node(PREF_ID);
    }

    public static XMLPreferences getPreferences() {
        return preferences;
    }

    public static ArrayList<RepositoryInfo> getRepositeries() {
        HashSet<RepositoryInfo> result = new HashSet<RepositoryInfo>();
        ArrayList<String> childs = preferences.childrenNames();
        for (String child : childs) {
            RepositoryInfo reposInf = new RepositoryInfo(preferences.node(child));
            if (reposInf.isEmpty() || reposInf.isOldDefault()) continue;
            result.add(reposInf);
        }
        result.add(new RepositoryInfo(DEFAULT_REPOSITERY_NAME, DEFAULT_REPOSITERY_LOCATION, true));
        return new ArrayList<RepositoryInfo>(result);
    }

    public static void setRepositeries(ArrayList<RepositoryInfo> values) {
        preferences.removeChildren();
        int i = 0;
        for (RepositoryInfo reposInf : values) {
            if (!reposInf.isEmpty()) {
                reposInf.save(preferences.node("repos" + i));
            }
            ++i;
        }
        preferences.clean();
    }

    public static class RepositoryInfo {
        private static final String ID_NAME = "name";
        private static final String ID_LOCATION = "location";
        private static final String ID_ENABLED = "enabled";
        private static final String ID_SUPPORTPARAM = "supportParam";
        private static final String ID_AUTHENTICATION = "authentication";
        private String name;
        private String location;
        private boolean supportParam;
        private boolean enabled;
        private final AuthenticationInfo authInf;

        public RepositoryInfo(String name, String location, String login, String password, boolean authEnabled, boolean enabled, boolean supportParam) {
            this.name = name;
            this.location = location;
            this.supportParam = supportParam;
            this.enabled = enabled;
            this.authInf = new AuthenticationInfo(login, password, authEnabled);
        }

        public RepositoryInfo(String name, String location, String login, String password, boolean authEnabled, boolean enabled) {
            this(name, location, login, password, authEnabled, enabled, true);
        }

        public RepositoryInfo(String name, String location, boolean enabled) {
            this(name, location, "", "", false, enabled);
        }

        public RepositoryInfo(String name, String location) {
            this(name, location, "", "", false, true);
        }

        public RepositoryInfo(XMLPreferences node) {
            this("", "", "", "", false, false);
            this.load(node);
        }

        public boolean isEmpty() {
            return StringUtil.isEmpty(this.location);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getLocation() {
            return this.location;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        public boolean getSupportParam() {
            return this.supportParam;
        }

        public void setSupportParam(boolean supportParam) {
            this.supportParam = supportParam;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getLogin() {
            return this.authInf.getLogin();
        }

        public void setLogin(String login) {
            this.authInf.setLogin(login);
        }

        public String getPassword() {
            return this.authInf.getPassword();
        }

        public void setPassword(String password) {
            this.authInf.setPassword(password);
        }

        public boolean isAuthenticationEnabled() {
            return this.authInf.isEnabled();
        }

        public void setAuthenticationEnabled(boolean value) {
            this.authInf.setEnabled(value);
        }

        public AuthenticationInfo getAuthenticationInfo() {
            return this.authInf;
        }

        public void load(XMLPreferences node) {
            if (node != null) {
                this.name = node.get(ID_NAME, "");
                this.location = node.get(ID_LOCATION, "");
                this.enabled = node.getBoolean(ID_ENABLED, false);
                this.supportParam = node.getBoolean(ID_SUPPORTPARAM, true);
                this.authInf.load(node.node(ID_AUTHENTICATION));
            }
        }

        public void save(XMLPreferences node) {
            if (node != null) {
                node.put(ID_NAME, this.name);
                node.put(ID_LOCATION, this.location);
                node.putBoolean(ID_ENABLED, this.enabled);
                node.putBoolean(ID_SUPPORTPARAM, this.supportParam);
                this.authInf.save(node.node(ID_AUTHENTICATION));
            }
        }

        public boolean isDefault() {
            return RepositoryPreferences.DEFAULT_REPOSITERY_NAME.equals(this.name) && RepositoryPreferences.DEFAULT_REPOSITERY_LOCATION.equals(this.location);
        }

        public boolean isOldDefault() {
            return RepositoryPreferences.DEFAULT_REPOSITERY_NAME.equals(this.name) && RepositoryPreferences.DEFAULT_REPOSITERY_LOCATION_OLD.equals(this.location);
        }

        public String toString() {
            return this.name + " - " + this.location;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.location.hashCode() ^ this.authInf.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof RepositoryInfo) {
                RepositoryInfo repoInf = (RepositoryInfo)obj;
                return StringUtil.equals(repoInf.toString(), this.toString()) && repoInf.authInf.equals((Object)this.authInf);
            }
            return super.equals(obj);
        }
    }
}

