package plugins.tprovoost.xugglerslider;

import icy.gui.dialog.MessageDialog;
import icy.gui.frame.IcyFrame;
import icy.image.IcyBufferedImage;
import icy.plugin.abstract_.PluginActionable;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;

import java.awt.BorderLayout;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;

import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class XugglerSlider extends PluginActionable {

	IcyFrame frame;
	JSlider sliderFrame;
	Sequence sequence;
	long duration = -1;
	String filename;
	ArrayList<Long> keyFrames;

	@Override
	public void run() {
		JFileChooser chooser = new JFileChooser();
		if (chooser.showDialog(null, "Select Video File") == JFileChooser.APPROVE_OPTION) {
			File f = chooser.getSelectedFile();
			filename = f.getAbsolutePath();

			ThreadUtil.bgRun(new Runnable() {
				public void run() {
					try {
						keyFrames = XugglerUtil.getVideoKeyFrames(filename);
						duration = XugglerUtil.getVideoDuration(filename);
					} catch (IllegalArgumentException e) {
						MessageDialog.showDialog("Illegal File", "Please choose a video file (.avi, .mov, .flv, etc).");
						return;
					}
					ThreadUtil.invokeNow(new Runnable() {

						@Override
						public void run() {
							initGUI();
						}
					});
				};
			});

		}
	}

	private void initGUI() {
		// CREATE FRAME
		frame = new IcyFrame("Xuggler", true, true, true, true);
		JPanel mainPanel = new JPanel(new BorderLayout());

		// CREATE SLIDER
		int nbFrames = (int) (duration);

		final JLabel lblCurrentImage = new JLabel("0");
		sliderFrame = new JSlider(0, nbFrames, 0);
		sliderFrame.addChangeListener(new ChangeListener() {

			@Override
			public void stateChanged(ChangeEvent e) {
				int value = sliderFrame.getValue();
				long keyFrame = XugglerUtil.findBestKeyFrame(keyFrames, value);
				BufferedImage result = XugglerUtil.getImage(filename, keyFrame, value - keyFrame);
				if (result != null) {
					if (sequence == null) {
						sequence = new Sequence(IcyBufferedImage.createFrom(result));
						addSequence(sequence);
					} else {
						sequence.setImage(0, 0, result);
					}
				}
				lblCurrentImage.setText(" " + value);
			}
		});
		mainPanel.add(new JLabel("Please move the cursor to access the image."), BorderLayout.NORTH);
		mainPanel.add(sliderFrame, BorderLayout.CENTER);
		mainPanel.add(lblCurrentImage, BorderLayout.EAST);

		frame.add(mainPanel);
		frame.pack();
		frame.setVisible(true);
		addIcyFrame(frame);
	}
}
