package plugins.lagache.compactionProfiler;


import java.util.Collection;
import java.util.Collections;
import java.util.ArrayList;
import java.util.List;

public class Point implements Comparable
{
    private int x;
    private int y;
    
    public Point() {
        final int borneMax = 499;
        this.x = (int)(Math.random() * borneMax + 1.0);
        this.y = (int)(Math.random() * borneMax + 1.0);
    }
    
    public Point(final int x, final int y) {
        this.x = x;
        this.y = y;
    }
    
    public int getX() {
        return this.x;
    }
    
    public int getY() {
        return this.y;
    }
    
    public static boolean isLeft(final Point a, final Point b, final Point c) {
        return (b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x) >= 0;
    }
    
    @Override
    public int compareTo(final Object o) {
        final Point other = (Point)o;
        final int otherX = other.getX();
        if (this.x < otherX) {
            return -1;
        }
        if (this.x == otherX) {
            return 0;
        }
        return 1;
    }
    
    public static List<Point> getListePointsOrdonnee(final int nombrePoints) {
        final List<Point> liste = new ArrayList<Point>();
        for (int i = 0; i < nombrePoints; ++i) {
            liste.add(new Point());
        }
        Collections.sort(liste);
        return liste;
    }
    
    public static List<Point> GrahamConvexHull(final List<Point> liste) {
        final List<Point> lUpper = new ArrayList<Point>();
        final List<Point> lLower = new ArrayList<Point>();
        final int n = liste.size();
        lUpper.add(liste.get(0));
        lUpper.add(liste.get(1));
        for (int i = 2; i < n; ++i) {
            lUpper.add(liste.get(i));
            while (lUpper.size() > 2 && isLeft(lUpper.get(lUpper.size() - 3), lUpper.get(lUpper.size() - 2), lUpper.get(lUpper.size() - 1))) {
                lUpper.remove(lUpper.get(lUpper.size() - 2));
            }
        }
        lLower.add(liste.get(n - 1));
        lLower.add(liste.get(n - 2));
        for (int i = n - 1; i >= 0; --i) {
            lLower.add(liste.get(i));
            while (lLower.size() > 2 && isLeft(lLower.get(lLower.size() - 3), lLower.get(lLower.size() - 2), lLower.get(lLower.size() - 1))) {
                lLower.remove(lLower.get(lLower.size() - 2));
            }
        }
        lLower.remove(0);
        lLower.remove(lLower.size() - 1);
        lUpper.addAll(lLower);
        return lUpper;
    }
}

