// 
// Decompiled by Procyon v0.5.36
// 

package plugins.lagache.compactionProfiler;

import icy.roi.BooleanMask2D;


import java.awt.Rectangle;
import java.util.Iterator;
import icy.roi.ROI;
import plugins.kernel.roi.roi2d.ROI2DPolygon;
import java.util.List;
import java.util.Collections;
import java.util.ArrayList;
import plugins.kernel.roi.roi2d.ROI2DRectangle;

import java.awt.geom.Point2D;
import java.util.HashMap;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import java.util.Date;
import icy.file.FileUtil;
import java.io.File;
import java.io.IOException;

import plugins.nchenouard.spot.Spot;
import java.util.Vector;

import icy.swimmingPool.SwimmingObject;
import icy.type.point.Point5D;
import icy.util.XLSUtil;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import icy.gui.frame.progress.AnnounceFrame;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.*;
import plugins.nchenouard.spot.DetectionResult;

public class CompactionProfiler extends EzPlug
{
    EzVarDouble alpha;
    EzVarSwimmingObject<DetectionResult> detections;
    private EzVarDouble output;
    private EzVarSequence sequence;    
  //EXCEL
  	protected EzVarBoolean exportExcel = new EzVarBoolean("Export to Excel",false);
  	protected EzVarFile exportExcelFile = new EzVarFile("Excel file", "");
  	private EzVarBoolean show;
  	private EzVarBoolean intensity;
	private Object criterion;
    public CompactionProfiler() {
        this.alpha = new EzVarDouble("Percentage P of signal (intensity or surface)", 0.0, 1.0, 0.01);
        this.detections = (EzVarSwimmingObject<DetectionResult>)new EzVarSwimmingObject("Detections");
        this.output = new EzVarDouble("Proportion of ROIs surface covered by P% of signal", new Double[] { 0.0 }, false);
        this.sequence = new EzVarSequence("input Sequence");        
        this.exportExcel = new EzVarBoolean("Export to Excel", false);
        this.exportExcelFile = new EzVarFile("Excel file", "");
        this.intensity = new EzVarBoolean("Use intensity of spots (not surface)", false);
        this.show = new EzVarBoolean("Show signal surface", false);
    }
    
    protected void initialize() {
        super.addEzComponent((EzComponent)this.alpha);
        super.addEzComponent((EzComponent)this.sequence);
        super.addEzComponent((EzComponent)this.detections);
        super.addEzComponent((EzComponent)this.output);    
        super.addEzComponent((EzComponent)this.show);
        super.addEzComponent((EzComponent)this.intensity);
        addEzComponent(new EzGroup("Export",exportExcel, exportExcelFile));
		exportExcel.addVisibilityTriggerTo(exportExcelFile, true);		
    }
    
    
    
    protected void execute() {
        double threshold = 0.0;
        if (this.alpha.getValue() == null) {
            new AnnounceFrame("Please first select percentage P of signal");
            return;
        }
        threshold = (double)this.alpha.getValue();    
        if (this.detections.getValue() == null) {
            new AnnounceFrame("Please first select a detection set");
            return;
        }
        if (this.sequence.getValue() == null) {
            new AnnounceFrame("Please first select a sequence");
            return;
        }
        final DetectionResult temp = (DetectionResult)((SwimmingObject)this.detections.getValue()).getObject();
        final Vector<Spot> detection = (Vector<Spot>)temp.getDetectionsAtT(0);
        if (detection.size() == 0) {
            new AnnounceFrame("There is no detections associated with the ROI");
            return;
        }
        this.performAnalysis(this.detections, this.exportExcel, this.show, threshold, this.sequence, this.output);
    }
    
    private void performAnalysis(final EzVarSwimmingObject<DetectionResult> detections, final EzVarBoolean exportExcel, final EzVarBoolean show, final double threshold, final EzVarSequence sequence, final EzVarDouble output) {
    	//EXCEL
    			int row = 0;		
    			WritableWorkbook WW = null;
    			WritableSheet WS = null;
    			if (exportExcel.getValue()) {
    				int page = 1;
    				try {
    					File f = exportExcelFile.getValue(true);
    					if (!FileUtil.getFileExtension(f.getPath(), false)
    							.equalsIgnoreCase("xls"))
    						f = new File(f.getPath() + ".xls");
    					WW = XLSUtil.loadWorkbookForWrite(f); 
    					}							
    				 catch (Exception e) {
    					e.printStackTrace();
    					return;}    				
    					WS  = XLSUtil.createNewPage(WW, "Page" + page);
    					XLSUtil.setCellString(WS, 0, 0, "Date of XLS page:");    					
    					row++;
    					XLSUtil.setCellString(WS, 0, row, new Date().toString());			
    					row++;
    					XLSUtil.setCellString(WS, 0, row, "Type of signal ");
    					row++;
    					if (intensity.getValue()) {
    						XLSUtil.setCellString(WS, 0, row, "Intensity ");}
    					else
    						{XLSUtil.setCellString(WS, 0, row, "Surface ");}
    					row++;
    					
    					XLSUtil.setCellString(WS, 0, row, "Percentage P of signal ");
    					row++;
    					XLSUtil.setCellNumber(WS, 0, row, threshold);
    					row++;row++;
    					
    					
    		    		
    					XLSUtil.setCellString(WS, 0, row, "ROI number");
    					XLSUtil.setCellString(WS, 1, row, "ROI name");
    					XLSUtil.setCellString(WS, 2, row,"ROI surface");
    					XLSUtil.setCellString(WS, 3, row,"ROI nb detection");
    					XLSUtil.setCellString(WS, 4, row,"Mean size of ROI spots");
    					XLSUtil.setCellString(WS, 5, row,"Percentage of the ROI surface occupied by x% of the signal");
            row++;
        }
        
    			final ArrayList<ROI> roiArrayList = sequence.getValue().getROIs();
    			final DetectionResult detect_ = (DetectionResult)((SwimmingObject)detections.getValue()).getObject();
    			final Vector<Spot> detection = (Vector<Spot>)detect_.getDetectionsAtT(0);
    			
    			
                final HashMap<ROI, Vector<Spot>> ROI2Detection = new HashMap<ROI, Vector<Spot>>();
                if (roiArrayList.size() == 0) {
                	roiArrayList.add(new ROI2DRectangle(new Rectangle(sequence.getValue().getWidth(), sequence.getValue().getHeight())));
                }        
                    for (ROI roi : roiArrayList) {
                        ROI2Detection.put(roi, new Vector<Spot>());            
                        for (final Spot spot : detection) {
                        	Point5D pos=new Point5D.Double(spot.mass_center.x, spot.mass_center.y, spot.mass_center.z, roi.getPosition5D().getT(), roi.getPosition5D().getC());
        					if (roi.contains(pos)) {
        						ROI2Detection.get(roi).add(spot);
                            }
                        }
                    }        
                int nb = 0;
        double surface_cellule_totale = 0.0;
        double surface_signal_totale = 0.0;
        
        for (final ROI roi : ROI2Detection.keySet()) {        	
        	final Vector<Spot> detect = ROI2Detection.get(roi);
        	final double surf_totale = this.getROISurface(roi);
        	double surf=compute_covered_surface(detect, roi,intensity.getValue(),threshold,show.getValue());
			output.setValue(surf/surf_totale);
            			
	        final Sequence s2 = this.getActiveSequence();
	        double taille = 0.0;
	        for (final Spot S5 : detect) {
	            taille += S5.point3DList.size();
	        }
	        taille /= ROI2Detection.get(roi).size();
	        
            if (exportExcel.getValue()) {
            	XLSUtil.setCellNumber(WS, 0, row, (double)nb);
            	XLSUtil.setCellString(WS, 1, row, roi.getName());
            	XLSUtil.setCellNumber(WS, 2, row, this.getROISurface(roi));
            	XLSUtil.setCellNumber(WS, 3, row, (double)ROI2Detection.get(roi).size());                
            	XLSUtil.setCellNumber(WS, 4, row,taille);
            	XLSUtil.setCellNumber(WS, 5, row, surf / surf_totale);
                row++;
            }
            nb++;
            surface_cellule_totale += surf_totale;
            surface_signal_totale += surf;
        }
        if (exportExcel.getValue()) {
            row++;
            row++;
            XLSUtil.setCellString(WS, 0, row, "Sum of ROIs surfaces");
            XLSUtil.setCellString(WS, 1, row, "Total surface of the signal");
            XLSUtil.setCellString(WS, 2, row, "Percentage of the global ROIs surface covered by P% of the signal");
            ++row;
            XLSUtil.setCellNumber(WS, 0, row, surface_cellule_totale);
            XLSUtil.setCellNumber(WS, 1, row, surface_signal_totale);
            XLSUtil.setCellNumber(WS, 2, row,  surface_signal_totale / surface_cellule_totale);
            try {
				XLSUtil.saveAndClose(WW);
			} catch (WriteException e) {
				e.printStackTrace();
			} catch (IOException e) {		
				e.printStackTrace();
			}
        }
        }
                    
    public double compute_covered_surface(Vector<Spot> detect, ROI roi,Boolean intensity,double threshold,Boolean show){
        
        double surf=0.0;
    	final Vector<Spot> select = new Vector<Spot>();
        final Vector<Spot> remain = (Vector<Spot>)detect.clone();
        if (remain.size()>2) {
        double sum = 0.0;
        final List<Point> mass_c = new ArrayList<Point>();            
        Spot S0 = remain.get(0);
        double y = 0.0;
        if (intensity)
        {y = S0.point3DList.size() * S0.meanIntensity;}
        else
        {y = S0.point3DList.size();}
        int index = 0;
        double Y = 0.0;
        for (final Spot S2 : remain) {
        	
          if (intensity){
                    if (S2.point3DList.size() * S2.meanIntensity > y) {
                        y = S2.point3DList.size() * S2.meanIntensity;
                        index = remain.indexOf(S2);
                        continue;
                    }
                    continue;
                }
           else  {  
        	   if (S2.point3DList.size() > y) {               
               y = S2.point3DList.size();
               index = remain.indexOf(S2);
               continue;
           }
           continue;
       }
            }            
        Spot spot3 = remain.get(index);
        select.add(spot3);
        remain.remove(index);
        Point point = new Point((int)spot3.mass_center.x, (int)spot3.mass_center.y);
        mass_c.add(point);
        sum = y;
        S0 = remain.get(0);
        if (intensity) {y = S0.point3DList.size() * S0.meanIntensity;}
        else {y = S0.point3DList.size();}
        index = 0;
        for (final Spot S3 : remain) {
        	if (intensity) {
                if (S3.point3DList.size() * S3.meanIntensity > y) {
                    y = S3.point3DList.size() * S3.meanIntensity;
                    index = remain.indexOf(S3);
                    continue;
                }
                continue;
            }
        	else {
                     if (S3.point3DList.size() > y) {
                        y = S3.point3DList.size();
                        index = remain.indexOf(S3);
                        continue;
                    }
                    continue;
                }
            }            
        spot3 = remain.get(index);
        select.add(spot3);
        remain.remove(index);
        point = new Point((int)spot3.mass_center.x, (int)spot3.mass_center.y);
        mass_c.add(point);
        sum += y;
        double surface = 0.0;
        if (intensity) {Y = this.getROIIntensity(roi, detect);}
        else {Y = this.getROINumber(roi, detect);}        
        while (sum < threshold * Y) {
            S0 = remain.get(0);
            point = new Point((int)S0.mass_center.x, (int)S0.mass_center.y);
            mass_c.add(point);
            Collections.sort(mass_c);
            List<Point> result = (List<Point>)Point.GrahamConvexHull((List)mass_c);
            Point2D l = new Point2D.Double(result.get(0).getX() + 0.5, result.get(0).getY() + 0.5);
            ROI2DPolygon r = new ROI2DPolygon(l);
            result.remove(0);
            for (final Point p : result) {
                l = new Point2D.Double(p.getX() + 0.5, p.getY() + 0.5);
                r.addNewPoint(l, true);
            }
            surf = this.getROISurface((ROI2D)r);
            double gain_surface = surf - surface;
            if (intensity) {
            	y = this.getROIIntensity((ROI2D)r, detect);
            }
            else
            {
                    y = this.getROINumber((ROI2D)r, detect);
            }
            double gain_y = y - sum;
            double delta_gain = 0.0;
            if (gain_surface > 0.0) {
                delta_gain = gain_y / gain_surface;
            }
            double temp_y = gain_y;
            double temp_s = gain_surface;
            mass_c.remove(point);
            index = 0;
            for (final Spot S4 : remain) {
                point = new Point((int)S4.mass_center.x, (int)S4.mass_center.y);
                mass_c.add(point);
                Collections.sort(mass_c);
                result = (List<Point>)Point.GrahamConvexHull((List)mass_c);
                l = new Point2D.Double(result.get(0).getX() + 0.5, result.get(0).getY() + 0.5);
                r = new ROI2DPolygon(l);
                result.remove(0);
                for (final Point p2 : result) {
                    l = new Point2D.Double(p2.getX() + 0.5, p2.getY() + 0.5);
                    r.addNewPoint(l, true);
                }
                surf = this.getROISurface((ROI2D)r);
                if (intensity) {y = this.getROIIntensity((ROI2D)r, detect);}
                else {y = this.getROINumber((ROI2D)r, detect);}                    
                gain_surface = surf - surface;
                gain_y = y - sum;
                if (gain_y / gain_surface > delta_gain) {
                    delta_gain = gain_y / gain_surface;
                    temp_y = gain_y;
                    temp_s = gain_surface;
                    index = remain.lastIndexOf(S4);
                }
                mass_c.remove(point);
            }
            spot3 = remain.get(index);
            select.add(spot3);
            remain.remove(index);
            point = new Point((int)spot3.mass_center.x, (int)spot3.mass_center.y);
            mass_c.add(point);
            sum += temp_y;
            surface += temp_s;
        }
        Collections.sort(mass_c);
        List<Point> result = (List<Point>)Point.GrahamConvexHull((List)mass_c);
        Point2D l = new Point2D.Double(result.get(0).getX() + 0.5, result.get(0).getY() + 0.5);
        ROI2DPolygon r = new ROI2DPolygon(l);
        result.remove(0);
        for (final Point p : result) {
            l = new Point2D.Double(p.getX() + 0.5, p.getY() + 0.5);
            r.addNewPoint(l, true);
        }     
        surf = this.getROISurface((ROI2D)r);        
        if (show) {
            this.getActiveSequence().addROI((ROI)r);
        }
        }
        return surf;
        }        
        
    
    double getROISurface(final ROI roi) {
        return roi.getNumberOfPoints();        
    }
    
    double getROIIntensity(final ROI roi, final Vector<Spot> detect) {
        
    	ROI2D roi2d=(ROI2D)(roi);
    	final BooleanMask2D B = roi2d.getBooleanMask(true);
        double sum = 0.0;
        for (final Spot S : detect) {
            boolean trouve = false;
            for (int i = -2; i < 3; ++i) {
                for (int j = -2; j < 3; ++j) {
                    if (!trouve && B.contains((int)S.mass_center.x + i, (int)S.mass_center.y + j)) {
                        sum += S.point3DList.size() * S.meanIntensity;
                        trouve = true;
                    }
                }
            }
        }
        return sum;
    }
    
    double getROINumber(final ROI roi, final Vector<Spot> detect) {
    	ROI2D roi2d = (ROI2D)(roi);
        final BooleanMask2D B = roi2d.getBooleanMask(true);
        double sum = 0.0;
        for (final Spot S : detect) {
            boolean trouve = false;
            for (int i = -2; i < 3; ++i) {
                for (int j = -2; j < 3; ++j) {
                    if (!trouve && B.contains((int)S.mass_center.x + i, (int)S.mass_center.y + j)) {
                        sum += S.point3DList.size();
                        trouve = true;
                    }
                }
            }
        }
        return sum;
    }
    
    public void clean() {
    }   

    private enum MethodType
    {
        Intensity("Intensity", 0, "Intensity of signal is considered"), 
        Surface("Surface", 1, "Surface of signal is considered");
        
        private final String name;
        
        private MethodType(final String name, final int ordinal, final String string) {
            this.name = string;
        }
        
        @Override
        public String toString() {
            return this.name;
        }
    }

}
