/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.projection;

import icy.image.IcyBufferedImage;
import icy.main.Icy;
import icy.math.ArrayMath;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLauncher;
import icy.plugin.PluginLoader;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.system.SystemUtil;
import icy.system.thread.Processor;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import icy.util.OMEUtil;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import ome.xml.meta.MetadataRetrieve;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarEnum;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarSequence;

public class Projection
extends EzPlug
implements Block,
EzStoppable {
    private final EzVarSequence input = new EzVarSequence("Input");
    private final EzVarEnum<ProjectionDirection> projectionDir = new EzVarEnum("Project along", (Enum[])ProjectionDirection.values(), (Enum)ProjectionDirection.Z);
    private final EzVarEnum<ProjectionType> projectionType = new EzVarEnum("Projection type", (Enum[])ProjectionType.values(), (Enum)ProjectionType.MAX);
    private final EzVarBoolean restrictToROI = new EzVarBoolean("Restrict to ROI", false);
    private final VarSequence output = new VarSequence("projected sequence", null);

    protected void initialize() {
        this.addEzComponent((EzComponent)this.input);
        this.addEzComponent((EzComponent)this.projectionDir);
        this.addEzComponent((EzComponent)this.projectionType);
        this.restrictToROI.setToolTipText("Check this option to project only the intensity data contained within the sequence ROI");
        this.addEzComponent((EzComponent)this.restrictToROI);
        this.setTimeDisplay(true);
    }

    protected void execute() {
        switch ((ProjectionDirection)((Object)this.projectionDir.getValue())) {
            case T: {
                this.output.setValue(Projection.tProjection((Sequence)this.input.getValue(true), (ProjectionType)((Object)this.projectionType.getValue()), true, (Boolean)this.restrictToROI.getValue()));
                break;
            }
            case Z: {
                this.output.setValue(Projection.zProjection((Sequence)this.input.getValue(true), (ProjectionType)((Object)this.projectionType.getValue()), true, (Boolean)this.restrictToROI.getValue()));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Projection along " + this.projectionDir.getValue() + " not supported");
            }
        }
        if (this.getUI() != null) {
            this.addSequence((Sequence)this.output.getValue());
        }
    }

    public void clean() {
    }

    public static Sequence zProjection(Sequence in, ProjectionType projection) {
        return Projection.zProjection(in, projection, true, false);
    }

    public static Sequence zProjection(Sequence in, ProjectionType projection, boolean multiThread) {
        return Projection.zProjection(in, projection, multiThread, false);
    }

    public static Sequence zProjection(Sequence in, final ProjectionType projection, boolean multiThread, boolean restrictToROI) {
        Sequence out = new Sequence(OMEUtil.createOMEXMLMetadata((MetadataRetrieve)in.getOMEXMLMetadata()), projection.name() + " projection of " + in.getName());
        final int width = in.getSizeX();
        int height = in.getSizeY();
        final int depth = in.getSizeZ();
        int frames = in.getSizeT();
        int channels = in.getSizeC();
        final DataType dataType = in.getDataType_();
        final HashSet rois = in.getROISet();
        final boolean processROI = restrictToROI && rois.size() > 0;
        Processor processor = new Processor(Math.max(1024, height), SystemUtil.getNumberOfCPUs());
        ArrayList<Future> futures = new ArrayList<Future>();
        for (int frame = 0; frame < frames; ++frame) {
            final int t = frame;
            IcyBufferedImage resultImg = new IcyBufferedImage(width, height, channels, dataType);
            final IcyBufferedImage[] images = in.getImages(t).toArray(new IcyBufferedImage[0]);
            for (int channel = 0; channel < channels; ++channel) {
                final int c = channel;
                final Object resultData = resultImg.getDataXY(c);
                try {
                    int line = 0;
                    while (line < height) {
                        final int y = line++;
                        futures.add(processor.submit(new Runnable(){

                            @Override
                            public void run() {
                                double[] pixelStack = new double[depth];
                                int offset = y * width;
                                int x = 0;
                                while (x < width) {
                                    int nbPixel = 0;
                                    for (int z = 0; z < depth; ++z) {
                                        boolean processPixel;
                                        if (processROI) {
                                            processPixel = false;
                                            for (ROI roi : rois) {
                                                if (!roi.contains((double)x, (double)y, (double)z, (double)t, (double)c)) continue;
                                                processPixel = true;
                                                break;
                                            }
                                        } else {
                                            processPixel = true;
                                        }
                                        if (!processPixel) continue;
                                        pixelStack[nbPixel++] = images[z].getData(x, y, c);
                                    }
                                    if (nbPixel != 0) {
                                        double[] pixels = pixelStack.length > nbPixel ? Arrays.copyOf(pixelStack, nbPixel) : pixelStack;
                                        double result = 0.0;
                                        switch (projection) {
                                            case MAX: {
                                                result = ArrayMath.max((double[])pixels);
                                                break;
                                            }
                                            case MEAN: {
                                                result = ArrayMath.mean((double[])pixels);
                                                break;
                                            }
                                            case MED: {
                                                result = ArrayMath.median((double[])pixels, (boolean)false);
                                                break;
                                            }
                                            case MIN: {
                                                result = ArrayMath.min((double[])pixels);
                                                break;
                                            }
                                            case STD: {
                                                result = ArrayMath.std((double[])pixels, (boolean)true);
                                                break;
                                            }
                                            case SATSUM: {
                                                result = ArrayMath.sum((double[])pixels);
                                                break;
                                            }
                                            default: {
                                                throw new UnsupportedOperationException((Object)((Object)projection) + " intensity projection not implemented");
                                            }
                                        }
                                        Array1DUtil.setValue((Object)resultData, (int)offset, (DataType)dataType, (double)result);
                                    }
                                    ++x;
                                    ++offset;
                                }
                            }
                        }));
                    }
                    for (Future future : futures) {
                        future.get();
                    }
                }
                catch (RejectedExecutionException e) {
                    processor.shutdownNow();
                }
                catch (InterruptedException e) {
                    processor.shutdownNow();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                resultImg.setDataXY(c, resultData);
            }
            out.setImage(t, 0, (BufferedImage)resultImg);
        }
        processor.shutdown();
        for (int c = 0; c < in.getSizeC(); ++c) {
            out.getColorModel().setColorMap(c, in.getColorMap(c), true);
        }
        return out;
    }

    public static Sequence tProjection(Sequence in, ProjectionType projection, boolean multiThread) {
        return Projection.tProjection(in, projection, multiThread, false);
    }

    public static Sequence tProjection(Sequence in, final ProjectionType projection, boolean multiThread, boolean restrictToROI) {
        Sequence out = new Sequence(OMEUtil.createOMEXMLMetadata((MetadataRetrieve)in.getOMEXMLMetadata()), projection.name() + " projection of " + in.getName());
        final int width = in.getSizeX();
        int height = in.getSizeY();
        int depth = in.getSizeZ();
        final int frames = in.getSizeT();
        int channels = in.getSizeC();
        final DataType dataType = in.getDataType_();
        final HashSet rois = in.getROISet();
        final boolean processROI = restrictToROI && rois.size() > 0;
        Processor processor = new Processor(Math.max(1024, height), SystemUtil.getNumberOfCPUs());
        ArrayList<Future> futures = new ArrayList<Future>();
        final IcyBufferedImage[] images = new IcyBufferedImage[depth * frames];
        for (int z = 0; z < depth; ++z) {
            for (int t = 0; t < frames; ++t) {
                images[z * frames + t] = in.getImage(t, z);
            }
        }
        for (int slice = 0; slice < depth; ++slice) {
            final int z = slice;
            final int imgOff = z * frames;
            IcyBufferedImage resultImg = new IcyBufferedImage(width, height, channels, dataType);
            for (int channel = 0; channel < channels; ++channel) {
                final int c = channel;
                final Object resultData = resultImg.getDataXY(c);
                try {
                    int line = 0;
                    while (line < height) {
                        final int y = line++;
                        futures.add(processor.submit(new Runnable(){

                            @Override
                            public void run() {
                                double[] pixelFrames = new double[frames];
                                int offset = y * width;
                                int x = 0;
                                while (x < width) {
                                    int nbPixel = 0;
                                    for (int t = 0; t < frames; ++t) {
                                        boolean processPixel;
                                        if (processROI) {
                                            processPixel = false;
                                            for (ROI roi : rois) {
                                                if (!roi.contains((double)x, (double)y, (double)z, (double)t, (double)c)) continue;
                                                processPixel = true;
                                                break;
                                            }
                                        } else {
                                            processPixel = true;
                                        }
                                        if (!processPixel) continue;
                                        pixelFrames[nbPixel++] = images[imgOff + t].getData(x, y, c);
                                    }
                                    if (nbPixel != 0) {
                                        double[] pixels = pixelFrames.length > nbPixel ? Arrays.copyOf(pixelFrames, nbPixel) : pixelFrames;
                                        double result = 0.0;
                                        switch (projection) {
                                            case MAX: {
                                                result = ArrayMath.max((double[])pixels);
                                                break;
                                            }
                                            case MEAN: {
                                                result = ArrayMath.mean((double[])pixels);
                                                break;
                                            }
                                            case MED: {
                                                result = ArrayMath.median((double[])pixels, (boolean)false);
                                                break;
                                            }
                                            case MIN: {
                                                result = ArrayMath.min((double[])pixels);
                                                break;
                                            }
                                            case STD: {
                                                result = ArrayMath.std((double[])pixels, (boolean)true);
                                                break;
                                            }
                                            case SATSUM: {
                                                result = ArrayMath.sum((double[])pixels);
                                                break;
                                            }
                                            default: {
                                                throw new UnsupportedOperationException((Object)((Object)projection) + " intensity projection not implemented");
                                            }
                                        }
                                        Array1DUtil.setValue((Object)resultData, (int)offset, (DataType)dataType, (double)result);
                                    }
                                    ++x;
                                    ++offset;
                                }
                            }
                        }));
                    }
                    for (Future future : futures) {
                        future.get();
                    }
                }
                catch (RejectedExecutionException e) {
                    processor.shutdownNow();
                }
                catch (InterruptedException e) {
                    processor.shutdownNow();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                resultImg.setDataXY(c, resultData);
            }
            out.setImage(0, z, (BufferedImage)resultImg);
        }
        processor.shutdown();
        for (int c = 0; c < in.getSizeC(); ++c) {
            out.getColorModel().setColorMap(c, in.getColorMap(c), true);
        }
        return out;
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("input", (Var)this.input.getVariable());
        inputMap.add("projection direction", this.projectionDir.getVariable());
        inputMap.add("projection type", this.projectionType.getVariable());
        inputMap.add("restrict to ROI", this.restrictToROI.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("projection output", (Var)this.output);
    }

    public static void main(String[] args) {
        Icy.main((String[])args);
        PluginLauncher.start((PluginDescriptor)PluginLoader.getPlugin((String)Projection.class.getName()));
    }

    public static enum ProjectionType {
        MAX("Maximum"),
        MEAN("Average"),
        MED("Median"),
        MIN("Minimum"),
        STD("Standard Deviation"),
        SATSUM("Saturated Sum");

        private final String description;

        private ProjectionType(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }

    public static enum ProjectionDirection {
        Z,
        T;

    }
}

