/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.roiintensityevolution;

import icy.image.IcyBufferedImage;
import icy.roi.BooleanMask2D;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import icy.type.collection.array.ArrayUtil;
import icy.type.rectangle.Rectangle5D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantLock;
import org.jfree.data.xy.XYSeries;

public class ROIAnalysis {
    private ROI roi;
    private Sequence sequence;
    private String description;
    private final XYSeries[] meanIntensity;
    private final XYSeries[] minIntensity;
    private final XYSeries[] maxIntensity;
    private final XYSeries[] medianIntensity;
    private final XYSeries[] sumIntensity;
    private final XYSeries[] varIntensity;
    private final XYSeries[] roiSize;
    ReentrantLock initLock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ROIAnalysis(ROI roi, Sequence sequence, String description, double threshold, boolean overthreshold, double scaling) {
        try {
            int c;
            this.initLock.lock();
            if (roi == null) {
                throw new IllegalArgumentException("NULL roi object is not allowed for creating a TrackAnalysis instance");
            }
            if (sequence == null) {
                throw new IllegalArgumentException("NULL Sequence object is not allowed for creating a TrackAnalysis instance");
            }
            if (description == null) {
                throw new IllegalArgumentException("NULL description object is not allowed for creating a TrackAnalysis instance");
            }
            this.roi = roi;
            this.sequence = sequence;
            this.description = description;
            this.meanIntensity = new XYSeries[sequence.getSizeC()];
            for (c = 0; c < sequence.getSizeC(); ++c) {
                this.meanIntensity[c] = new XYSeries((Comparable)((Object)description));
            }
            this.minIntensity = new XYSeries[sequence.getSizeC()];
            for (c = 0; c < sequence.getSizeC(); ++c) {
                this.minIntensity[c] = new XYSeries((Comparable)((Object)description));
            }
            this.maxIntensity = new XYSeries[sequence.getSizeC()];
            for (c = 0; c < sequence.getSizeC(); ++c) {
                this.maxIntensity[c] = new XYSeries((Comparable)((Object)description));
            }
            this.medianIntensity = new XYSeries[sequence.getSizeC()];
            for (c = 0; c < sequence.getSizeC(); ++c) {
                this.medianIntensity[c] = new XYSeries((Comparable)((Object)description));
            }
            this.sumIntensity = new XYSeries[sequence.getSizeC()];
            for (c = 0; c < sequence.getSizeC(); ++c) {
                this.sumIntensity[c] = new XYSeries((Comparable)((Object)description));
            }
            this.varIntensity = new XYSeries[sequence.getSizeC()];
            for (c = 0; c < sequence.getSizeC(); ++c) {
                this.varIntensity[c] = new XYSeries((Comparable)((Object)description));
            }
            this.roiSize = new XYSeries[sequence.getSizeC()];
            for (c = 0; c < sequence.getSizeC(); ++c) {
                this.roiSize[c] = new XYSeries((Comparable)((Object)description));
            }
            this.fillSeriesNoLock(threshold, overthreshold, scaling);
        }
        finally {
            this.initLock.unlock();
        }
    }

    private void fillSeriesNoLock(double threshold, boolean overthreshold, double areaScale) {
        for (int c = 0; c < this.sequence.getSizeC(); ++c) {
            this.meanIntensity[c].clear();
            this.maxIntensity[c].clear();
            this.minIntensity[c].clear();
            this.varIntensity[c].clear();
            this.sumIntensity[c].clear();
            this.medianIntensity[c].clear();
        }
        ROI2D roi2D = (ROI2D)this.roi;
        BooleanMask2D mask = roi2D.getBooleanMask(true);
        Rectangle5D.Integer bounds = this.roi.getBounds5D().toInteger();
        Sequence subSeq = SequenceUtil.getSubSequence((Sequence)this.sequence, (Rectangle5D.Integer)bounds);
        ArrayList<int[]> pixels = new ArrayList<int[]>();
        for (int y = bounds.y; y < bounds.y + bounds.sizeY; ++y) {
            for (int x = bounds.x; x < bounds.x + bounds.sizeX; ++x) {
                if (!mask.contains(x, y)) continue;
                pixels.add(new int[]{x - bounds.x, y - bounds.y});
            }
        }
        if (pixels.size() > 0) {
            int cntValues = pixels.size();
            for (int t = 0; t < subSeq.getSizeT(); ++t) {
                IcyBufferedImage image = subSeq.getImage(t, 0);
                int width = image.getWidth();
                for (int c = 0; c < subSeq.getSizeC(); ++c) {
                    int i;
                    double value;
                    double[] data = (double[])ArrayUtil.arrayToDoubleArray((Object)image.getDataXY(c), (boolean)image.isSignedDataType());
                    int[] p = (int[])pixels.get(0);
                    double sumIntensity = value = data[p[0] + p[1] * width];
                    double minIntensity = value;
                    double maxIntensity = value;
                    double sumSqIntensity = value * value;
                    ArrayList<Double> valueList = new ArrayList<Double>();
                    valueList.add(value);
                    int cntPixThreshold = 0;
                    if (overthreshold) {
                        if (value > threshold) {
                            ++cntPixThreshold;
                        }
                        for (i = 1; i < pixels.size(); ++i) {
                            p = (int[])pixels.get(i);
                            value = data[p[0] + p[1] * width];
                            sumIntensity += value;
                            sumSqIntensity += value * value;
                            valueList.add(new Double(value));
                            if (value < minIntensity) {
                                minIntensity = value;
                            }
                            if (value > maxIntensity) {
                                maxIntensity = value;
                            }
                            if (!(value > threshold)) continue;
                            ++cntPixThreshold;
                        }
                    } else {
                        if (value < threshold) {
                            ++cntPixThreshold;
                        }
                        for (i = 1; i < pixels.size(); ++i) {
                            p = (int[])pixels.get(i);
                            value = data[p[0] + p[1] * width];
                            sumIntensity += value;
                            sumSqIntensity += value * value;
                            valueList.add(new Double(value));
                            if (value < minIntensity) {
                                minIntensity = value;
                            }
                            if (value > maxIntensity) {
                                maxIntensity = value;
                            }
                            if (!(value < threshold)) continue;
                            ++cntPixThreshold;
                        }
                    }
                    double meanIntensity = 0.0;
                    double varIntensity = 0.0;
                    if (cntValues > 0) {
                        meanIntensity = sumIntensity / (double)cntValues;
                        varIntensity = sumSqIntensity / (double)cntValues - meanIntensity * meanIntensity;
                    }
                    this.meanIntensity[c].add((double)t, meanIntensity);
                    this.maxIntensity[c].add((double)t, maxIntensity);
                    this.minIntensity[c].add((double)t, minIntensity);
                    this.varIntensity[c].add((double)t, varIntensity);
                    this.sumIntensity[c].add((double)t, sumIntensity);
                    if (!valueList.isEmpty()) {
                        Arrays.sort(valueList.toArray());
                        if (cntValues == 1) {
                            this.medianIntensity[c].add((double)t, (Number)valueList.get(0));
                        } else if (cntValues % 2 == 0) {
                            this.medianIntensity[c].add((double)t, (Double)valueList.get(cntValues / 2) + ((Double)valueList.get(cntValues / 2) - 1.0) / 2.0);
                        } else {
                            this.medianIntensity[c].add((double)t, (Number)valueList.get(cntValues / 2));
                        }
                    }
                    this.roiSize[c].add((double)t, (double)cntPixThreshold * areaScale);
                }
            }
        } else {
            for (int t = 0; t < this.sequence.getSizeT(); ++t) {
                for (int c = 0; c < this.sequence.getSizeC(); ++c) {
                    this.meanIntensity[c].add((double)t, 0.0);
                    this.maxIntensity[c].add((double)t, 0.0);
                    this.minIntensity[c].add((double)t, 0.0);
                    this.varIntensity[c].add((double)t, 0.0);
                    this.sumIntensity[c].add((double)t, 0.0);
                    this.medianIntensity[c].add((double)t, 0.0);
                    this.roiSize[c].add((double)t, 0.0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillSeries(double threshold, boolean overthreshold, double scale) {
        try {
            this.initLock.lock();
            this.fillSeriesNoLock(threshold, overthreshold, scale);
        }
        finally {
            this.initLock.unlock();
        }
    }

    public int getNumChannels() {
        try {
            this.initLock.lock();
            int n = this.sequence.getSizeC();
            return n;
        }
        finally {
            this.initLock.unlock();
        }
    }

    public ROI getROI() {
        try {
            this.initLock.lock();
            ROI rOI = this.roi;
            return rOI;
        }
        finally {
            this.initLock.unlock();
        }
    }

    public XYSeries[] getMeanIntensity() {
        try {
            this.initLock.lock();
            XYSeries[] xYSeriesArray = this.meanIntensity;
            return xYSeriesArray;
        }
        finally {
            this.initLock.unlock();
        }
    }

    public XYSeries[] getMedianIntensity() {
        try {
            this.initLock.lock();
            XYSeries[] xYSeriesArray = this.medianIntensity;
            return xYSeriesArray;
        }
        finally {
            this.initLock.unlock();
        }
    }

    public XYSeries[] getSumIntensity() {
        try {
            this.initLock.lock();
            XYSeries[] xYSeriesArray = this.sumIntensity;
            return xYSeriesArray;
        }
        finally {
            this.initLock.unlock();
        }
    }

    public XYSeries[] getVarIntensity() {
        try {
            this.initLock.lock();
            XYSeries[] xYSeriesArray = this.varIntensity;
            return xYSeriesArray;
        }
        finally {
            this.initLock.unlock();
        }
    }

    public XYSeries[] getMinIntensity() {
        try {
            this.initLock.lock();
            XYSeries[] xYSeriesArray = this.minIntensity;
            return xYSeriesArray;
        }
        finally {
            this.initLock.unlock();
        }
    }

    public XYSeries[] getMaxIntensity() {
        try {
            this.initLock.lock();
            XYSeries[] xYSeriesArray = this.maxIntensity;
            return xYSeriesArray;
        }
        finally {
            this.initLock.unlock();
        }
    }

    public XYSeries[] getROISize() {
        try {
            this.initLock.lock();
            XYSeries[] xYSeriesArray = this.roiSize;
            return xYSeriesArray;
        }
        finally {
            this.initLock.unlock();
        }
    }

    public String getDescription() {
        try {
            this.initLock.lock();
            String string = this.description;
            return string;
        }
        finally {
            this.initLock.unlock();
        }
    }
}

