/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.roi;

import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROI3D;
import icy.roi.ROIUtil;
import icy.sequence.Sequence;
import icy.type.point.Point3D;
import java.awt.Point;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Point3d;
import plugins.adufour.blocks.tools.roi.ROIBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.quickhull.QuickHull2D;
import plugins.adufour.quickhull.QuickHull3D;
import plugins.adufour.roi.mesh.polygon.ROI3DPolygonalMesh;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.kernel.roi.roi2d.ROI2DArea;
import plugins.kernel.roi.roi2d.ROI2DPolygon;
import plugins.kernel.roi.roi2d.ROI2DShape;

public class Convexify
extends EzPlug
implements ROIBlock {
    private EzVarSequence input = new EzVarSequence("Input sequence");
    private EzVarBoolean replace = new EzVarBoolean("Replace existing ROI", false);
    private VarROIArray roiIN = new VarROIArray("List of ROI");
    private VarROIArray roiOUT = new VarROIArray("List of ROI");

    protected void initialize() {
        this.addEzComponent((EzComponent)this.input);
        this.addEzComponent((EzComponent)this.replace);
    }

    public void clean() {
    }

    public void execute() {
        Iterator s;
        if (!this.isHeadLess()) {
            this.roiIN.setValue((Object)new ROI[0]);
            s = (Sequence)this.input.getValue(true);
            this.roiIN.add((Object[])s.getROIs().toArray(new ROI[0]));
        }
        this.roiOUT.setValue((Object)new ROI[0]);
        for (ROI roi : this.roiIN) {
            this.roiOUT.add((Object[])new ROI[]{Convexify.createConvexROI(roi)});
        }
        if (!this.isHeadLess()) {
            s = (Sequence)this.input.getValue(true);
            if (((Boolean)this.replace.getValue()).booleanValue()) {
                s.removeAllROI();
            }
            for (ROI roi : this.roiOUT) {
                s.addROI(roi);
            }
        }
    }

    public static ROI createConvexROI(ROI roi) throws IllegalArgumentException {
        ROI2DPolygon output = null;
        try {
            if (roi instanceof ROI2D) {
                List envelope;
                if (roi instanceof ROI2DShape) {
                    envelope = QuickHull2D.computeConvexEnvelope((List)((ROI2DShape)roi).getPoints());
                } else if (roi instanceof ROI2DArea) {
                    Point[] points = ((ROI2DArea)roi).getBooleanMask(true).getContourPoints();
                    envelope = QuickHull2D.computeConvexEnvelope(Arrays.asList(points));
                } else {
                    throw new IllegalArgumentException("Cannot compute convex hull for ROI " + roi.getName() + " of type " + roi.getClassName() + ".");
                }
                output = new ROI2DPolygon(envelope);
                ROI2D roi2d = (ROI2D)roi;
                ((ROI2D)output).setT(roi2d.getT());
                ((ROI2D)output).setZ(roi2d.getZ());
                ((ROI2D)output).setC(roi2d.getC());
            } else if (roi instanceof ROI3D) {
                Point3D.Integer[] points = ((ROI3D)roi).getBooleanMask(true).getContourPoints();
                Point3d[] pt3d = new Point3d[points.length];
                for (int i = 0; i < points.length; ++i) {
                    Point3D.Integer p = points[i];
                    pt3d[i] = new Point3d(p.getX(), p.getY(), p.getZ());
                }
                QuickHull3D qhull = new QuickHull3D();
                qhull.build(pt3d, pt3d.length);
                output = new ROI3DPolygonalMesh(qhull);
                ROI3D roi2d = (ROI3D)roi;
                ((ROI3D)output).setT(roi2d.getT());
                ((ROI2D)output).setC(roi2d.getC());
            }
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Cannot compute convex hull for ROI " + roi.getName() + " of type " + roi.getClassName() + ".", t);
        }
        if (output == null) {
            throw new IllegalArgumentException("Cannot compute convex hull for ROI " + roi.getName() + " of type " + roi.getClassName() + ".");
        }
        ROIUtil.copyROIProperties((ROI)roi, output, (boolean)false);
        output.setName(roi.getName() + " (convex)");
        return output;
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("Regions of interest", (Var)this.roiIN);
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("Regions of interest", (Var)this.roiOUT);
    }
}

