/*
 * Decompiled with CFR 0.152.
 */
package danyfel80.wells.data.columbus;

import danyfel80.wells.data.ITimepoint;
import danyfel80.wells.data.columbus.ColumbusChannel;
import danyfel80.wells.data.columbus.ColumbusImage;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ColumbusTimepoint
implements ITimepoint {
    private long id;
    private Map<Long, ColumbusChannel> channels;

    @Override
    public long getId() {
        return this.id;
    }

    public Map<Long, ColumbusChannel> getChannels() {
        return Collections.unmodifiableMap(this.channels);
    }

    public String toString() {
        return "Timepoint " + this.getId();
    }

    public static final class Builder {
        public static ColumbusTimepoint fromImages(List<ColumbusImage> timepointImages) {
            Map channels = timepointImages.stream().map(im -> ColumbusChannel.Builder.fromImage(im)).collect(Collectors.toMap(ColumbusChannel::getId, Function.identity()));
            ColumbusTimepoint timepoint = new ColumbusTimepoint();
            timepoint.id = timepointImages.stream().findAny().map(im -> im.getTimepointId()).orElse(-1L);
            timepoint.channels = channels;
            return timepoint;
        }
    }
}

