/*
 * Decompiled with CFR 0.152.
 */
package danyfel80.wells.data.im;

import danyfel80.wells.data.IField;
import danyfel80.wells.data.im.ImPlane;
import danyfel80.wells.data.im.ImTimepoint;
import icy.type.dimension.Dimension2D;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class ImField
implements IField {
    public Point2D.Double position;
    private long id;
    private Point2D positionInWell;
    private Map<Long, ImPlane> planes;
    private Rectangle2D bounds;
    private Rectangle2D pixelBounds;

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public Point2D getPosition() {
        return this.positionInWell;
    }

    public Map<Long, ImPlane> getPlanes() {
        return this.planes;
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }

    @Override
    public Rectangle2D getPixelBounds() {
        return this.pixelBounds;
    }

    public static class Builder {
        public static ImField createSingleField(Element gridElement, Path imagePath, Point positionInWell) throws IOException {
            ImField field = new ImField();
            field.id = 0L;
            field.planes = new HashMap();
            ImPlane plane = ImPlane.Builder.createSinglePlane(gridElement, imagePath, positionInWell);
            field.planes.put(plane.getId(), plane);
            Dimension2D.Double pixelResolution = new Dimension2D.Double();
            Dimension imageSize = new Dimension();
            plane.getTimepoints().values().stream().findFirst().ifPresent(arg_0 -> Builder.lambda$createSingleField$1((Dimension2D)pixelResolution, imageSize, arg_0));
            field.positionInWell = new Point2D.Double();
            field.bounds = new Rectangle2D.Double(0.0, 0.0, (double)imageSize.width * pixelResolution.getWidth(), (double)imageSize.height * pixelResolution.getHeight());
            field.pixelBounds = new Rectangle2D.Double(0.0, 0.0, imageSize.width, imageSize.height);
            return field;
        }

        private static /* synthetic */ void lambda$createSingleField$1(Dimension2D pixelResolution, Dimension imageSize, ImTimepoint t) {
            t.getChannels().values().stream().findFirst().ifPresent(ch -> {
                pixelResolution.setSize(ch.getImage().getResolution());
                imageSize.setSize(ch.getImage().getSizeXY());
            });
        }
    }
}

