/*
 * Decompiled with CFR 0.152.
 */
package danyfel80.wells.data.im;

import danyfel80.wells.data.IPlate;
import danyfel80.wells.data.im.ImWell;
import danyfel80.wells.util.MessageProgressListener;
import danyfel80.wells.util.stream.StreamUtils;
import icy.util.XMLUtil;
import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ImPlate
implements IPlate {
    private String id;
    private String name;
    private String type;
    private Dimension dimension;
    private Map<Long, ImWell> wells;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Dimension getDimension() {
        return this.dimension;
    }

    public Map<Long, ImWell> getWells() {
        return this.wells;
    }

    public static class Builder {
        private String xmlFile;
        private String folderPath;
        private MessageProgressListener progressListener;

        public Builder(String xmlFilePath, String folderPath) {
            this.xmlFile = xmlFilePath;
            this.folderPath = folderPath;
        }

        public Builder progressListener(MessageProgressListener progressListener) {
            this.progressListener = progressListener;
            return this;
        }

        public ImPlate build() throws IOException {
            this.notifyProgress(() -> 0.01, () -> "Loading xml descriptor file");
            Document plateDescriptionDocument = this.loadXMLDescriptorFile();
            Element gridElement = XMLUtil.getElement((Node)plateDescriptionDocument, (String)"ExperimentGrid");
            Element plateSettings = XMLUtil.getElement((Node)gridElement, (String)"PlateSetting");
            ImPlate plate = new ImPlate();
            plate.id = XMLUtil.getAttributeValue((Element)plateSettings, (String)"GID", (String)"unknown plate");
            plate.name = plate.id;
            plate.type = "Unknown";
            plate.dimension = new Dimension(XMLUtil.getAttributeIntValue((Element)plateSettings, (String)"XWells", (int)0), XMLUtil.getAttributeIntValue((Element)plateSettings, (String)"YWells", (int)0));
            plate.wells = this.getWellsFromGridElement(plate, gridElement);
            return plate;
        }

        private Document loadXMLDescriptorFile() throws IOException {
            return Optional.ofNullable(XMLUtil.loadDocument((String)this.xmlFile)).orElseThrow(() -> new IOException("Could not read xml from file"));
        }

        private Map<Long, ImWell> getWellsFromGridElement(ImPlate plate, Element gridElement) {
            ArrayList wellElements = XMLUtil.getElements((Node)gridElement, (String)"Experiment");
            Map<Long, ImWell> wells = wellElements.stream().map(StreamUtils.wrapFunction(wellElement -> ImWell.Builder.fromXMLElement(gridElement, wellElement, this.folderPath))).collect(Collectors.toMap(ImWell::getId, Function.identity()));
            return wells;
        }

        private void notifyProgress(DoubleSupplier progress, Supplier<String> message) {
            if (this.progressListener != null) {
                this.progressListener.notifyProgress(progress.getAsDouble(), message.get());
            }
        }
    }
}

