/*
 * Decompiled with CFR 0.152.
 */
package danyfel80.wells.data.im;

import danyfel80.wells.data.IField;
import danyfel80.wells.data.IWell;
import danyfel80.wells.data.im.ImField;
import danyfel80.wells.data.im.ImWellShape;
import icy.util.XMLUtil;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class ImWell
implements IWell {
    private long id;
    private Point positionInPlate;
    private Map<Long, ImField> fields;
    private ImWellShape wellShape;

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public Point getPositionInPlate() {
        return this.positionInPlate;
    }

    public Map<Long, ImField> getFields() {
        return this.fields;
    }

    @Override
    public ImWellShape getShape() {
        return this.wellShape;
    }

    @Override
    public Rectangle2D getFieldBoundsOnWell(IField field) {
        return field.getBounds();
    }

    public static class Builder {
        public static ImWell fromXMLElement(Element gridElement, Element wellElement, String platePath) throws IOException {
            int id = XMLUtil.getAttributeIntValue((Element)wellElement, (String)"PartIndex", (int)0);
            Point pos = new Point(XMLUtil.getAttributeIntValue((Element)wellElement, (String)"XPosition", (int)0), XMLUtil.getAttributeIntValue((Element)wellElement, (String)"YPosition", (int)0));
            Path imagePath = Paths.get(platePath, XMLUtil.getAttributeValue((Element)wellElement, (String)"Path", (String)""));
            ImField field = ImField.Builder.createSingleField(gridElement, imagePath, pos);
            ImWell well = new ImWell();
            well.id = id;
            well.positionInPlate = pos;
            well.fields = new HashMap();
            well.fields.put(field.getId(), field);
            well.wellShape = ImWellShape.DEFAULT_SHAPE;
            return null;
        }
    }
}

