/*
 * Decompiled with CFR 0.152.
 */
package danyfel80.wells.ui;

import danyfel80.wells.data.IField;
import danyfel80.wells.data.IWell;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import javax.swing.JComponent;

public class WellViewer
extends JComponent
implements MouseListener {
    private static final long serialVersionUID = 2478991498042362510L;
    private IWell well;
    private Rectangle2D wellBounds;
    private boolean selected;
    private boolean showFields;
    private int selectedFieldId = 1;
    private final AffineTransform transform = new AffineTransform();

    public WellViewer(IWell well, boolean showFields) {
        this.well = well;
        if (well != null) {
            this.wellBounds = this.well.getShape().getShape().getBounds2D();
        }
        this.showFields = showFields;
        this.addMouseListener(this);
        if (well != null && !well.getFields().isEmpty()) {
            this.setSelectedField((IField)((Map.Entry)well.getFields().entrySet().stream().findFirst().get()).getValue());
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (this.well == null) {
            e.consume();
            return;
        }
        try {
            Point2D clickLocation = this.transform.inverseTransform(e.getPoint(), null);
            if (this.well.getShape().getShape().contains(clickLocation)) {
                super.processMouseEvent(e);
            }
        }
        catch (NoninvertibleTransformException e1) {
            e1.printStackTrace();
        }
    }

    protected void fieldChanged(IWell theWell, IField theField) {
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.well == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(0.6f / (float)Math.log1p(this.transform.getScaleX())));
        g2.transform(this.transform);
        g2.setColor(Color.gray);
        Shape shape = this.well.getShape().getShape();
        g2.draw(shape);
        if (!this.well.getFields().isEmpty()) {
            g2.fill(shape);
        }
        if (this.showFields) {
            for (IField iField : this.well.getFields().values()) {
                g2.setColor(iField.getId() == (long)this.selectedFieldId ? Color.yellow : Color.darkGray);
                Rectangle2D fieldRectangle = this.well.getFieldBoundsOnWell(iField);
                g2.fill(fieldRectangle);
            }
        } else if (this.selected) {
            g2.setStroke(new BasicStroke(2.0f / (float)Math.log1p(this.transform.getScaleX())));
            g2.setColor(Color.yellow);
            g2.draw(shape);
        }
        g2.dispose();
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        if (this.well != null) {
            this.transform.setToIdentity();
            int offset = Math.min(w, h);
            this.transform.translate((double)((w - offset) / 2) + 0.05 * (double)offset, (double)((h - offset) / 2) + 0.05 * (double)offset);
            double scaleX = 0.9 * (double)offset / this.wellBounds.getWidth();
            double scaleY = 0.9 * (double)offset / this.wellBounds.getHeight();
            if (scaleX > 0.0 && scaleY > 0.0) {
                this.transform.scale(scaleX, scaleY);
            }
            this.transform.translate(-this.wellBounds.getX(), -this.wellBounds.getY());
        }
        super.setBounds(x, y, w, h);
    }

    public void setWell(IWell well) {
        this.well = well;
        if (well == null || well.getFields().isEmpty()) {
            this.wellBounds = null;
            this.repaint();
        } else {
            this.wellBounds = this.well.getShape().getShape().getBounds2D();
            this.setSelectedField((IField)((Map.Entry)well.getFields().entrySet().stream().findFirst().get()).getValue());
        }
    }

    public IWell getWell() {
        return this.well;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public int getSelectedFieldId() {
        return this.selectedFieldId;
    }

    public void setSelectedField(IField selectedField) {
        if (selectedField != null) {
            this.selectedFieldId = (int)selectedField.getId();
            this.fieldChanged(this.well, selectedField);
            this.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        block3: {
            try {
                Point2D clickLocation = this.transform.inverseTransform(e.getPoint(), null);
                if (!this.showFields || e.getClickCount() != 1) break block3;
                for (IField iField : this.well.getFields().values()) {
                    Rectangle2D fieldBoundsOnWell = this.well.getFieldBoundsOnWell(iField);
                    if (!fieldBoundsOnWell.contains(clickLocation)) continue;
                    this.setSelectedField(iField);
                    break;
                }
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

