/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.hcs.blocks;

import danyfel80.wells.data.IField;
import danyfel80.wells.data.IPlate;
import danyfel80.wells.data.IWell;
import icy.gui.frame.progress.CancelableProgressFrame;
import icy.sequence.Sequence;
import icy.system.IcyHandledException;
import icy.system.SystemUtil;
import icy.util.StringUtil;
import java.awt.Point;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import plugins.adufour.blocks.lang.Batch;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.hcs.WellPlateImporter;
import plugins.adufour.hcs.io.AbstractWellPlateReader;
import plugins.adufour.vars.gui.FileMode;
import plugins.adufour.vars.gui.model.FileTypeModel;
import plugins.adufour.vars.gui.model.VarEditorModel;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarFile;
import plugins.adufour.vars.lang.VarInteger;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.lang.VarString;
import plugins.adufour.vars.util.VarListener;

public class WellPlateBatch
extends Batch {
    private VarString wellFilter;
    private VarString plateID;
    private VarString wellID;
    private VarInteger fieldID;
    private VarFile plateFolder;
    private boolean wellPlateLoaded = false;
    private VarSequence element;
    String[] wellFilterValues;
    AbstractWellPlateReader reader;
    IPlate currentWellPlate;
    Iterator<? extends IWell> wellIterator;
    Iterator<? extends IField> fieldIterator;
    private IWell currentWell;

    public void declareInput(VarList inputMap) {
        super.declareInput(inputMap);
        this.wellFilter = new VarString("Well filter", "");
        inputMap.add(this.wellFilter.getName(), (Var)this.wellFilter);
    }

    public void declareOutput(VarList outputMap) {
        super.declareOutput(outputMap);
        this.plateID = new VarString("Plate", "--");
        this.plateID.setEnabled(false);
        this.wellID = new VarString("Well", "--");
        this.wellID.setEnabled(false);
        this.fieldID = new VarInteger("Field", 0);
        this.fieldID.setEnabled(false);
        outputMap.add(this.plateID.getName(), (Var)this.plateID);
        outputMap.add(this.wellID.getName(), (Var)this.wellID);
        outputMap.add(this.fieldID.getName(), (Var)this.fieldID);
    }

    public void declareLoopVariables(List<Var<?>> loopVariables) {
        super.declareLoopVariables(loopVariables);
        loopVariables.add((Var<?>)this.wellFilter);
        loopVariables.add((Var<?>)this.plateID);
        loopVariables.add((Var<?>)this.wellID);
        loopVariables.add((Var<?>)this.fieldID);
    }

    public Var<?> getBatchSource() {
        if (this.plateFolder == null) {
            this.plateFolder = new VarFile("Plate folder", null, (VarListener)new VarListener<File>(){

                public void valueChanged(Var<File> source, File oldValue, File newValue) {
                    WellPlateBatch.this.wellPlateLoaded = false;
                }

                public void referenceChanged(Var<File> source, Var<? extends File> oldReference, Var<? extends File> newReference) {
                    WellPlateBatch.this.wellPlateLoaded = false;
                }
            });
            this.plateFolder.setDefaultEditorModel((VarEditorModel)new FileTypeModel(null, FileMode.FOLDERS, null, false));
        }
        return this.plateFolder;
    }

    public VarSequence getBatchElement() {
        if (this.element == null) {
            this.element = new VarSequence("Sequence", null);
        }
        return this.element;
    }

    public void initializeLoop() {
        this.wellFilterValues = ((String)this.wellFilter.getValue(true)).split("\\s+");
        if (!this.wellPlateLoaded) {
            File folder = (File)this.plateFolder.getValue(true);
            this.reader = WellPlateImporter.getReaderFor(folder);
            if (this.reader == null) {
                throw new IcyHandledException("No plate reader found for folder " + folder.getPath());
            }
            Optional<CancelableProgressFrame> progress = SystemUtil.isHeadLess() ? Optional.empty() : Optional.of(new CancelableProgressFrame("Loading well plate..."));
            try {
                Future<? extends IPlate> plateFuture = this.reader.loadPlateFromFolder(folder, (p, m) -> progress.ifPresent(pr -> {
                    pr.setPosition(p);
                    pr.setMessage(m);
                }));
                this.currentWellPlate = plateFuture.get();
                this.plateID.setValue((Object)this.currentWellPlate.getId());
                this.wellPlateLoaded = true;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
            finally {
                progress.ifPresent(pr -> pr.close());
            }
        }
        this.wellIterator = this.currentWellPlate.getWells().values().stream().filter(this::shouldLoadWell).iterator();
        this.fieldIterator = Collections.emptyList().iterator();
    }

    private boolean shouldLoadWell(IWell well) {
        if (this.wellFilterValues.length != 0) {
            Point wellPos = well.getPositionInPlate();
            char col = (char)(65 + wellPos.x - 1);
            String row = StringUtil.toString((int)wellPos.y, (int)2);
            String wellAlphanumeric = "" + col + row;
            for (String filter : this.wellFilterValues) {
                if (!wellAlphanumeric.contains(filter)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public void beforeIteration() {
        try {
            Sequence sequence = new Sequence();
            if (!this.fieldIterator.hasNext() && this.wellIterator.hasNext()) {
                this.currentWell = this.wellIterator.next();
                this.fieldIterator = this.currentWell.getFields().values().iterator();
            }
            if (this.fieldIterator.hasNext()) {
                IField currentField = this.fieldIterator.next();
                Point pos = this.currentWell.getPositionInPlate();
                this.wellID.setValue((Object)("" + (char)(65 + pos.x - 1) + StringUtil.toString((int)pos.y, (int)2)));
                this.fieldID.setValue((Object)((int)currentField.getId()));
                this.reader.loadField(this.currentWellPlate, this.currentWell, currentField, sequence, null);
                this.element.setValue(sequence);
            }
            Thread.yield();
        }
        catch (Exception e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
    }

    public boolean isStopConditionReached() {
        return !this.fieldIterator.hasNext() && !this.wellIterator.hasNext();
    }
}

