/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.hcs.data;

import icy.sequence.Sequence;
import java.io.IOException;
import java.util.Iterator;
import ome.xml.meta.OMEXMLMetadata;
import org.xml.sax.SAXException;
import plugins.adufour.hcs.data.OldField;
import plugins.adufour.hcs.data.OldWell;
import plugins.adufour.hcs.io.OldWellPlateReader;

@Deprecated
public class OldWellPlate {
    private final OldWellPlateReader wellPlateReader;
    private final OMEXMLMetadata metadata;
    private final Sequence sequence;
    private final OldWell[] wells;

    public OldWellPlate(OldWellPlateReader reader, OMEXMLMetadata metadata, OldWell.Shape shape) {
        this.wellPlateReader = reader;
        this.metadata = metadata;
        this.sequence = new Sequence(metadata);
        int nbRows = this.getNbRows();
        int nbCols = this.getNbCols();
        this.wells = new OldWell[nbRows * nbCols];
        for (int row = 0; row < nbRows; ++row) {
            for (int col = 0; col < nbCols; ++col) {
                this.wells[row * nbCols + col] = new OldWell(shape, row, col);
            }
        }
    }

    public OldWellPlate(OldWellPlateReader reader, OMEXMLMetadata metadata, OldWell[] wells) {
        this.wellPlateReader = reader;
        this.metadata = metadata;
        this.sequence = new Sequence(metadata);
        int nbRows = this.getNbRows();
        int nbCols = this.getNbCols();
        if (nbRows * nbCols != wells.length) {
            throw new IllegalArgumentException("The size of the wells array (" + wells.length + ") is not compatible with the metadata (" + nbRows + ", " + nbCols + ")");
        }
        this.wells = wells;
    }

    public int getNbRows() {
        return (Integer)this.metadata.getPlateRows(0).getValue();
    }

    public int getNbCols() {
        return (Integer)this.metadata.getPlateColumns(0).getValue();
    }

    public OldWell getWellAt(int row, int col) {
        return this.wells[row * this.getNbCols() + col];
    }

    public OMEXMLMetadata getMetaData() {
        return this.metadata;
    }

    public String toString() {
        String plateID = this.metadata.getPlateID(0);
        String plateType = this.metadata.getPlateName(0);
        return plateID + " (" + plateType + ")";
    }

    public Sequence loadField(OldField field) throws IOException, SAXException {
        this.wellPlateReader.loadField(field, this.sequence);
        if (field != null) {
            this.sequence.setName(field.getWell().getAlphanumericID());
        }
        return this.sequence;
    }

    public Iterator<OldWell> wellIterator() {
        return this.wellIterator(null);
    }

    public Iterator<OldWell> wellIterator(final String filters) {
        return new Iterator<OldWell>(){
            int currentWellIndex = -1;
            int nextWellIndex = 0;
            OldWell nextWell = null;

            @Override
            public OldWell next() {
                this.currentWellIndex = this.nextWellIndex;
                return this.nextWell;
            }

            @Override
            public boolean hasNext() {
                for (int newWell = this.currentWellIndex + 1; newWell < OldWellPlate.this.wells.length; ++newWell) {
                    boolean isValidWell;
                    OldWell candidateWell = OldWellPlate.this.wells[newWell];
                    if (candidateWell.isEmpty()) continue;
                    boolean bl = isValidWell = filters == null;
                    if (filters != null) {
                        for (String filter : filters.split("\\s+")) {
                            if (!candidateWell.getAlphanumericID().contains(filter)) continue;
                            isValidWell = true;
                            break;
                        }
                    }
                    if (!isValidWell) continue;
                    this.nextWell = OldWellPlate.this.wells[newWell];
                    this.nextWellIndex = newWell;
                    return true;
                }
                return false;
            }
        };
    }

    public Iterator<OldField> fieldIterator() {
        return this.fieldIterator(null);
    }

    public Iterator<OldField> fieldIterator(final String templates) {
        return new Iterator<OldField>(){
            Iterator<OldWell> wellIterator;
            Iterator<OldField> currentFieldIterator;
            {
                this.wellIterator = OldWellPlate.this.wellIterator(templates);
                this.currentFieldIterator = null;
            }

            @Override
            public OldField next() {
                return this.currentFieldIterator.next();
            }

            @Override
            public boolean hasNext() {
                if (this.currentFieldIterator != null && this.currentFieldIterator.hasNext()) {
                    return true;
                }
                if (this.wellIterator.hasNext()) {
                    this.currentFieldIterator = this.wellIterator.next().fieldIterator();
                    return this.currentFieldIterator.hasNext();
                }
                return false;
            }
        };
    }
}

