/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.hcs.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import javax.swing.JComponent;
import plugins.adufour.hcs.data.OldField;
import plugins.adufour.hcs.data.OldWell;

@Deprecated
public class OldWellViewer
extends JComponent
implements MouseListener {
    private static final long serialVersionUID = 2478991498042362510L;
    private OldWell well;
    private boolean selected;
    private boolean showFields;
    private int selectedFieldID = 1;
    private final AffineTransform transform = new AffineTransform();

    public OldWellViewer(OldWell well, boolean showFields) {
        this.well = well;
        this.showFields = showFields;
        this.addMouseListener(this);
        if (well != null && !well.isEmpty()) {
            this.setSelectedField(well.getFields().iterator().next());
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (this.well == null) {
            e.consume();
            return;
        }
        try {
            Point2D clickLocation = this.transform.inverseTransform(e.getPoint(), null);
            if (this.well.getShape().wellShape.contains(clickLocation)) {
                super.processMouseEvent(e);
            }
        }
        catch (NoninvertibleTransformException e1) {
            e1.printStackTrace();
        }
    }

    protected void fieldChanged(OldWell theWell, OldField theField) {
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.well == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(0.6f / (float)Math.log1p(this.transform.getScaleX())));
        g2.transform(this.transform);
        g2.setColor(Color.gray);
        RectangularShape shape = this.well.getShape().wellShape;
        g2.draw(shape);
        if (!this.well.isEmpty()) {
            g2.fill(shape);
        }
        if (this.showFields) {
            for (OldField field : this.well.getFields()) {
                g2.setColor(field.getID() == this.selectedFieldID ? Color.yellow : Color.darkGray);
                g2.fill(field.getBounds());
            }
        } else if (this.selected) {
            g2.setStroke(new BasicStroke(2.0f / (float)Math.log1p(this.transform.getScaleX())));
            g2.setColor(Color.yellow);
            g2.draw(shape);
        }
        g2.dispose();
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        if (this.well != null) {
            this.transform.setToIdentity();
            OldWell.Shape wellShape = this.well.getShape();
            this.transform.translate(0.05 * (double)w, 0.05 * (double)h);
            double scaleX = 0.9 * (double)w / wellShape.wellShape.getWidth();
            double scaleY = 0.9 * (double)h / wellShape.wellShape.getHeight();
            if (scaleX > 0.0 && scaleY > 0.0) {
                this.transform.scale(scaleX, scaleY);
            }
        }
        super.setBounds(x, y, w, h);
    }

    public void setWell(OldWell well) {
        this.well = well;
        if (well == null || well.isEmpty()) {
            this.repaint();
        } else {
            this.setSelectedField(well.fieldIterator().next());
        }
    }

    public OldWell getWell() {
        return this.well;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public int getSelectedFieldID() {
        return this.selectedFieldID;
    }

    public void setSelectedField(OldField selectedField) {
        this.selectedFieldID = selectedField.getID();
        this.fieldChanged(this.well, selectedField);
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        block3: {
            try {
                Point2D clickLocation = this.transform.inverseTransform(e.getPoint(), null);
                if (!this.showFields || e.getClickCount() != 1) break block3;
                for (OldField field : this.well.getFields()) {
                    if (!field.getBounds().contains(clickLocation)) continue;
                    this.setSelectedField(field);
                    break;
                }
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

