/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.hcs.io;

import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codec.TIFFDecodeParam;
import com.sun.media.jai.codecimpl.TIFFCodec;
import icy.gui.frame.progress.CancelableProgressFrame;
import icy.image.IcyBufferedImage;
import icy.sequence.MetaDataUtil;
import icy.sequence.Sequence;
import icy.util.OMEUtil;
import icy.util.XMLUtil;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Optional;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedImageAdapter;
import ome.xml.meta.OMEXMLMetadata;
import ome.xml.meta.OMEXMLMetadataRoot;
import ome.xml.model.Image;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelImpl;
import ome.xml.model.Pixels;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.primitives.PositiveInteger;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import plugins.adufour.hcs.data.OldField;
import plugins.adufour.hcs.data.OldWell;
import plugins.adufour.hcs.data.OldWellPlate;
import plugins.adufour.hcs.io.OldWellPlateReader;

@Deprecated
public class OldWellPlateReader_ScanR
extends OldWellPlateReader {
    @Override
    public String getSystemName() {
        return "ScanR (Olympus)";
    }

    @Override
    public boolean isValidPlate(File plateFile) {
        return false;
    }

    @Override
    public OldWellPlate loadPlateFromFolder(File folder, Optional<CancelableProgressFrame> progress) throws IOException {
        Object rootCluster;
        OMEXMLMetadata metadata = OMEUtil.createOMEXMLMetadata();
        OldWellPlate wellPlate = null;
        Point2D.Double wellA1 = new Point2D.Double();
        int wellShiftX = 0;
        int wellShiftY = 0;
        double wellDiameter = 0.0;
        int totalStageX = 0;
        int totalStageY = 0;
        try {
            Document xml = XMLUtil.createDocument((String)FileUtils.readFileToString((File)new File(folder.getPath() + "/experiment_descriptor.xml"), (String)"UTF-8"));
            rootCluster = XMLUtil.getElement((Node)XMLUtil.getElement((Node)xml, (String)"LVData"), (String)"Cluster");
            for (Object string : XMLUtil.getElements((Node)rootCluster, (String)"String")) {
                String name = XMLUtil.getElementValue((Node)string, (String)"Name", (String)"");
                if (!name.equalsIgnoreCase("plate name")) continue;
                String plateName = XMLUtil.getElementValue((Node)string, (String)"Val", (String)"Unnamed plate");
                metadata.setPlateID(plateName, 0);
            }
            OldWell.Shape wellShape = null;
            for (Element cluster : XMLUtil.getElements((Node)rootCluster, (String)"Cluster")) {
                String name = XMLUtil.getElementValue((Node)cluster, (String)"Name", (String)"");
                if (!name.equalsIgnoreCase("format typedef")) continue;
                for (Element property : XMLUtil.getElements((Node)cluster)) {
                    if (property.getNodeName().contentEquals("Name") || property.getNodeName().contentEquals("NumElts")) continue;
                    String value = XMLUtil.getElementValue((Node)property, (String)"Val", (String)"");
                    switch (XMLUtil.getElementValue((Node)property, (String)"Name", (String)"")) {
                        case "Rows": {
                            metadata.setPlateRows(new PositiveInteger(Integer.valueOf(Integer.parseInt(value))), 0);
                            break;
                        }
                        case "Columns": {
                            metadata.setPlateColumns(new PositiveInteger(Integer.valueOf(Integer.parseInt(value))), 0);
                            break;
                        }
                        case "well diameter": {
                            wellDiameter = Integer.parseInt(value);
                            break;
                        }
                        case "Format description": {
                            metadata.setPlateName(value, 0);
                            break;
                        }
                        case "Well Shape": {
                            wellShape = OldWell.Shape.valueOf(value);
                            break;
                        }
                        case "column spacer": {
                            wellShiftX = Integer.parseInt(value);
                            break;
                        }
                        case "row spacer": {
                            wellShiftY = Integer.parseInt(value);
                            break;
                        }
                        case "Xtot": {
                            totalStageX = Integer.parseInt(value);
                            break;
                        }
                        case "Ytot": {
                            totalStageY = Integer.parseInt(value);
                            break;
                        }
                        case "XYA1": {
                            ArrayList coordsA1 = XMLUtil.getElements((Node)property, (String)"I32");
                            int xA1 = XMLUtil.getElementIntValue((Node)((Node)coordsA1.get(0)), (String)"Val", (int)0);
                            int yA1 = XMLUtil.getElementIntValue((Node)((Node)coordsA1.get(1)), (String)"Val", (int)0);
                            ((Point2D)wellA1).setLocation(xA1, yA1);
                            break;
                        }
                    }
                }
            }
            wellShape.setDimension(wellDiameter, wellDiameter);
            wellPlate = new OldWellPlate((OldWellPlateReader)this, metadata, wellShape);
        }
        catch (SAXException xml) {
            // empty catch block
        }
        BufferedReader reader = new BufferedReader(new FileReader(folder.getPath() + "/experiment_descriptor.dat"));
        rootCluster = null;
        try {
            while (reader.ready()) {
                String line = reader.readLine();
                if (!line.startsWith("IMAGE")) continue;
                String[] tokens = line.split("\t");
                int wellIndex = Integer.parseInt(tokens[6].substring(5));
                int nCols = (Integer)metadata.getPlateColumns(0).getValue();
                int row = wellIndex / nCols;
                int col = wellIndex % nCols - 1;
                OldWell well = wellPlate.getWellAt(row, col);
                double fieldX = (double)totalStageX - Double.parseDouble(tokens[1].substring(2)) - (double)(col * wellShiftX) - ((Point2D)wellA1).getX();
                double fieldY = (double)totalStageY - Double.parseDouble(tokens[2].substring(2)) - (double)(row * wellShiftY) - ((Point2D)wellA1).getY();
                int id = Integer.parseInt(tokens[7].substring(7));
                well.addField(new OldField(well, id, fieldX, fieldY));
            }
        }
        catch (Throwable line) {
            rootCluster = line;
            throw line;
        }
        finally {
            if (reader != null) {
                if (rootCluster != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable line) {
                        ((Throwable)rootCluster).addSuppressed(line);
                    }
                } else {
                    reader.close();
                }
            }
        }
        try {
            Document doc = XMLUtil.loadDocument((String)(folder.getPath() + "/data/metadata.ome.xml"));
            OMEXMLMetadataRoot ome = new OMEXMLMetadataRoot(XMLUtil.getElement((Node)doc, (String)"OME"), (OMEModel)new OMEModelImpl());
            metadata.setInstrumentID(ome.getCreator(), 0);
            int nbImages = ome.sizeOfImageList();
            for (int i = 0; i < nbImages; ++i) {
                int fieldID;
                int col;
                int nCols;
                int posP;
                Image image = ome.getImage(i);
                String id = image.getID();
                int wellIndex = Integer.parseInt(id.substring(7, posP = id.indexOf(80)));
                int row = wellIndex / (nCols = ((Integer)metadata.getPlateColumns(0).getValue()).intValue());
                OldWell well = wellPlate.getWellAt(row, col = wellIndex % nCols - 1);
                OldField field = well.getField(fieldID = Integer.parseInt(id.substring(posP + 1)));
                if (field == null) continue;
                Pixels pixels = image.getPixels();
                int imageWidth = (Integer)pixels.getSizeX().getValue();
                int imageHeight = (Integer)pixels.getSizeY().getValue();
                double pixelSizeX = pixels.getPhysicalSizeX().value().doubleValue();
                double pixelSizeY = pixels.getPhysicalSizeY().value().doubleValue();
                MetaDataUtil.setPixelSizeX((OMEXMLMetadata)metadata, (int)0, (double)pixelSizeX);
                MetaDataUtil.setPixelSizeY((OMEXMLMetadata)metadata, (int)0, (double)pixelSizeY);
                double fieldWidth = (double)imageWidth * pixelSizeX;
                double fieldHeight = (double)imageHeight * pixelSizeY;
                field.setFieldSize(fieldWidth, fieldHeight);
                int nChannels = (Integer)pixels.getSizeC().getValue();
                for (int c = 0; c < nChannels; ++c) {
                    metadata.setChannelName(pixels.getChannel(c).getName(), c, 0);
                    field.addFilePath(folder.getPath() + "/data/" + pixels.getTiffData(c).getUUID().getFileName());
                }
            }
        }
        catch (EnumerationException enumerationException) {
            // empty catch block
        }
        return wellPlate;
    }

    @Override
    public void loadField(OldField field, Sequence sequence) throws IOException {
        ArrayList<IcyBufferedImage> channels = new ArrayList<IcyBufferedImage>();
        try {
            for (String filePath : field.getFilePaths()) {
                File file = new File(filePath);
                if (!file.exists()) {
                    sequence.removeAllImages();
                    return;
                }
                SeekableStream ss = SeekableStream.wrapInputStream((InputStream)new FileInputStream(file), (boolean)true);
                ImageDecoder dec = TIFFCodec.createImageDecoder((String)"tiff", (SeekableStream)ss, (ImageDecodeParam)new TIFFDecodeParam());
                RenderedImage _plane = dec.decodeAsRenderedImage(0);
                channels.add(IcyBufferedImage.createFrom((PlanarImage)new RenderedImageAdapter(_plane)));
            }
            sequence.setImage(0, 0, (BufferedImage)IcyBufferedImage.createFrom(channels));
        }
        catch (Exception e) {
            System.err.println("Warning: cannot load field " + field.toString() + ": " + e.getMessage());
            sequence.removeAllImages();
        }
    }
}

