/*
 * Decompiled with CFR 0.152.
 */
package danyfel80.wells.data.columbus;

import danyfel80.wells.data.IPlate;
import danyfel80.wells.data.columbus.ColumbusImage;
import danyfel80.wells.data.columbus.ColumbusWell;
import danyfel80.wells.util.MessageProgressListener;
import danyfel80.wells.util.stream.StreamUtils;
import icy.util.XMLUtil;
import java.awt.Dimension;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.bind.DatatypeConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ColumbusPlate
implements IPlate {
    private String folder;
    private String id;
    private String measurementId;
    private Date measurementDate;
    private String name;
    private String type;
    private Dimension dimension;
    private Set<Long> wellIds;
    private Map<Long, ColumbusWell> wells;

    private ColumbusPlate() {
    }

    public String getFolder() {
        return this.folder;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getMeasurementId() {
        return this.measurementId;
    }

    public Date getMeasurementDate() {
        return this.measurementDate;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public Set<Long> getWellIds() {
        return Collections.unmodifiableSet(this.wells != null ? this.wells.keySet() : this.wellIds);
    }

    @Override
    public Dimension getDimension() {
        return this.dimension;
    }

    public Map<Long, ColumbusWell> getWells() {
        return this.wells;
    }

    public String toString() {
        String plateID = this.getId();
        String plateType = this.getName();
        return String.valueOf(plateID) + " (" + plateType + ")";
    }

    /* synthetic */ ColumbusPlate(ColumbusPlate columbusPlate) {
        this();
    }

    public static class Builder {
        private static final Date DEFAULT_DATE = new Date();
        private String xmlDescriptorFile;
        private MessageProgressListener progressListener;

        public Builder(String xmlDescriptorFile) {
            this.xmlDescriptorFile = xmlDescriptorFile;
            this.progressListener = null;
        }

        public Builder progressListener(MessageProgressListener progressListener) {
            this.progressListener = progressListener;
            return this;
        }

        public ColumbusPlate build() throws IOException {
            this.notifyProgress(() -> 0.01, () -> "Loading xml descriptor file");
            Document plateDescriptionDocument = this.loadXMLDescriptorFile();
            Element rootElement = XMLUtil.getRootElement((Document)plateDescriptionDocument);
            this.notifyProgress(() -> 0.1, () -> "Creating plate element");
            Element platesElement = XMLUtil.getElement((Node)rootElement, (String)"Plates");
            ArrayList plateElements = XMLUtil.getElements((Node)platesElement, (String)"Plate");
            ColumbusPlate plate = this.getPlatefromElement((Element)plateElements.get(0));
            plate.folder = Paths.get(this.xmlDescriptorFile, new String[0]).getParent().toString();
            this.notifyProgress(() -> 0.2, () -> "Reading plate images");
            Element imagesElement = XMLUtil.getElement((Node)rootElement, (String)"Images");
            Map<String, ColumbusImage> images = this.getImagesFromElement(imagesElement);
            this.notifyProgress(() -> 0.6, () -> "Reading plate wells");
            Element wellsElement = XMLUtil.getElement((Node)rootElement, (String)"Wells");
            plate.wells = this.getWellsFromElement(wellsElement, images, plate.wellIds);
            return plate;
        }

        private Document loadXMLDescriptorFile() throws IOException {
            return Optional.ofNullable(XMLUtil.loadDocument((String)this.xmlDescriptorFile)).orElseThrow(() -> new IOException("Could not read xml from file"));
        }

        private ColumbusPlate getPlatefromElement(Element plateElement) throws RuntimeException {
            String plateId = XMLUtil.getElementValue((Node)plateElement, (String)"PlateID", null);
            String plateMeasurementId = XMLUtil.getElementValue((Node)plateElement, (String)"MeasurementID", null);
            Date plateDate = Optional.ofNullable(XMLUtil.getElementValue((Node)plateElement, (String)"MeasuremenetStartTime", null)).flatMap(StreamUtils.wrapFunction(timeStr -> Optional.of(DatatypeConverter.parseDateTime((String)timeStr).getTime()))).orElse(DEFAULT_DATE);
            String plateName = XMLUtil.getElementValue((Node)plateElement, (String)"Name", (String)plateId);
            String plateType = XMLUtil.getElementValue((Node)plateElement, (String)"PlateType", (String)"");
            int plateRows = XMLUtil.getElementIntValue((Node)plateElement, (String)"PlateRows", (int)0);
            int plateColumns = XMLUtil.getElementIntValue((Node)plateElement, (String)"PlateColumns", (int)0);
            Set plateWellIds = XMLUtil.getElements((Node)plateElement, (String)"Well").stream().map(StreamUtils.wrapFunction(wellElement -> XMLUtil.getAttributeLongValue((Element)wellElement, (String)"id", (long)-1L))).collect(Collectors.toSet());
            ColumbusPlate plate = new ColumbusPlate(null);
            plate.id = plateId;
            plate.measurementId = plateMeasurementId;
            plate.measurementDate = plateDate;
            plate.name = plateName;
            plate.type = plateType;
            plate.dimension = new Dimension(plateRows, plateColumns);
            plate.wellIds = plateWellIds;
            return plate;
        }

        private Map<String, ColumbusImage> getImagesFromElement(Element imagesElement) {
            ArrayList imageElements = XMLUtil.getElements((Node)imagesElement, (String)"Image");
            int imageCount = imageElements.size();
            AtomicInteger readImages = new AtomicInteger();
            Map<String, ColumbusImage> images = imageElements.stream().map(StreamUtils.wrapFunction(e -> {
                int imageNumber = readImages.incrementAndGet();
                this.notifyProgress(() -> 0.2 + 0.4 * (double)imageNumber / (double)imageCount, () -> "Reading plate images (" + imageNumber + "/" + imageCount + ")");
                return e;
            })).map(StreamUtils.wrapFunction(imageElement -> ColumbusImage.Builder.fromXMLElement(imageElement))).collect(Collectors.toMap(ColumbusImage::getId, Function.identity()));
            return images;
        }

        private Map<Long, ColumbusWell> getWellsFromElement(Element wellsElement, Map<String, ColumbusImage> images, Set<Long> wellIds) {
            ArrayList wellElements = XMLUtil.getElements((Node)wellsElement, (String)"Well");
            int wellsCount = wellElements.size();
            AtomicInteger readWells = new AtomicInteger();
            Map<Long, ColumbusWell> wells = wellElements.stream().map(StreamUtils.wrapFunction(e -> {
                int wellNumber = readWells.incrementAndGet();
                this.notifyProgress(() -> 0.6 + 0.4 * (double)wellNumber / (double)wellsCount, () -> "Reading plate wells (" + wellNumber + "/" + wellsCount + ")");
                return e;
            })).map(StreamUtils.wrapFunction(wellElement -> ColumbusWell.Builder.fromXMLElement(wellElement, images))).filter(well -> wellIds.contains(well.getId())).collect(Collectors.toMap(ColumbusWell::getId, Function.identity()));
            return wells;
        }

        private void notifyProgress(DoubleSupplier progress, Supplier<String> message) {
            if (this.progressListener != null) {
                this.progressListener.notifyProgress(progress.getAsDouble(), message.get());
            }
        }
    }
}

